/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.data.datatype;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.datatype.DataType;
import com.nexacro.java.xapi.data.datatype.JavaDataType;
import com.nexacro.java.xapi.data.datatype.PlatformDataType;
import com.nexacro.java.xapi.data.datatype.SqlDataType;
import com.nexacro.java.xapi.util.PlatformGlobals;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataTypeFactory {
    public static DataType NULL = JavaDataType.NULL;
    private static Map cacheMap = new HashMap();
    private static Map convertingMap = new HashMap();
    private static Map nodeMap = new HashMap();
    private static Map convertibleCacheMap = new HashMap();
    private static final String CONVERSION_BOOLEAN_STRING_KEY = "platform.data.DataType.conversion.booleanstring";
    private static final boolean IS_DEBUG = false;
    private static int debugStep;
    private static StringBuffer debugBuffer;
    static /* synthetic */ Class class$com$nexacro$java$xapi$data$datatype$DataTypeFactory;

    public static DataType getJavaDataType(int type) {
        return DataTypeFactory.getDataType("JAVA", type);
    }

    public static DataType getJavaDataType(String name) {
        return DataTypeFactory.getDataType("JAVA", name);
    }

    public static DataType getJavaDataType(Class clazz) {
        String typeName = JavaDataType.getSimpleName(clazz);
        DataType dataType = DataTypeFactory.getJavaDataType(typeName);
        if (dataType != null) {
            return dataType;
        }
        typeName = clazz.getName();
        dataType = DataTypeFactory.getJavaDataType(typeName);
        if (dataType != null) {
            return dataType;
        }
        int type = JavaDataType.getNewType();
        dataType = new DataType("JAVA", type, clazz.getName());
        DataTypeFactory.register(dataType);
        return dataType;
    }

    public static DataType getJavaDataType(DataType dataType) {
        if (dataType == null) {
            return null;
        }
        if ("JAVA".equalsIgnoreCase(dataType.getCategoryName())) {
            return dataType;
        }
        String convertingKey = dataType.getCategoryName() + "." + dataType.getTypeName() + "->" + "JAVA";
        return (DataType)convertingMap.get(convertingKey);
    }

    public static DataType getPlatformDataType(int type) {
        return DataTypeFactory.getDataType("PLATFORM", type);
    }

    public static DataType getPlatformDataType(String name) {
        return DataTypeFactory.getDataType("PLATFORM", name);
    }

    public static DataType getPlatformDataType(DataType dataType) {
        if (dataType == null) {
            return null;
        }
        if ("PLATFORM".equalsIgnoreCase(dataType.getCategoryName())) {
            return dataType;
        }
        DataType javaDataType = DataTypeFactory.getJavaDataType(dataType);
        String convertingKey = javaDataType.getCategoryName() + "." + javaDataType.getTypeName() + "->" + "PLATFORM";
        return (DataType)convertingMap.get(convertingKey);
    }

    public static DataType getSqlDataType(int type) {
        return DataTypeFactory.getDataType("SQL", type);
    }

    public static DataType getSqlDataType(String name) {
        return DataTypeFactory.getDataType("SQL", name);
    }

    public static DataType getSqlDataType(DataType dataType) {
        if (dataType == null) {
            return null;
        }
        if ("SQL".equalsIgnoreCase(dataType.getCategoryName())) {
            return dataType;
        }
        DataType javaDataType = DataTypeFactory.getJavaDataType(dataType);
        String convertingKey = javaDataType.getCategoryName() + "." + javaDataType.getTypeName() + "->" + "SQL";
        return (DataType)convertingMap.get(convertingKey);
    }

    public static DataType getDataType(String categoryName, int type) {
        if (categoryName == null) {
            return null;
        }
        String cacheKey = categoryName + "." + type;
        return (DataType)cacheMap.get(cacheKey.toUpperCase());
    }

    public static DataType getDataType(String categoryName, String name) {
        if (categoryName == null) {
            return null;
        }
        if (name == null) {
            return null;
        }
        String cacheKey = categoryName + "." + name;
        return (DataType)cacheMap.get(cacheKey.toUpperCase());
    }

    public static DataType getDataTypeOfValue(Object value) {
        if (value == null) {
            return NULL;
        }
        if (value instanceof String) {
            boolean conversion = PlatformGlobals.getBooleanProperty(CONVERSION_BOOLEAN_STRING_KEY, true);
            if ((((String)value).equalsIgnoreCase("true") || ((String)value).equalsIgnoreCase("false")) && conversion) {
                return PlatformDataType.BOOLEAN;
            }
            return PlatformDataType.STRING;
        }
        if (value instanceof Integer) {
            return PlatformDataType.INT;
        }
        if (value instanceof Boolean) {
            return PlatformDataType.BOOLEAN;
        }
        if (value instanceof Long) {
            return PlatformDataType.LONG;
        }
        if (value instanceof Float) {
            return PlatformDataType.FLOAT;
        }
        if (value instanceof Double) {
            return PlatformDataType.DOUBLE;
        }
        if (value instanceof BigDecimal) {
            return PlatformDataType.BIG_DECIMAL;
        }
        if (value instanceof Date) {
            return PlatformDataType.DATE;
        }
        if (value instanceof byte[]) {
            return PlatformDataType.BLOB;
        }
        if (value instanceof DataSet) {
            return PlatformDataType.DATASET;
        }
        return PlatformDataType.UNDEFINED;
    }

    public static void register(Class clazz) {
        Field[] fields = clazz.getFields();
        int count = fields.length;
        for (int i = 0; i < count; ++i) {
            Log log;
            try {
                if (!DataTypeFactory.isDataTypeField(fields[i])) continue;
                DataType dataType = (DataType)fields[i].get(null);
                DataTypeFactory.register(dataType);
                continue;
            }
            catch (IllegalArgumentException ex) {
                log = LogFactory.getLog((Class)(class$com$nexacro$java$xapi$data$datatype$DataTypeFactory == null ? DataTypeFactory.class$("com.nexacro.java.xapi.data.datatype.DataTypeFactory") : class$com$nexacro$java$xapi$data$datatype$DataTypeFactory));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Could not register data type: fields[" + i + "]=" + fields[i]), (Throwable)ex);
                continue;
            }
            catch (IllegalAccessException ex) {
                log = LogFactory.getLog((Class)(class$com$nexacro$java$xapi$data$datatype$DataTypeFactory == null ? DataTypeFactory.class$("com.nexacro.java.xapi.data.datatype.DataTypeFactory") : class$com$nexacro$java$xapi$data$datatype$DataTypeFactory));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Could not register data type: fields[" + i + "]=" + fields[i]), (Throwable)ex);
            }
        }
    }

    public static void register(DataType dataType) {
        if (dataType == null) {
            return;
        }
        String categoryName = dataType.getCategoryName();
        if (categoryName == null) {
            return;
        }
        dataType.getCategoryName();
        String typeCacheKey = categoryName + "." + dataType.getType();
        cacheMap.put(typeCacheKey.toUpperCase(), dataType);
        String nameCacheKey = categoryName + "." + dataType.getTypeName();
        cacheMap.put(nameCacheKey.toUpperCase(), dataType);
    }

    public static void bindConverting(DataType from, DataType to) {
        String convertingKey = from.getCategoryName() + "." + from.getTypeName() + "->" + to.getCategoryName();
        convertingMap.put(convertingKey, to);
        DataTypeFactory.setAsConvertible(from, to);
    }

    public static synchronized boolean isConvertible(DataType from, DataType to) {
        if (from == null || to == null) {
            return false;
        }
        String pairKey = DataTypeFactory.getPairKey(from, to);
        Boolean isConvertible = (Boolean)convertibleCacheMap.get(pairKey);
        if (isConvertible == null) {
            Node fromNode = (Node)nodeMap.get(from.toString());
            Node toNode = new Node(to);
            if (fromNode == null) {
                return false;
            }
            String searchKey = "" + Thread.currentThread().hashCode() + ":" + new SecureRandom().nextDouble();
            isConvertible = new Boolean(fromNode.isLinkedTo(toNode, searchKey));
            convertibleCacheMap.put(pairKey, isConvertible);
        }
        return isConvertible;
    }

    public static synchronized void setAsConvertible(DataType from, DataType to) {
        Node toNode;
        Node fromNode = (Node)nodeMap.get(from.toString());
        if (fromNode == null) {
            fromNode = new Node(from);
            nodeMap.put(from.toString(), fromNode);
        }
        if ((toNode = (Node)nodeMap.get(to.toString())) == null) {
            toNode = new Node(to);
            nodeMap.put(to.toString(), toNode);
        }
        if (fromNode.has(toNode)) {
            return;
        }
        fromNode.addAsToNode(toNode);
        convertibleCacheMap.clear();
    }

    static boolean isDataTypeField(Field field) {
        if (!Modifier.isFinal(field.getModifiers())) {
            return false;
        }
        if (!Modifier.isStatic(field.getModifiers())) {
            return false;
        }
        try {
            return field.get(null).getClass() == DataType.class;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return false;
    }

    private static String getPairKey(DataType from, DataType to) {
        return from.toString() + "->" + to.toString();
    }

    static {
        JavaDataType.registerDefinedDataType();
        PlatformDataType.registerDefinedDataType();
        SqlDataType.registerDefinedDataType();
        JavaDataType.registerConvertible();
        PlatformDataType.registerConvertible();
        SqlDataType.registerConvertible();
        debugStep = -1;
        debugBuffer = new StringBuffer();
    }

    private static class Node {
        private final String name;
        private final List toNodeList;
        private String currentSearchKey;

        private Node(DataType dataType) {
            this.name = dataType.toString();
            this.toNodeList = new ArrayList();
        }

        public boolean isLinkedTo(Node targetNode, String searchKey) {
            if (searchKey.equals(this.currentSearchKey)) {
                return false;
            }
            this.currentSearchKey = searchKey;
            if (this.name.equals(targetNode.name)) {
                return true;
            }
            Iterator iter = this.toNodeList.iterator();
            while (iter.hasNext()) {
                Node toNode = (Node)iter.next();
                if (!toNode.isLinkedTo(targetNode, searchKey)) continue;
                return true;
            }
            return false;
        }

        private void addAsToNode(Node node) {
            this.toNodeList.add(node);
        }

        private boolean has(Node node) {
            return this.toNodeList.contains(node);
        }
    }
}

