/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.data.util;

import com.nexacro.java.xapi.data.DataTypes;
import com.nexacro.java.xapi.util.DatetimeFormat;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

class DateTypeConverter {
    private static final int DEFAULT_YEAR = 1970;
    private static final int DEFAULT_MONTH = 0;
    private static final int DEFAULT_DATE = 1;
    private static final int DEFAULT_HOUR = 0;
    private static final int DEFAULT_MINUTE = 0;
    private static final int DEFAULT_SECOND = 0;
    private static final int DEFAULT_MILLISECOND = 0;
    private DatetimeFormat datetimeFormat = new DatetimeFormat();

    public Object toObject(Date value) {
        return value;
    }

    public String toString(Date value) {
        return this.toString(value, 11);
    }

    public String toString(Date value, int type) {
        if (value == null) {
            return DataTypes.DEFAULT_VALUE_STRING;
        }
        if (type == 9) {
            this.datetimeFormat.setFormat(2);
            return this.datetimeFormat.format(value);
        }
        if (type == 10) {
            this.datetimeFormat.setFormat(3);
            return this.datetimeFormat.format(value);
        }
        this.datetimeFormat.setFormat(0);
        return this.datetimeFormat.format(value);
    }

    public int toInt(Date value) {
        return 0;
    }

    public boolean toBoolean(Date value) {
        return false;
    }

    public long toLong(Date value) {
        return value == null ? 0L : value.getTime();
    }

    public float toFloat(Date value) {
        return 0.0f;
    }

    public double toDouble(Date value) {
        return 0.0;
    }

    public BigDecimal toBigDecimal(Date value) {
        return DataTypes.DEFAULT_VALUE_BIG_DECIMAL;
    }

    public Date toDate(Date value) {
        if (value == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public Date toTime(Date value) {
        if (value == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
        return cal.getTime();
    }

    public byte[] toBlob(Date value) {
        return DataTypes.DEFAULT_VALUE_BLOB;
    }

    public Object convert(Date value, int type) {
        switch (type) {
            case 2: {
                return this.toString(value);
            }
            case 3: {
                return new Integer(this.toInt(value));
            }
            case 4: {
                return this.toBoolean(value) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return new Long(this.toLong(value));
            }
            case 6: {
                return new Float(this.toFloat(value));
            }
            case 7: {
                return new Double(this.toDouble(value));
            }
            case 8: {
                return this.toBigDecimal(value);
            }
            case 9: {
                return this.toDate(value);
            }
            case 10: {
                return this.toTime(value);
            }
            case 11: {
                return this.toObject(value);
            }
            case 12: {
                return this.toBlob(value);
            }
        }
        return this.toObject(value);
    }
}

