/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.data.util;

import com.nexacro.java.xapi.data.DataTypes;
import java.math.BigDecimal;
import java.util.Date;

class FloatTypeConverter {
    public Object toObject(float value) {
        return new Float(value);
    }

    public String toString(float value) {
        return String.valueOf(value);
    }

    public int toInt(float value) {
        return (int)value;
    }

    public boolean toBoolean(float value) {
        return false;
    }

    public long toLong(float value) {
        return (long)value;
    }

    public double toDouble(float value) {
        return value;
    }

    public BigDecimal toBigDecimal(float value) {
        return new BigDecimal(String.valueOf(value));
    }

    public Date toDate(float value) {
        return DataTypes.DEFAULT_VALUE_DATE;
    }

    public Date toTime(float value) {
        return DataTypes.DEFAULT_VALUE_TIME;
    }

    public Date toDateTime(float value) {
        return DataTypes.DEFAULT_VALUE_DATE_TIME;
    }

    public byte[] toBlob(float value) {
        return DataTypes.DEFAULT_VALUE_BLOB;
    }

    public Object convert(float value, int type) {
        switch (type) {
            case 2: {
                return this.toString(value);
            }
            case 3: {
                return new Integer(this.toInt(value));
            }
            case 4: {
                return this.toBoolean(value) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return new Long(this.toLong(value));
            }
            case 6: {
                return this.toObject(value);
            }
            case 7: {
                return new Double(this.toDouble(value));
            }
            case 8: {
                return this.toBigDecimal(value);
            }
            case 9: {
                return this.toDate(value);
            }
            case 10: {
                return this.toTime(value);
            }
            case 11: {
                return this.toDateTime(value);
            }
            case 12: {
                return this.toBlob(value);
            }
        }
        return this.toObject(value);
    }
}

