/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.tx;

import com.nexacro.java.xapi.tx.StreamLog;
import com.nexacro.java.xapi.util.DatetimeFormat;
import java.io.File;
import java.io.IOException;
import java.util.Date;

public class DefaultStreamLogFile
implements StreamLog.StreamLogFile {
    private static final String DEFAULT_LOG_DIR = ".";
    private static final String DEFAULT_LOG_PREFIX = "xapi";
    private static final String DEFAULT_LOG_SUFFIX = "req";
    private DatetimeFormat dateFormat = new DatetimeFormat();
    private String path = null;

    private String getLogPath(String prefix, String suffix) {
        String dir = this.getPath();
        String logPrefix = this.isEmpty(prefix) ? DEFAULT_LOG_PREFIX : prefix;
        String logSuffix = this.isEmpty(suffix) ? DEFAULT_LOG_PREFIX : suffix;
        String file = logPrefix + "_" + this.getCurrentDateString() + DEFAULT_LOG_DIR + logSuffix;
        return dir + File.separator + file;
    }

    public String getPath() {
        if (this.isEmpty(this.path)) {
            return DEFAULT_LOG_DIR;
        }
        int len = this.path.length();
        char ch = this.path.charAt(len - 1);
        String dir = ch == '/' || ch == '\\' ? this.path.substring(0, len - 1) : this.path;
        return File.separatorChar == '/' ? dir.replace('\\', '/') : dir.replace('/', '\\');
    }

    public void setPath(String path) {
        this.path = path;
    }

    public File createLogFile(String prefix, String suffix) throws IOException {
        return new File(this.getLogPath(prefix, suffix));
    }

    private String getCurrentDateString() {
        return this.getDateString(System.currentTimeMillis());
    }

    private String getDateString(long time) {
        Date date = new Date(time);
        StringBuffer buffer = new StringBuffer();
        this.dateFormat.setFormat(2);
        buffer.append(this.dateFormat.format(date));
        buffer.append('_');
        this.dateFormat.setFormat(3);
        buffer.append(this.dateFormat.format(date));
        return buffer.toString();
    }

    private boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }
}

