/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.tx;

import com.nexacro.java.xapi.tx.PartPlatformResponse;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.tx.PlatformRequest;
import com.nexacro.java.xapi.tx.PlatformUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpPartPlatformResponse
extends PartPlatformResponse {
    private Log log = LogFactory.getLog((Class)HttpPartPlatformResponse.class);
    private HttpServletResponse httpRes;

    public HttpPartPlatformResponse(HttpServletResponse httpRes) {
        this(httpRes, (String)null);
    }

    public HttpPartPlatformResponse(HttpServletResponse httpRes, String contentType) {
        this(httpRes, contentType, null);
    }

    public HttpPartPlatformResponse(HttpServletResponse httpRes, String contentType, String charset) {
        super(contentType, charset);
        this.httpRes = httpRes;
    }

    public HttpPartPlatformResponse(HttpServletResponse httpRes, HttpServletRequest httpReq) {
        this(httpRes);
        this.setCheckLicense(!this.isLocalRequest(httpReq));
    }

    public HttpPartPlatformResponse(HttpServletResponse httpRes, PlatformRequest req) {
        super(req);
        this.httpRes = httpRes;
    }

    public HttpPartPlatformResponse(HttpServletResponse httpRes, Writer out) {
        this(httpRes, out, (String)null);
    }

    public HttpPartPlatformResponse(HttpServletResponse httpRes, Writer out, String contentType) {
        this(httpRes, out, contentType, null);
    }

    public HttpPartPlatformResponse(HttpServletResponse httpRes, Writer out, String contentType, String charset) {
        super(out, contentType, charset);
        this.httpRes = httpRes;
    }

    public HttpPartPlatformResponse(HttpServletResponse httpRes, Writer out, HttpServletRequest httpReq) {
        this(httpRes, out);
        this.setCheckLicense(!this.isLocalRequest(httpReq));
    }

    public HttpPartPlatformResponse(HttpServletResponse httpRes, Writer out, PlatformRequest req) {
        super(out, req);
        this.httpRes = httpRes;
    }

    public void start() throws PlatformException {
        if (this.isCurrentVerbose()) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)StringUtils.normalizeSpace((String)("Sending data to HTTP: " + this.toSimpleString())));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)StringUtils.normalizeSpace((String)("Sending data to HTTP: " + this.toSimpleString())));
        }
        String httpContentType = this.getHttpContentType();
        String charset = this.getCurrentCharset();
        if (this.log.isDebugEnabled() && this.log.isDebugEnabled()) {
            this.log.debug((Object)StringUtils.normalizeSpace((String)("Sending data: httpContentType=" + httpContentType + ", charset=" + charset)));
        }
        this.httpRes.setContentType(httpContentType.replaceAll("[\\r\\n]", ""));
        this.httpRes.setHeader("X-Content-Type-Options", "nosniff");
        if (this.getOutputStream() == null && this.getWriter() == null) {
            if (this.isCharStream()) {
                try {
                    PrintWriter writer = this.httpRes.getWriter();
                    this.setWriter(writer);
                }
                catch (IOException ex) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"Could not get HTTP Writer");
                    }
                    throw new PlatformException("Could not get HTTP Writer", ex);
                }
            }
            try {
                ServletOutputStream outputstream = this.httpRes.getOutputStream();
                this.setOutputStream((OutputStream)outputstream);
            }
            catch (IOException ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Could not get HTTP OutputStream");
                }
                throw new PlatformException("Could not get HTTP OutputStream", ex);
            }
        }
        if (!this.useOutputStream() && this.getWriter() instanceof JspWriter) {
            try {
                ((JspWriter)this.getWriter()).clearBuffer();
            }
            catch (IOException ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Could not clear JSP Buffer");
                }
                throw new PlatformException("Could not clear JSP Buffer", ex);
            }
        }
        super.start();
    }

    String getHttpContentType() {
        String contentType = this.getCurrentContentType();
        String charset = this.getCurrentCharset();
        return PlatformUtils.getHttpContentType(contentType, charset);
    }

    private boolean isLocalRequest(HttpServletRequest httpReq) {
        String serverName = httpReq.getServerName();
        return "localhost".equals(serverName) || "127.0.0.1".equals(serverName);
    }

    private boolean isCharStream() {
        if (this.getProtocolTypeCount() == 0) {
            String contentType = this.getCurrentContentType();
            return "PlatformXml".equals(contentType) || "MiXml".equals(contentType) || "PlatformHtml".equals(contentType);
        }
        return false;
    }
}

