/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.tx;

import com.nexacro.java.xapi.tx.JavaTypeDataSerializer;
import com.nexacro.java.xapi.tx.impl.PlatformBinaryJavaTypeDataSerializer;
import com.nexacro.java.xapi.tx.impl.PlatformXmlJavaTypeDataSerializer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaTypeDataSerializerFactory {
    private static final String SUFFIX_SERIALIZER = ".serializer";
    private static Map filters = new HashMap();

    public static JavaTypeDataSerializer getSerializer(String type) {
        block4: {
            Object serializer = filters.get(type + SUFFIX_SERIALIZER);
            if (serializer instanceof JavaTypeDataSerializer) {
                return (JavaTypeDataSerializer)serializer;
            }
            if (serializer instanceof Class) {
                try {
                    return (JavaTypeDataSerializer)((Class)serializer).newInstance();
                }
                catch (Throwable ex) {
                    Log log = LogFactory.getLog((Class)JavaTypeDataSerializerFactory.class);
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)("Could not create JavaTypeDataSerializer: type=" + type), ex);
                }
            }
        }
        return null;
    }

    public static void registerSerializer(String type, Object serializer) {
        block12: {
            JavaTypeDataSerializerFactory.checkType(type);
            Log log = LogFactory.getLog((Class)JavaTypeDataSerializerFactory.class);
            String contentType = type.trim();
            if (serializer instanceof JavaTypeDataSerializer) {
                filters.put(contentType + SUFFIX_SERIALIZER, serializer);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Register JavaTypeDataSerializer: type=" + type + ", serializer=" + serializer));
                }
            } else {
                if (serializer instanceof Class) {
                    try {
                        Object obj = ((Class)serializer).newInstance();
                        if (obj instanceof JavaTypeDataSerializer) {
                            filters.put(contentType + SUFFIX_SERIALIZER, serializer);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Register JavaTypeDataSerializer: type=" + type + ", serializer=" + serializer));
                            }
                        } else if (log.isWarnEnabled()) {
                            log.warn((Object)("Could not register JavaTypeDataSerializer: type=" + type + ", serializer=" + serializer));
                        }
                        break block12;
                    }
                    catch (Throwable ex) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)("Could not register JavaTypeDataSerializer: type=" + type + ", serializer=" + serializer), ex);
                        }
                        break block12;
                    }
                }
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Could not register JavaTypeDataSerializer: type=" + type + ", serializer=" + serializer));
                }
            }
        }
    }

    private static void initSerializers(Map filters) {
        filters.put("PlatformXml.serializer", PlatformXmlJavaTypeDataSerializer.class);
        filters.put("PlatformBinary.serializer", PlatformBinaryJavaTypeDataSerializer.class);
    }

    private static void checkType(String type) {
        if (type == null || "".equals(type)) {
            throw new IllegalArgumentException("No type specified");
        }
        if (type.charAt(0) == ' ' && "".equals(type.trim())) {
            throw new IllegalArgumentException("Invalid type: \"" + type + "\"");
        }
    }

    private JavaTypeDataSerializerFactory() {
    }

    static {
        JavaTypeDataSerializerFactory.initSerializers(filters);
    }
}

