/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.tx;

import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.tx.PlatformRequest;
import com.nexacro.java.xapi.tx.PlatformResponse;
import com.nexacro.java.xapi.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformFileClient {
    private Log log = LogFactory.getLog((Class)PlatformFileClient.class);
    private File source;
    private File target;
    private String sourceContentType;
    private String targetContentType;
    private String sourceCharset;
    private String targetCharset;
    private List sourceProtocolTypes;
    private List targetProtocolTypes;
    private boolean verbose;

    public PlatformFileClient(String path) {
        this(path, path);
    }

    public PlatformFileClient(String source, String target) {
        this(new File(source), new File(target));
    }

    public PlatformFileClient(File file) {
        this(file, file);
    }

    public PlatformFileClient(File file, String contentType) {
        this(file, file, contentType);
    }

    public PlatformFileClient(File file, String contentType, String charset) {
        this(file, file, contentType, charset);
    }

    public PlatformFileClient(File source, File target) {
        this(source, target, null, null);
    }

    public PlatformFileClient(File source, File target, String contentType) {
        this(source, target, contentType, null);
    }

    public PlatformFileClient(File source, File target, String contentType, String charset) {
        this.source = source;
        this.target = target;
        this.sourceContentType = contentType;
        this.targetContentType = contentType;
        this.sourceCharset = charset;
        this.targetCharset = charset;
    }

    public File getSource() {
        return this.source;
    }

    public void setSource(File source) {
        this.source = source;
    }

    public File getTarget() {
        return this.target;
    }

    public void setTarget(File target) {
        this.target = target;
    }

    public void setContentType(String contentType) {
        this.setSourceContentType(contentType);
        this.setTargetContentType(contentType);
    }

    public String getSourceContentType() {
        return this.sourceContentType;
    }

    public void setSourceContentType(String contentType) {
        this.sourceContentType = contentType;
    }

    public String getTargetContentType() {
        return this.targetContentType;
    }

    public void setTargetContentType(String contentType) {
        this.targetContentType = contentType;
    }

    public void setCharset(String charset) {
        this.setSourceCharset(charset);
        this.setTargetCharset(charset);
    }

    public String getSourceCharset() {
        return this.sourceCharset;
    }

    public void setSourceCharset(String charset) {
        this.sourceCharset = charset;
    }

    public String getTargetCharset() {
        return this.targetCharset;
    }

    public void setTargetCharset(String charset) {
        this.targetCharset = charset;
    }

    public void addProtocolType(String protocolType) {
        this.addSourceProtocolType(protocolType);
        this.addTargetProtocolType(protocolType);
    }

    public void removeProtocolType(String protocolType) {
        this.removeSourceProtocolType(protocolType);
        this.removeTargetProtocolType(protocolType);
    }

    public void clearProtocolTypes() {
        this.clearSourceProtocolTypes();
        this.clearTargetProtocolTypes();
    }

    public String getSourceProtocolType(int index) {
        return this.sourceProtocolTypes == null ? null : (String)this.sourceProtocolTypes.get(index);
    }

    public void addSourceProtocolType(String protocolType) {
        if (this.sourceProtocolTypes == null) {
            this.sourceProtocolTypes = new ArrayList();
        }
        if (this.sourceProtocolTypes.contains(protocolType)) {
            throw new IllegalArgumentException("Duplicate protocol type: " + protocolType);
        }
        this.sourceProtocolTypes.add(protocolType);
    }

    public void removeSourceProtocolType(int index) {
        this.sourceProtocolTypes.remove(index);
    }

    public void removeSourceProtocolType(String protocolType) {
        this.sourceProtocolTypes.remove(protocolType);
    }

    public boolean containsSourceProtocolType(String protocolType) {
        return this.sourceProtocolTypes == null ? false : this.sourceProtocolTypes.contains(protocolType);
    }

    public void clearSourceProtocolTypes() {
        if (this.getSourceProtocolTypeCount() > 0) {
            this.sourceProtocolTypes.clear();
        }
    }

    public int getSourceProtocolTypeCount() {
        return this.sourceProtocolTypes == null ? 0 : this.sourceProtocolTypes.size();
    }

    public String getTargetProtocolType(int index) {
        return this.targetProtocolTypes == null ? null : (String)this.targetProtocolTypes.get(index);
    }

    public void addTargetProtocolType(String protocolType) {
        if (this.targetProtocolTypes == null) {
            this.targetProtocolTypes = new ArrayList();
        }
        if (this.targetProtocolTypes.contains(protocolType)) {
            throw new IllegalArgumentException("Duplicate protocol type: " + protocolType);
        }
        this.targetProtocolTypes.add(protocolType);
    }

    public void removeTargetProtocolType(int index) {
        this.targetProtocolTypes.remove(index);
    }

    public void removeTargetProtocolType(String protocolType) {
        this.targetProtocolTypes.remove(protocolType);
    }

    public boolean containsTargetProtocolType(String protocolType) {
        return this.targetProtocolTypes == null ? false : this.targetProtocolTypes.contains(protocolType);
    }

    public void clearTargetProtocolTypes() {
        if (this.getTargetProtocolTypeCount() > 0) {
            this.targetProtocolTypes.clear();
        }
    }

    public int getTargetProtocolTypeCount() {
        return this.targetProtocolTypes == null ? 0 : this.targetProtocolTypes.size();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void sendData(PlatformData data) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Saving data: target=" + this.target + ", contentType=" + this.targetContentType + ", charset=" + this.targetCharset));
        }
        this.makeParentDirs(this.target);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.target);
        }
        catch (IOException ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not create FileOutputStream: target=" + this.target), (Throwable)ex);
            }
            throw new PlatformException("Could not create FileOutputStream: target=" + this.target, ex);
        }
        try {
            PlatformResponse res = new PlatformResponse(out);
            res.setContentType(this.getTargetCurrentContentType());
            res.setCharset(this.getTargetCurrentCharset());
            int protocolTypeCount = this.getTargetProtocolTypeCount();
            for (int i = 0; i < protocolTypeCount; ++i) {
                res.addProtocolType(this.getTargetProtocolType(i));
            }
            res.setData(data);
            res.sendData();
        }
        catch (PlatformException ex) {
            throw new PlatformException("Saving file failed: target=" + this.target, ex);
        }
        finally {
            block16: {
                try {
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                }
                catch (IOException ex) {
                    if (!this.log.isWarnEnabled()) break block16;
                    this.log.warn((Object)("Closing OutputStream failed: target=" + this.target), (Throwable)ex);
                }
            }
        }
    }

    public PlatformData receiveData() throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Loading data: source=" + this.source + ", contentType=" + this.sourceContentType + ", charset=" + this.sourceCharset));
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.source);
        }
        catch (IOException ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not create FileInputStream: source=" + this.source), (Throwable)ex);
            }
            throw new PlatformException("Could not create FileInputStream: source=" + this.source, ex);
        }
        try {
            PlatformRequest req = new PlatformRequest(in);
            req.setContentType(this.getSourceCurrentContentType());
            req.setCharset(this.getSourceCurrentCharset());
            int protocolTypeCount = this.getSourceProtocolTypeCount();
            for (int i = 0; i < protocolTypeCount; ++i) {
                req.addProtocolType(this.getSourceProtocolType(i));
            }
            req.receiveData();
            PlatformData platformData = req.getData();
            return platformData;
        }
        catch (PlatformException ex) {
            throw new PlatformException("Loading file failed: source=" + this.source, ex);
        }
        finally {
            block15: {
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                }
                catch (IOException ex) {
                    if (!this.log.isWarnEnabled()) break block15;
                    this.log.warn((Object)("Closing InputStream failed: source=" + this.source), (Throwable)ex);
                }
            }
            this.close();
        }
    }

    public void close() {
    }

    private String getSourceCurrentContentType() {
        String contentType = this.getSourceContentType();
        return StringUtils.isEmpty(contentType) ? this.getDefaultContentType() : contentType;
    }

    private String getTargetCurrentContentType() {
        String contentType = this.getTargetContentType();
        return StringUtils.isEmpty(contentType) ? this.getDefaultContentType() : contentType;
    }

    private String getSourceCurrentCharset() {
        String charset = this.getSourceCharset();
        return StringUtils.isEmpty(charset) ? this.getDefaultCharset() : charset;
    }

    private String getTargetCurrentCharset() {
        String charset = this.getTargetCharset();
        return StringUtils.isEmpty(charset) ? this.getDefaultCharset() : charset;
    }

    private String getDefaultContentType() {
        return "PlatformXml";
    }

    private String getDefaultCharset() {
        return "UTF-8";
    }

    private void makeParentDirs(File file) {
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Creating parent dir: file=" + file));
            }
            parent.mkdirs();
        }
    }
}

