/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.tx;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.license.InvalidLicenseException;
import com.nexacro.java.xapi.license.License;
import com.nexacro.java.xapi.tx.DataTypeChanger;
import com.nexacro.java.xapi.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class PlatformTransaction {
    private Log log = LogFactory.getLog((Class)PlatformTransaction.class);
    private static final boolean CHECK_LICENSE = true;
    static final String USER_CONTENT_TYPE = "__contentType__";
    static final String USER_CHARSET = "__charset__";
    static final String USER_PROTOCOL_TYPE = "__protocolType__";
    static final String USER_VERBOSE = "__verbose__";
    static final String HTTP_DATA = "httpData";
    static final String HTTP_DATA_COUNT = "httpDataCount";
    private boolean checkLicense = true;
    private String contentType;
    private String charset;
    private List protocolTypes;
    private PlatformData data;
    private DataTypeChanger dataTypeChanger;
    private boolean verbose;
    private Map properties;

    protected PlatformTransaction() {
    }

    protected PlatformTransaction(String contentType) {
        this(contentType, null);
    }

    protected PlatformTransaction(String contentType, String charset) {
        this.contentType = contentType;
        this.charset = charset;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getProtocolType(int index) {
        int userCount = this.getUserProtocolTypeCount();
        if (userCount == -1) {
            return this.protocolTypes == null ? null : (String)this.protocolTypes.get(index);
        }
        return this.getUserProtocolType(index);
    }

    public void addProtocolType(String protocolType) {
        if (this.protocolTypes == null) {
            this.protocolTypes = new ArrayList();
        }
        if (this.protocolTypes.contains(protocolType)) {
            throw new IllegalArgumentException("Duplicate protocol type: " + protocolType);
        }
        this.protocolTypes.add(protocolType);
    }

    public void removeProtocolType(int index) {
        this.protocolTypes.remove(index);
    }

    public void removeProtocolType(String protocolType) {
        this.protocolTypes.remove(protocolType);
    }

    public boolean containsProtocolType(String protocolType) {
        return this.protocolTypes == null ? false : this.protocolTypes.contains(protocolType);
    }

    public void clearProtocolTypes() {
        if (this.getProtocolTypeCount() > 0) {
            this.protocolTypes.clear();
        }
    }

    public int getProtocolTypeCount() {
        int userCount = this.getUserProtocolTypeCount();
        if (userCount == -1) {
            return this.protocolTypes == null ? 0 : this.protocolTypes.size();
        }
        return userCount;
    }

    public PlatformData getData() {
        return this.data;
    }

    public void setData(PlatformData data) {
        this.data = data;
    }

    public DataTypeChanger getDataTypeChanger() {
        return this.dataTypeChanger;
    }

    public void setDataTypeChanger(DataTypeChanger dataTypeChanger) {
        this.dataTypeChanger = dataTypeChanger;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public Object getProperty(String key) {
        return this.properties == null ? null : this.properties.get(key);
    }

    public void setProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(key, value);
    }

    protected String getCurrentContentType() {
        String contentType = this.getUserContentType();
        if (contentType != null) {
            contentType = contentType.trim();
            if (this.log.isDebugEnabled()) {
                try {
                    this.log.debug((Object)("User content type: " + URLEncoder.encode(contentType, "UTF-8")));
                }
                catch (UnsupportedEncodingException e) {
                    this.log.debug((Object)"UnsupportedEncodingException");
                }
            }
        }
        if (contentType == null || "".equals(contentType)) {
            contentType = this.getContentType();
            if (contentType != null) {
                contentType = contentType.trim();
            }
            if (contentType == null || "".equals(contentType)) {
                contentType = this.getDefaultContentType();
            }
        }
        return contentType;
    }

    protected String getCurrentCharset() {
        String charset = this.getUserCharset();
        if (charset != null) {
            charset = charset.trim();
            if (this.log.isDebugEnabled()) {
                try {
                    this.log.debug((Object)("User charset: " + URLEncoder.encode(charset, "UTF-8")));
                }
                catch (UnsupportedEncodingException e) {
                    this.log.debug((Object)"UnsupportedEncodingException");
                }
            }
        }
        if (charset == null || "".equals(charset)) {
            charset = this.getCharset();
            if (charset != null) {
                charset = charset.trim();
            }
            if (charset == null || "".equals(charset)) {
                charset = this.getDefaultCharset();
            }
        }
        return charset;
    }

    protected boolean isCurrentVerbose() {
        return this.isVerbose() || this.isUserVerbose();
    }

    protected String getDefaultContentType() {
        return "PlatformXml";
    }

    protected String getDefaultCharset() {
        return "UTF-8";
    }

    boolean isCheckLicense() {
        return this.checkLicense;
    }

    void setCheckLicense(boolean checkLicense) {
        this.checkLicense = checkLicense;
    }

    void checkLicense() throws InvalidLicenseException {
        if (this.isInternalPackage()) {
            return;
        }
        if (this.isCheckLicense()) {
            try {
                License license = License.getInstance(0);
                if (!license.isValidTime()) {
                    throw new InvalidLicenseException(3, "License has expired");
                }
            }
            catch (InvalidLicenseException ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Invalid license", (Throwable)ex);
                }
                System.out.println(ex.getMessage());
                throw ex;
            }
        }
    }

    String toSimpleString() {
        String name = this.getClass().getName();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return name + "@" + Integer.toHexString(this.hashCode());
        }
        return name.substring(index + 1) + "@" + Integer.toHexString(this.hashCode());
    }

    private String getUserContentType() {
        return this.getUserData(USER_CONTENT_TYPE);
    }

    private String getUserCharset() {
        return this.getUserData(USER_CHARSET);
    }

    private String getUserProtocolType(int index) {
        if (this.getUserProtocolTypeCount() > 0) {
            List protocolTypeList = StringUtils.split(this.getUserProtocolTypes().trim(), '|');
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)org.apache.commons.lang.StringUtils.normalizeSpace((String)("User protocol type: protocolTypeList=" + protocolTypeList)));
            }
            return (String)protocolTypeList.get(index);
        }
        return null;
    }

    private int getUserProtocolTypeCount() {
        String protocolType = this.getUserProtocolTypes();
        if (protocolType == null) {
            return -1;
        }
        if ("".equals(protocolType = protocolType.trim())) {
            return 0;
        }
        return StringUtils.split(protocolType, '|').size();
    }

    private String getUserProtocolTypes() {
        return this.getUserData(USER_PROTOCOL_TYPE);
    }

    private boolean isUserVerbose() {
        return "true".equals(this.getUserData(USER_VERBOSE));
    }

    private String getUserData(String name) {
        if (this.data == null) {
            return null;
        }
        String value = this.data.getVariableList().getString(name);
        if (value == null) {
            DataSet ds = this.data.getDataSet(HTTP_DATA);
            if (ds == null || ds.getRowCount() == 0) {
                return null;
            }
            return ds.getString(0, name);
        }
        return value;
    }

    private boolean isInternalPackage() {
        String className = this.getClass().getName();
        int len = className.length();
        if (len > 20 && className.substring(0, 20).hashCode() == 2054388934) {
            return true;
        }
        return len > 30 && className.substring(0, 30).hashCode() == 1422498297;
    }
}

