/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.tx;

import com.nexacro.java.xapi.tx.ProtocolDecoder;
import com.nexacro.java.xapi.tx.ProtocolEncoder;
import com.nexacro.java.xapi.tx.impl.PlatformZlibByteDecoder;
import com.nexacro.java.xapi.tx.impl.PlatformZlibByteEncoder;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProtocolFilterFactory {
    private static final String SUFFIX_BYTE_ENCODER = ".byteEncoder";
    private static final String SUFFIX_CHAR_ENCODER = ".charEncoder";
    private static final String SUFFIX_BYTE_DECODER = ".byteDecoder";
    private static final String SUFFIX_CHAR_DECODER = ".charDecoder";
    private static Map filters = new HashMap();

    public static OutputStream getEncoder(String type, OutputStream out) {
        block4: {
            Class encoder = (Class)filters.get(type + SUFFIX_BYTE_ENCODER);
            try {
                Class[] parameterTypes = new Class[]{OutputStream.class};
                Constructor constructor = encoder.getConstructor(parameterTypes);
                Object[] parameters = new Object[]{out};
                Object obj = constructor.newInstance(parameters);
                if (obj instanceof ProtocolEncoder && obj instanceof OutputStream) {
                    return (OutputStream)obj;
                }
                Log log = LogFactory.getLog((Class)ProtocolFilterFactory.class);
                if (log.isWarnEnabled()) {
                    log.warn((Object)StringUtils.normalizeSpace((String)("Could not create ProtocolEncoder: type=" + type + ", obj=" + obj)));
                }
            }
            catch (Throwable ex) {
                Log log = LogFactory.getLog((Class)ProtocolFilterFactory.class);
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)StringUtils.normalizeSpace((String)("Could not create ProtocolEncoder: type=" + type)), ex);
            }
        }
        return null;
    }

    public static Writer getEncoder(String type, Writer out) {
        block4: {
            Class encoder = (Class)filters.get(type + SUFFIX_CHAR_ENCODER);
            try {
                Class[] parameterTypes = new Class[]{Writer.class};
                Constructor constructor = encoder.getConstructor(parameterTypes);
                Object[] parameters = new Object[]{out};
                Object obj = constructor.newInstance(parameters);
                if (obj instanceof ProtocolEncoder && obj instanceof Writer) {
                    return (Writer)obj;
                }
                Log log = LogFactory.getLog((Class)ProtocolFilterFactory.class);
                if (log.isWarnEnabled()) {
                    log.warn((Object)StringUtils.normalizeSpace((String)("Could not create ProtocolEncoder: type=" + type + ", obj=" + obj)));
                }
            }
            catch (Throwable ex) {
                Log log = LogFactory.getLog((Class)ProtocolFilterFactory.class);
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)StringUtils.normalizeSpace((String)("Could not create ProtocolEncoder: type=" + type)), ex);
            }
        }
        return null;
    }

    public static InputStream getDecoder(String type, InputStream in) {
        block4: {
            Class decoder = (Class)filters.get(type + SUFFIX_BYTE_DECODER);
            try {
                Class[] parameterTypes = new Class[]{InputStream.class};
                Constructor constructor = decoder.getConstructor(parameterTypes);
                Object[] parameters = new Object[]{in};
                Object obj = constructor.newInstance(parameters);
                if (obj instanceof ProtocolDecoder && obj instanceof InputStream) {
                    return (InputStream)obj;
                }
                Log log = LogFactory.getLog((Class)ProtocolFilterFactory.class);
                if (log.isWarnEnabled()) {
                    log.warn((Object)StringUtils.normalizeSpace((String)("Could not create ProtocolDecoder: type=" + type + ", obj=" + obj)));
                }
            }
            catch (Throwable ex) {
                Log log = LogFactory.getLog((Class)ProtocolFilterFactory.class);
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)StringUtils.normalizeSpace((String)("Could not create ProtocolDecoder: type=" + type)), ex);
            }
        }
        return null;
    }

    public static Reader getDecoder(String type, Reader in) {
        block4: {
            Class decoder = (Class)filters.get(type + SUFFIX_CHAR_DECODER);
            try {
                Class[] parameterTypes = new Class[]{Reader.class};
                Constructor constructor = decoder.getConstructor(parameterTypes);
                Object[] parameters = new Object[]{in};
                Object obj = constructor.newInstance(parameters);
                if (obj instanceof ProtocolDecoder && obj instanceof Reader) {
                    return (Reader)obj;
                }
                Log log = LogFactory.getLog((Class)ProtocolFilterFactory.class);
                if (log.isWarnEnabled()) {
                    log.warn((Object)StringUtils.normalizeSpace((String)("Could not create ProtocolDecoder: type=" + type + ", obj=" + obj)));
                }
            }
            catch (Throwable ex) {
                Log log = LogFactory.getLog((Class)ProtocolFilterFactory.class);
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)StringUtils.normalizeSpace((String)("Could not create ProtocolDecoder: type=" + type)), ex);
            }
        }
        return null;
    }

    private static void initEncoders(Map filters) {
        filters.put("PlatformZlib.byteEncoder", PlatformZlibByteEncoder.class);
    }

    private static void initDecoders(Map filters) {
        filters.put("PlatformZlib.byteDecoder", PlatformZlibByteDecoder.class);
    }

    private ProtocolFilterFactory() {
    }

    static {
        ProtocolFilterFactory.initEncoders(filters);
        ProtocolFilterFactory.initDecoders(filters);
    }
}

