/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.tx;

import com.nexacro.java.xapi.tx.StreamLog;
import com.nexacro.java.xapi.tx.StreamLogReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class StreamLogInputStream
extends InputStream {
    private InputStream in;
    private StreamLog streamLog;
    private ByteArrayOutputStream buffer;

    public StreamLogInputStream(InputStream in, StreamLog streamLog) {
        this.in = in;
        this.streamLog = streamLog;
    }

    public int read() throws IOException {
        int b = this.in.read();
        if (b != -1 && this.checkBuffer(1)) {
            this.buffer.write(b);
        }
        return b;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int n = this.in.read(b, off, len);
        if (n > 0 && this.checkBuffer(n)) {
            this.buffer.write(b, off, n);
        }
        return n;
    }

    public long skip(long n) throws IOException {
        long remaining;
        int nr;
        if (n <= 0L) {
            return 0L;
        }
        byte[] skipBuffer = new byte[2048];
        for (remaining = n; remaining > 0L && (nr = this.in.read(skipBuffer, 0, (int)Math.min(2048L, remaining))) >= 0; remaining -= (long)nr) {
            if (nr <= 0 || !this.checkBuffer(nr)) continue;
            this.buffer.write(skipBuffer, 0, nr);
        }
        return n - remaining;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeStreamLog() throws IOException {
        File parent;
        Log log = LogFactory.getLog((Class)StreamLogReader.class);
        File file = this.streamLog.createLogFile();
        if (file == null) {
            return;
        }
        boolean exists = file.exists();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Storing stream: path=" + URLEncoder.encode(file.getAbsolutePath(), "UTF-8") + ", exists=" + exists));
        }
        if (exists) {
            block21: {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException ex) {
                    if (!log.isErrorEnabled()) break block21;
                    log.error((Object)ex.getMessage());
                }
            }
            file = this.streamLog.createLogFile();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Storing stream: path=" + URLEncoder.encode(file.getAbsolutePath(), "UTF-8")));
            }
        }
        if (!(parent = file.getParentFile()).exists()) {
            parent.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(file);
        try {
            if (this.buffer == null) {
                if (this.in == null) {
                    out.write("The buffer does not exist. in=null".getBytes());
                } else if (this.in.available() > 0) {
                    this.copy(this.in, out);
                } else {
                    out.write("The buffer does not exist. in.available()=0".getBytes());
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("buffer=" + this.buffer.size()));
                }
                out.write(this.buffer.toByteArray());
                if (this.streamLog.isExceededSize()) {
                    int maxSize = this.streamLog.getLogMaxSize();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("The buffer was exceeded. maxSize=" + maxSize));
                    }
                    out.write(System.getProperty("line.separator").getBytes());
                    out.write(("The buffer was exceeded. maxSize=" + maxSize).getBytes());
                } else if (this.in.available() > 0) {
                    this.copy(this.in, out);
                }
            }
        }
        finally {
            out.close();
        }
    }

    private long copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = in.read(buffer))) {
            out.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    private boolean checkBuffer(int length) {
        if (this.streamLog.isExceededSize()) {
            return false;
        }
        if (this.buffer == null) {
            this.buffer = new ByteArrayOutputStream();
        }
        if (this.buffer.size() + length > this.streamLog.getLogMaxSize()) {
            this.streamLog.setExceededSize(true);
            return false;
        }
        return true;
    }
}

