/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.tx.impl;

import com.nexacro.java.xapi.data.ColumnHeader;
import com.nexacro.java.xapi.data.ConstantColumnHeader;
import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.DataSetList;
import com.nexacro.java.xapi.data.DataTypes;
import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.data.Variable;
import com.nexacro.java.xapi.data.VariableList;
import com.nexacro.java.xapi.tx.DataSerializer;
import com.nexacro.java.xapi.tx.DataTypeChanger;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.tx.PlatformUtils;
import com.nexacro.java.xapi.tx.impl.Base64;
import com.nexacro.java.xapi.tx.impl.PlatformCodec;
import com.nexacro.java.xapi.tx.impl.XmlCodec;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MiXmlDataSerializer
implements DataSerializer {
    private Log log = LogFactory.getLog((Class)MiXmlDataSerializer.class);
    private static final boolean NULL_IS_SINGLE_TAG = true;
    private static final String NL = System.getProperty("line.separator");
    private static final String[] TABS = new String[]{"", "\t", "\t\t", "\t\t\t", "\t\t\t\t", "\t\t\t\t\t"};
    private static final int BUFFER_SIZE = 4096;
    private PlatformCodec platformCodec = new PlatformCodec();
    private XmlCodec xmlCodec = new XmlCodec();
    private byte[] buffer;

    public void setProperty(String key, Object value) {
    }

    public void writeData(OutputStream out, PlatformData data, DataTypeChanger dataTypeChanger, String charset) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Writing data: this=" + this + ", charset=" + (charset != null ? URLEncoder.encode(charset, "UTF-8") : null)));
            }
            catch (UnsupportedEncodingException e) {
                this.log.debug((Object)"UnsupportedEncodingException");
            }
        }
        try {
            this.writeData(new OutputStreamWriter(out, charset), data, dataTypeChanger, charset);
        }
        catch (UnsupportedEncodingException ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Unsupported charset: ", (Throwable)ex);
            }
            throw new PlatformException("Unsupported charset: " + charset, ex);
        }
    }

    public void writeData(Writer out, PlatformData data, DataTypeChanger dataTypeChanger, String charset) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Writing data: this=" + this + ", charset=" + (charset != null ? URLEncoder.encode(charset, "UTF-8") : null)));
            }
            catch (UnsupportedEncodingException e) {
                this.log.debug((Object)"UnsupportedEncodingException");
            }
        }
        try {
            this.write(out, data, dataTypeChanger, charset);
        }
        catch (IOException ex) {
            String contentType = "MiXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not serialize: contentType=" + contentType, ex);
        }
    }

    private void write(Writer out, PlatformData data, DataTypeChanger dataTypeChanger, String charset) throws IOException {
        int depth = 0;
        this.writeHeader(out, data, charset, depth);
        this.writeBeginRoot(out, depth);
        this.writeVariableList(out, data, dataTypeChanger, ++depth);
        this.writeDataSetList(out, data, dataTypeChanger, depth--);
        this.writeEndRoot(out, depth);
        out.flush();
    }

    private void writeHeader(Writer out, PlatformData data, String charset, int depth) throws IOException {
        if (charset == null) {
            this.writeString(out, "<?xml version=\"1.0\"?>", depth);
        } else {
            this.writeString(out, "<?xml version=\"1.0\" encoding=\"" + charset + "\"?>", depth);
        }
    }

    private void writeBeginRoot(Writer out, int depth) throws IOException {
        this.writeString(out, "<root>", depth);
    }

    private void writeEndRoot(Writer out, int depth) throws IOException {
        this.writeString(out, "</root>", depth);
    }

    private void writeVariableList(Writer out, PlatformData data, DataTypeChanger dataTypeChanger, int depth) throws IOException {
        VariableList varList = data.getVariableList();
        int count = varList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing VariableList: count=" + count));
        }
        if (count == 0) {
            this.writeString(out, "<params/>", depth);
        } else {
            this.writeString(out, "<params>", depth++);
            for (int i = 0; i < count; ++i) {
                this.writeVariable(out, varList.get(i), dataTypeChanger, depth);
            }
            this.writeString(out, "</params>", --depth);
        }
    }

    private void writeVariable(Writer out, Variable var, DataTypeChanger dataTypeChanger, int depth) throws IOException {
        if (DataTypes.isBinary(var.getType())) {
            this.writeBinaryVariable(out, var, depth);
        } else {
            this.writeStringVariable(out, var, depth);
        }
    }

    private void writeStringVariable(Writer out, Variable var, int depth) throws IOException {
        String name = var.getName();
        String type = this.toMiType(var.getType());
        String value = this.getStringValue(var);
        int length = value == null ? 0 : value.length();
        StringBuffer buffer = new StringBuffer(length + 64);
        buffer.append("<param id=\"").append(name);
        buffer.append("\" type=\"").append(type);
        if (value == null) {
            buffer.append("\"/>");
        } else {
            buffer.append("\">").append(value);
            buffer.append("</param>");
        }
        this.writeString(out, buffer.toString(), depth);
    }

    private void writeBinaryVariable(Writer out, Variable var, int depth) throws IOException {
        String name = var.getName();
        String type = this.toMiType(var.getType());
        byte[] value = this.getBinaryValue(var);
        if (value == null) {
            StringBuffer buffer = new StringBuffer(64);
            buffer.append("<param id=\"").append(name);
            buffer.append("\" type=\"").append(type);
            buffer.append("\"/>");
            this.writeString(out, buffer.toString(), depth);
        } else {
            String prefix = "<param id=\"" + name + "\" type=\"" + type + "\" encrypt=\"base64\">";
            String suffix = "</param>";
            this.writeBinary(out, value, prefix, suffix, depth);
        }
    }

    private String getStringValue(Variable var) {
        int dataType = var.getType();
        if (dataType == 4) {
            return var.getBoolean() ? "1" : "0";
        }
        String value = var.getString();
        if (value == null) {
            return value;
        }
        if (dataType == 2) {
            return this.encode(value);
        }
        return value;
    }

    private byte[] getBinaryValue(Variable var) {
        return var.getBlob();
    }

    private void writeDataSetList(Writer out, PlatformData data, DataTypeChanger dataTypeChanger, int depth) throws IOException {
        DataSetList dsList = data.getDataSetList();
        int count = dsList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSetList: count=" + count));
        }
        for (int i = 0; i < count; ++i) {
            this.writeDataSet(out, data, dsList.get(i), dataTypeChanger, depth);
        }
    }

    private void writeDataSet(Writer out, PlatformData data, DataSet ds, DataTypeChanger dataTypeChanger, int depth) throws IOException {
        String name = ds.getName();
        String alias = ds.getAlias();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSet: name=" + (name != null ? URLEncoder.encode(name, "UTF-8") : null) + ", alias=" + (alias != null ? URLEncoder.encode(alias, "UTF-8") : null) + ", columnCount=" + ds.getColumnCount() + ", rowCount=" + ds.getRowCount() + ", removedRowCount=" + ds.getRemovedRowCount()));
        }
        this.writeString(out, "<dataset id=\"" + alias + "\">", depth);
        int[] dataTypes = this.getTargetDataTypes(ds, dataTypeChanger);
        this.writeColumns(out, ds, dataTypes, ++depth);
        this.writeRows(out, data, ds, dataTypes, depth--);
        this.writeString(out, "</dataset>", depth);
    }

    private void writeColumns(Writer out, DataSet ds, int[] dataTypes, int depth) throws IOException {
        int dataType;
        ColumnHeader header;
        int i;
        int count = ds.getColumnCount();
        for (i = 0; i < count; ++i) {
            header = ds.getColumn(i);
            if (header.getType() == 0) continue;
            if (header.getType() == 1) {
                dataType = dataTypes[i];
                this.writeConstantColumnHeader(out, ds, header, dataType, depth);
                continue;
            }
            throw new IOException("Invalid column type: " + header.getType());
        }
        for (i = 0; i < count; ++i) {
            header = ds.getColumn(i);
            if (header.getType() != 0) continue;
            dataType = dataTypes[i];
            this.writeDefaultColumnHeader(out, header, dataType, depth);
        }
    }

    private void writeDefaultColumnHeader(Writer out, ColumnHeader header, int dataType, int depth) throws IOException {
        String name = header.getName();
        String dataTypeStr = this.toMiType(dataType);
        int dataSize = header.getDataSize();
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("<colinfo id=\"").append(name);
        buffer.append("\" type=\"").append(dataTypeStr);
        buffer.append("\" size=\"").append(dataSize);
        if (dataType == 13 || DataTypes.isBinary(dataType)) {
            buffer.append("\" encrypt=\"").append("base64");
        }
        buffer.append("\"/>");
        this.writeString(out, buffer.toString(), depth);
    }

    private void writeConstantColumnHeader(Writer out, DataSet ds, ColumnHeader header, int dataType, int depth) throws IOException {
        if (DataTypes.isBinary(header.getDataType())) {
            this.writeBinaryColumnHeader(out, ds, (ConstantColumnHeader)header, dataType, depth);
        } else {
            this.writeStringColumnHeader(out, ds, (ConstantColumnHeader)header, dataType, depth);
        }
    }

    private void writeStringColumnHeader(Writer out, DataSet ds, ConstantColumnHeader header, int dataType, int depth) throws IOException {
        if (dataType == 13) {
            dataType = 2;
        }
        String name = header.getName();
        String dataTypeStr = this.toMiType(dataType);
        int dataSize = header.getDataSize();
        String value = this.getStringValue(ds, header);
        int length = value == null ? 0 : value.length();
        StringBuffer buffer = new StringBuffer(length + 64);
        buffer.append("<column id=\"").append(name);
        buffer.append("\" type=\"").append(dataTypeStr);
        buffer.append("\" size=\"").append(dataSize);
        if (value == null) {
            buffer.append("\"/>");
        } else {
            buffer.append("\">").append(value);
            buffer.append("</column>");
        }
        this.writeString(out, buffer.toString(), depth);
    }

    private void writeBinaryColumnHeader(Writer out, DataSet ds, ConstantColumnHeader header, int dataType, int depth) throws IOException {
        String name = header.getName();
        String dataTypeStr = this.toMiType(dataType);
        int dataSize = header.getDataSize();
        byte[] value = this.getBinaryValue(ds, header);
        if (value == null) {
            StringBuffer buffer = new StringBuffer(64);
            buffer.append("<column id=\"").append(name);
            buffer.append("\" type=\"").append(dataTypeStr);
            buffer.append("\" size=\"").append(dataSize);
            buffer.append("\"/>");
            this.writeString(out, buffer.toString(), depth);
        } else {
            String prefix = "<column id=\"" + name + "\" type=\"" + dataTypeStr + "\" size=\"" + dataSize + "\" encrypt=\"base64\">";
            String suffix = "</column>";
            this.writeBinary(out, value, prefix, suffix, depth);
        }
    }

    private String getStringValue(DataSet ds, ConstantColumnHeader header) {
        int dataType = header.getDataType();
        if (dataType == 4) {
            return header.getBooleanValue(ds) ? "1" : "0";
        }
        String value = header.getStringValue(ds);
        if (value == null) {
            return value;
        }
        if (dataType == 2) {
            return this.encode(value);
        }
        return value;
    }

    private byte[] getBinaryValue(DataSet ds, ConstantColumnHeader header) {
        return header.getBlobValue(ds);
    }

    private void writeRows(Writer out, PlatformData data, DataSet ds, int[] dataTypes, int depth) throws IOException {
        boolean isCheckingGetterDataIndex;
        int saveType = ds.getSaveType();
        if (saveType == 0) {
            saveType = data.getSaveType();
        }
        if (saveType == 0) {
            saveType = 2;
        }
        int count = ds.getRowCount();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing rows: count=" + count));
        }
        if (isCheckingGetterDataIndex = ds.isCheckingGetterDataIndex()) {
            ds.setCheckingGetterDataIndex(false);
        }
        for (int i = 0; i < count; ++i) {
            this.writeRow(out, ds, dataTypes, i, saveType, depth);
        }
        if (saveType == 1 || saveType == 4 || saveType == 5) {
            int removedCount = ds.getRemovedRowCount();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Writing removed rows: removedCount=" + removedCount));
            }
            for (int i = 0; i < removedCount; ++i) {
                this.writeRemovedRow(out, ds, dataTypes, i, depth);
            }
        }
        if (isCheckingGetterDataIndex) {
            ds.setCheckingGetterDataIndex(true);
        }
    }

    private void writeRow(Writer out, DataSet ds, int[] dataTypes, int row, int saveType, int depth) throws IOException {
        int rowType = ds.getRowType(row);
        if (saveType != 1 && (saveType == 2 ? rowType == 3 : (saveType == 3 ? rowType == 0 || rowType == 3 : (saveType == 4 ? rowType == 0 || rowType == 1 || rowType == 2 : saveType == 5 && rowType == 0)))) {
            return;
        }
        if (saveType == 2) {
            this.writeString(out, "<record>", depth++);
        } else if (rowType == 1) {
            this.writeString(out, "<record type=\"insert\">", depth++);
        } else if (rowType == 2) {
            this.writeString(out, "<record type=\"update\">", depth++);
        } else if (rowType == 3) {
            this.writeString(out, "<record type=\"delete\">", depth++);
        } else {
            this.writeString(out, "<record>", depth++);
        }
        int count = ds.getColumnCount();
        for (int i = 0; i < count; ++i) {
            Object value;
            ColumnHeader header = ds.getColumn(i);
            if (header.isConstant()) continue;
            String name = header.getName();
            int sourceDataType = header.getDataType();
            int dataType = dataTypes[i];
            if (dataType == 13 || DataTypes.isBinary(dataType)) {
                byte[] byArray = value = sourceDataType == 13 ? this.getBinaryValueFromFile(ds, row, i, dataType) : this.getBinaryValue(ds, row, i);
                if (value == null) {
                    this.writeString(out, "<" + name + "/>", depth);
                    continue;
                }
                String prefix = "<" + name + ">";
                String suffix = "</" + name + ">";
                this.writeBinary(out, (byte[])value, prefix, suffix, depth);
                continue;
            }
            value = sourceDataType == 13 ? this.getStringValueFromFile(ds, row, i, dataType) : this.getStringValue(ds, row, i);
            if (value == null) {
                this.writeString(out, "<" + name + "/>", depth);
                continue;
            }
            this.writeString(out, "<" + name + ">" + (String)value + "</" + name + ">", depth);
        }
        if ((saveType == 1 || saveType == 3 || saveType == 5) && rowType == 2) {
            this.writeSavedRow(out, ds, dataTypes, row, depth);
        }
        this.writeString(out, "</record>", --depth);
    }

    private void writeSavedRow(Writer out, DataSet ds, int[] dataTypes, int row, int depth) throws IOException {
        this.writeString(out, "<org_record>", depth++);
        int count = ds.getColumnCount();
        for (int i = 0; i < count; ++i) {
            Object value;
            ColumnHeader header = ds.getColumn(i);
            if (header.isConstant()) continue;
            String name = header.getName();
            int sourceDataType = header.getDataType();
            int dataType = dataTypes[i];
            if (dataType == 13 || DataTypes.isBinary(dataType)) {
                byte[] byArray = value = sourceDataType == 13 ? this.getSavedBinaryValueFromFile(ds, row, i, dataType) : this.getSavedBinaryValue(ds, row, i);
                if (value == null) {
                    this.writeString(out, "<" + name + "/>", depth);
                    continue;
                }
                String prefix = "<" + name + ">";
                String suffix = "</" + name + ">";
                this.writeBinary(out, (byte[])value, prefix, suffix, depth);
                continue;
            }
            value = sourceDataType == 13 ? this.getSavedStringValueFromFile(ds, row, i, dataType) : this.getSavedStringValue(ds, row, i);
            if (value == null) {
                this.writeString(out, "<" + name + "/>", depth);
                continue;
            }
            this.writeString(out, "<" + name + ">" + (String)value + "</" + name + ">", depth);
        }
        this.writeString(out, "</org_record>", --depth);
    }

    private void writeRemovedRow(Writer out, DataSet ds, int[] dataTypes, int row, int depth) throws IOException {
        this.writeString(out, "<record type=\"delete\">", depth++);
        int count = ds.getColumnCount();
        for (int i = 0; i < count; ++i) {
            Object value;
            ColumnHeader header = ds.getColumn(i);
            if (header.isConstant()) continue;
            String name = header.getName();
            int sourceDataType = header.getDataType();
            int dataType = dataTypes[i];
            if (dataType == 13 || DataTypes.isBinary(dataType)) {
                byte[] byArray = value = sourceDataType == 13 ? this.getRemovedBinaryValueFromFile(ds, row, i, dataType) : this.getRemovedBinaryValue(ds, row, i);
                if (value == null) {
                    this.writeString(out, "<" + name + "/>", depth);
                    continue;
                }
                String prefix = "<" + name + ">";
                String suffix = "</" + name + ">";
                this.writeBinary(out, (byte[])value, prefix, suffix, depth);
                continue;
            }
            value = sourceDataType == 13 ? this.getRemovedStringValueFromFile(ds, row, i, dataType) : this.getRemovedStringValue(ds, row, i);
            if (value == null) {
                this.writeString(out, "<" + name + "/>", depth);
                continue;
            }
            this.writeString(out, "<" + name + ">" + (String)value + "</" + name + ">", depth);
        }
        this.writeString(out, "</record>", --depth);
    }

    private String getStringValue(DataSet ds, int row, int column) {
        int dataType = ds.getColumn(column).getDataType();
        if (dataType == 4) {
            return ds.getBoolean(row, column) ? "1" : "0";
        }
        String value = ds.getString(row, column);
        if (dataType == 2) {
            value = this.encode(value);
        }
        return value;
    }

    private byte[] getBinaryValue(DataSet ds, int row, int column) {
        return ds.getBlob(row, column);
    }

    private String getStringValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 2) {
            String filename = ds.getString(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading data from file: filename=" + (filename != null ? URLEncoder.encode(filename, "UTF-8") : null) + ", content=" + content));
            }
            return content == null ? null : this.encode(new String(content));
        }
        return null;
    }

    private byte[] getBinaryValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 12 || dataType == 13) {
            String filename = ds.getString(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading data from file: filename=" + (filename != null ? URLEncoder.encode(filename, "UTF-8") : null) + ", content=" + content));
            }
            return content;
        }
        return null;
    }

    private String getSavedStringValue(DataSet ds, int row, int column) {
        int dataType = ds.getColumn(column).getDataType();
        if (dataType == 4) {
            return ds.getSavedBooleanData(row, column) ? "1" : "0";
        }
        String value = ds.getSavedStringData(row, column);
        if (dataType == 2) {
            value = this.encode(value);
        }
        return value;
    }

    private byte[] getSavedBinaryValue(DataSet ds, int row, int column) {
        return ds.getSavedBlobData(row, column);
    }

    private String getSavedStringValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 2) {
            String filename = ds.getSavedStringData(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading saved data from file: filename=" + (filename != null ? URLEncoder.encode(filename, "UTF-8") : null) + ", content=" + content));
            }
            return content == null ? null : this.encode(new String(content));
        }
        return null;
    }

    private byte[] getSavedBinaryValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 12 || dataType == 13) {
            String filename = ds.getSavedStringData(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading saved data from file: filename=" + (filename != null ? URLEncoder.encode(filename, "UTF-8") : null) + ", content=" + content));
            }
            return content;
        }
        return null;
    }

    private String getRemovedStringValue(DataSet ds, int row, int column) {
        int dataType = ds.getColumn(column).getDataType();
        if (dataType == 4) {
            return ds.getRemovedBooleanData(row, column) ? "1" : "0";
        }
        String value = ds.getRemovedStringData(row, column);
        if (dataType == 2) {
            value = this.encode(value);
        }
        return value;
    }

    private byte[] getRemovedBinaryValue(DataSet ds, int row, int column) {
        return ds.getRemovedBlobData(row, column);
    }

    private String getRemovedStringValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 2) {
            String filename = ds.getRemovedStringData(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading removed data from file: filename=" + (filename != null ? URLEncoder.encode(filename, "UTF-8") : null) + ", content=" + content));
            }
            return content == null ? null : this.encode(new String(content));
        }
        return null;
    }

    private byte[] getRemovedBinaryValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 12 || dataType == 13) {
            String filename = ds.getRemovedStringData(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading removed data from file: filename=" + (filename != null ? URLEncoder.encode(filename, "UTF-8") : null) + ", content=" + content));
            }
            return content;
        }
        return null;
    }

    private void writeString(Writer out, String str, int depth) throws IOException {
        PlatformUtils.PlatformEncoder encoder = PlatformUtils.getPlatformEncoder("xml");
        if (depth == 0) {
            encoder.encodeTo(out, str);
            out.write(NL);
        } else if (depth < 6) {
            out.write(TABS[depth]);
            encoder.encodeTo(out, str);
            out.write(NL);
        } else {
            for (int i = 0; i < depth; ++i) {
                out.write(TABS[0]);
            }
            encoder.encodeTo(out, str);
            out.write(NL);
        }
    }

    private void writeBinary(Writer out, byte[] value, String prefix, String suffix, int depth) throws IOException {
        PlatformUtils.PlatformEncoder encoder = PlatformUtils.getPlatformEncoder("xml");
        if (depth == 0) {
            encoder.encodeTo(out, prefix);
            String encoded = Base64.encodeBytes(value, 8);
            encoder.encodeTo(out, encoded);
            encoder.encodeTo(out, suffix);
            out.write(NL);
        } else if (depth < 6) {
            out.write(TABS[depth]);
            encoder.encodeTo(out, prefix);
            String encoded = Base64.encodeBytes(value, 8);
            encoder.encodeTo(out, encoded);
            encoder.encodeTo(out, suffix);
            out.write(NL);
        } else {
            for (int i = 0; i < depth; ++i) {
                out.write(TABS[0]);
            }
            encoder.encodeTo(out, prefix);
            String encoded = Base64.encodeBytes(value, 8);
            encoder.encodeTo(out, encoded);
            encoder.encodeTo(out, suffix);
            out.write(NL);
        }
    }

    private int[] getTargetDataTypes(DataSet ds, DataTypeChanger dataTypeChanger) {
        int count = ds.getColumnCount();
        int[] dataTypes = new int[count];
        for (int i = 0; i < count; ++i) {
            ColumnHeader header = ds.getColumn(i);
            if (dataTypeChanger == null) {
                dataTypes[i] = header.getDataType();
                continue;
            }
            String dsName = ds.getAlias();
            String columnName = header.getName();
            int dataType = header.getDataType();
            dataTypes[i] = dataTypeChanger.getDataType(dsName, columnName, dataType);
        }
        return dataTypes;
    }

    private String toMiType(int type) {
        switch (type) {
            case 2: {
                return "STRING";
            }
            case 3: {
                return "INT";
            }
            case 4: {
                return "INT";
            }
            case 5: {
                return "CURRENCY";
            }
            case 6: {
                return "DECIMAL";
            }
            case 7: {
                return "DECIMAL";
            }
            case 8: {
                return "STRING";
            }
            case 9: {
                return "DATE";
            }
            case 10: {
                return "DATE";
            }
            case 11: {
                return "DATE";
            }
            case 12: {
                return "BLOB";
            }
            case 13: {
                return "BLOB";
            }
            case 0: {
                return "STRING";
            }
            case 1: {
                return "STRING";
            }
        }
        return "STRING";
    }

    private String encode(String str) {
        if (str == null) {
            return str;
        }
        return this.xmlCodec.encode(this.platformCodec.encode(str));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadFile(String filename) throws IOException {
        if (filename == null) {
            return null;
        }
        File file = null;
        PlatformUtils.PlatformFileHandler fileHandler = PlatformUtils.getPlatformFileHandler(filename);
        if (fileHandler != null) {
            file = fileHandler.toFile();
        }
        if (file != null && file.canRead()) {
            FileInputStream in = new FileInputStream(file);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = this.getBuffer();
            try {
                int n;
                while ((n = in.read(buffer)) != -1) {
                    out.write(buffer, 0, n);
                }
                out.close();
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            finally {
                in.close();
            }
        }
        return null;
    }

    private byte[] getBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[4096];
        }
        return this.buffer;
    }
}

