/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.tx.impl;

import com.nexacro.java.xapi.data.ColumnHeader;
import com.nexacro.java.xapi.data.ConstantColumnHeader;
import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.DataSetList;
import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.data.Variable;
import com.nexacro.java.xapi.data.VariableList;
import com.nexacro.java.xapi.tx.DataSerializer;
import com.nexacro.java.xapi.tx.DataTypeChanger;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.tx.PlatformUtils;
import com.nexacro.java.xapi.tx.impl.PlatformCodec;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformBinaryDataSerializer
implements DataSerializer {
    private Log log = LogFactory.getLog((Class)PlatformBinaryDataSerializer.class);
    private static final String CHARSET = "UTF-8";
    private static final int BUFFER_SIZE = 4096;
    private static final boolean COLUMN_SORT = false;
    private static final int TIMEZONE_OFFSET = PlatformBinaryDataSerializer.getTimezoneOffset();
    private PlatformCodec platformCodec = new PlatformCodec();
    private Map columnIndexesMap = new HashMap();
    private byte[] buffer;

    private static int getTimezoneOffset() {
        Calendar cal = Calendar.getInstance();
        return cal.get(15) + cal.get(16);
    }

    public void setProperty(String key, Object value) {
    }

    public void writeData(OutputStream out, PlatformData data, DataTypeChanger dataTypeChanger, String charset) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Writing data: this=" + this + ", charset=" + (charset != null ? URLEncoder.encode(charset, CHARSET) : null)));
            }
            catch (UnsupportedEncodingException e) {
                this.log.debug((Object)"UnsupportedEncodingException");
            }
        }
        try {
            this.write(out, data, dataTypeChanger);
        }
        catch (IOException ex) {
            String contentType = "PlatformBinary";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not serialize: contentType=" + contentType, ex);
        }
    }

    public void writeData(Writer out, PlatformData data, DataTypeChanger dataTypeChanger, String charset) throws PlatformException {
        String contentType = "PlatformBinary";
        throw new UnsupportedOperationException("Unsupported content type: " + contentType);
    }

    protected void write(OutputStream out, PlatformData data, DataTypeChanger dataTypeChanger) throws IOException {
        DataOutputStream stream = out instanceof DataOutputStream ? (DataOutputStream)out : new DataOutputStream(out);
        this.writeVariableList(stream, data, dataTypeChanger);
        this.writeDataSetList(stream, data, dataTypeChanger);
        stream.flush();
    }

    protected void writeVariableList(DataOutputStream out, PlatformData data, DataTypeChanger dataTypeChanger) throws IOException {
        PlatformUtils.PlatformEncoder encoder = PlatformUtils.getPlatformEncoder("bin");
        VariableList vl = data.getVariableList();
        int count = vl.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing VariableList: count=" + count));
        }
        if (count == 0) {
            return;
        }
        out.writeShort(65040);
        out.writeShort(5000);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream bufferOut = new DataOutputStream(buffer);
        bufferOut.writeShort(count);
        for (int i = 0; i < count; ++i) {
            Variable var = vl.get(i);
            this.writeVariable(bufferOut, var, dataTypeChanger);
        }
        bufferOut.close();
        buffer.close();
        byte[] bin = buffer.toByteArray();
        this.writeLength(out, bin.length);
        encoder.encodeTo(out, bin);
    }

    protected void writeVariable(DataOutputStream out, Variable var, DataTypeChanger dataTypeChanger) throws IOException {
        String name = var.getName();
        int dataType = var.getType();
        byte[] nameBytes = name.getBytes(CHARSET);
        out.writeShort(nameBytes.length);
        out.write(nameBytes);
        switch (dataType) {
            case 2: {
                this.writeValue(out, var.getString());
                break;
            }
            case 3: {
                this.writeValue(out, var.getInt());
                break;
            }
            case 4: {
                this.writeValue(out, var.getBoolean());
                break;
            }
            case 5: {
                this.writeValue(out, var.getLong());
                break;
            }
            case 6: {
                this.writeValue(out, var.getFloat());
                break;
            }
            case 7: {
                this.writeValue(out, var.getDouble());
                break;
            }
            case 8: {
                this.writeValue(out, var.getBigDecimal());
                break;
            }
            case 9: {
                this.writeDateValue(out, var.getDateTime());
                break;
            }
            case 10: {
                this.writeTimeValue(out, var.getDateTime());
                break;
            }
            case 11: {
                this.writeValue(out, var.getDateTime());
                break;
            }
            case 12: {
                this.writeValue(out, var.getBlob());
                break;
            }
            case 13: {
                this.writeEmptyValue(out);
                break;
            }
            case 1: {
                this.writeEmptyValue(out);
                break;
            }
            default: {
                this.writeEmptyValue(out);
            }
        }
    }

    protected void writeDataSetList(DataOutputStream out, PlatformData data, DataTypeChanger dataTypeChanger) throws IOException {
        DataSetList dl = data.getDataSetList();
        int count = dl.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSetList: count=" + count));
        }
        for (int i = 0; i < count; ++i) {
            DataSet ds = dl.get(i);
            this.writeDataSet(out, data, ds, dataTypeChanger);
        }
    }

    protected void writeDataSet(DataOutputStream out, PlatformData data, DataSet ds, DataTypeChanger dataTypeChanger) throws IOException {
        String name = ds.getName();
        String alias = ds.getAlias();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSet: name=" + (name != null ? URLEncoder.encode(name, CHARSET) : null) + ", alias=" + (alias != null ? URLEncoder.encode(alias, CHARSET) : null) + ", columnCount=" + ds.getColumnCount() + ", rowCount=" + ds.getRowCount() + ", removedRowCount=" + ds.getRemovedRowCount()));
        }
        out.writeShort(65025);
        out.writeShort(5000);
        int[] dataTypes = this.getTargetDataTypes(ds, dataTypeChanger);
        this.writeColumnHeaders(out, ds, dataTypes);
        this.writeRows(out, data, ds, dataTypes);
        out.writeInt(0);
    }

    protected void writeColumnHeaders(DataOutputStream out, DataSet ds, int[] dataTypes) throws IOException {
        String alias = ds.getAlias();
        PlatformUtils.PlatformEncoder encoder = PlatformUtils.getPlatformEncoder("bin");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream bufferOut = new DataOutputStream(buffer);
        byte[] nameBytes = alias.getBytes(CHARSET);
        bufferOut.writeShort(nameBytes.length);
        bufferOut.write(nameBytes);
        this.writeConstantColumnHeaders(bufferOut, ds, dataTypes);
        this.writeDefaultColumnHeaders(bufferOut, ds, dataTypes);
        bufferOut.close();
        buffer.close();
        byte[] bin = buffer.toByteArray();
        this.writeLength(out, bin.length);
        encoder.encodeTo(out, bin);
    }

    protected void writeDefaultColumnHeaders(DataOutputStream out, DataSet ds, int[] dataTypes) throws IOException {
        ColumnHeader header;
        int i;
        int count = ds.getColumnCount();
        int n = 0;
        for (i = 0; i < count; ++i) {
            header = ds.getColumn(i);
            if (header.isConstant()) continue;
            ++n;
        }
        out.writeShort(n);
        for (i = 0; i < count; ++i) {
            header = ds.getColumn(i);
            if (header.isConstant()) continue;
            String name = header.getName();
            byte[] nameBytes = name.getBytes(CHARSET);
            out.writeShort(nameBytes.length);
            out.write(nameBytes);
            int dataType = dataTypes[i];
            int dataSize = header.getDataSize();
            switch (dataType) {
                case 2: {
                    out.writeShort(1);
                    break;
                }
                case 3: {
                    out.writeShort(2);
                    break;
                }
                case 4: {
                    out.writeShort(2);
                    break;
                }
                case 5: {
                    out.writeShort(4);
                    break;
                }
                case 6: {
                    out.writeShort(3);
                    break;
                }
                case 7: {
                    out.writeShort(3);
                    break;
                }
                case 8: {
                    out.writeShort(4);
                    break;
                }
                case 9: {
                    out.writeShort(5);
                    break;
                }
                case 10: {
                    out.writeShort(6);
                    break;
                }
                case 11: {
                    out.writeShort(7);
                    break;
                }
                case 12: {
                    out.writeShort(8);
                    break;
                }
                case 13: {
                    out.writeShort(8);
                    break;
                }
                case 1: {
                    out.writeShort(0);
                    break;
                }
                default: {
                    out.writeShort(0);
                }
            }
            out.writeShort(dataSize);
            out.writeShort(1);
        }
    }

    protected void writeConstantColumnHeaders(DataOutputStream out, DataSet ds, int[] dataTypes) throws IOException {
        ColumnHeader header;
        int i;
        out.writeShort(65040);
        out.writeShort(5000);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream bufferOut = new DataOutputStream(buffer);
        int count = ds.getColumnCount();
        int n = 0;
        for (i = 0; i < count; ++i) {
            header = ds.getColumn(i);
            if (!header.isConstant()) continue;
            ++n;
        }
        bufferOut.writeShort(n);
        block15: for (i = 0; i < count; ++i) {
            header = ds.getColumn(i);
            if (!header.isConstant()) continue;
            ConstantColumnHeader constantHeader = (ConstantColumnHeader)header;
            String name = constantHeader.getName();
            byte[] nameBytes = name.getBytes(CHARSET);
            bufferOut.writeShort(nameBytes.length);
            bufferOut.write(nameBytes);
            int sourceDataType = constantHeader.getDataType();
            int dataType = dataTypes[i];
            if (sourceDataType == 13) {
                this.writeValue(bufferOut, constantHeader.getStringValue(ds));
                continue;
            }
            if (dataType == 13) {
                dataType = sourceDataType;
            }
            switch (dataType) {
                case 2: {
                    this.writeValue(bufferOut, constantHeader.getStringValue(ds));
                    continue block15;
                }
                case 3: {
                    this.writeValue(bufferOut, constantHeader.getIntValue(ds));
                    continue block15;
                }
                case 4: {
                    this.writeValue(bufferOut, constantHeader.getBooleanValue(ds));
                    continue block15;
                }
                case 5: {
                    this.writeValue(bufferOut, constantHeader.getLongValue(ds));
                    continue block15;
                }
                case 6: {
                    this.writeValue(bufferOut, constantHeader.getFloatValue(ds));
                    continue block15;
                }
                case 7: {
                    this.writeValue(bufferOut, constantHeader.getDoubleValue(ds));
                    continue block15;
                }
                case 8: {
                    this.writeValue(bufferOut, constantHeader.getBigDecimalValue(ds));
                    continue block15;
                }
                case 9: {
                    this.writeDateValue(bufferOut, constantHeader.getDateTimeValue(ds));
                    continue block15;
                }
                case 10: {
                    this.writeTimeValue(bufferOut, constantHeader.getDateTimeValue(ds));
                    continue block15;
                }
                case 11: {
                    this.writeValue(bufferOut, constantHeader.getDateTimeValue(ds));
                    continue block15;
                }
                case 12: {
                    this.writeValue(bufferOut, constantHeader.getBlobValue(ds));
                    continue block15;
                }
                case 1: {
                    this.writeEmptyValue(bufferOut);
                    continue block15;
                }
                default: {
                    this.writeEmptyValue(bufferOut);
                }
            }
        }
        bufferOut.close();
        buffer.close();
        byte[] bin = buffer.toByteArray();
        this.writeLength(out, bin.length);
        out.write(bin);
    }

    protected void writeRows(DataOutputStream out, PlatformData data, DataSet ds, int[] dataTypes) throws IOException {
        boolean isCheckingGetterDataIndex;
        int saveType = ds.getSaveType();
        if (saveType == 0) {
            saveType = data.getSaveType();
        }
        if (saveType == 0) {
            saveType = 2;
        }
        int count = ds.getRowCount();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing rows: count=" + count));
        }
        if (isCheckingGetterDataIndex = ds.isCheckingGetterDataIndex()) {
            ds.setCheckingGetterDataIndex(false);
        }
        PlatformUtils.PlatformEncoder encoder = PlatformUtils.getPlatformEncoder("bin");
        for (int i = 0; i < count; ++i) {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream bufferOut = new DataOutputStream(buffer);
            this.writeRow(bufferOut, ds, dataTypes, i, saveType);
            bufferOut.close();
            buffer.close();
            byte[] bin = buffer.toByteArray();
            if (bin.length <= 0) continue;
            this.writeLength(out, bin.length);
            encoder.encodeTo(out, bin);
        }
        if (saveType == 1 || saveType == 4 || saveType == 5) {
            int removedCount = ds.getRemovedRowCount();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Writing removed rows: removedCount=" + removedCount));
            }
            for (int i = 0; i < removedCount; ++i) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                DataOutputStream bufferOut = new DataOutputStream(buffer);
                this.writeRemovedRow(bufferOut, ds, dataTypes, i);
                bufferOut.close();
                buffer.close();
                byte[] bin = buffer.toByteArray();
                if (bin.length <= 0) continue;
                this.writeLength(out, bin.length);
                encoder.encodeTo(out, bin);
            }
        }
        if (isCheckingGetterDataIndex) {
            ds.setCheckingGetterDataIndex(true);
        }
    }

    protected void writeRow(DataOutputStream out, DataSet ds, int[] dataTypes, int row, int saveType) throws IOException {
        int rowType = ds.getRowType(row);
        if (saveType != 1 && (saveType == 2 ? rowType == 3 : (saveType == 3 ? rowType == 0 || rowType == 3 : (saveType == 4 ? rowType == 0 || rowType == 1 || rowType == 2 : saveType == 5 && rowType == 0)))) {
            return;
        }
        int[] indexes = this.getColumnIndexes(ds);
        int count = indexes.length;
        if (saveType == 2) {
            out.writeShort(1);
        } else {
            switch (rowType) {
                case 0: {
                    out.writeShort(1);
                    break;
                }
                case 1: {
                    out.writeShort(2);
                    break;
                }
                case 2: {
                    out.writeShort(4);
                    break;
                }
                case 3: {
                    out.writeShort(8);
                    break;
                }
                default: {
                    out.writeShort(1);
                }
            }
        }
        out.writeShort(count);
        block21: for (int i = 0; i < count; ++i) {
            int index = indexes[i];
            int sourceDataType = ds.getColumn(index).getDataType();
            int dataType = dataTypes[index];
            if (sourceDataType == 13) {
                if (dataType == 2) {
                    this.writeStringFromFile(out, ds.getString(row, index));
                    continue;
                }
                if (dataType == 12 || dataType == 13) {
                    this.writeBlobFromFile(out, ds.getString(row, index));
                    continue;
                }
                this.writeEmptyValue(out);
                continue;
            }
            switch (dataType) {
                case 2: {
                    this.writeValue(out, ds.getString(row, index));
                    continue block21;
                }
                case 3: {
                    this.writeIntValue(out, ds, row, index, ds.getObject(row, index));
                    continue block21;
                }
                case 4: {
                    this.writeBooleanValue(out, ds, row, index, ds.getObject(row, index));
                    continue block21;
                }
                case 5: {
                    this.writeLongValue(out, ds, row, index, ds.getObject(row, index));
                    continue block21;
                }
                case 6: {
                    this.writeFloatValue(out, ds, row, index, ds.getObject(row, index));
                    continue block21;
                }
                case 7: {
                    this.writeDoubleValue(out, ds, row, index, ds.getObject(row, index));
                    continue block21;
                }
                case 8: {
                    this.writeValue(out, ds.getBigDecimal(row, index));
                    continue block21;
                }
                case 9: {
                    this.writeDateValue(out, ds.getDateTime(row, index));
                    continue block21;
                }
                case 10: {
                    this.writeTimeValue(out, ds.getDateTime(row, index));
                    continue block21;
                }
                case 11: {
                    this.writeValue(out, ds.getDateTime(row, index));
                    continue block21;
                }
                case 12: {
                    this.writeValue(out, ds.getBlob(row, index));
                    continue block21;
                }
                case 13: {
                    this.writeValue(out, ds.getBlob(row, index));
                    continue block21;
                }
                case 1: {
                    this.writeEmptyValue(out);
                    continue block21;
                }
                default: {
                    this.writeEmptyValue(out);
                }
            }
        }
        if ((saveType == 1 || saveType == 3 || saveType == 5) && rowType == 2) {
            this.writeSavedRow(out, ds, dataTypes, row);
        }
    }

    protected void writeSavedRow(DataOutputStream out, DataSet ds, int[] dataTypes, int row) throws IOException {
        int[] indexes = this.getColumnIndexes(ds);
        int count = indexes.length;
        out.writeShort(count);
        block15: for (int i = 0; i < count; ++i) {
            int index = indexes[i];
            int sourceDataType = ds.getColumn(index).getDataType();
            int dataType = dataTypes[index];
            if (sourceDataType == 13) {
                if (dataType == 2) {
                    this.writeStringFromFile(out, ds.getSavedStringData(row, index));
                    continue;
                }
                if (dataType == 12 || dataType == 13) {
                    this.writeBlobFromFile(out, ds.getSavedStringData(row, index));
                    continue;
                }
                this.writeEmptyValue(out);
                continue;
            }
            switch (dataType) {
                case 2: {
                    this.writeValue(out, ds.getSavedStringData(row, index));
                    continue block15;
                }
                case 3: {
                    this.writeIntValue(out, ds, row, index, ds.getSavedData(row, index));
                    continue block15;
                }
                case 4: {
                    this.writeBooleanValue(out, ds, row, index, ds.getSavedData(row, index));
                    continue block15;
                }
                case 5: {
                    this.writeLongValue(out, ds, row, index, ds.getSavedData(row, index));
                    continue block15;
                }
                case 6: {
                    this.writeFloatValue(out, ds, row, index, ds.getSavedData(row, index));
                    continue block15;
                }
                case 7: {
                    this.writeDoubleValue(out, ds, row, index, ds.getSavedData(row, index));
                    continue block15;
                }
                case 8: {
                    this.writeValue(out, ds.getSavedBigDecimalData(row, index));
                    continue block15;
                }
                case 9: {
                    this.writeDateValue(out, ds.getSavedDateTimeData(row, index));
                    continue block15;
                }
                case 10: {
                    this.writeTimeValue(out, ds.getSavedDateTimeData(row, index));
                    continue block15;
                }
                case 11: {
                    this.writeValue(out, ds.getSavedDateTimeData(row, index));
                    continue block15;
                }
                case 12: {
                    this.writeValue(out, ds.getSavedBlobData(row, index));
                    continue block15;
                }
                case 13: {
                    this.writeValue(out, ds.getSavedBlobData(row, index));
                    continue block15;
                }
                case 1: {
                    this.writeEmptyValue(out);
                    continue block15;
                }
                default: {
                    this.writeEmptyValue(out);
                }
            }
        }
    }

    protected void writeRemovedRow(DataOutputStream out, DataSet ds, int[] dataTypes, int row) throws IOException {
        int[] indexes = this.getColumnIndexes(ds);
        int count = indexes.length;
        out.writeShort(8);
        out.writeShort(count);
        block15: for (int i = 0; i < count; ++i) {
            int index = indexes[i];
            int sourceDataType = ds.getColumn(index).getDataType();
            int dataType = dataTypes[index];
            if (sourceDataType == 13) {
                if (dataType == 2) {
                    this.writeStringFromFile(out, ds.getRemovedStringData(row, index));
                    continue;
                }
                if (dataType == 12 || dataType == 13) {
                    this.writeBlobFromFile(out, ds.getRemovedStringData(row, index));
                    continue;
                }
                this.writeEmptyValue(out);
                continue;
            }
            switch (dataType) {
                case 2: {
                    this.writeValue(out, ds.getRemovedStringData(row, index));
                    continue block15;
                }
                case 3: {
                    this.writeIntValue(out, ds, row, index, ds.getRemovedData(row, index));
                    continue block15;
                }
                case 4: {
                    this.writeBooleanValue(out, ds, row, index, ds.getRemovedData(row, index));
                    continue block15;
                }
                case 5: {
                    this.writeLongValue(out, ds, row, index, ds.getRemovedData(row, index));
                    continue block15;
                }
                case 6: {
                    this.writeFloatValue(out, ds, row, index, ds.getRemovedData(row, index));
                    continue block15;
                }
                case 7: {
                    this.writeDoubleValue(out, ds, row, index, ds.getRemovedData(row, index));
                    continue block15;
                }
                case 8: {
                    this.writeValue(out, ds.getRemovedBigDecimalData(row, index));
                    continue block15;
                }
                case 9: {
                    this.writeDateValue(out, ds.getRemovedDateTimeData(row, index));
                    continue block15;
                }
                case 10: {
                    this.writeTimeValue(out, ds.getRemovedDateTimeData(row, index));
                    continue block15;
                }
                case 11: {
                    this.writeValue(out, ds.getRemovedDateTimeData(row, index));
                    continue block15;
                }
                case 12: {
                    this.writeValue(out, ds.getRemovedBlobData(row, index));
                    continue block15;
                }
                case 13: {
                    this.writeValue(out, ds.getRemovedBlobData(row, index));
                    continue block15;
                }
                case 1: {
                    this.writeEmptyValue(out);
                    continue block15;
                }
                default: {
                    this.writeEmptyValue(out);
                }
            }
        }
    }

    protected void writeValue(DataOutputStream out, String value) throws IOException {
        if (value == null) {
            out.writeShort(0);
        } else {
            String str = this.platformCodec.encode(value);
            out.writeShort(21);
            byte[] strBytes = str.getBytes(CHARSET);
            this.writeLength(out, strBytes.length);
            out.write(strBytes);
        }
    }

    protected void writeValue(DataOutputStream out, int value) throws IOException {
        out.writeShort(3);
        out.writeInt(value);
    }

    protected void writeValue(DataOutputStream out, boolean value) throws IOException {
        out.writeShort(3);
        int bool = value ? 1 : 0;
        out.writeInt(bool);
    }

    protected void writeValue(DataOutputStream out, long value) throws IOException {
        out.writeShort(40);
        String longStr = String.valueOf(value);
        byte[] longBytes = longStr.getBytes();
        this.writeLength(out, longBytes.length);
        out.write(longBytes);
    }

    protected void writeValue(DataOutputStream out, float value) throws IOException {
        out.writeShort(4);
        double dbl = Double.parseDouble(String.valueOf(value));
        out.writeDouble(dbl);
    }

    protected void writeValue(DataOutputStream out, double value) throws IOException {
        out.writeShort(4);
        out.writeDouble(value);
    }

    protected void writeValue(DataOutputStream out, BigDecimal value) throws IOException {
        if (value == null) {
            out.writeShort(0);
        } else {
            out.writeShort(40);
            String decimalStr = value.toString();
            byte[] decimalBytes = decimalStr.getBytes();
            this.writeLength(out, decimalBytes.length);
            out.write(decimalBytes);
        }
    }

    protected void writeDateValue(DataOutputStream out, Date value) throws IOException {
        if (value == null) {
            out.writeShort(0);
        } else {
            out.writeShort(41);
            long dateLong = this.reviseTimeValue(value.getTime());
            out.writeDouble(dateLong);
        }
    }

    protected void writeTimeValue(DataOutputStream out, Date value) throws IOException {
        if (value == null) {
            out.writeShort(0);
        } else {
            out.writeShort(41);
            long timeLong = this.reviseTimeValue(value.getTime());
            out.writeDouble(timeLong);
        }
    }

    protected void writeValue(DataOutputStream out, Date value) throws IOException {
        if (value == null) {
            out.writeShort(0);
        } else {
            out.writeShort(41);
            long datetimeLong = this.reviseTimeValue(value.getTime());
            out.writeDouble(datetimeLong);
        }
    }

    protected void writeValue(DataOutputStream out, byte[] value) throws IOException {
        if (value == null) {
            out.writeShort(0);
        } else {
            out.writeShort(26);
            this.writeLength(out, value.length);
            out.write(value);
        }
    }

    protected void writeEmptyValue(DataOutputStream out) throws IOException {
        out.writeShort(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeStringFromFile(DataOutputStream out, String filename) throws IOException {
        if (filename == null) {
            out.writeShort(0);
            return;
        } else {
            File file = null;
            PlatformUtils.PlatformFileHandler fileHandler = PlatformUtils.getPlatformFileHandler(filename);
            if (fileHandler != null) {
                file = fileHandler.toFile();
            }
            if (file != null && file.canRead()) {
                out.writeShort(21);
                int len = (int)file.length();
                this.writeLength(out, len);
                FileInputStream in = new FileInputStream(file);
                byte[] buffer = this.getBuffer();
                try {
                    int n;
                    while ((n = in.read(buffer)) != -1) {
                        out.write(buffer, 0, n);
                    }
                    if (!this.log.isDebugEnabled()) return;
                    this.log.debug((Object)StringUtils.normalizeSpace((String)("Load data from file: file=" + file)));
                    return;
                }
                finally {
                    in.close();
                }
            } else {
                out.writeShort(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeBlobFromFile(DataOutputStream out, String filename) throws IOException {
        if (filename == null) {
            out.writeShort(0);
            return;
        } else {
            File file = null;
            PlatformUtils.PlatformFileHandler fileHandler = PlatformUtils.getPlatformFileHandler(filename);
            if (fileHandler != null) {
                file = fileHandler.toFile();
            }
            if (file != null && file.canRead()) {
                out.writeShort(26);
                int len = (int)file.length();
                this.writeLength(out, len);
                FileInputStream in = new FileInputStream(file);
                byte[] buffer = this.getBuffer();
                try {
                    int n;
                    while ((n = in.read(buffer)) != -1) {
                        out.write(buffer, 0, n);
                    }
                    if (!this.log.isDebugEnabled()) return;
                    this.log.debug((Object)StringUtils.normalizeSpace((String)("Load data from file: file=" + file)));
                    return;
                }
                finally {
                    in.close();
                }
            } else {
                out.writeShort(0);
            }
        }
    }

    protected void writeLength(DataOutputStream out, int length) throws IOException {
        if (length < 32768) {
            out.writeShort(length);
        } else {
            out.writeInt(length | Integer.MIN_VALUE);
        }
    }

    protected int[] getTargetDataTypes(DataSet ds, DataTypeChanger dataTypeChanger) {
        int count = ds.getColumnCount();
        int[] dataTypes = new int[count];
        for (int i = 0; i < count; ++i) {
            ColumnHeader header = ds.getColumn(i);
            if (dataTypeChanger == null) {
                dataTypes[i] = header.getDataType();
                continue;
            }
            String dsName = ds.getAlias();
            String columnName = header.getName();
            int dataType = header.getDataType();
            dataTypes[i] = dataTypeChanger.getDataType(dsName, columnName, dataType);
        }
        return dataTypes;
    }

    protected int[] getColumnIndexes(DataSet ds) {
        String id = ds.getName() + "@" + ds.hashCode();
        int[] indexes = (int[])this.columnIndexesMap.get(id);
        if (indexes == null) {
            indexes = this.getNormalColumnIndexes(ds);
            this.columnIndexesMap.put(id, indexes);
        }
        return indexes;
    }

    private void writeIntValue(DataOutputStream out, DataSet ds, int rowIndex, int columnIndex, Object value) throws IOException {
        if (value == null) {
            this.writeEmptyValue(out);
        } else {
            int intValue = ds.getCurrentDataConverter().toInt(ds, rowIndex, columnIndex, value);
            this.writeValue(out, intValue);
        }
    }

    private void writeBooleanValue(DataOutputStream out, DataSet ds, int rowIndex, int columnIndex, Object value) throws IOException {
        if (value == null) {
            this.writeEmptyValue(out);
        } else {
            boolean booleanValue = ds.getCurrentDataConverter().toBoolean(ds, rowIndex, columnIndex, value);
            this.writeValue(out, booleanValue);
        }
    }

    private void writeLongValue(DataOutputStream out, DataSet ds, int rowIndex, int columnIndex, Object value) throws IOException {
        if (value == null) {
            this.writeEmptyValue(out);
        } else {
            long longValue = ds.getCurrentDataConverter().toLong(ds, rowIndex, columnIndex, value);
            this.writeValue(out, longValue);
        }
    }

    private void writeFloatValue(DataOutputStream out, DataSet ds, int rowIndex, int columnIndex, Object value) throws IOException {
        if (value == null) {
            this.writeEmptyValue(out);
        } else {
            float floatValue = ds.getCurrentDataConverter().toFloat(ds, rowIndex, columnIndex, value);
            this.writeValue(out, floatValue);
        }
    }

    private void writeDoubleValue(DataOutputStream out, DataSet ds, int rowIndex, int columnIndex, Object value) throws IOException {
        if (value == null) {
            this.writeEmptyValue(out);
        } else {
            double doubleValue = ds.getCurrentDataConverter().toDouble(ds, rowIndex, columnIndex, value);
            this.writeValue(out, doubleValue);
        }
    }

    private int[] sortColumnIndexes(DataSet ds) {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        int count = ds.getColumnCount();
        for (int i2 = 0; i2 < count; ++i2) {
            ColumnHeader header = ds.getColumn(i2);
            if (header.isConstant()) continue;
            list.add(header.getName());
        }
        ArrayList<String> sorted = new ArrayList<String>();
        Iterator iter = list.iterator();
        block1: while (iter.hasNext()) {
            String name = (String)iter.next();
            int size = sorted.size();
            for (i = 0; i < size; ++i) {
                String str = (String)sorted.get(i);
                if (name.compareToIgnoreCase(str) >= 0) continue;
                sorted.add(i, name);
                continue block1;
            }
            sorted.add(name);
        }
        int len = sorted.size();
        int[] indexes = new int[len];
        for (i = 0; i < len; ++i) {
            indexes[i] = ds.indexOfColumn(sorted.get(i).toString());
        }
        return indexes;
    }

    private int[] getNormalColumnIndexes(DataSet ds) {
        int count = ds.getColumnCount();
        int[] list = new int[count];
        int n = 0;
        for (int i = 0; i < count; ++i) {
            ColumnHeader header = ds.getColumn(i);
            if (header.isConstant()) continue;
            list[n++] = i;
        }
        int[] indexes = new int[n];
        System.arraycopy(list, 0, indexes, 0, n);
        return indexes;
    }

    private long reviseTimeValue(long time) {
        return time + (long)TIMEZONE_OFFSET;
    }

    private byte[] getBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[4096];
        }
        return this.buffer;
    }
}

