/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.tx.impl;

import com.nexacro.java.xapi.data.ColumnHeader;
import com.nexacro.java.xapi.data.ConstantColumnHeader;
import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.DataSetList;
import com.nexacro.java.xapi.data.DataTypes;
import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.data.Variable;
import com.nexacro.java.xapi.data.VariableList;
import com.nexacro.java.xapi.tx.DataSerializer;
import com.nexacro.java.xapi.tx.DataTypeChanger;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.tx.PlatformUtils;
import com.nexacro.java.xapi.tx.impl.Base64;
import com.nexacro.java.xapi.tx.impl.PlatformCodec;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class PlatformJsonDataSerializer
implements DataSerializer {
    private Log log = LogFactory.getLog((Class)PlatformJsonDataSerializer.class);
    private static final int BUFFER_SIZE = 4096;
    private PlatformCodec platformCodec = new PlatformCodec();
    private byte[] buffer;

    public void setProperty(String key, Object value) {
    }

    public void writeData(OutputStream out, PlatformData data, DataTypeChanger dataTypeChanger, String charset) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Writing data: this=" + this + ", charset=" + (charset != null ? URLEncoder.encode(charset, "UTF-8") : null)));
            }
            catch (UnsupportedEncodingException e) {
                this.log.debug((Object)"UnsupportedEncodingException");
            }
        }
        try {
            this.writeData(new OutputStreamWriter(out, charset), data, dataTypeChanger, charset);
        }
        catch (UnsupportedEncodingException ex) {
            if (this.log.isErrorEnabled()) {
                try {
                    this.log.error((Object)("Unsupported charset: " + (charset != null ? URLEncoder.encode(charset, "UTF-8") : null)), (Throwable)ex);
                }
                catch (UnsupportedEncodingException e) {
                    this.log.error((Object)"UnsupportedEncodingException");
                }
            }
            throw new PlatformException("Unsupported charset: " + charset, ex);
        }
    }

    public void writeData(Writer out, PlatformData data, DataTypeChanger dataTypeChanger, String charset) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Writing data: this=" + this + ", charset=" + (charset != null ? URLEncoder.encode(charset, "UTF-8") : null)));
            }
            catch (UnsupportedEncodingException e) {
                this.log.debug((Object)"UnsupportedEncodingException");
            }
        }
        try {
            this.write(out, data, dataTypeChanger, charset);
        }
        catch (IOException ex) {
            String contentType = "PlatformJson";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + contentType), (Throwable)ex);
            }
            throw new PlatformException("Could not serialize: contentType=" + contentType, ex);
        }
    }

    private void write(Writer out, PlatformData data, DataTypeChanger dataTypeChanger, String charset) throws IOException {
        JSONObject jsonObject = new JSONObject();
        this.writeHeader(jsonObject, data, charset);
        this.writeVariableList(jsonObject, data, dataTypeChanger);
        this.writeDataSetList(jsonObject, data, dataTypeChanger);
        out.write(jsonObject.toJSONString());
        out.flush();
    }

    private void writeHeader(JSONObject jsonObject, PlatformData data, String charset) throws IOException {
        jsonObject.put((Object)"version", (Object)"1.0");
    }

    private void writeVariableList(JSONObject jsonObject, PlatformData data, DataTypeChanger dataTypeChanger) throws IOException {
        VariableList varList = data.getVariableList();
        int count = varList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing VariableList: count=" + count));
        }
        JSONArray parameters = new JSONArray();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                JSONObject parameter = new JSONObject();
                this.writeVariable(parameter, varList.get(i), dataTypeChanger);
                parameters.add((Object)parameter);
            }
        }
        if (parameters.size() > 0) {
            jsonObject.put((Object)"Parameters", (Object)parameters);
        }
    }

    private void writeVariable(JSONObject parameter, Variable var, DataTypeChanger dataTypeChanger) throws IOException {
        if (DataTypes.isBinary(var.getType())) {
            this.writeBinaryVariable(parameter, var);
        } else {
            this.writeStringVariable(parameter, var);
        }
    }

    private void writeStringVariable(JSONObject parameter, Variable var) throws IOException {
        String name = var.getName();
        String type = this.getDataType(var.getType());
        String value = this.getStringValue(var);
        parameter.put((Object)"id", (Object)name);
        parameter.put((Object)"type", (Object)type);
        if (value != null) {
            parameter.put((Object)"value", (Object)value);
        }
    }

    private void writeBinaryVariable(JSONObject parameter, Variable var) throws IOException {
        String encoded;
        String name = var.getName();
        String type = this.getDataType(var.getType());
        byte[] value = this.getBinaryValue(var);
        parameter.put((Object)"id", (Object)name);
        parameter.put((Object)"type", (Object)type);
        if (value != null && (encoded = Base64.encodeBytes(value, 8)) != null) {
            parameter.put((Object)"value", (Object)encoded);
        }
    }

    private String getStringValue(Variable var) {
        int dataType = var.getType();
        if (dataType == 4) {
            return var.getBoolean() ? "1" : "0";
        }
        String value = var.getString();
        if (value == null) {
            return value;
        }
        if (dataType == 2) {
            return this.encode(value);
        }
        return value;
    }

    private byte[] getBinaryValue(Variable var) {
        return var.getBlob();
    }

    private void writeDataSetList(JSONObject jsonObject, PlatformData data, DataTypeChanger dataTypeChanger) throws IOException {
        DataSetList dsList = data.getDataSetList();
        int count = dsList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSetList: count=" + count));
        }
        JSONArray datasets = new JSONArray();
        for (int i = 0; i < count; ++i) {
            this.writeDataSet(datasets, data, dsList.get(i), dataTypeChanger);
        }
        if (datasets.size() > 0) {
            jsonObject.put((Object)"Datasets", (Object)datasets);
        }
    }

    private void writeDataSet(JSONArray datasets, PlatformData data, DataSet ds, DataTypeChanger dataTypeChanger) throws IOException {
        String name = ds.getName();
        String alias = ds.getAlias();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSet: name=" + (name != null ? URLEncoder.encode(name, "UTF-8") : null) + ", alias=" + (alias != null ? URLEncoder.encode(alias, "UTF-8") : null) + ", columnCount=" + ds.getColumnCount() + ", rowCount=" + ds.getRowCount() + ", removedRowCount=" + ds.getRemovedRowCount()));
        }
        JSONObject dataset = new JSONObject();
        dataset.put((Object)"id", (Object)ds.getName());
        int[] dataTypes = this.getTargetDataTypes(ds, dataTypeChanger);
        this.writeColumns(dataset, ds, dataTypes);
        this.writeRows(dataset, data, ds, dataTypes);
        datasets.add((Object)dataset);
    }

    private void writeColumns(JSONObject dataset, DataSet ds, int[] dataTypes) throws IOException {
        int count = ds.getColumnCount();
        JSONObject columnInfo = new JSONObject();
        JSONArray constColumn = new JSONArray();
        JSONArray column = new JSONArray();
        for (int i = 0; i < count; ++i) {
            ColumnHeader header = ds.getColumn(i);
            int dataType = dataTypes[i];
            if (header.getType() == 0) {
                this.writeDefaultColumnHeader(column, header, dataType);
                continue;
            }
            if (header.getType() == 1) {
                this.writeConstantColumnHeader(constColumn, ds, header, dataType);
                continue;
            }
            throw new IOException("Invalid column type: " + header.getType());
        }
        if (constColumn.size() > 0) {
            columnInfo.put((Object)"ConstColumn", (Object)constColumn);
        }
        if (column.size() > 0) {
            columnInfo.put((Object)"Column", (Object)column);
        }
        if (columnInfo.size() > 0) {
            dataset.put((Object)"ColumnInfo", (Object)columnInfo);
        }
    }

    private void writeDefaultColumnHeader(JSONArray column, ColumnHeader header, int dataType) throws IOException {
        JSONObject col = new JSONObject();
        String name = header.getName();
        String dataTypeStr = this.getDataType(dataType);
        int dataSize = header.getDataSize();
        col.put((Object)"id", (Object)name);
        col.put((Object)"type", (Object)dataTypeStr);
        col.put((Object)"size", (Object)Integer.toString(dataSize));
        column.add((Object)col);
    }

    private void writeConstantColumnHeader(JSONArray constColumn, DataSet ds, ColumnHeader header, int dataType) throws IOException {
        JSONObject col = new JSONObject();
        if (DataTypes.isBinary(dataType)) {
            this.writeBinaryColumnHeader(col, ds, (ConstantColumnHeader)header, dataType);
        } else {
            this.writeStringColumnHeader(col, ds, (ConstantColumnHeader)header, dataType);
        }
        constColumn.add((Object)col);
    }

    private void writeStringColumnHeader(JSONObject col, DataSet ds, ConstantColumnHeader header, int dataType) throws IOException {
        if (dataType == 13) {
            dataType = 2;
        }
        String name = header.getName();
        String dataTypeStr = this.getDataType(dataType);
        int dataSize = header.getDataSize();
        String value = this.getStringValue(ds, header);
        col.put((Object)"id", (Object)name);
        col.put((Object)"type", (Object)dataTypeStr);
        col.put((Object)"size", (Object)Integer.toString(dataSize));
        if (value != null) {
            col.put((Object)"value", (Object)value);
        }
    }

    private void writeBinaryColumnHeader(JSONObject col, DataSet ds, ConstantColumnHeader header, int dataType) throws IOException {
        String name = header.getName();
        String dataTypeStr = this.getDataType(dataType);
        int dataSize = header.getDataSize();
        byte[] value = this.getBinaryValue(ds, header);
        col.put((Object)"id", (Object)name);
        col.put((Object)"type", (Object)dataTypeStr);
        col.put((Object)"size", (Object)Integer.toString(dataSize));
        if (value != null) {
            String encoded = Base64.encodeBytes(value, 8);
            col.put((Object)"value", (Object)encoded);
        }
    }

    private String getStringValue(DataSet ds, ConstantColumnHeader header) {
        int dataType = header.getDataType();
        if (dataType == 4) {
            return header.getBooleanValue(ds) ? "1" : "0";
        }
        String value = header.getStringValue(ds);
        if (value == null) {
            return value;
        }
        if (dataType == 2) {
            return this.encode(value);
        }
        return value;
    }

    private byte[] getBinaryValue(DataSet ds, ConstantColumnHeader header) {
        return header.getBlobValue(ds);
    }

    private void writeRows(JSONObject dataset, PlatformData data, DataSet ds, int[] dataTypes) throws IOException {
        boolean isCheckingGetterDataIndex;
        int saveType = ds.getSaveType();
        if (saveType == 0) {
            saveType = data.getSaveType();
        }
        if (saveType == 0) {
            saveType = 2;
        }
        int count = ds.getRowCount();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing rows: count=" + count));
        }
        if (isCheckingGetterDataIndex = ds.isCheckingGetterDataIndex()) {
            ds.setCheckingGetterDataIndex(false);
        }
        JSONArray rows = new JSONArray();
        for (int i = 0; i < count; ++i) {
            this.writeRow(rows, ds, dataTypes, i, saveType);
        }
        if (saveType == 1 || saveType == 4 || saveType == 5) {
            int removedCount = ds.getRemovedRowCount();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Writing removed rows: removedCount=" + removedCount));
            }
            for (int i = 0; i < removedCount; ++i) {
                this.writeRemovedRow(rows, ds, dataTypes, i);
            }
        }
        if (isCheckingGetterDataIndex) {
            ds.setCheckingGetterDataIndex(true);
        }
        if (rows.size() > 0) {
            dataset.put((Object)"Rows", (Object)rows);
        }
    }

    private void writeRow(JSONArray rows, DataSet ds, int[] dataTypes, int row, int saveType) throws IOException {
        int rowType = ds.getRowType(row);
        if (saveType != 1 && (saveType == 2 ? rowType == 3 : (saveType == 3 ? rowType == 0 || rowType == 3 : (saveType == 4 ? rowType == 0 || rowType == 1 || rowType == 2 : saveType == 5 && rowType == 0)))) {
            return;
        }
        JSONObject jsonRow = new JSONObject();
        if (saveType == 2) {
            jsonRow.put((Object)"_RowType_", (Object)"N");
        } else if (rowType == 1) {
            jsonRow.put((Object)"_RowType_", (Object)"I");
        } else if (rowType == 2) {
            jsonRow.put((Object)"_RowType_", (Object)"U");
        } else if (rowType == 3) {
            jsonRow.put((Object)"_RowType_", (Object)"D");
        } else {
            jsonRow.put((Object)"_RowType_", (Object)"N");
        }
        int count = ds.getColumnCount();
        for (int i = 0; i < count; ++i) {
            Object value;
            ColumnHeader header = ds.getColumn(i);
            if (header.isConstant()) continue;
            int sourceDataType = header.getDataType();
            int dataType = dataTypes[i];
            if (dataType == 13 || DataTypes.isBinary(dataType)) {
                byte[] byArray = value = sourceDataType == 13 ? this.getBinaryValueFromFile(ds, row, i, dataType) : this.getBinaryValue(ds, row, i);
                if (value == null) continue;
                String encoded = Base64.encodeBytes(value, 8);
                jsonRow.put((Object)header.getName(), (Object)encoded);
                continue;
            }
            value = sourceDataType == 13 ? this.getStringValueFromFile(ds, row, i, dataType) : this.getStringValue(ds, row, i);
            if (value == null) continue;
            jsonRow.put((Object)header.getName(), value);
        }
        rows.add((Object)jsonRow);
        if ((saveType == 1 || saveType == 3 || saveType == 5) && rowType == 2) {
            this.writeSavedRow(rows, ds, dataTypes, row);
        }
    }

    private void writeSavedRow(JSONArray rows, DataSet ds, int[] dataTypes, int row) throws IOException {
        JSONObject jsonRow = new JSONObject();
        jsonRow.put((Object)"_RowType_", (Object)"O");
        int count = ds.getColumnCount();
        for (int i = 0; i < count; ++i) {
            Object value;
            ColumnHeader header = ds.getColumn(i);
            if (header.isConstant()) continue;
            int sourceDataType = header.getDataType();
            int dataType = dataTypes[i];
            if (dataType == 13 || DataTypes.isBinary(dataType)) {
                byte[] byArray = value = sourceDataType == 13 ? this.getSavedBinaryValueFromFile(ds, row, i, dataType) : this.getSavedBinaryValue(ds, row, i);
                if (value == null) continue;
                String encoded = Base64.encodeBytes(value, 8);
                jsonRow.put((Object)header.getName(), (Object)encoded);
                continue;
            }
            value = sourceDataType == 13 ? this.getSavedStringValueFromFile(ds, row, i, dataType) : this.getSavedStringValue(ds, row, i);
            if (value == null) continue;
            jsonRow.put((Object)header.getName(), value);
        }
        rows.add((Object)jsonRow);
    }

    private void writeRemovedRow(JSONArray rows, DataSet ds, int[] dataTypes, int row) throws IOException {
        JSONObject jsonRow = new JSONObject();
        jsonRow.put((Object)"_RowType_", (Object)"D");
        int count = ds.getColumnCount();
        for (int i = 0; i < count; ++i) {
            Object value;
            ColumnHeader header = ds.getColumn(i);
            if (header.isConstant()) continue;
            int sourceDataType = header.getDataType();
            int dataType = dataTypes[i];
            if (dataType == 13 || DataTypes.isBinary(dataType)) {
                byte[] byArray = value = sourceDataType == 13 ? this.getRemovedBinaryValueFromFile(ds, row, i, dataType) : this.getRemovedBinaryValue(ds, row, i);
                if (value == null) continue;
                String encoded = Base64.encodeBytes(value, 8);
                jsonRow.put((Object)header.getName(), (Object)encoded);
                continue;
            }
            value = sourceDataType == 13 ? this.getRemovedStringValueFromFile(ds, row, i, dataType) : this.getRemovedStringValue(ds, row, i);
            if (value == null) continue;
            jsonRow.put((Object)header.getName(), value);
        }
        rows.add((Object)jsonRow);
    }

    private String getStringValue(DataSet ds, int row, int column) {
        int dataType = ds.getColumn(column).getDataType();
        if (dataType == 4) {
            return ds.getBoolean(row, column) ? "1" : "0";
        }
        String value = ds.getString(row, column);
        if (dataType == 2) {
            value = this.encode(value);
        }
        return value;
    }

    private byte[] getBinaryValue(DataSet ds, int row, int column) {
        return ds.getBlob(row, column);
    }

    private String getStringValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 2) {
            String filename = ds.getString(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading data from file: filename=" + (filename != null ? URLEncoder.encode(filename, "UTF-8") : null) + ", content=" + content));
            }
            return content == null ? null : this.encode(new String(content));
        }
        return null;
    }

    private byte[] getBinaryValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 12 || dataType == 13) {
            String filename = ds.getString(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading data from file: filename=" + (filename != null ? URLEncoder.encode(filename, "UTF-8") : null) + ", content=" + content));
            }
            return content;
        }
        return null;
    }

    private String getSavedStringValue(DataSet ds, int row, int column) {
        int dataType = ds.getColumn(column).getDataType();
        if (dataType == 4) {
            return ds.getSavedBooleanData(row, column) ? "1" : "0";
        }
        String value = ds.getSavedStringData(row, column);
        if (dataType == 2) {
            value = this.encode(value);
        }
        return value;
    }

    private byte[] getSavedBinaryValue(DataSet ds, int row, int column) {
        return ds.getSavedBlobData(row, column);
    }

    private String getSavedStringValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 2) {
            String filename = ds.getSavedStringData(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading saved data from file: filename=" + (filename != null ? URLEncoder.encode(filename, "UTF-8") : null) + ", content=" + content));
            }
            return content == null ? null : this.encode(new String(content));
        }
        return null;
    }

    private byte[] getSavedBinaryValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 12 || dataType == 13) {
            String filename = ds.getSavedStringData(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading saved data from file: filename=" + (filename != null ? URLEncoder.encode(filename, "UTF-8") : null) + ", content=" + content));
            }
            return content;
        }
        return null;
    }

    private String getRemovedStringValue(DataSet ds, int row, int column) {
        int dataType = ds.getColumn(column).getDataType();
        if (dataType == 4) {
            return ds.getRemovedBooleanData(row, column) ? "1" : "0";
        }
        String value = ds.getRemovedStringData(row, column);
        if (dataType == 2) {
            value = this.encode(value);
        }
        return value;
    }

    private byte[] getRemovedBinaryValue(DataSet ds, int row, int column) {
        return ds.getRemovedBlobData(row, column);
    }

    private String getRemovedStringValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 2) {
            String filename = ds.getRemovedStringData(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading removed data from file: filename=" + (filename != null ? URLEncoder.encode(filename, "UTF-8") : null) + ", content=" + content));
            }
            return content == null ? null : this.encode(new String(content));
        }
        return null;
    }

    private byte[] getRemovedBinaryValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 12 || dataType == 13) {
            String filename = ds.getRemovedStringData(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading removed data from file: filename=" + (filename != null ? URLEncoder.encode(filename, "UTF-8") : null) + ", content=" + content));
            }
            return content;
        }
        return null;
    }

    private int[] getTargetDataTypes(DataSet ds, DataTypeChanger dataTypeChanger) {
        int count = ds.getColumnCount();
        int[] dataTypes = new int[count];
        for (int i = 0; i < count; ++i) {
            ColumnHeader header = ds.getColumn(i);
            if (dataTypeChanger == null) {
                dataTypes[i] = header.getDataType();
                continue;
            }
            String dsName = ds.getAlias();
            String columnName = header.getName();
            int dataType = header.getDataType();
            dataTypes[i] = dataTypeChanger.getDataType(dsName, columnName, dataType);
        }
        return dataTypes;
    }

    private String getDataType(int dataType) {
        if (dataType == 4) {
            return DataTypes.toStringType(3);
        }
        if (dataType == 5) {
            return DataTypes.toStringType(8);
        }
        if (dataType == 7) {
            return DataTypes.toStringType(6);
        }
        if (dataType == 13) {
            return DataTypes.toStringType(12);
        }
        return DataTypes.toStringType(dataType);
    }

    private String encode(String str) {
        if (str == null) {
            return str;
        }
        return this.platformCodec.encode(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadFile(String filename) throws IOException {
        if (filename == null) {
            return null;
        }
        File file = null;
        PlatformUtils.PlatformFileHandler fileHandler = PlatformUtils.getPlatformFileHandler(filename);
        if (fileHandler != null) {
            file = fileHandler.toFile();
        }
        if (file != null && file.canRead()) {
            FileInputStream in = new FileInputStream(file);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = this.getBuffer();
            try {
                int n;
                while ((n = in.read(buffer)) != -1) {
                    out.write(buffer, 0, n);
                }
                out.close();
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            finally {
                in.close();
            }
        }
        return null;
    }

    private byte[] getBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[4096];
        }
        return this.buffer;
    }
}

