/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.tx.impl;

import com.nexacro.java.xapi.data.ColumnHeader;
import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.DataTypes;
import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.data.Variable;
import com.nexacro.java.xapi.tx.DataDeserializer;
import com.nexacro.java.xapi.tx.DataTypeChanger;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.tx.impl.Base64;
import com.nexacro.java.xapi.tx.impl.SeperatorReader;
import com.nexacro.java.xapi.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformSsvDataDeserializer
implements DataDeserializer {
    private Log log = LogFactory.getLog((Class)PlatformSsvDataDeserializer.class);
    private String unitSeperator = null;
    private String recordSeperator = null;

    public void setProperty(String key, Object value) {
    }

    public PlatformData readData(InputStream in, DataTypeChanger dataTypeChanger, String charset) throws PlatformException {
        this.getDataSeperator();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)org.apache.commons.lang.StringUtils.normalizeSpace((String)("Reading data: this=" + this + ", charset=" + charset)));
        }
        try {
            byte[] header = this.readHeader(in);
            String encoding = this.findEncoding(header);
            if (encoding == null) {
                encoding = charset;
            }
            InputStreamReader reader = new InputStreamReader(in, encoding);
            return this.read(reader, dataTypeChanger);
        }
        catch (IOException ex) {
            String contentType = "PlatformSsv";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)org.apache.commons.lang.StringUtils.normalizeSpace((String)("Could not deserialize: contentType=" + contentType)), (Throwable)ex);
            }
            throw new PlatformException(org.apache.commons.lang.StringUtils.normalizeSpace((String)("Could not deserialize: contentType=" + contentType)), ex);
        }
    }

    public PlatformData readData(Reader in, DataTypeChanger dataTypeChanger, String charset) throws PlatformException {
        this.getDataSeperator();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)org.apache.commons.lang.StringUtils.normalizeSpace((String)("Reading data: this=" + this + ", charset=" + charset)));
        }
        try {
            char[] header = this.readHeader(in);
            String encoding = this.findEncoding(header);
            return this.read(in, dataTypeChanger);
        }
        catch (IOException ex) {
            String contentType = "PlatformSsv";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)org.apache.commons.lang.StringUtils.normalizeSpace((String)("Could not deserialize: contentType=" + contentType)), (Throwable)ex);
            }
            throw new PlatformException("Could not deserialize: contentType=" + contentType, ex);
        }
    }

    private PlatformData read(Reader in, DataTypeChanger dataTypeChanger) throws PlatformException {
        SeperatorReader reader = new SeperatorReader(in, this.recordSeperator);
        try {
            PlatformData data = new PlatformData();
            String line = null;
            while ((line = reader.readLine2()) != null) {
                if (line.length() == 0) continue;
                if (this.isDataSetHeader(line)) {
                    this.readDataSet(reader, line, data, dataTypeChanger);
                    continue;
                }
                this.readVariable(reader, line, data, dataTypeChanger);
            }
            return data;
        }
        catch (IOException ex) {
            String contentType = "PlatformSsv";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)org.apache.commons.lang.StringUtils.normalizeSpace((String)("Could not deserialize: contentType=" + contentType)), (Throwable)ex);
            }
            throw new PlatformException(org.apache.commons.lang.StringUtils.normalizeSpace((String)("Could not deserialize: contentType=" + contentType)), ex);
        }
    }

    private void readVariable(SeperatorReader reader, String str, PlatformData data, DataTypeChanger dataTypeChanger) {
        List list = StringUtils.split(str, this.unitSeperator);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String name;
            String varStr = (String)iter.next();
            int index = varStr.indexOf(61);
            if (index <= 0) continue;
            String header = varStr.substring(0, index);
            String value = varStr.substring(index + 1);
            int typeIndex = header.indexOf(58);
            if (typeIndex > 0) {
                Variable var;
                int dataType;
                String dataTypeStr;
                name = header.substring(0, typeIndex);
                String typeStr = header.substring(typeIndex + 1);
                int sizeStartIndex = typeStr.indexOf(40);
                int sizeEndIndex = typeStr.indexOf(41, sizeStartIndex + 1);
                if (sizeStartIndex > 0 && sizeEndIndex > 0) {
                    dataTypeStr = typeStr.substring(0, sizeStartIndex);
                    dataType = this.getDataType(dataTypeStr);
                    if (dataType == 2 && this.isNullString(value)) {
                        value = null;
                    }
                    var = new Variable(name, dataType, (Object)value);
                    data.addVariable(var);
                    continue;
                }
                dataTypeStr = typeStr;
                dataType = this.getDataType(dataTypeStr);
                if (dataType == 2 && this.isNullString(value)) {
                    value = null;
                }
                var = new Variable(name, dataType, (Object)value);
                data.addVariable(var);
                continue;
            }
            name = header;
            int dataType = 2;
            if (this.isNullString(value)) {
                value = null;
            }
            Variable var = new Variable(name, dataType, (Object)value);
            data.addVariable(var);
        }
    }

    private void readDataSet(SeperatorReader reader, String header, PlatformData data, DataTypeChanger dataTypeChanger) throws IOException {
        int index = header.indexOf(58);
        String name = header.substring(index + 1);
        DataSet ds = new DataSet(name);
        boolean isStoreDataChanges = ds.isStoreDataChanges();
        boolean isCheckingSetterDataIndex = ds.isCheckingSetterDataIndex();
        if (isStoreDataChanges) {
            ds.stopStoreDataChanges();
        }
        if (isCheckingSetterDataIndex) {
            ds.setCheckingSetterDataIndex(false);
        }
        String line = null;
        while ((line = reader.readLine2()) != null && line.length() != 0) {
            if (this.isConstantColumnHeader(line)) {
                this.readConstantColumnHeader(line, ds);
                continue;
            }
            if (this.isDefaultColumnHeader(line)) {
                this.readDefaultColumnHeader(line, ds);
                continue;
            }
            this.readDataRow(line, ds);
        }
        if (isStoreDataChanges) {
            ds.startStoreDataChanges(true);
        }
        if (isCheckingSetterDataIndex) {
            ds.setCheckingSetterDataIndex(true);
        }
        data.addDataSet(ds);
    }

    private void readConstantColumnHeader(String str, DataSet ds) {
        List list = StringUtils.split(str, this.unitSeperator);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String name;
            String columnStr = (String)iter.next();
            int index = columnStr.indexOf(61);
            if (index <= 0) continue;
            String header = columnStr.substring(0, index);
            String value = columnStr.substring(index + 1);
            int typeIndex = header.indexOf(58);
            if (typeIndex > 0) {
                String dataTypeStr;
                name = header.substring(0, typeIndex);
                String typeStr = header.substring(typeIndex + 1);
                int sizeStartIndex = typeStr.indexOf(40);
                int sizeEndIndex = typeStr.indexOf(41, sizeStartIndex + 1);
                if (sizeStartIndex > 0 && sizeEndIndex > 0) {
                    dataTypeStr = typeStr.substring(0, sizeStartIndex);
                    String dataSizeStr = typeStr.substring(sizeStartIndex + 1, sizeEndIndex);
                    int dataType = this.getDataType(dataTypeStr);
                    int dataSize = StringUtils.toInt(dataSizeStr, DataTypes.getDefaultSize(dataType));
                    ds.addConstantColumn(name, dataType, dataSize, (Object)value);
                    continue;
                }
                dataTypeStr = typeStr;
                int dataType = this.getDataType(dataTypeStr);
                ds.addConstantColumn(name, dataType, (Object)value);
                continue;
            }
            name = header;
            int dataType = 2;
            ds.addConstantColumn(name, dataType, (Object)value);
        }
    }

    private void readDefaultColumnHeader(String str, DataSet ds) {
        List list = StringUtils.split(str, this.unitSeperator);
        Iterator iter = list.iterator();
        iter.next();
        int i = 0;
        while (iter.hasNext()) {
            String name;
            String header = (String)iter.next();
            int typeIndex = header.indexOf(58);
            if (typeIndex > 0) {
                String dataTypeStr;
                name = header.substring(0, typeIndex);
                String typeStr = header.substring(typeIndex + 1);
                int sizeStartIndex = typeStr.indexOf(40);
                int sizeEndIndex = typeStr.indexOf(41, sizeStartIndex + 1);
                if (sizeStartIndex > 0 && sizeEndIndex > 0) {
                    dataTypeStr = typeStr.substring(0, sizeStartIndex);
                    String dataSizeStr = typeStr.substring(sizeStartIndex + 1, sizeEndIndex);
                    int dataType = this.getDataType(dataTypeStr);
                    int dataSize = StringUtils.toInt(dataSizeStr, DataTypes.getDefaultSize(dataType));
                    ds.insertColumn(i, new ColumnHeader(name, dataType, dataSize));
                } else {
                    dataTypeStr = typeStr;
                    int dataType = this.getDataType(dataTypeStr);
                    ds.insertColumn(i, new ColumnHeader(name, dataType));
                }
            } else {
                name = header;
                int dataType = 2;
                ds.insertColumn(i, new ColumnHeader(name, dataType));
            }
            ++i;
        }
    }

    private void readDataRow(String str, DataSet ds) {
        List list = StringUtils.split(str, this.unitSeperator);
        Iterator iter = list.iterator();
        String rowType = (String)iter.next();
        if (rowType.length() == 1) {
            char ch = rowType.charAt(0);
            if (ch == 'O') {
                int rowIndex = ds.getRowCount() - 1;
                int columnCount = ds.getColumnCount();
                for (int i = 0; iter.hasNext() && i < columnCount; ++i) {
                    Object value = iter.next();
                    if (this.isNullString(value)) {
                        value = null;
                    }
                    if (DataTypes.isBinary(ds.getColumnDataType(i)) && value != null) {
                        ds.setSavedData(rowIndex, i, (Object)Base64.decode(value.toString()));
                        continue;
                    }
                    ds.setSavedData(rowIndex, i, value);
                }
            } else if (ch == 'N' || ch == 'I' || ch == 'U' || ch == 'D') {
                int rowIndex = ds.newRow();
                int columnCount = ds.getColumnCount();
                for (int i = 0; iter.hasNext() && i < columnCount; ++i) {
                    Object value = iter.next();
                    if (this.isNullString(value)) {
                        value = null;
                    }
                    if (DataTypes.isBinary(ds.getColumnDataType(i)) && value != null) {
                        ds.set(rowIndex, i, Base64.decode(value.toString()));
                        continue;
                    }
                    ds.set(rowIndex, i, value);
                }
                if (ch == 'N') {
                    ds.setRowType(rowIndex, 0);
                } else if (ch == 'I') {
                    ds.setRowType(rowIndex, 1);
                } else if (ch == 'U') {
                    ds.setRowType(rowIndex, 2);
                } else if (ch == 'D') {
                    ds.setRowType(rowIndex, 3);
                }
            }
        } else if (this.log.isWarnEnabled()) {
            int rowCount = ds.getRowCount();
            this.log.warn((Object)org.apache.commons.lang.StringUtils.normalizeSpace((String)("Invalid SSV row type: rowType=" + rowType + ", rowCount=" + rowCount)));
            this.log.warn((Object)org.apache.commons.lang.StringUtils.normalizeSpace((String)("Invalid SSV row type: str=" + str)));
        }
    }

    private boolean isConstantColumnHeader(String str) {
        return str.startsWith("_Const_");
    }

    private boolean isDefaultColumnHeader(String str) {
        return str.startsWith("_RowType_");
    }

    private boolean isDataSetHeader(String str) {
        return str.startsWith("Dataset:");
    }

    private byte[] readHeader(InputStream in) throws IOException {
        int ch;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean isEnd = false;
        int rslength = this.recordSeperator.length();
        ByteArrayOutputStream tmpout = new ByteArrayOutputStream();
        while ((ch = in.read()) != -1) {
            if (ch == this.recordSeperator.charAt(0)) {
                int index;
                tmpout.reset();
                tmpout.write(ch);
                for (index = 1; index < rslength; ++index) {
                    ch = in.read();
                    if (ch == -1) {
                        isEnd = true;
                        break;
                    }
                    tmpout.write(ch);
                    if (ch != this.recordSeperator.charAt(index)) break;
                }
                if (index == rslength) break;
                out.write(tmpout.toByteArray());
            } else {
                out.write(ch);
            }
            if (!isEnd) continue;
            break;
        }
        tmpout.close();
        out.close();
        return out.toByteArray();
    }

    private char[] readHeader(Reader in) throws IOException {
        int ch;
        CharArrayWriter out = new CharArrayWriter();
        boolean isEnd = false;
        int rslength = this.recordSeperator.length();
        CharArrayWriter tmpout = new CharArrayWriter();
        while ((ch = in.read()) != -1) {
            if (ch == this.recordSeperator.charAt(0)) {
                int index;
                tmpout.reset();
                tmpout.write(ch);
                for (index = 1; index < rslength; ++index) {
                    ch = in.read();
                    if (ch == -1) {
                        isEnd = true;
                        break;
                    }
                    tmpout.write(ch);
                    if (ch != this.recordSeperator.charAt(index)) break;
                }
                if (index == rslength) break;
                out.write(tmpout.toCharArray());
            } else {
                out.write(ch);
            }
            if (!isEnd) continue;
            break;
        }
        tmpout.close();
        out.close();
        return out.toCharArray();
    }

    private String findEncoding(byte[] header) {
        return this.findEncoding(new String(header));
    }

    private String findEncoding(char[] header) {
        return this.findEncoding(new String(header));
    }

    private String findEncoding(String header) {
        int end;
        int begin;
        String encoding;
        String prefix = "SSV:";
        int index = header.indexOf(prefix);
        if (index == 0 && (encoding = header.substring(begin = index + prefix.length(), end = header.length()).trim()).length() > 0) {
            return encoding;
        }
        return null;
    }

    private int getDataType(String str) {
        if ("binary".equalsIgnoreCase(str)) {
            return 12;
        }
        if ("float".equalsIgnoreCase(str)) {
            return 7;
        }
        return DataTypes.toIntType(str);
    }

    private boolean isNullString(String value) {
        return value.length() == 1 && value.charAt(0) == '\u0003';
    }

    private boolean isNullString(Object value) {
        String newVal;
        if (value == null) {
            return true;
        }
        return value instanceof String && (newVal = (String)value).length() == 1 && newVal.charAt(0) == '\u0003';
    }

    private void getDataSeperator() throws PlatformException {
        if (this.unitSeperator == null || this.recordSeperator == null) {
            StringBuffer unitBuff = new StringBuffer();
            StringBuffer recordBuff = new StringBuffer();
            StringUtils.getDataSeperator(unitBuff, recordBuff);
            this.unitSeperator = unitBuff.toString();
            this.recordSeperator = recordBuff.toString();
        }
    }
}

