/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xapi.tx.impl;

import com.nexacro.java.xapi.data.ColumnHeader;
import com.nexacro.java.xapi.data.ConstantColumnHeader;
import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.DataTypes;
import com.nexacro.java.xapi.data.Variable;
import com.nexacro.java.xapi.tx.DataTypeChanger;
import com.nexacro.java.xapi.tx.PartDataSerializer;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.tx.PlatformUtils;
import com.nexacro.java.xapi.tx.impl.Base64;
import com.nexacro.java.xapi.tx.impl.PlatformCodec;
import com.nexacro.java.xapi.tx.impl.XmlCodec;
import com.nexacro.java.xapi.util.PlatformGlobals;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformXmlPartDataSerializer
implements PartDataSerializer {
    private Log log = LogFactory.getLog((Class)PlatformXmlPartDataSerializer.class);
    private static final boolean NULL_IS_SINGLE_TAG = true;
    private static final boolean WRITE_NULL_VALUE = false;
    private static final String NL = System.getProperty("line.separator");
    private static final String[] TABS = new String[]{"", "\t", "\t\t", "\t\t\t", "\t\t\t\t", "\t\t\t\t\t"};
    private static final String XML_NS = "http://www.nexacro.com/platform/dataset";
    private static final String VERSION = "5000";
    private static final int BUFFER_SIZE = 4096;
    private PlatformCodec platformCodec = new PlatformCodec();
    private XmlCodec xmlCodec = new XmlCodec();
    private byte[] buffer;
    private String charset;
    private DataTypeChanger dataTypeChanger;
    private Writer out;
    private int depth;
    private Object data;
    private boolean nullToEmpty = PlatformGlobals.getBooleanProperty("platform.tx.DataSerializer.nullchar.toempty", false);

    public void setProperty(String key, Object value) {
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setDataTypeChanger(DataTypeChanger dataTypeChanger) {
        this.dataTypeChanger = dataTypeChanger;
    }

    public void setOutputStream(OutputStream out) throws PlatformException {
        try {
            this.out = this.charset == null ? new OutputStreamWriter(out) : new OutputStreamWriter(out, this.charset);
        }
        catch (UnsupportedEncodingException ex) {
            String contentType = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)StringUtils.normalizeSpace((String)("Could not serialize: contentType=" + contentType)), (Throwable)ex);
            }
            throw new PlatformException(StringUtils.normalizeSpace((String)("Could not serialize: contentType=" + contentType)), ex);
        }
    }

    public void setWriter(Writer out) throws PlatformException {
        this.out = out;
    }

    public void writeHead() throws PlatformException {
        try {
            if (this.charset == null) {
                this.writeString(this.out, "<?xml version=\"1.0\"?>", this.depth);
            } else {
                this.writeString(this.out, "<?xml version=\"1.0\" encoding=\"" + this.charset + "\"?>", this.depth);
            }
            this.writeString(this.out, "<Root xmlns=\"http://www.nexacro.com/platform/dataset\" ver=\"5000\">", this.depth);
        }
        catch (IOException ex) {
            String contentType = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)StringUtils.normalizeSpace((String)("Could not serialize: contentType=" + contentType)), (Throwable)ex);
            }
            throw new PlatformException(StringUtils.normalizeSpace((String)("Could not serialize: contentType=" + contentType)), ex);
        }
    }

    public void writeTail() throws PlatformException {
        try {
            if (this.data instanceof Variable) {
                --this.depth;
                this.writeString(this.out, "</Parameters>", this.depth);
                --this.depth;
            } else if (this.data instanceof DataSet) {
                --this.depth;
                this.writeString(this.out, "</Rows>", this.depth);
                --this.depth;
                this.writeString(this.out, "</Dataset>", this.depth);
                --this.depth;
            }
            this.writeString(this.out, "</Root>", this.depth);
            this.out.flush();
        }
        catch (IOException ex) {
            String contentType = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)StringUtils.normalizeSpace((String)("Could not serialize: contentType=" + contentType)), (Throwable)ex);
            }
            throw new PlatformException(StringUtils.normalizeSpace((String)("Could not serialize: contentType=" + contentType)), ex);
        }
    }

    public void writeVariable(Variable var) throws PlatformException {
        try {
            if (this.data == null) {
                ++this.depth;
                this.writeString(this.out, "<Parameters>", this.depth);
                ++this.depth;
            }
            if (DataTypes.isBinary(var.getType())) {
                this.writeBinaryVariable(var);
            } else {
                this.writeStringVariable(var);
            }
            this.out.flush();
            this.data = var;
        }
        catch (IOException ex) {
            String contentType = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)StringUtils.normalizeSpace((String)("Could not serialize: contentType=" + contentType)), (Throwable)ex);
            }
            throw new PlatformException(StringUtils.normalizeSpace((String)("Could not serialize: contentType=" + contentType)), ex);
        }
    }

    public void writeDataSet(DataSet ds) throws PlatformException {
        try {
            String name = ds.getName();
            String alias = ds.getAlias();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)StringUtils.normalizeSpace((String)("Writing DataSet: name=" + name + ", alias=" + alias + ", columnCount=" + ds.getColumnCount() + ", rowCount=" + ds.getRowCount() + ", removedRowCount=" + ds.getRemovedRowCount())));
            }
            if (this.data == ds) {
                int[] dataTypes = this.getTargetDataTypes(ds, this.dataTypeChanger);
                this.writeRowData(ds, dataTypes);
            } else {
                if (this.data instanceof Variable) {
                    --this.depth;
                    this.writeString(this.out, "</Parameters>", this.depth);
                } else if (this.data instanceof DataSet) {
                    --this.depth;
                    this.writeString(this.out, "</Rows>", this.depth);
                    --this.depth;
                    this.writeString(this.out, "</Dataset>", this.depth);
                } else {
                    ++this.depth;
                }
                this.writeString(this.out, "<Dataset id=\"" + alias + "\">", this.depth);
                ++this.depth;
                int[] dataTypes = this.getTargetDataTypes(ds, this.dataTypeChanger);
                this.writeColumns(ds, dataTypes);
                this.writeString(this.out, "<Rows>", this.depth);
                ++this.depth;
                this.writeRowData(ds, dataTypes);
            }
            this.out.flush();
            this.data = ds;
        }
        catch (IOException ex) {
            String contentType = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)StringUtils.normalizeSpace((String)("Could not serialize: contentType=" + contentType)), (Throwable)ex);
            }
            throw new PlatformException(StringUtils.normalizeSpace((String)("Could not serialize: contentType=" + contentType)), ex);
        }
    }

    private void writeStringVariable(Variable var) throws IOException {
        String name = var.getName();
        String type = this.getDataType(var.getType());
        String value = this.getStringValue(var);
        int length = value == null ? 0 : value.length();
        StringBuffer buffer = new StringBuffer(length + 64);
        buffer.append("<Parameter id=\"").append(name);
        buffer.append("\" type=\"").append(type);
        if (value == null) {
            buffer.append("\"/>");
        } else {
            buffer.append("\">").append(value);
            buffer.append("</Parameter>");
        }
        this.writeString(this.out, buffer.toString(), this.depth);
    }

    private void writeBinaryVariable(Variable var) throws IOException {
        String name = var.getName();
        String type = this.getDataType(var.getType());
        byte[] value = this.getBinaryValue(var);
        if (value == null) {
            StringBuffer buffer = new StringBuffer(64);
            buffer.append("<Parameter id=\"").append(name);
            buffer.append("\" type=\"").append(type);
            buffer.append("\"/>");
            this.writeString(this.out, buffer.toString(), this.depth);
        } else {
            String prefix = "<Parameter id=\"" + name + "\" type=\"" + type + "\" encrypt=\"base64\">";
            String suffix = "</Parameter>";
            this.writeBinary(this.out, value, prefix, suffix, this.depth);
        }
    }

    private String getStringValue(Variable var) {
        int dataType = var.getType();
        if (dataType == 4) {
            return var.getBoolean() ? "1" : "0";
        }
        String value = var.getString();
        if (value == null) {
            return value;
        }
        if (dataType == 2) {
            return this.encode(value);
        }
        return value;
    }

    private byte[] getBinaryValue(Variable var) {
        return var.getBlob();
    }

    private void writeColumns(DataSet ds, int[] dataTypes) throws IOException {
        this.writeString(this.out, "<ColumnInfo>", this.depth++);
        int count = ds.getColumnCount();
        StringBuffer defaultBuffer = new StringBuffer();
        StringBuffer constantBuffer = new StringBuffer();
        PlatformUtils.PlatformEncoder encoder = PlatformUtils.getPlatformEncoder("xml");
        for (int i = 0; i < count; ++i) {
            ColumnHeader header = ds.getColumn(i);
            int dataType = dataTypes[i];
            if (header.getType() == 0) {
                this.writeDefaultColumnHeader(defaultBuffer, header, dataType);
                continue;
            }
            if (header.getType() == 1) {
                this.writeConstantColumnHeader(constantBuffer, ds, header, dataType);
                continue;
            }
            throw new IOException("Invalid column type: " + header.getType());
        }
        if (constantBuffer.length() > 0) {
            encoder.encodeTo(this.out, constantBuffer.toString());
        }
        if (defaultBuffer.length() > 0) {
            encoder.encodeTo(this.out, defaultBuffer.toString());
        }
        this.writeString(this.out, "</ColumnInfo>", --this.depth);
    }

    private void writeDefaultColumnHeader(StringBuffer buffer, ColumnHeader header, int dataType) throws IOException {
        String name = header.getName();
        String dataTypeStr = this.getDataType(dataType);
        int dataSize = header.getDataSize();
        this.writeDepth(buffer, this.depth);
        buffer.append("<Column id=\"").append(name);
        buffer.append("\" type=\"").append(dataTypeStr);
        buffer.append("\" size=\"").append(dataSize);
        if (dataType == 13 || DataTypes.isBinary(dataType)) {
            buffer.append("\" encrypt=\"").append("base64");
        }
        buffer.append("\"/>");
        buffer.append(NL);
    }

    private void writeConstantColumnHeader(StringBuffer buffer, DataSet ds, ColumnHeader header, int dataType) throws IOException {
        if (DataTypes.isBinary(dataType)) {
            this.writeBinaryColumnHeader(buffer, ds, (ConstantColumnHeader)header, dataType);
        } else {
            this.writeStringColumnHeader(buffer, ds, (ConstantColumnHeader)header, dataType);
        }
    }

    private void writeStringColumnHeader(StringBuffer buffer, DataSet ds, ConstantColumnHeader header, int dataType) throws IOException {
        if (dataType == 13) {
            dataType = 2;
        }
        String name = header.getName();
        String dataTypeStr = this.getDataType(dataType);
        int dataSize = header.getDataSize();
        String value = this.getStringValue(ds, header);
        this.writeDepth(buffer, this.depth);
        buffer.append("<ConstColumn id=\"").append(name);
        buffer.append("\" type=\"").append(dataTypeStr);
        buffer.append("\" size=\"").append(dataSize);
        if (value != null) {
            buffer.append("\" value=\"").append(value);
        }
        buffer.append("\"/>");
        buffer.append(NL);
    }

    private void writeBinaryColumnHeader(StringBuffer buffer, DataSet ds, ConstantColumnHeader header, int dataType) throws IOException {
        String name = header.getName();
        String dataTypeStr = this.getDataType(dataType);
        int dataSize = header.getDataSize();
        byte[] value = this.getBinaryValue(ds, header);
        PlatformUtils.PlatformEncoder encoder = PlatformUtils.getPlatformEncoder("xml");
        this.writeDepth(buffer, this.depth);
        if (value == null) {
            buffer.append("<ConstColumn id=\"").append(name);
            buffer.append("\" type=\"").append(dataTypeStr);
            buffer.append("\" size=\"").append(dataSize);
            buffer.append("\"/>");
        } else {
            buffer.append("<ConstColumn id=\"" + name + "\" type=\"" + dataTypeStr + "\" size=\"" + dataSize + "\" encrypt=\"base64\" value=\"");
            String encoded = Base64.encodeBytes(value, 8);
            encoder.encodeTo(this.out, encoded);
            buffer.append("\"></ConstColumn>");
        }
        buffer.append(NL);
    }

    private String getStringValue(DataSet ds, ConstantColumnHeader header) {
        int dataType = header.getDataType();
        if (dataType == 4) {
            return header.getBooleanValue(ds) ? "1" : "0";
        }
        String value = header.getStringValue(ds);
        if (value == null) {
            return value;
        }
        if (dataType == 2) {
            return this.encode(value);
        }
        return value;
    }

    private byte[] getBinaryValue(DataSet ds, ConstantColumnHeader header) {
        return header.getBlobValue(ds);
    }

    private void writeRowData(DataSet ds, int[] dataTypes) throws IOException {
        boolean isCheckingGetterDataIndex;
        int saveType = ds.getSaveType();
        if (saveType == 0) {
            saveType = 2;
        }
        int count = ds.getRowCount();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)StringUtils.normalizeSpace((String)("Writing rows: count=" + count)));
        }
        if (isCheckingGetterDataIndex = ds.isCheckingGetterDataIndex()) {
            ds.setCheckingGetterDataIndex(false);
        }
        for (int i = 0; i < count; ++i) {
            this.writeRow(ds, dataTypes, i, saveType);
        }
        if (saveType == 1 || saveType == 4 || saveType == 5) {
            int removedCount = ds.getRemovedRowCount();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)StringUtils.normalizeSpace((String)("Writing removed rows: removedCount=" + removedCount)));
            }
            for (int i = 0; i < removedCount; ++i) {
                this.writeRemovedRow(ds, dataTypes, i);
            }
        }
        if (isCheckingGetterDataIndex) {
            ds.setCheckingGetterDataIndex(true);
        }
    }

    private void writeRow(DataSet ds, int[] dataTypes, int row, int saveType) throws IOException {
        int rowType = ds.getRowType(row);
        if (saveType != 1 && (saveType == 2 ? rowType == 3 : (saveType == 3 ? rowType == 0 || rowType == 3 : (saveType == 4 ? rowType == 0 || rowType == 1 || rowType == 2 : saveType == 5 && rowType == 0)))) {
            return;
        }
        if (saveType == 2) {
            this.writeString(this.out, "<Row>", this.depth++);
        } else if (rowType == 1) {
            this.writeString(this.out, "<Row type=\"insert\">", this.depth++);
        } else if (rowType == 2) {
            this.writeString(this.out, "<Row type=\"update\">", this.depth++);
        } else if (rowType == 3) {
            this.writeString(this.out, "<Row type=\"delete\">", this.depth++);
        } else {
            this.writeString(this.out, "<Row>", this.depth++);
        }
        int count = ds.getColumnCount();
        for (int i = 0; i < count; ++i) {
            Object value;
            ColumnHeader header = ds.getColumn(i);
            if (header.isConstant()) continue;
            String name = header.getName();
            int sourceDataType = header.getDataType();
            int dataType = dataTypes[i];
            if (dataType == 13 || DataTypes.isBinary(dataType)) {
                byte[] byArray = value = sourceDataType == 13 ? this.getBinaryValueFromFile(ds, row, i, dataType) : this.getBinaryValue(ds, row, i);
                if (value == null) {
                    if (!this.nullToEmpty) continue;
                    this.writeString(this.out, "<Col id=\"" + name + "\"/>", this.depth);
                    continue;
                }
                String prefix = "<Col id=\"" + name + "\">";
                String suffix = "</Col>";
                this.writeBinary(this.out, (byte[])value, prefix, suffix, this.depth);
                continue;
            }
            value = sourceDataType == 13 ? this.getStringValueFromFile(ds, row, i, dataType) : this.getStringValue(ds, row, i);
            if (value == null) {
                if (!this.nullToEmpty) continue;
                this.writeString(this.out, "<Col id=\"" + name + "\"/>", this.depth);
                continue;
            }
            this.writeString(this.out, "<Col id=\"" + name + "\">" + (String)value + "</Col>", this.depth);
        }
        if ((saveType == 1 || saveType == 3 || saveType == 5) && rowType == 2) {
            this.writeSavedRow(ds, dataTypes, row);
        }
        this.writeString(this.out, "</Row>", --this.depth);
    }

    private void writeSavedRow(DataSet ds, int[] dataTypes, int row) throws IOException {
        this.writeString(this.out, "<OrgRow>", this.depth++);
        int count = ds.getColumnCount();
        for (int i = 0; i < count; ++i) {
            Object value;
            ColumnHeader header = ds.getColumn(i);
            if (header.isConstant()) continue;
            String name = header.getName();
            int sourceDataType = header.getDataType();
            int dataType = dataTypes[i];
            if (dataType == 13 || DataTypes.isBinary(dataType)) {
                byte[] byArray = value = sourceDataType == 13 ? this.getSavedBinaryValueFromFile(ds, row, i, dataType) : this.getSavedBinaryValue(ds, row, i);
                if (value == null) {
                    if (!this.nullToEmpty) continue;
                    this.writeString(this.out, "<Col id=\"" + name + "\"/>", this.depth);
                    continue;
                }
                String prefix = "<Col id=\"" + name + "\">";
                String suffix = "</Col>";
                this.writeBinary(this.out, (byte[])value, prefix, suffix, this.depth);
                continue;
            }
            value = sourceDataType == 13 ? this.getSavedStringValueFromFile(ds, row, i, dataType) : this.getSavedStringValue(ds, row, i);
            if (value == null) {
                if (!this.nullToEmpty) continue;
                this.writeString(this.out, "<Col id=\"" + name + "\"/>", this.depth);
                continue;
            }
            this.writeString(this.out, "<Col id=\"" + name + "\">" + (String)value + "</Col>", this.depth);
        }
        this.writeString(this.out, "</OrgRow>", --this.depth);
    }

    private void writeRemovedRow(DataSet ds, int[] dataTypes, int row) throws IOException {
        this.writeString(this.out, "<Row type=\"delete\">", this.depth++);
        int count = ds.getColumnCount();
        for (int i = 0; i < count; ++i) {
            Object value;
            ColumnHeader header = ds.getColumn(i);
            if (header.isConstant()) continue;
            String name = header.getName();
            int sourceDataType = header.getDataType();
            int dataType = dataTypes[i];
            if (dataType == 13 || DataTypes.isBinary(dataType)) {
                byte[] byArray = value = sourceDataType == 13 ? this.getRemovedBinaryValueFromFile(ds, row, i, dataType) : this.getRemovedBinaryValue(ds, row, i);
                if (value == null) {
                    if (!this.nullToEmpty) continue;
                    this.writeString(this.out, "<Col id=\"" + name + "\"/>", this.depth);
                    continue;
                }
                String prefix = "<Col id=\"" + name + "\">";
                String suffix = "</Col>";
                this.writeBinary(this.out, (byte[])value, prefix, suffix, this.depth);
                continue;
            }
            value = sourceDataType == 13 ? this.getRemovedStringValueFromFile(ds, row, i, dataType) : this.getRemovedStringValue(ds, row, i);
            if (value == null) {
                if (!this.nullToEmpty) continue;
                this.writeString(this.out, "<Col id=\"" + name + "\"/>", this.depth);
                continue;
            }
            this.writeString(this.out, "<Col id=\"" + name + "\">" + (String)value + "</Col>", this.depth);
        }
        this.writeString(this.out, "</Row>", --this.depth);
    }

    private String getStringValue(DataSet ds, int row, int column) {
        int dataType = ds.getColumn(column).getDataType();
        if (dataType == 4) {
            return ds.getBoolean(row, column) ? "1" : "0";
        }
        String value = ds.getString(row, column);
        if (dataType == 2) {
            value = this.encode(value);
        }
        return value;
    }

    private byte[] getBinaryValue(DataSet ds, int row, int column) {
        return ds.getBlob(row, column);
    }

    private String getStringValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 2) {
            String filename = ds.getString(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)StringUtils.normalizeSpace((String)("Loading data from file: filename=" + filename + ", content=" + content)));
            }
            return content == null ? null : this.encode(new String(content));
        }
        return null;
    }

    private byte[] getBinaryValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 12 || dataType == 13) {
            String filename = ds.getString(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)StringUtils.normalizeSpace((String)("Loading data from file: filename=" + filename + ", content=" + content)));
            }
            return content;
        }
        return null;
    }

    private String getSavedStringValue(DataSet ds, int row, int column) {
        int dataType = ds.getColumn(column).getDataType();
        if (dataType == 4) {
            return ds.getSavedBooleanData(row, column) ? "1" : "0";
        }
        String value = ds.getSavedStringData(row, column);
        if (dataType == 2) {
            value = this.encode(value);
        }
        return value;
    }

    private byte[] getSavedBinaryValue(DataSet ds, int row, int column) {
        return ds.getSavedBlobData(row, column);
    }

    private String getSavedStringValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 2) {
            String filename = ds.getSavedStringData(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)StringUtils.normalizeSpace((String)("Loading saved data from file: filename=" + filename + ", content=" + content)));
            }
            return content == null ? null : this.encode(new String(content));
        }
        return null;
    }

    private byte[] getSavedBinaryValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 12 || dataType == 13) {
            String filename = ds.getSavedStringData(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)StringUtils.normalizeSpace((String)("Loading saved data from file: filename=" + filename + ", content=" + content)));
            }
            return content;
        }
        return null;
    }

    private String getRemovedStringValue(DataSet ds, int row, int column) {
        int dataType = ds.getColumn(column).getDataType();
        if (dataType == 4) {
            return ds.getRemovedBooleanData(row, column) ? "1" : "0";
        }
        String value = ds.getRemovedStringData(row, column);
        if (dataType == 2) {
            value = this.encode(value);
        }
        return value;
    }

    private byte[] getRemovedBinaryValue(DataSet ds, int row, int column) {
        return ds.getRemovedBlobData(row, column);
    }

    private String getRemovedStringValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 2) {
            String filename = ds.getRemovedStringData(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)StringUtils.normalizeSpace((String)("Loading removed data from file: filename=" + filename + ", content=" + content)));
            }
            return content == null ? null : this.encode(new String(content));
        }
        return null;
    }

    private byte[] getRemovedBinaryValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 12 || dataType == 13) {
            String filename = ds.getRemovedStringData(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)StringUtils.normalizeSpace((String)("Loading removed data from file: filename=" + filename + ", content=" + content)));
            }
            return content;
        }
        return null;
    }

    private void writeString(Writer out, String str, int depth) throws IOException {
        PlatformUtils.PlatformEncoder encoder = PlatformUtils.getPlatformEncoder("xml");
        if (depth == 0) {
            encoder.encodeTo(out, str);
            out.write(NL);
        } else if (depth < 6) {
            out.write(TABS[depth]);
            encoder.encodeTo(out, str);
            out.write(NL);
        } else {
            for (int i = 0; i < depth; ++i) {
                out.write(TABS[1]);
            }
            encoder.encodeTo(out, str);
            out.write(NL);
        }
    }

    private void writeBinary(Writer out, byte[] value, String prefix, String suffix, int depth) throws IOException {
        PlatformUtils.PlatformEncoder encoder = PlatformUtils.getPlatformEncoder("xml");
        if (depth == 0) {
            encoder.encodeTo(out, prefix);
            String encoded = Base64.encodeBytes(value, 8);
            encoder.encodeTo(out, encoded);
            encoder.encodeTo(out, suffix);
            out.write(NL);
        } else if (depth < 6) {
            out.write(TABS[depth]);
            encoder.encodeTo(out, prefix);
            String encoded = Base64.encodeBytes(value, 8);
            encoder.encodeTo(out, encoded);
            encoder.encodeTo(out, suffix);
            out.write(NL);
        } else {
            for (int i = 0; i < depth; ++i) {
                out.write(TABS[1]);
            }
            encoder.encodeTo(out, prefix);
            String encoded = Base64.encodeBytes(value, 8);
            encoder.encodeTo(out, encoded);
            encoder.encodeTo(out, suffix);
            out.write(NL);
        }
    }

    protected void writeDepth(StringBuffer buffer, int depth) {
        if (depth != 0) {
            if (depth < 6) {
                buffer.append(TABS[depth]);
            } else {
                for (int i = 0; i < depth; ++i) {
                    buffer.append(TABS[1]);
                }
            }
        }
    }

    private int[] getTargetDataTypes(DataSet ds, DataTypeChanger dataTypeChanger) {
        int count = ds.getColumnCount();
        int[] dataTypes = new int[count];
        for (int i = 0; i < count; ++i) {
            ColumnHeader header = ds.getColumn(i);
            if (dataTypeChanger == null) {
                dataTypes[i] = header.getDataType();
                continue;
            }
            String dsName = ds.getAlias();
            String columnName = header.getName();
            int dataType = header.getDataType();
            dataTypes[i] = dataTypeChanger.getDataType(dsName, columnName, dataType);
        }
        return dataTypes;
    }

    private String getDataType(int dataType) {
        if (dataType == 4) {
            return DataTypes.toStringType(3);
        }
        if (dataType == 5) {
            return DataTypes.toStringType(8);
        }
        if (dataType == 7) {
            return DataTypes.toStringType(6);
        }
        if (dataType == 13) {
            return DataTypes.toStringType(12);
        }
        return DataTypes.toStringType(dataType);
    }

    private String encode(String str) {
        if (str == null) {
            return str;
        }
        return this.xmlCodec.encode(this.platformCodec.encode(str));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadFile(String filename) throws IOException {
        if (filename == null) {
            return null;
        }
        File file = null;
        PlatformUtils.PlatformFileHandler fileHandler = PlatformUtils.getPlatformFileHandler(filename);
        if (fileHandler != null) {
            file = fileHandler.toFile();
        }
        if (file != null && file.canRead()) {
            FileInputStream in = new FileInputStream(file);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = this.getBuffer();
            try {
                int n;
                while ((n = in.read(buffer)) != -1) {
                    out.write(buffer, 0, n);
                }
                out.close();
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            finally {
                in.close();
            }
        }
        return null;
    }

    private byte[] getBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[4096];
        }
        return this.buffer;
    }
}

