/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.data;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xeni.data.GridExportFormatFactory;
import com.nexacro.java.xeni.data.exportformats.ExportFormat;
import com.nexacro.java.xeni.services.GridExportImportServlet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class GridExportData {
    private DataSet dsCommand = new DataSet();
    private DataSet dsStyle = new DataSet();
    private DataSet dsCell = new DataSet();
    private ExportFormat gridformat = null;
    private String sAppendUrl = null;
    private boolean bAppendExport = false;
    private static final Log oLogger = LogFactory.getLog(GridExportImportServlet.class);
    private long lLastAccTime = 0L;

    public void setAppendExport(String url) {
        this.bAppendExport = true;
        this.sAppendUrl = url;
    }

    public boolean isAppendExport() {
        return this.bAppendExport;
    }

    public String getAppendExportUrl() {
        return this.sAppendUrl;
    }

    public void setCmdDataset(DataSet ds) {
        if (ds == null) {
            return;
        }
        String sName = this.dsCommand.getName();
        if (sName == null) {
            this.dsCommand.setName(ds.getName());
            this.dsCommand.copyFrom(ds, true);
            String sFormats = ds.getString(0, "format");
            GridExportFormatFactory oFormatFactory = new GridExportFormatFactory();
            this.gridformat = oFormatFactory.readFormatString(sFormats);
        } else {
            this.dsCommand.copyDataFrom(ds);
        }
    }

    public void setStyleDataset(DataSet ds) {
        if (ds == null) {
            return;
        }
        String sName = this.dsStyle.getName();
        if (sName == null) {
            this.dsStyle.setName(ds.getName());
            this.dsStyle.copyFrom(ds, true);
        } else {
            this.dsStyle.copyDataFrom(ds, true);
        }
    }

    public void setCellDataset(DataSet ds) {
        if (ds == null) {
            return;
        }
        String sName = this.dsCell.getName();
        if (sName == null) {
            this.dsCell.setName(ds.getName());
            this.dsCell.copyFrom(ds, true);
        } else {
            this.dsCell.copyDataFrom(ds, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String export(String exportFilePath, String exportUrl) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet("test sheet");
        HSSFRow row = sheet.createRow(0);
        HSSFCell cell = null;
        cell = row.createCell(0);
        cell.setCellValue("Grid");
        cell = row.createCell(1);
        cell.setCellValue("Export");
        cell = row.createCell(2);
        cell.setCellValue("Import");
        String sFileName = this.dsCommand.getString(0, "item") + ".xls";
        String sFileFullName = exportFilePath + "export" + "/" + sFileName;
        File oFile = new File(sFileFullName);
        File parent = oFile.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        FileOutputStream fileOut = null;
        try {
            fileOut = new FileOutputStream(oFile);
            workbook.write((OutputStream)fileOut);
            if (oLogger.isInfoEnabled()) {
                oLogger.info((Object)("have been saved export file.....[ " + oFile.getAbsolutePath() + " ]"));
            }
        }
        catch (Exception e) {
            if (oLogger.isInfoEnabled()) {
                oLogger.info((Object)e);
            }
        }
        finally {
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                }
            }
        }
        return exportUrl + "export" + "/" + sFileName;
    }

    public DataSet getCmdDataset() {
        return this.dsCommand;
    }

    public DataSet getStyleDataset() {
        return this.dsStyle;
    }

    public DataSet getCellDataset() {
        return this.dsCell;
    }

    public void setLastAccTime(long lTime) {
        this.lLastAccTime = lTime;
    }

    public long getLastAccTime() {
        return this.lLastAccTime;
    }

    public ExportFormat getGridFormat() {
        return this.gridformat;
    }
}

