/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.data;

import com.nexacro.java.xeni.data.exportformats.ExportFormat;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class GridExportFormatFactory
extends DefaultHandler {
    private static final Log oLogger = LogFactory.getLog(GridExportFormatFactory.class);
    private ExportFormat format;
    private int currIndex;
    protected static final int INDEX_UNDEFINED = 0;
    protected static final int INDEX_COLUMNS = 1;
    protected static final int INDEX_ROWS = 2;
    protected static final int INDEX_DATA_HEAD = 3;
    protected static final int INDEX_DATA_BODY = 4;
    protected static final int INDEX_DATA_SUMMARY = 5;

    public ExportFormat readFormatString(String str) {
        InputSource insrc = new InputSource(new StringReader(str));
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            factory.setNamespaceAware(true);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            SAXParser parser = factory.newSAXParser();
            parser.parse(insrc, (DefaultHandler)this);
        }
        catch (Exception ex) {
            oLogger.error((Object)("Fail to create grid format : " + StringUtils.normalizeSpace((String)ex.getMessage())));
            return null;
        }
        return this.format;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if ("Cell".equals(qName)) {
            this.startCell(attributes);
        } else if ("Summary".equals(qName)) {
            this.setCurrentIndex(5);
        } else if ("Body".equals(qName)) {
            this.setCurrentIndex(4);
        } else if ("Head".equals(qName)) {
            this.setCurrentIndex(3);
        } else if ("Row".equals(qName)) {
            this.startRow(attributes);
        } else if ("Column".equals(qName)) {
            this.startColumn(attributes);
        } else if ("Format".equals(qName)) {
            this.startFormat(attributes);
        } else if ("Formats".equals(qName)) {
            this.startData();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (!"Cell".equals(qName)) {
            if ("Summary".equals(qName)) {
                this.setCurrentIndex(0);
            } else if ("Body".equals(qName)) {
                this.setCurrentIndex(0);
            } else if ("Head".equals(qName)) {
                this.setCurrentIndex(0);
            } else if ("Formats".equals(qName)) {
                this.endData();
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
    }

    protected void startData() {
        this.setData(new ExportFormat());
    }

    protected void endData() {
        this.setCurrentIndex(0);
    }

    protected void setData(ExportFormat data) {
        this.format = data;
    }

    protected ExportFormat getData() {
        return this.format;
    }

    protected void setCurrentIndex(int index) {
        this.currIndex = index;
    }

    protected int getCurrentIndex() {
        return this.currIndex;
    }

    protected void startFormat(Attributes attr) {
        String id = attr.getValue("id");
        this.getData().setId(id);
    }

    protected void startColumn(Attributes attr) {
        String size = attr.getValue("size");
        this.getData().addColumn(size);
    }

    protected void startRow(Attributes attr) {
        String size = attr.getValue("size");
        String band = attr.getValue("band");
        this.getData().addRow(size, band);
    }

    protected void startCell(Attributes attr) {
        int index = this.getCurrentIndex();
        if (index != 3 && index != 4 && index != 5) {
            return;
        }
        this.getData().addCell(index, attr.getValue("row"), attr.getValue("col"), attr.getValue("rowspan"), attr.getValue("colspan"), attr.getValue("style"), attr.getValue("style1"), attr.getValue("style2"), attr.getValue("text"), attr.getValue("displaytype"), attr.getValue("edittype"), attr.getValue("combodisplay"), attr.getValue("type"));
    }
}

