/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.data;

import com.nexacro.java.xeni.data.importformats.ImportFormat;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class GridImportFormatFactory
extends DefaultHandler {
    private static final Log oLogger = LogFactory.getLog(GridImportFormatFactory.class);
    private static GridImportFormatFactory oGridImportFormatFactory;
    private ImportFormat importformat;

    public static GridImportFormatFactory getInstance() {
        if (oGridImportFormatFactory == null) {
            oGridImportFormatFactory = new GridImportFormatFactory();
        }
        return oGridImportFormatFactory;
    }

    public ImportFormat readFormatString(String str) {
        InputSource insrc = new InputSource(new StringReader(str));
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            factory.setNamespaceAware(true);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            SAXParser parser = factory.newSAXParser();
            parser.parse(insrc, (DefaultHandler)this);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            return null;
        }
        return this.importformat;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if ("Sheet".equals(qName)) {
            this.startSheet(attributes);
        } else if ("Import".equals(qName)) {
            this.startData();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if ("Sheet".equals(qName) || "Import".equals(qName)) {
            // empty if block
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
    }

    protected void startData() {
        this.setData(new ImportFormat());
    }

    protected void setData(ImportFormat data) {
        this.importformat = data;
    }

    protected ImportFormat getData() {
        return this.importformat;
    }

    protected void startSheet(Attributes attr) {
        String cmd = null;
        String output = null;
        String head = null;
        String body = null;
        for (int index = 0; index < attr.getLength(); ++index) {
            String qname = attr.getQName(index);
            String value = attr.getValue(index);
            if ("command".equalsIgnoreCase(qname)) {
                cmd = value;
            }
            if ("output".equalsIgnoreCase(qname)) {
                output = value;
            }
            if ("head".equalsIgnoreCase(qname)) {
                head = value;
            }
            if (!"body".equalsIgnoreCase(qname)) continue;
            body = value;
        }
        this.getData().addSheet(cmd, output, head, body);
    }
}

