/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.data.exportformats;

import com.nexacro.java.xeni.data.exportformats.FormatCell;
import com.nexacro.java.xeni.data.exportformats.FormatColumn;
import com.nexacro.java.xeni.data.exportformats.FormatRow;
import java.util.ArrayList;
import java.util.List;

public class ExportFormat {
    private String id = null;
    private List<FormatColumn> columns = new ArrayList<FormatColumn>();
    private List<FormatRow> rows = new ArrayList<FormatRow>();
    private List<FormatCell> head = new ArrayList<FormatCell>();
    private List<FormatCell> body = new ArrayList<FormatCell>();
    private List<FormatCell> summary = new ArrayList<FormatCell>();
    protected static final int DATA_BAND_HEAD = 3;
    protected static final int DATA_BAND_BODY = 4;
    protected static final int DATA_BAND_SUMMARY = 5;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void addColumn(String size) {
        FormatColumn column = new FormatColumn();
        column.setSize(size);
        this.columns.add(column);
    }

    public FormatColumn getColumn(int index) {
        return this.columns.get(index);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public void addRow(String size, String band) {
        FormatRow row = new FormatRow();
        row.setSize(size);
        row.setBand(band == null ? "body" : band);
        this.rows.add(row);
    }

    public FormatRow getRow(int index) {
        return this.rows.get(index);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getRowCountOfEachBand(String sBand) {
        int nCount = 0;
        for (int nIdx = 0; nIdx < this.rows.size(); ++nIdx) {
            FormatRow oRow = this.rows.get(nIdx);
            if (oRow == null || !oRow.getBand().equals(sBand)) continue;
            ++nCount;
        }
        return nCount;
    }

    public void addCell(int band, String row, String col, String rowspan, String colspan, String style, String style1, String style2, String text, String displaytype, String edittype, String combodisplay, String type) {
        FormatCell cell = new FormatCell();
        if (row == null) {
            cell.setRow("0");
        } else {
            cell.setRow(row);
        }
        if (col == null) {
            cell.setCol("0");
        } else {
            cell.setCol(col);
        }
        if (rowspan == null) {
            cell.setRowspan("1");
        } else {
            cell.setRowspan(rowspan);
        }
        if (colspan == null) {
            cell.setColspan("1");
        } else {
            cell.setColspan(colspan);
        }
        if (style == null) {
            cell.setStyle("");
        } else {
            cell.setStyle(style);
        }
        if (style1 == null) {
            cell.setStyle1("");
        } else {
            cell.setStyle1(style1);
        }
        if (style2 == null) {
            cell.setStyle2("");
        } else {
            cell.setStyle2(style2);
        }
        if (text == null) {
            cell.setText("");
        } else {
            cell.setText(text);
        }
        if (type == null) {
            cell.setType("");
        } else {
            cell.setType(type);
        }
        if (band == 3) {
            this.head.add(cell);
        } else if (band == 4) {
            this.body.add(cell);
        } else if (band == 5) {
            this.summary.add(cell);
        }
    }

    public int getHeadCellCount() {
        return this.head.size();
    }

    public FormatCell getHeadCell(int nIndex) {
        return this.head.get(nIndex);
    }

    public int getBodyCellCount() {
        return this.body.size();
    }

    public FormatCell getBodyCell(int nIndex) {
        return this.body.get(nIndex);
    }

    public int getSummaryCellCount() {
        return this.summary.size();
    }

    public FormatCell getSummary(int nIndex) {
        return this.summary.get(nIndex);
    }
}

