/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.export;

import com.nexacro.java.xapi.data.VariableList;
import java.util.HashMap;
import java.util.Map;

public class GridExportContext {
    private String appendUrl = null;
    private String sheetName = "Sheet";
    private String requestType = "PlatformSsv";
    private String responseType = "PlatformSsv";
    private String absolutePath;
    private String downloadUrl;
    private String password = null;
    private String itemName;
    private String instanceId = null;
    private String fileName;
    private int startColIndex = 0;
    private int startRowIndex = 0;
    private int limitRowCount = 0x100000;
    private int rowAccessSize = 100;
    private int exportType = 288;
    private int sequence = -1;
    private float commandVersion = 1.0f;
    private boolean isOoxml = true;
    private boolean isNoHead = false;
    private boolean isNoSummary = false;
    private boolean isTopSummary = false;
    private boolean isApplyWidth = true;
    private boolean isApplyHeight = false;
    private boolean isOutsidePath = false;
    private boolean isWrapText = true;
    private boolean isRtl = false;
    private boolean isCsvQuote = true;
    private boolean isCsvBom = true;
    private VariableList userVarList = null;
    Map<Integer, Integer> rowHeights = null;

    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public String getAppendUrl() {
        return this.appendUrl;
    }

    public void setAppendUrl(String appendUrl) {
        if (appendUrl != null && appendUrl.length() > 0) {
            this.appendUrl = appendUrl;
        }
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public int getStartColIndex() {
        return this.startColIndex;
    }

    public void setStartColIndex(int startColIndex) {
        this.startColIndex = startColIndex;
    }

    public int getStartRowIndex() {
        return this.startRowIndex;
    }

    public void setCommandVersion(float version) {
        this.commandVersion = version;
    }

    public float getCommandVersion() {
        return this.commandVersion;
    }

    public void setStartRowIndex(int startRowIndex) {
        this.startRowIndex = startRowIndex;
    }

    public boolean isOoxml() {
        return this.isOoxml;
    }

    public void setOoxml(boolean isOoxml) {
        this.isOoxml = isOoxml;
        if (!isOoxml) {
            this.limitRowCount = 65536;
        }
    }

    public boolean isNoHead() {
        return this.isNoHead;
    }

    public void setNoHead(boolean isNoHead) {
        this.isNoHead = isNoHead;
    }

    public boolean isNoSummary() {
        return this.isNoSummary;
    }

    public void setNoSummary(boolean isNoSummary) {
        this.isNoSummary = isNoSummary;
    }

    public boolean isTopSummary() {
        return this.isTopSummary;
    }

    public void setTopSummary(boolean isTopSummary) {
        this.isTopSummary = isTopSummary;
    }

    public boolean isApplyWidth() {
        return this.isApplyWidth;
    }

    public void setApplyWidth(boolean isSetWidth) {
        this.isApplyWidth = isSetWidth;
    }

    public boolean isApplyHeight() {
        return this.isApplyHeight;
    }

    public void setApplyHeight(boolean isSetHeight) {
        this.isApplyHeight = isSetHeight;
    }

    public void setRequestPlatformType(String type) {
        this.requestType = type;
    }

    public String getRequestPlatformType() {
        return this.requestType;
    }

    public void setResponsePlatformType(String type) {
        if (type != null) {
            if ("xml".equalsIgnoreCase(type)) {
                this.responseType = "PlatformXml";
            } else if ("json".equalsIgnoreCase(type)) {
                this.responseType = "PlatformJson";
            } else if ("binary".equalsIgnoreCase(type)) {
                this.responseType = "PlatformBinary";
            }
        }
    }

    public String getResponsePlatformType() {
        return this.responseType;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public void setAbsolutePath(String absolutePath) {
        this.absolutePath = absolutePath;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public boolean isOutsidePath() {
        return this.isOutsidePath;
    }

    public void setOutsidePath(boolean isOutsidePath) {
        this.isOutsidePath = isOutsidePath;
    }

    public VariableList getUserVariableList() {
        return this.userVarList;
    }

    public void setUserVariableList(VariableList userVariableList) {
        String rowHeightStr;
        this.userVarList = userVariableList;
        int size = this.userVarList.getInt("accesswindowsize");
        if (size > 0) {
            this.rowAccessSize = size;
        }
        if (this.userVarList.contains("csvbom")) {
            this.isCsvBom = this.userVarList.getBoolean("csvbom");
        }
        if (this.userVarList.contains("rowheight") && (rowHeightStr = this.userVarList.getString("rowheight")) != null && rowHeightStr.length() > 0) {
            String[] rows;
            this.rowHeights = new HashMap<Integer, Integer>();
            for (String row : rows = rowHeightStr.split("\\,")) {
                String[] height = row.split("\\:");
                if (height.length < 2) continue;
                this.rowHeights.put(Integer.parseInt(height[0].trim()), Integer.parseInt(height[1].trim()));
            }
        }
    }

    public Map<Integer, Integer> getRowHeights() {
        return this.rowHeights;
    }

    public int getRowAccessSize() {
        return this.rowAccessSize;
    }

    public boolean isWrapText() {
        return this.isWrapText;
    }

    public void setWrapText(boolean isWrapText) {
        this.isWrapText = isWrapText;
    }

    public boolean isRtl() {
        return this.isRtl;
    }

    public void setRtl(boolean isRtl) {
        this.isRtl = isRtl;
    }

    public boolean isCsvQuote() {
        return this.isCsvQuote;
    }

    public void setCsvQuote(boolean isCsvQuote) {
        this.isCsvQuote = isCsvQuote;
    }

    public boolean isCsvBom() {
        return this.isCsvBom;
    }

    public void setCsvBom(boolean isCsvBom) {
        this.isCsvBom = isCsvBom;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String gridName) {
        this.itemName = gridName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getExportType() {
        return this.exportType;
    }

    public void setExportType(int exportType) {
        this.exportType = exportType;
        this.setOoxml(exportType == 288 || exportType == 1040);
    }
}

