/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.export.api;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.DataSetList;
import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.data.VariableList;
import com.nexacro.java.xapi.tx.HttpPlatformResponse;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.tx.PlatformRequest;
import com.nexacro.java.xeni.export.GridExportContext;
import com.nexacro.java.xeni.export.impl.GridPartExportExcel;
import com.nexacro.java.xeni.provider.ServletProvider;
import com.nexacro.java.xeni.util.XeniErrorProperties;
import com.nexacro.java.xeni.util.XeniProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.openxml4j.util.ZipSecureFile;

public class GridExportExcel
extends GridPartExportExcel {
    private static final Log log = LogFactory.getLog(GridExportExcel.class);
    private String securityPattern;
    private String securityPattern2;
    GridExportContext exportContext = new GridExportContext();
    ServletProvider svltProvider;
    DataSet dsCommand;
    DataSet dsStyle;
    DataSet dsCell;
    int errorCode = 0;

    public GridExportExcel(ServletProvider svltProvider) {
        this.svltProvider = svltProvider;
        this.dsCommand = null;
        this.dsStyle = null;
        this.dsCell = null;
        this.securityPattern = XeniProperties.getStringProperty("xeni.security.pattern");
        if (this.securityPattern == null || this.securityPattern.length() <= 0) {
            this.securityPattern = "'|\"|:|;|\\(|\\)|<|>|\\[|\\]|\\{|\\}|`|=|#|\\$|%|&|\\?|!|@|\\*|\t|\\||%27|%22|%3a|%3b|%28|%29|%3c|%3e|%5b|%5d|%7b|%7d|%60|%3d|%23|%24|%25|%26|%3f|%21|%40|%2a|%09|%7c|&#x|27;|&#x22;|&#x3a;|&#x3b;|&#x28;|&#x29;|&#x3c;|&#x3e;|&#x5b;|&#x5d;|&#x7b;|&#x7d;|&#x60;|&#x3d;|&#x23;|&#x24;|&#x25;|&#x26;|&#x3f;|&#x21;|&#x40;|&#x2a;|&#x09;|&#x7c;|script|javascript|vbscript|livescript|iframe|mocha|applet|img|embed|object|marquee|qss|body|input|form|div|style|table|isindex|meta|http-equiv|xss|href";
            this.securityPattern2 = "'|\"|:|;|<|>|`|=|#|\\$|%|&|\\?|!|@|\\*|\t|\\||%27|%22|%3a|%3b|%28|%29|%3c|%3e|%5b|%5d|%7b|%7d|%60|%3d|%23|%24|%25|%26|%3f|%21|%40|%2a|%09|%7c|&#x|27;|&#x22;|&#x3a;|&#x3b;|&#x28;|&#x29;|&#x3c;|&#x3e;|&#x5b;|&#x5d;|&#x7b;|&#x7d;|&#x60;|&#x3d;|&#x23;|&#x24;|&#x25;|&#x26;|&#x3f;|&#x21;|&#x40;|&#x2a;|&#x09;|&#x7c;|script|javascript|vbscript|livescript|iframe|mocha|applet|img|embed|object|marquee|qss|body|input|form|div|style|table|isindex|meta|http-equiv|xss|href";
        } else {
            this.securityPattern2 = this.securityPattern;
        }
        String maxEntryStr = XeniProperties.getStringProperty("xeni.guard.maxentry.size", null);
        String maxTextStr = XeniProperties.getStringProperty("xeni.guard.maxtext.size", null);
        String minRatioStr = XeniProperties.getStringProperty("xeni.guard.mininflate.ratio", null);
        if (maxEntryStr != null) {
            ZipSecureFile.setMaxEntrySize((long)Long.parseLong(maxEntryStr));
        }
        if (maxTextStr != null) {
            ZipSecureFile.setMaxTextSize((long)Long.parseLong(maxTextStr));
        }
        if (minRatioStr != null) {
            ZipSecureFile.setMinInflateRatio((double)Double.parseDouble(minRatioStr));
        }
    }

    @Override
    public GridExportContext getExportContext() {
        return this.exportContext;
    }

    public GridExportContext receiveData() throws IOException, PlatformException {
        if (this.svltProvider == null || this.svltProvider.getHttpServletRequest() == null) {
            String msg = "Http servlet request is null.";
            this.sendErrorMessage(-2006, msg);
            throw new IOException(msg);
        }
        PlatformRequest platformReq = null;
        try {
            platformReq = new PlatformRequest((InputStream)this.svltProvider.getHttpServletRequest().getInputStream());
            platformReq.receiveData();
        }
        catch (PlatformException e) {
            this.sendErrorMessage(-3101, e.getMessage());
            throw e;
        }
        catch (IOException e) {
            this.sendErrorMessage(-3101, e.getMessage());
            throw e;
        }
        PlatformData reauestData = platformReq.getData();
        if (reauestData == null) {
            String msg = XeniErrorProperties.getErrorProperty("err.agent.no.data");
            this.sendErrorMessage(-2006, msg);
            throw new IOException(msg);
        }
        DataSetList dsList = reauestData.getDataSetList();
        VariableList varList = reauestData.getVariableList();
        this.dsCommand = dsList.get("COMMAND");
        if (this.dsCommand == null) {
            String msg = XeniErrorProperties.getErrorProperty("err.agent.no.data");
            this.sendErrorMessage(-2006, msg);
            throw new IOException(msg);
        }
        this.dsStyle = dsList.get("STYLE");
        String sCommand = this.dsCommand.getString(0, "command");
        if (!sCommand.equals("export")) {
            String msg = XeniErrorProperties.getErrorProperty("err.agent.not.exporttype", sCommand);
            this.sendErrorMessage(-2006, msg);
            throw new IOException(msg);
        }
        String instanceId = this.dsCommand.getString(0, "instanceid");
        if (instanceId == null || instanceId.equals("")) {
            instanceId = UUID.randomUUID().toString();
        }
        if (log.isInfoEnabled()) {
            String item = this.dsCommand.getString(0, "item");
            String seq = this.dsCommand.getString(0, "seq");
            String eof = this.dsCommand.getString(0, "eof");
            String url = this.dsCommand.getString(0, "url");
            String instid = this.dsCommand.getString(0, "instanceid");
            log.info((Object)("Input export data : [ Item = " + StringUtils.normalizeSpace((String)item) + ", Seq. = " + StringUtils.normalizeSpace((String)seq) + ", EOF = " + StringUtils.normalizeSpace((String)eof) + ", Url = " + StringUtils.normalizeSpace((String)url) + ", Inst.Id = " + StringUtils.normalizeSpace((String)instid) + " ]"));
        }
        this.dsCommand.set(0, "instanceid", instanceId);
        this.exportContext = this.getExportContext(this.dsCommand, varList, platformReq.getContentType());
        return this.exportContext;
    }

    private GridExportContext getExportContext(DataSet command, VariableList varlist, String type) {
        GridExportContext context = this.getExportContext();
        context.setRequestPlatformType(type);
        context.setResponsePlatformType(XeniProperties.getStringProperty("xeni.export.commdataformat"));
        context.setUserVariableList(varlist);
        context.setAppendUrl(command.getString(0, "url"));
        context.setExportType(command.getInt(0, "type"));
        context.setItemName(command.getString(0, "item"));
        context.setFileName(command.getString(0, "exportfilename"));
        context.setInstanceId(command.getString(0, "instanceid"));
        String headSummary = command.getString(0, "exporthead");
        if (headSummary != null) {
            context.setNoHead(headSummary.contains("nohead"));
            context.setNoSummary(headSummary.contains("nosumm"));
        }
        context.setTopSummary("top".equals(command.getString(0, "summarytype")));
        if ("both".equals(command.getString(0, "exportsize"))) {
            context.setApplyHeight(true);
        } else if ("height".equals(command.getString(0, "exportsize"))) {
            context.setApplyWidth(false);
            context.setApplyHeight(true);
        }
        context.setWrapText(command.getBoolean(0, "wraptext"));
        context.setRtl(command.getBoolean(0, "righttoleft"));
        context.setPassword(command.getString(0, "password"));
        context.setCommandVersion(command.getFloat(0, "commandversion"));
        return context;
    }

    public void setExportPath(String path, String url) throws Exception {
        if (this.exportContext == null) {
            this.exportContext = new GridExportContext();
        }
        String exportPath = "";
        if (path == null || path.isEmpty()) {
            exportPath = "export/";
        } else {
            if (path.startsWith("file://")) {
                exportPath = path.substring(7);
                this.exportContext.setOutsidePath(true);
            } else if (path.startsWith("/")) {
                exportPath = path.substring(1);
            }
            if (!exportPath.endsWith("/")) {
                exportPath = exportPath + "/";
            }
        }
        String ctxtPath = null;
        if (this.svltProvider.getHttpServletRequest().getSession() == null) {
            log.info((Object)"Request session is null");
        } else if (this.svltProvider.getHttpServletRequest().getSession().getServletContext() == null) {
            log.info((Object)"Servlet context is null");
        } else {
            ctxtPath = this.svltProvider.getHttpServletRequest().getSession().getServletContext().getRealPath("/");
        }
        if (ctxtPath == null) {
            if (!this.exportContext.isOutsidePath()) {
                String msg = "Unable to get real path of the context. Set absolute paths.";
                this.sendErrorMessage(-2001, msg);
                throw new Exception(msg);
            }
        } else if (!(ctxtPath = ctxtPath.replaceAll("\\\\", "/")).endsWith("/")) {
            ctxtPath = ctxtPath + "/";
        }
        if (this.exportContext.isOutsidePath()) {
            this.exportContext.setAbsolutePath(exportPath);
        } else {
            this.exportContext.setAbsolutePath(ctxtPath + exportPath);
        }
        String requestUrl = null;
        if (url != null && !url.isEmpty()) {
            requestUrl = url;
        } else {
            int pos;
            requestUrl = this.svltProvider.getHttpServletRequest().getRequestURL().toString();
            String ctxtName = ctxtPath;
            if (ctxtName.endsWith("/")) {
                ctxtName = ctxtName.substring(0, ctxtName.length() - 1);
            }
            if ((pos = requestUrl.indexOf(ctxtName = ctxtName.substring(ctxtName.lastIndexOf("/") + 1) + "/")) > 0) {
                requestUrl = requestUrl.substring(0, pos + ctxtName.length());
            }
        }
        if (this.exportContext.isOutsidePath()) {
            this.exportContext.setDownloadUrl(requestUrl);
        } else {
            this.exportContext.setDownloadUrl(requestUrl.substring(0, requestUrl.lastIndexOf("/") + 1) + exportPath);
        }
    }

    public void startExport(DataSet dataset, boolean eof) throws IOException, Exception {
        if (dataset == null) {
            return;
        }
        if (this.exportContext.getAbsolutePath() == null || this.exportContext.getDownloadUrl() == null) {
            this.setExportPath(null, null);
        }
        if (this.dsCommand == null) {
            this.dsCommand = new DataSet("COMMAND");
        }
        if (this.dsStyle == null) {
            this.dsStyle = new DataSet("STYLE");
        }
        this.dsCommand.set(0, "seq", this.exportContext.getSequence() + 1);
        this.dsCommand.set(0, "eof", eof);
        int errorCode = 0;
        if (this.dsCommand.getInt(0, "seq") == 1) {
            errorCode = this.initialize(this.exportContext, this.dsCommand);
        }
        if (errorCode >= 0) {
            this.startExport(this.svltProvider, this.dsCommand, this.dsStyle, dataset);
        }
        if (errorCode != 0) {
            this.sendErrorMessage(-2001, this.getErrorMessage());
            throw new Exception(this.getErrorMessage());
        }
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    private void sendErrorMessage(int errcode, String errmsg) {
        block3: {
            this.errorCode = errcode;
            PlatformData responseData = new PlatformData();
            VariableList varList = responseData.getVariableList();
            varList.add("ErrorCode", errcode);
            varList.add("ErrorMsg", errmsg);
            HttpPlatformResponse platformResponse = new HttpPlatformResponse(this.svltProvider.getHttpServletResponse(), "PlatformSsv", "UTF-8");
            platformResponse.setData(responseData);
            if (log.isErrorEnabled()) {
                log.error((Object)StringUtils.normalizeSpace((String)errmsg));
            }
            try {
                platformResponse.sendData();
            }
            catch (PlatformException e) {
                if (!log.isInfoEnabled()) break block3;
                log.error((Object)StringUtils.normalizeSpace((String)e.getMessage()));
            }
        }
    }
}

