/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.export.impl;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xeni.export.impl.GridCellStyleInfoExt;
import com.nexacro.java.xeni.util.CommUtil;
import com.nexacro.java.xeni.util.XeniErrorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFont;

public class GridCellStyleInfo {
    private String sErrMessage = "";
    private static final Log oLogger = LogFactory.getLog(GridCellStyleInfo.class);
    private List<GridCellStyleInfoExt> listStyle;
    private HashMap<String, Integer> oColors;
    private DataSet dsStyle;
    private short nOffset = (short)8;
    private boolean bAppended = false;

    public GridCellStyleInfo() {
        this.listStyle = new ArrayList<GridCellStyleInfoExt>();
        this.oColors = new HashMap();
        this.dsStyle = new DataSet();
    }

    public int getStyleInfo(Workbook workbook, DataSet dsstyle, boolean b2007, boolean bwrap, boolean bappend) {
        this.bAppended = bappend;
        int nRowIdx = this.dsStyle.getRowCount();
        if (this.dsStyle.getColumnCount() <= 0) {
            this.dsStyle.copyFrom(dsstyle, true);
        } else {
            this.dsStyle.copyDataFrom(dsstyle, true);
        }
        while (nRowIdx < this.dsStyle.getRowCount()) {
            String sType = this.dsStyle.getString(nRowIdx, "type");
            if (sType.equals("style") && this.createCellStyle(workbook, this.dsStyle, b2007, bwrap, nRowIdx) < 0) {
                return -2009;
            }
            ++nRowIdx;
        }
        return 0;
    }

    private void setErrorMessage(String message) {
        this.sErrMessage = message;
        if (oLogger.isInfoEnabled()) {
            oLogger.info((Object)StringUtils.normalizeSpace((String)message));
        }
    }

    public String getErrorMessage() {
        return this.sErrMessage;
    }

    private int createCellStyle(Workbook workbook, DataSet dsStyle, boolean bIs2007, boolean bWrap, int index) {
        GridCellStyleInfoExt extStyle = new GridCellStyleInfoExt();
        CellStyle cellStyle = workbook.createCellStyle();
        this.setDefaultStyle(cellStyle, bWrap);
        Font font = null;
        String sName = dsStyle.getString(index, "name");
        String sValue = dsStyle.getString(index, "value");
        if (oLogger.isDebugEnabled()) {
            oLogger.debug((Object)("Create style[ " + StringUtils.normalizeSpace((String)sName) + " - " + StringUtils.normalizeSpace((String)sValue) + " ]"));
        }
        String[] saStyles = sValue.split("\\,");
        for (int nArrIdx = 0; nArrIdx < saStyles.length; ++nArrIdx) {
            if (saStyles[nArrIdx].equals("")) continue;
            String[] sType = saStyles[nArrIdx].split("\\:");
            if (sType.length < 2) {
                this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.style.notfound.type", sName, saStyles[nArrIdx]));
                continue;
            }
            String sStyleType = sType[0].trim();
            String[] arrValues = this.getStyleValue(dsStyle, sStyleType, sType[1].trim());
            String sLocale = arrValues[1];
            String sStyleValue = arrValues[0];
            if (sStyleValue == null || sStyleValue.length() < 1) {
                this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.style.notfound.type", sName, saStyles[nArrIdx]));
                continue;
            }
            if (sStyleType.equals("align")) {
                this.setStyleAlign(cellStyle, sStyleValue);
                continue;
            }
            if (sStyleType.equals("font")) {
                if (font == null) {
                    font = workbook.createFont();
                }
                this.setStyleFont(sStyleValue, font);
                continue;
            }
            if (sStyleType.equals("background")) {
                this.setStyleBackground(workbook, cellStyle, sStyleValue, bIs2007);
                continue;
            }
            if (sStyleType.equals("color")) {
                if (font == null) {
                    font = workbook.createFont();
                }
                this.setStyleForeground(workbook, sStyleValue, bIs2007, font);
                continue;
            }
            if (sStyleType.equals("line")) {
                this.setStyleBorder(workbook, cellStyle, sStyleValue, bIs2007);
                continue;
            }
            if (sStyleType.equals("type")) {
                this.setStyleDataType(workbook, cellStyle, sStyleValue, extStyle, sLocale);
                continue;
            }
            if (sStyleType.equals("rowsuppress") || sStyleType.equals("merge")) {
                this.setStyleSuppress(workbook, cellStyle, sStyleValue, extStyle, true);
                continue;
            }
            if (sStyleType.equals("colsuppress")) {
                this.setStyleSuppress(workbook, cellStyle, sStyleValue, extStyle, false);
                continue;
            }
            this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.style.notfound.type", sName, saStyles[nArrIdx]));
            return -1;
        }
        if (font != null) {
            cellStyle.setFont(font);
        }
        extStyle.addStyle(sName, cellStyle.getIndex());
        this.listStyle.add(extStyle);
        return 0;
    }

    private void setDefaultStyle(CellStyle style, boolean bWrap) {
        if (bWrap) {
            style.setWrapText(true);
        }
    }

    private String[] getStyleValue(DataSet dsStyle, String sType, String sName) {
        String[] values = new String[2];
        for (int nRowIdx = 0; nRowIdx < dsStyle.getRowCount(); ++nRowIdx) {
            String sFindType = dsStyle.getString(nRowIdx, "type");
            String sFindName = dsStyle.getString(nRowIdx, "name");
            if (!sType.equals(sFindType.trim()) || !sName.equals(sFindName.trim())) continue;
            if ("type".equals(sType)) {
                values[1] = dsStyle.getString(nRowIdx, "locale");
            }
            values[0] = dsStyle.getString(nRowIdx, "value");
            return values;
        }
        return null;
    }

    private void setStyleAlign(CellStyle style, String value) {
        String[] saAlign;
        if (oLogger.isDebugEnabled()) {
            oLogger.debug((Object)("Set style align [ " + StringUtils.normalizeSpace((String)value) + " ]"));
        }
        if ((saAlign = value.split("\\,")).length < 1) {
            return;
        }
        HorizontalAlignment shHAlign = HorizontalAlignment.LEFT;
        VerticalAlignment shVAlign = VerticalAlignment.CENTER;
        if (saAlign[0].equals("left")) {
            shHAlign = HorizontalAlignment.LEFT;
        } else if (saAlign[0].equals("center")) {
            shHAlign = HorizontalAlignment.CENTER;
        } else if (saAlign[0].equals("right")) {
            shHAlign = HorizontalAlignment.RIGHT;
        }
        style.setAlignment(shHAlign);
        if (saAlign.length > 1) {
            if (saAlign[1].equals("top")) {
                shVAlign = VerticalAlignment.TOP;
            } else if (saAlign[1].equals("middle")) {
                shVAlign = VerticalAlignment.CENTER;
            } else if (saAlign[1].equals("bottom")) {
                shVAlign = VerticalAlignment.BOTTOM;
            }
        }
        style.setVerticalAlignment(shVAlign);
    }

    private void setStyleFont(String value, Font font) {
        String[] saFont;
        if (oLogger.isDebugEnabled()) {
            oLogger.debug((Object)("Set style font [ " + StringUtils.normalizeSpace((String)value) + " ]"));
        }
        if ((saFont = value.split("\\,")).length < 1) {
            return;
        }
        boolean bBold = false;
        boolean bItalic = false;
        byte btULine = 0;
        boolean bStOut = false;
        for (int nIdx = 0; nIdx < saFont.length; ++nIdx) {
            String sName = saFont[nIdx].trim();
            if ("".equals(sName = sName.replaceAll("\"", ""))) continue;
            if (sName.equals("bold")) {
                bBold = true;
                continue;
            }
            if (sName.equals("italic")) {
                bItalic = true;
                continue;
            }
            if (sName.equals("underline")) {
                btULine = 1;
                continue;
            }
            if (sName.equals("strikeout")) {
                bStOut = true;
                continue;
            }
            if (sName.equals("antialias")) continue;
            if (CommUtil.isNumber(sName)) {
                font.setFontHeight((short)(Integer.parseInt(sName) * 20));
                continue;
            }
            font.setFontName(sName);
        }
        font.setBold(bBold);
        font.setItalic(bItalic);
        font.setUnderline(btULine);
        font.setStrikeout(bStOut);
    }

    private void setStyleBackground(Workbook workbook, CellStyle style, String value, boolean bIs2007) {
        String[] saColor;
        if (oLogger.isDebugEnabled()) {
            oLogger.debug((Object)("Set style background [ " + StringUtils.normalizeSpace((String)value) + " ]"));
        }
        if ((saColor = value.split("\\,")).length < 3) {
            return;
        }
        style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.WHITE.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        if (bIs2007) {
            XSSFColor color = this.getXSSFRGBColor(saColor[0], saColor[1], saColor[2], false);
            if (color != null) {
                ((XSSFCellStyle)style).setFillForegroundColor(color);
            }
        } else {
            short nIndex = this.getHSSFRGBColor(saColor[0], saColor[1], saColor[2], workbook);
            style.setFillForegroundColor(nIndex);
        }
    }

    private void setStyleForeground(Workbook workbook, String value, boolean bIs2007, Font font) {
        String[] saColor;
        if (oLogger.isDebugEnabled()) {
            oLogger.debug((Object)("Set style foreground [ " + StringUtils.normalizeSpace((String)value) + " ]"));
        }
        if ((saColor = value.split("\\,")).length < 3) {
            return;
        }
        font.setColor((short)Short.MAX_VALUE);
        if (bIs2007) {
            XSSFColor color = this.getXSSFRGBColor(saColor[0], saColor[1], saColor[2], true);
            if (color != null) {
                CTFont cffont = ((XSSFFont)font).getCTFont();
                cffont.setColorArray(0, color.getCTColor());
            }
        } else {
            short nIndex = this.getHSSFRGBColor(saColor[0], saColor[1], saColor[2], workbook);
            font.setColor(nIndex);
        }
    }

    private void setStyleBorder(Workbook workbook, CellStyle style, String value, boolean bIs2007) {
        String[] saBorder;
        if (oLogger.isDebugEnabled()) {
            oLogger.debug((Object)("Set style border [ " + StringUtils.normalizeSpace((String)value) + " ]"));
        }
        if ((saBorder = value.split("\\:")).length < 4) {
            return;
        }
        for (int nIndex = 0; nIndex < saBorder.length; ++nIndex) {
            if (saBorder[nIndex].equals("") || saBorder[nIndex].equals("empty")) continue;
            String[] saColor = saBorder[nIndex].split("\\,");
            BorderStyle shBorder = BorderStyle.THIN;
            if (saColor.length > 3) {
                shBorder = BorderStyle.MEDIUM;
                if (saColor[3].equals("double")) {
                    shBorder = BorderStyle.DOUBLE;
                } else if (saColor[3].equals("dotted")) {
                    shBorder = BorderStyle.DOTTED;
                } else if (saColor[3].equals("dashed")) {
                    shBorder = BorderStyle.DASHED;
                }
            }
            if (bIs2007) {
                XSSFColor color = this.getXSSFRGBColor(saColor[0], saColor[1], saColor[2], false);
                if (color == null) continue;
                if (nIndex == 0) {
                    style.setBorderLeft(shBorder);
                    ((XSSFCellStyle)style).setLeftBorderColor(color);
                    continue;
                }
                if (nIndex == 1) {
                    style.setBorderTop(shBorder);
                    ((XSSFCellStyle)style).setTopBorderColor(color);
                    continue;
                }
                if (nIndex == 2) {
                    style.setBorderRight(shBorder);
                    ((XSSFCellStyle)style).setRightBorderColor(color);
                    continue;
                }
                if (nIndex != 3) continue;
                style.setBorderBottom(shBorder);
                ((XSSFCellStyle)style).setBottomBorderColor(color);
                continue;
            }
            short nColIdx = this.getHSSFRGBColor(saColor[0], saColor[1], saColor[2], workbook);
            if (nIndex == 0) {
                style.setBorderLeft(shBorder);
                style.setLeftBorderColor(nColIdx);
                continue;
            }
            if (nIndex == 1) {
                style.setBorderTop(shBorder);
                style.setTopBorderColor(nColIdx);
                continue;
            }
            if (nIndex == 2) {
                style.setBorderRight(shBorder);
                style.setRightBorderColor(nColIdx);
                continue;
            }
            if (nIndex != 3) continue;
            style.setBorderBottom(shBorder);
            style.setBottomBorderColor(nColIdx);
        }
    }

    private void setStyleDataType(Workbook wb, CellStyle style, String value, GridCellStyleInfoExt extstyle, String locale) {
        if (oLogger.isDebugEnabled()) {
            oLogger.debug((Object)("Set style data type [ " + StringUtils.normalizeSpace((String)value) + " ]"));
        }
        String sType = null;
        String sMask = null;
        int nSep = value.indexOf(58);
        if (nSep <= 0) {
            sType = value;
        } else {
            sType = value.substring(0, nSep);
            sMask = value.substring(nSep + 1);
        }
        int nType = this.getDataTypeNumber(sType);
        extstyle.setDataType(nType);
        if (nType == 1) {
            if (sMask != null) {
                int dotPos;
                if (sMask.startsWith("!") || sMask.startsWith("+") || sMask.startsWith("-")) {
                    sMask = sMask.substring(1);
                }
                if (sMask.contains("9")) {
                    sMask = sMask.replace('9', '#');
                }
                if ((dotPos = sMask.indexOf(46)) > 0) {
                    char[] masks = sMask.toCharArray();
                    boolean find0 = false;
                    int i = masks.length - 1;
                    while (find0 ? i > dotPos : i > dotPos + 1) {
                        if (find0) {
                            masks[i] = 48;
                        } else if (masks[i] == '0') {
                            find0 = true;
                        }
                        --i;
                    }
                    if (find0) {
                        sMask = String.valueOf(masks);
                    }
                }
                sMask = sMask.replace("#.", "0.");
                if ((sMask = sMask.replace(".#", ".0")).contains("%")) {
                    extstyle.setbPercentage(true);
                } else {
                    sMask = sMask + "_ ";
                }
                style.setDataFormat(wb.createDataFormat().getFormat(sMask));
                extstyle.setDataFormat(sMask);
            } else {
                style.setDataFormat(wb.createDataFormat().getFormat("#,##0_ "));
            }
        } else if (nType == 2) {
            if (sMask != null) {
                String format = sMask;
                if (format.contains("sss")) {
                    format = format.replace("sss", ".000");
                }
                if (format.contains("/")) {
                    format = format.replaceAll("\\/", "\\\\/");
                }
                format = this.getFormatForLanguage(format, locale);
                style.setDataFormat(wb.createDataFormat().getFormat(format));
                format = sMask;
                if (format.contains("dddd")) {
                    format = format.replace("dddd", "E");
                } else if (format.contains("ddd")) {
                    format = format.replace("ddd", "E");
                }
                if (format.contains("hh")) {
                    format = format.replace("hh", "HH");
                } else if (format.contains("h")) {
                    format = format.replace("h", "H");
                }
                if (format.contains("sss")) {
                    format = format.replace("sss", "SSS");
                }
                extstyle.setDataFormat(format);
            }
        } else if (nType == 3) {
            if (sMask != null && sMask.startsWith("image")) {
                extstyle.setImageData(true);
                String[] saOpt = sMask.split("\\,");
                if (saOpt.length > 1) {
                    extstyle.setImageStretch(saOpt[1]);
                }
            } else {
                style.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"TEXT"));
            }
        }
    }

    private void setStyleSuppress(Workbook wb, CellStyle style, String value, GridCellStyleInfoExt extstyle, boolean isRow) {
        int iValue;
        if (oLogger.isDebugEnabled()) {
            oLogger.debug((Object)("Set style suppress [ " + StringUtils.normalizeSpace((String)value) + " ]"));
        }
        if ((iValue = Integer.parseInt(value)) > 1) {
            if (isRow) {
                extstyle.setiRowSuppressCount(iValue);
            } else {
                extstyle.setiColSuppressCount(iValue);
            }
        }
    }

    private XSSFColor getXSSFRGBColor(String sR, String sG, String sB, boolean isFore) {
        int nR = Integer.parseInt(sR);
        int nG = Integer.parseInt(sG);
        int nB = Integer.parseInt(sB);
        byte[] rgb = new byte[]{0, (byte)nR, (byte)nG, (byte)nB};
        XSSFColor color = new XSSFColor();
        color.setRGB(rgb);
        return color;
    }

    private short getHSSFRGBColor(String sR, String sG, String sB, Workbook wb) {
        if (!this.bAppended) {
            String sColor = sR + sG + sB;
            if (this.oColors.containsKey(sColor)) {
                return (short)this.oColors.get(sColor).intValue();
            }
            int nR = Integer.parseInt(sR);
            int nG = Integer.parseInt(sG);
            int nB = Integer.parseInt(sB);
            short nIndex = this.nOffset;
            HSSFPalette palette = ((HSSFWorkbook)wb).getCustomPalette();
            if (this.nOffset > 64) {
                this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.style.limit.usercolor"));
                HSSFColor color = palette.findSimilarColor(nR, nG, nB);
                return color != null ? (short)color.getIndex() : (short)64;
            }
            palette.setColorAtIndex(nIndex, (byte)nR, (byte)nG, (byte)nB);
            this.nOffset = (short)(this.nOffset + 1);
            this.oColors.put(sColor, Integer.valueOf(nIndex));
            return nIndex;
        }
        HSSFColor color = null;
        HSSFPalette palette = ((HSSFWorkbook)wb).getCustomPalette();
        byte nR = (byte)Integer.parseInt(sR);
        byte nG = (byte)Integer.parseInt(sG);
        byte nB = (byte)Integer.parseInt(sB);
        try {
            color = palette.findColor(nR, nG, nB);
            if (color == null) {
                color = palette.addColor(nR, nG, nB);
            }
        }
        catch (RuntimeException e) {
            color = palette.findSimilarColor(nR, nG, nB);
        }
        return color.getIndex();
    }

    public GridCellStyleInfoExt getCellStyle(String sName) {
        GridCellStyleInfoExt extStyle = null;
        for (int nIdx = 0; nIdx < this.listStyle.size(); ++nIdx) {
            extStyle = this.listStyle.get(nIdx);
            if (!sName.equals(extStyle.getStyleName())) continue;
            return extStyle;
        }
        return null;
    }

    public CellStyle getCellStyle(Workbook wb, String sName) {
        if (sName == null || sName.length() < 1) {
            return null;
        }
        CellStyle style = null;
        GridCellStyleInfoExt extStyle = this.getCellStyle(sName);
        if (extStyle != null) {
            style = wb.getCellStyleAt((int)extStyle.getStyleIndex());
        }
        return style;
    }

    public void clear() {
        this.listStyle.clear();
        this.oColors.clear();
    }

    public short getPaletteOffset() {
        return this.nOffset;
    }

    public void setPaletteOffset(short offset) {
        this.nOffset = offset;
    }

    public void appendStyle(String name, short index, int type, String format, boolean image) {
        GridCellStyleInfoExt extStyle = new GridCellStyleInfoExt();
        extStyle.addStyle(name, index);
        extStyle.setDataType(type);
        extStyle.setDataFormat(format);
        extStyle.setImageData(image);
        this.listStyle.add(extStyle);
    }

    private int getDataTypeNumber(String type) {
        int nType = 3;
        if ("normal".equals(type)) {
            nType = 0;
        } else if ("number".equals(type)) {
            nType = 1;
        } else if ("date".equals(type)) {
            nType = 2;
        }
        return nType;
    }

    private String getFormatForLanguage(String mask, String locale) {
        if (locale == null || "".equals(locale)) {
            Locale defLocale = Locale.getDefault();
            locale = defLocale.getLanguage() + "_" + defLocale.getCountry();
        }
        String format = "";
        if ("ko_KR".equals(locale)) {
            format = "[$-412]";
        } else if ("ja_JP".equals(locale)) {
            format = "[$-411]";
        } else if ("zh_CN".equals(locale)) {
            format = "[$-804]";
        } else if ("zh_HK".equals(locale)) {
            format = "[$-C04]";
        } else if ("zh_SG".equals(locale)) {
            format = "[$-1004]";
        } else if ("zh_TW".equals(locale)) {
            format = "[$-404]";
        } else if ("aa_DJ".equals(locale)) {
            format = "[$-1000]";
        } else if ("aa_ER".equals(locale)) {
            format = "[$-1000]";
        } else if ("aa_ET".equals(locale)) {
            format = "[$-1000]";
        } else if ("af_ZA".equals(locale)) {
            format = "[$-436]";
        } else if ("ar_AE".equals(locale)) {
            format = "[$-3801]";
        } else if ("ar_BH".equals(locale)) {
            format = "[$-3C01]";
        } else if ("ar_DZ".equals(locale)) {
            format = "[$-1401]";
        } else if ("ar_EG".equals(locale)) {
            format = "[$-c01]";
        } else if ("ar_IN".equals(locale)) {
            format = "[$-1]";
        } else if ("ar_IQ".equals(locale)) {
            format = "[$-801]";
        } else if ("ar_JO".equals(locale)) {
            format = "[$-2C01]";
        } else if ("ar_KW".equals(locale)) {
            format = "[$-3401]";
        } else if ("ar_LB".equals(locale)) {
            format = "[$-3001]";
        } else if ("ar_LY".equals(locale)) {
            format = "[$-1001]";
        } else if ("ar_MA".equals(locale)) {
            format = "[$-1801]";
        } else if ("ar_OM".equals(locale)) {
            format = "[$-2001]";
        } else if ("ar_QA".equals(locale)) {
            format = "[$-4001]";
        } else if ("ar_SA".equals(locale)) {
            format = "[$-401]";
        } else if ("ar_SD".equals(locale)) {
            format = "[$-1000]";
        } else if ("ar_SY".equals(locale)) {
            format = "[$-2801]";
        } else if ("ar_TN".equals(locale)) {
            format = "[$-1C01]";
        } else if ("ar_YE".equals(locale)) {
            format = "[$-2401]";
        } else if ("as_IN".equals(locale)) {
            format = "[$-44D]";
        } else if ("az_AZ".equals(locale)) {
            format = "[$-2C]";
        } else if ("be_BY".equals(locale)) {
            format = "[$-423]";
        } else if ("bg_BG".equals(locale)) {
            format = "[$-402]";
        } else if ("bn_BD".equals(locale)) {
            format = "[$-845]";
        } else if ("bn_IN".equals(locale)) {
            format = "[$-445]";
        } else if ("br_FR".equals(locale)) {
            format = "[$-47E]";
        } else if ("bs_BA".equals(locale)) {
            format = "[$-781A]";
        } else if ("ca_AD".equals(locale)) {
            format = "[$-1000]";
        } else if ("ca_ES".equals(locale)) {
            format = "[$-403]";
        } else if ("ca_FR".equals(locale)) {
            format = "[$-1000]";
        } else if ("ca_IT".equals(locale)) {
            format = "[$-1000]";
        } else if ("cs_CZ".equals(locale)) {
            format = "[$-405]";
        } else if ("cy_GB".equals(locale)) {
            format = "[$-452]";
        } else if ("da_DK".equals(locale)) {
            format = "[$-406]";
        } else if ("de_AT".equals(locale)) {
            format = "[$-C07]";
        } else if ("de_BE".equals(locale)) {
            format = "[$-1000]";
        } else if ("de_CH".equals(locale)) {
            format = "[$-807]";
        } else if ("de_DE".equals(locale)) {
            format = "[$-407]";
        } else if ("de_LU".equals(locale)) {
            format = "[$-1007]";
        } else if ("dz_BT".equals(locale)) {
            format = "[$-C51]";
        } else if ("el_CY".equals(locale)) {
            format = "[$-1000]";
        } else if ("el_GR".equals(locale)) {
            format = "[$-408]";
        } else if ("en_AU".equals(locale)) {
            format = "[$-C09]";
        } else if ("en_BW".equals(locale)) {
            format = "[$-1000]";
        } else if ("en_CA".equals(locale)) {
            format = "[$-1009]";
        } else if ("en_DK".equals(locale)) {
            format = "[$-1000]";
        } else if ("en_GB".equals(locale)) {
            format = "[$-809]";
        } else if ("en_HK".equals(locale)) {
            format = "[$-3C09]";
        } else if ("en_IE".equals(locale)) {
            format = "[$-1809]";
        } else if ("en_IN".equals(locale)) {
            format = "[$-4009]";
        } else if ("en_NZ".equals(locale)) {
            format = "[$-1409]";
        } else if ("en_PH".equals(locale)) {
            format = "[$-3409]";
        } else if ("en_SG".equals(locale)) {
            format = "[$-4809]";
        } else if ("en_US".equals(locale)) {
            format = "[$-409]";
        } else if ("en_ZA".equals(locale)) {
            format = "[$-1C09]";
        } else if ("en_ZW".equals(locale)) {
            format = "[$-3009]";
        } else if ("es_AR".equals(locale)) {
            format = "[$-2C0A]";
        } else if ("es_BO".equals(locale)) {
            format = "[$-400A]";
        } else if ("es_CL".equals(locale)) {
            format = "[$-340A]";
        } else if ("es_CO".equals(locale)) {
            format = "[$-240A]";
        } else if ("es_CR".equals(locale)) {
            format = "[$-140A]";
        } else if ("es_DO".equals(locale)) {
            format = "[$-1c0A]";
        } else if ("es_EC".equals(locale)) {
            format = "[$-300A]";
        } else if ("es_ES".equals(locale)) {
            format = "[$-0c0A]";
        } else if ("es_GT".equals(locale)) {
            format = "[$-100A]";
        } else if ("es_HN".equals(locale)) {
            format = "[$-480A]";
        } else if ("es_MX".equals(locale)) {
            format = "[$-80A]";
        } else if ("es_NI".equals(locale)) {
            format = "[$-4C0A]";
        } else if ("es_PA".equals(locale)) {
            format = "[$-180A]";
        } else if ("es_PE".equals(locale)) {
            format = "[$-280A]";
        } else if ("es_PR".equals(locale)) {
            format = "[$-500A]";
        } else if ("es_PY".equals(locale)) {
            format = "[$-3C0A]";
        } else if ("es_SV".equals(locale)) {
            format = "[$-440A]";
        } else if ("es_US".equals(locale)) {
            format = "[$-540A]";
        } else if ("es_UY".equals(locale)) {
            format = "[$-380A]";
        } else if ("es_VE".equals(locale)) {
            format = "[$-200A]";
        } else if ("et_EE".equals(locale)) {
            format = "[$-425]";
        } else if ("eu_ES".equals(locale)) {
            format = "[$-42D]";
        } else if ("fa_IR".equals(locale)) {
            format = "[$-429]";
        } else if ("fi_FI".equals(locale)) {
            format = "[$-40B]";
        } else if ("fo_FO".equals(locale)) {
            format = "[$-438]";
        } else if ("fr_BE".equals(locale)) {
            format = "[$-80C]";
        } else if ("fr_CA".equals(locale)) {
            format = "[$-c0C]";
        } else if ("fr_CH".equals(locale)) {
            format = "[$-100C]";
        } else if ("fr_FR".equals(locale)) {
            format = "[$-40C]";
        } else if ("fr_LU".equals(locale)) {
            format = "[$-140C]";
        } else if ("fy_NL".equals(locale)) {
            format = "[$-462]";
        } else if ("ga_IE".equals(locale)) {
            format = "[$-83C]";
        } else if ("gd_GB".equals(locale)) {
            format = "[$-491]";
        } else if ("gl_ES".equals(locale)) {
            format = "[$-456]";
        } else if ("gu_IN".equals(locale)) {
            format = "[$-447]";
        } else if ("gv_GB".equals(locale)) {
            format = "[$-1000]";
        } else if ("he_IL".equals(locale)) {
            format = "[$-40D]";
        } else if ("hi_IN".equals(locale)) {
            format = "[$-439]";
        } else if ("hr_HR".equals(locale)) {
            format = "[$-41A]";
        } else if ("hu_HU".equals(locale)) {
            format = "[$-40E]";
        } else if ("hy_AM".equals(locale)) {
            format = "[$-42B]";
        } else if ("id_ID".equals(locale)) {
            format = "[$-421]";
        } else if ("is_IS".equals(locale)) {
            format = "[$-40F]";
        } else if ("it_CH".equals(locale)) {
            format = "[$-810]";
        } else if ("it_IT".equals(locale)) {
            format = "[$-410]";
        } else if ("iw_IL".equals(locale)) {
            format = "[$-40D]";
        } else if ("ka_GE".equals(locale)) {
            format = "[$-437]";
        } else if ("kk_KZ".equals(locale)) {
            format = "[$-43F]";
        } else if ("kl_GL".equals(locale)) {
            format = "[$-46F]";
        } else if ("km_KH".equals(locale)) {
            format = "[$-453]";
        } else if ("kn_IN".equals(locale)) {
            format = "[$-44B]";
        } else if ("ku_TR".equals(locale)) {
            format = "[$-92]";
        } else if ("kw_GB".equals(locale)) {
            format = "[$-1000]";
        } else if ("ky_KG".equals(locale)) {
            format = "[$-440]";
        } else if ("lg_UG".equals(locale)) {
            format = "[$-1000]";
        } else if ("lo_LA".equals(locale)) {
            format = "[$-454]";
        } else if ("lt_LT".equals(locale)) {
            format = "[$-427]";
        } else if ("lv_LV".equals(locale)) {
            format = "[$-426]";
        } else if ("mg_MG".equals(locale)) {
            format = "[$-1000]";
        } else if ("mi_NZ".equals(locale)) {
            format = "[$-481]";
        } else if ("mk_MK".equals(locale)) {
            format = "[$-42F]";
        } else if ("ml_IN".equals(locale)) {
            format = "[$-44C]";
        } else if ("mn_MN".equals(locale)) {
            format = "[$-450]";
        } else if ("mr_IN".equals(locale)) {
            format = "[$-44E]";
        } else if ("ms_MY".equals(locale)) {
            format = "[$-43E]";
        } else if ("mt_MT".equals(locale)) {
            format = "[$-43A]";
        } else if ("nb_NO".equals(locale)) {
            format = "[$-414]";
        } else if ("ne_NP".equals(locale)) {
            format = "[$-461]";
        } else if ("nl_BE".equals(locale)) {
            format = "[$-813]";
        } else if ("nl_NL".equals(locale)) {
            format = "[$-413]";
        } else if ("nn_NO".equals(locale)) {
            format = "[$-814]";
        } else if ("no_NO".equals(locale)) {
            format = "[$-414]";
        } else if ("nr_ZA".equals(locale)) {
            format = "[$-1000]";
        } else if ("oc_FR".equals(locale)) {
            format = "[$-482]";
        } else if ("om_ET".equals(locale)) {
            format = "[$-472]";
        } else if ("om_KE".equals(locale)) {
            format = "[$-1000]";
        } else if ("or_IN".equals(locale)) {
            format = "[$-448]";
        } else if ("pa_IN".equals(locale)) {
            format = "[$-446]";
        } else if ("pa_PK".equals(locale)) {
            format = "[$-46]";
        } else if ("pl_PL".equals(locale)) {
            format = "[$-415]";
        } else if ("pt_BR".equals(locale)) {
            format = "[$-416]";
        } else if ("pt_PT".equals(locale)) {
            format = "[$-816]";
        } else if ("ro_RO".equals(locale)) {
            format = "[$-418]";
        } else if ("ru_RU".equals(locale)) {
            format = "[$-419]";
        } else if ("ru_UA".equals(locale)) {
            format = "[$-1000]";
        } else if ("rw_RW".equals(locale)) {
            format = "[$-487]";
        } else if ("se_NO".equals(locale)) {
            format = "[$-43B]";
        } else if ("si_LK".equals(locale)) {
            format = "[$-45B]";
        } else if ("sk_SK".equals(locale)) {
            format = "[$-41B]";
        } else if ("sl_SI".equals(locale)) {
            format = "[$-424]";
        } else if ("so_DJ".equals(locale)) {
            format = "[$-1000]";
        } else if ("so_ET".equals(locale)) {
            format = "[$-1000]";
        } else if ("so_KE".equals(locale)) {
            format = "[$-1000]";
        } else if ("so_SO".equals(locale)) {
            format = "[$-477]";
        } else if ("sq_AL".equals(locale)) {
            format = "[$-41C]";
        } else if ("sr_CS".equals(locale)) {
            format = "[$-C1A]";
        } else if ("sr_ME".equals(locale)) {
            format = "[$-301A]";
        } else if ("sr_RS".equals(locale)) {
            format = "[$-281A]";
        } else if ("ss_ZA".equals(locale)) {
            format = "[$-1000]";
        } else if ("st_ZA".equals(locale)) {
            format = "[$-430]";
        } else if ("sv_FI".equals(locale)) {
            format = "[$-81D]";
        } else if ("sv_SE".equals(locale)) {
            format = "[$-41D]";
        } else if ("ta_IN".equals(locale)) {
            format = "[$-449]";
        } else if ("te_IN".equals(locale)) {
            format = "[$-44A]";
        } else if ("tg_TJ".equals(locale)) {
            format = "[$-428]";
        } else if ("th_TH".equals(locale)) {
            format = "[$-41E]";
        } else if ("ti_ER".equals(locale)) {
            format = "[$-873]";
        } else if ("ti_ET".equals(locale)) {
            format = "[$-473]";
        } else if ("tl_PH".equals(locale)) {
            format = "[$-464]";
        } else if ("tn_ZA".equals(locale)) {
            format = "[$-432]";
        } else if ("tr_CY".equals(locale)) {
            format = "[$-1000]";
        } else if ("tr_TR".equals(locale)) {
            format = "[$-41F]";
        } else if ("ts_ZA".equals(locale)) {
            format = "[$-431]";
        } else if ("tt_RU".equals(locale)) {
            format = "[$-444]";
        } else if ("uk_UA".equals(locale)) {
            format = "[$-422]";
        } else if ("ur_PK".equals(locale)) {
            format = "[$-420]";
        } else if ("uz_UZ".equals(locale)) {
            format = "[$-843]";
        } else if ("ve_ZA".equals(locale)) {
            format = "[$-433]";
        } else if ("vi_VN".equals(locale)) {
            format = "[$-42A]";
        } else if ("wa_BE".equals(locale)) {
            format = "[$-C]";
        } else if ("xh_ZA".equals(locale)) {
            format = "[$-434]";
        } else if ("yi_US".equals(locale)) {
            format = "[$-409]";
        } else if ("zu_ZA".equals(locale)) {
            format = "[$-435]";
        }
        format = format + mask;
        return format;
    }
}

