/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.export.impl;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.data.VariableList;
import com.nexacro.java.xapi.tx.HttpPlatformResponse;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xeni.data.GridExportFormatFactory;
import com.nexacro.java.xeni.data.exportformats.ExportFormat;
import com.nexacro.java.xeni.data.exportformats.FormatCell;
import com.nexacro.java.xeni.export.GridExportBase;
import com.nexacro.java.xeni.export.GridExportContext;
import com.nexacro.java.xeni.extend.XeniDataValidationBase;
import com.nexacro.java.xeni.extend.XeniExcelDataStorageBase;
import com.nexacro.java.xeni.extend.XeniExcelDataStorageDef;
import com.nexacro.java.xeni.extend.XeniExtendLoader;
import com.nexacro.java.xeni.provider.ServletProvider;
import com.nexacro.java.xeni.util.CommUtil;
import com.nexacro.java.xeni.util.XeniErrorProperties;
import com.nexacro.java.xeni.util.XeniUtils;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Base64;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.util.IOUtils;

public class GridPartExportCsv
implements GridExportBase {
    private static final Log logger = LogFactory.getLog(GridPartExportCsv.class);
    private long accessTime = 0L;
    private boolean isEof = false;
    private boolean isAppended = false;
    private char separator = (char)44;
    private String errorMessage = "";
    private String quoteString = "";
    private String groupSeparator = String.valueOf('\u001d');
    private String absolutePath;
    private String downloadUrl;
    private GridExportContext context = null;
    private ExportFormat gridFormat = null;
    private BufferedWriter outputWriter = null;
    private XeniDataValidationBase validator = null;

    @Override
    public int initialize(GridExportContext ctx, DataSet command) {
        int errorCode;
        String userQuote;
        this.validator = XeniExtendLoader.getDataValidationFactory().getDataValidator();
        this.context = ctx;
        String userSeparator = command.getString(0, "separator");
        if (this.context.getExportType() == 1296 && userSeparator != null && userSeparator.length() > 0) {
            this.separator = (char)Integer.parseInt(userSeparator.substring(2), 16);
        }
        if ((userQuote = command.getString(0, "quotechar")) != null) {
            if ("default".equalsIgnoreCase(userQuote)) {
                if (this.context.isCsvQuote()) {
                    this.quoteString = "\"";
                }
            } else if (!"none".equalsIgnoreCase(userQuote)) {
                this.quoteString = "" + userQuote.charAt(0);
            }
        }
        if ((errorCode = this.getExportFilePath()) < 0) {
            return errorCode;
        }
        if ("PlatformXml".equals(this.context.getRequestPlatformType())) {
            this.groupSeparator = "_x001D_";
        }
        String exportFormat = command.getString(0, "format");
        if (this.context.getCommandVersion() == 2.0f) {
            exportFormat = new String(Base64.getDecoder().decode(exportFormat), StandardCharsets.UTF_8);
        } else if (this.context.getCommandVersion() == 3.0f) {
            exportFormat = new String(new Base32().decode(exportFormat), StandardCharsets.UTF_8);
        }
        this.gridFormat = new GridExportFormatFactory().readFormatString(exportFormat);
        if (this.gridFormat == null) {
            this.setErrorMessage("Fail to create grid format.");
            return -2012;
        }
        this.outputWriter = this.getOutputWriter();
        if (this.outputWriter == null) {
            this.setErrorMessage("Fail to create output file. (" + this.context.getInstanceId() + "/" + this.context.getFileName() + ")");
            return -2012;
        }
        return 0;
    }

    @Override
    public int startExport(ServletProvider svltProvider, DataSet command, DataSet style, DataSet data) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Start export : " + StringUtils.normalizeSpace((String)this.context.getFileName())));
        }
        int errorCode = 0;
        this.context.setSequence(command.getInt(0, "seq"));
        this.setEof(command.getBoolean(0, "eof"));
        if (this.context.getSequence() == 1) {
            if (!this.context.isNoHead() && this.gridFormat.getRowCountOfEachBand("head") > 0 && (errorCode = this.setHead()) < 0) {
                return errorCode;
            }
            if (!this.context.isNoSummary() && this.context.isTopSummary() && this.gridFormat.getRowCountOfEachBand("summ") > 0 && (errorCode = this.setSummary()) < 0) {
                return errorCode;
            }
        }
        if (this.gridFormat.getRowCountOfEachBand("body") > 0 && (errorCode = this.setBody(data)) < 0) {
            return errorCode;
        }
        if (this.isEof()) {
            if (!this.context.isNoSummary() && !this.context.isTopSummary() && (errorCode = this.setSummary()) < 0) {
                return errorCode;
            }
            errorCode = this.saveExportFile(svltProvider, command);
        } else {
            errorCode = this.sendExportPartResponse(svltProvider, command);
        }
        return errorCode;
    }

    private int getExportFilePath() {
        if (this.context.getAppendUrl() == null) {
            String exportName = this.context.getFileName();
            String instanceId = this.context.getInstanceId();
            if (!(exportName != null && exportName.length() > 0 || (exportName = this.context.getItemName()) != null && exportName.length() > 0)) {
                exportName = "TEMP";
            }
            if (exportName.contains(".") || exportName.contains("/") || instanceId.contains(".") || instanceId.contains("/")) {
                this.setErrorMessage("Invalid file or path name.");
                return -3201;
            }
            int extType = 4;
            String fileName = exportName + ".csv";
            if (this.context.getExportType() == 1296) {
                extType = 5;
                fileName = exportName + ".txt";
            }
            this.absolutePath = this.context.getAbsolutePath() + instanceId + "/" + fileName;
            if (this.context.isOutsidePath()) {
                try {
                    this.downloadUrl = this.context.getDownloadUrl() + "?command=export&key=" + this.context.getInstanceId() + "&name=" + URLEncoder.encode(exportName, "UTF-8") + "&type=" + extType;
                }
                catch (UnsupportedEncodingException e) {
                    logger.info((Object)"getExportFilePath : UnsupportedEncodingException");
                }
            } else {
                this.downloadUrl = this.context.getDownloadUrl() + instanceId + "/" + fileName;
            }
        } else {
            String appendUrl = this.context.getAppendUrl();
            this.downloadUrl = appendUrl.replaceAll("&amp;", "&");
            if (this.context.isOutsidePath()) {
                int findIdx = appendUrl.indexOf("key=");
                String key = appendUrl.substring(findIdx + 4, appendUrl.indexOf(38, findIdx));
                if (key == null || key.contains(".") || key.contains("/")) {
                    this.setErrorMessage("Invalid key name.");
                    return -3201;
                }
                findIdx = appendUrl.indexOf("name=", findIdx);
                String fileName = appendUrl.substring(findIdx + 5, appendUrl.indexOf(38, findIdx));
                try {
                    fileName = URLDecoder.decode(fileName, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    logger.info((Object)"getExportFilePath : UnsupportedEncodingException");
                }
                if (fileName == null || fileName.contains(".") || fileName.contains("/")) {
                    this.setErrorMessage("Invalid key name.");
                    return -3201;
                }
                findIdx = appendUrl.indexOf("type=", findIdx);
                int extType = Integer.parseInt(appendUrl.substring(findIdx + 5));
                String fileType = ".csv";
                if (extType == 5) {
                    fileType = fileType + ".txt";
                }
                this.absolutePath = this.context.getAbsolutePath() + key + "/" + fileName + fileType;
            } else {
                int findIdx = appendUrl.lastIndexOf("/");
                String path = appendUrl.substring(0, findIdx);
                String fileName = appendUrl.substring(findIdx);
                String name = fileName.substring(1, fileName.lastIndexOf(46));
                if (name == null || name.contains(".") || name.contains("/")) {
                    this.setErrorMessage("Invalid file name.");
                    return -3201;
                }
                this.absolutePath = this.context.getAbsolutePath() + path.substring(path.lastIndexOf("/")) + fileName;
            }
        }
        return 0;
    }

    @Override
    public void setErrorMessage(String message) {
        this.errorMessage = message;
        if (logger.isErrorEnabled()) {
            logger.error((Object)StringUtils.normalizeSpace((String)message));
        }
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public long getAccessTime() {
        return this.accessTime;
    }

    @Override
    public void setAccessTime(long accessTime) {
        this.accessTime = accessTime;
    }

    @Override
    public boolean isEof() {
        return this.isEof;
    }

    @Override
    public void setEof(boolean isEof) {
        this.isEof = isEof;
    }

    @Override
    public GridExportContext getExportContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedWriter getOutputWriter() {
        BufferedWriter outputWriter = null;
        InputStream inputStream = null;
        FileOutputStream outputTemp = null;
        try {
            if (this.context.getAppendUrl() == null) {
                int index = this.absolutePath.lastIndexOf("/");
                String path = this.absolutePath.substring(0, index);
                File file = XeniUtils.getXeniFileHandler(path).toFile();
                if (!file.exists()) {
                    file.mkdirs();
                }
                outputWriter = this.getBufferedWriter(false);
            } else {
                XeniExcelDataStorageBase extendClass = XeniExtendLoader.getExcelDataStorageFactory().getExtendClass("xeni.exportimport.storage");
                if (extendClass instanceof XeniExcelDataStorageDef) {
                    outputWriter = this.getBufferedWriter(true);
                } else {
                    int read;
                    inputStream = extendClass.loadTargetStream(this.absolutePath);
                    if (inputStream == null) {
                        BufferedWriter path = null;
                        return path;
                    }
                    byte[] bytes = new byte[8192];
                    outputTemp = new FileOutputStream(XeniUtils.getXeniFileHandler(this.absolutePath + ".xeni").toFile());
                    while ((read = inputStream.read(bytes)) != -1) {
                        outputTemp.write(bytes, 0, read);
                    }
                    Files.move(XeniUtils.getXeniFileHandler(this.absolutePath + ".xeni").toPath(), XeniUtils.getXeniFileHandler(this.absolutePath).toPath(), StandardCopyOption.REPLACE_EXISTING);
                    outputWriter = this.getBufferedWriter(true);
                }
            }
        }
        catch (Exception e) {
            this.setErrorMessage(e.getMessage());
            BufferedWriter bufferedWriter = null;
            return bufferedWriter;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputTemp != null) {
                    outputTemp.close();
                }
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
        return outputWriter;
    }

    private BufferedWriter getBufferedWriter(boolean append) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(XeniUtils.getXeniFileHandler(this.absolutePath).toFile(), append);
        OutputStreamWriter OutputStreamWriter2 = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        BufferedWriter bufferedWriter = new BufferedWriter(OutputStreamWriter2);
        if (!append && this.context.isCsvBom()) {
            bufferedWriter.append("\ufeff");
        }
        return bufferedWriter;
    }

    private void setCsvValue(String value) throws IOException {
        if (this.validator != null) {
            value = this.validator.checkData(value);
        }
        this.outputWriter.append(this.quoteString + value + this.quoteString);
    }

    private int setHead() {
        int curRow = 0;
        int preCol = 0;
        int count = this.gridFormat.getHeadCellCount();
        try {
            if (count > 0) {
                if (this.context.getAppendUrl() != null) {
                    this.outputWriter.append("\r\n");
                }
                this.isAppended = true;
            }
            for (int cellIdx = 0; cellIdx < count; ++cellIdx) {
                FormatCell headCell = this.gridFormat.getHeadCell(cellIdx);
                int rowRdx = Integer.parseInt(headCell.getRow());
                int colIdx = Integer.parseInt(headCell.getCol());
                if (rowRdx > curRow) {
                    this.outputWriter.append("\r\n");
                    preCol = 0;
                }
                if (cellIdx > 0) {
                    for (int subCol = 0; subCol < colIdx - preCol; ++subCol) {
                        this.outputWriter.append(this.separator);
                    }
                }
                this.setCsvValue(headCell.getText());
                curRow = rowRdx;
                preCol = colIdx;
            }
        }
        catch (IOException e) {
            this.setErrorMessage(e.getMessage());
            return -2003;
        }
        return 0;
    }

    private int setSummary() {
        int curRow = 0;
        int preCol = 0;
        int count = this.gridFormat.getSummaryCellCount();
        try {
            if (count > 0) {
                if (this.isAppended) {
                    this.outputWriter.append("\r\n");
                } else if (this.context.getAppendUrl() != null) {
                    this.outputWriter.append("\r\n");
                }
                this.isAppended = true;
            }
            for (int cellIdx = 0; cellIdx < count; ++cellIdx) {
                FormatCell summCell = this.gridFormat.getSummary(cellIdx);
                int rowIdx = Integer.parseInt(summCell.getRow());
                int colIdx = Integer.parseInt(summCell.getCol());
                if (rowIdx > curRow) {
                    this.outputWriter.append("\r\n");
                    preCol = 0;
                }
                if (cellIdx > 0) {
                    for (int subcol = 0; subcol < colIdx - preCol; ++subcol) {
                        this.outputWriter.append(this.separator);
                    }
                }
                this.setCsvValue(summCell.getText());
                curRow = rowIdx;
                preCol = colIdx;
            }
        }
        catch (IOException e) {
            this.setErrorMessage(e.getMessage());
            return -2003;
        }
        return 0;
    }

    private int setBody(DataSet data) {
        int count;
        int colCount = data.getColumnCount();
        if (colCount != (count = this.gridFormat.getBodyCellCount())) {
            this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.export.fault.bodyformat", Integer.toString(colCount), Integer.toString(count)));
            return -2014;
        }
        try {
            int rowIdx = 0;
            while (data.getRowCount() > 0) {
                if (this.isAppended) {
                    this.outputWriter.append("\r\n");
                } else {
                    if (this.context.getAppendUrl() != null) {
                        this.outputWriter.append("\r\n");
                    }
                    this.isAppended = true;
                }
                int curRow = -1;
                for (int colIdx = 0; colIdx < count; ++colIdx) {
                    String[] values;
                    String value;
                    FormatCell bodycell = this.gridFormat.getBodyCell(colIdx);
                    int bodyRowIdx = Integer.parseInt(bodycell.getRow());
                    int colspan = Integer.parseInt(bodycell.getColspan());
                    if (colIdx > 0) {
                        if (bodyRowIdx > curRow) {
                            this.outputWriter.append("\r\n");
                        } else {
                            this.outputWriter.append(this.separator);
                        }
                    }
                    if ((value = data.getString(rowIdx, colIdx)) != null && value.length() > 0 && (values = value.split(this.groupSeparator)).length > 0) {
                        String decValue = values[0];
                        if (this.context.getCommandVersion() == 2.0f) {
                            decValue = new String(Base64.getDecoder().decode(decValue), StandardCharsets.UTF_8);
                        } else if (this.context.getCommandVersion() == 3.0f) {
                            decValue = new String(new Base32().decode(decValue), StandardCharsets.UTF_8);
                        }
                        this.setCsvValue(decValue);
                    }
                    for (int spanIdx = 1; spanIdx < colspan; ++spanIdx) {
                        this.outputWriter.append(this.separator);
                    }
                    curRow = bodyRowIdx;
                }
                data.removeRow(rowIdx);
            }
            this.outputWriter.flush();
        }
        catch (IOException e) {
            this.setErrorMessage(e.getMessage());
            return -2003;
        }
        return 0;
    }

    private int sendExportPartResponse(ServletProvider svltProvider, DataSet command) {
        PlatformData platformData = new PlatformData();
        VariableList varList = platformData.getVariableList();
        varList.add("ErrorCode", 0);
        varList.add("ErrorMsg", "SUCCESS");
        DataSet dsResponse = CommUtil.getDatasetExportResponse(command);
        if (this.isEof()) {
            dsResponse.set(0, "url", this.downloadUrl);
        }
        platformData.addDataSet(dsResponse);
        try {
            HttpPlatformResponse platformResponse = new HttpPlatformResponse(svltProvider.getHttpServletResponse(), this.context.getResponsePlatformType(), "UTF-8");
            platformResponse.setData(platformData);
            platformResponse.sendData();
        }
        catch (PlatformException e) {
            this.setErrorMessage(e.getMessage());
            return -2001;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int saveExportFile(ServletProvider svltProvider, DataSet command) {
        int errorCode = 0;
        FileInputStream inputStream = null;
        try {
            XeniExcelDataStorageBase extendClass = XeniExtendLoader.getExcelDataStorageFactory().getExtendClass("xeni.exportimport.storage");
            if (extendClass == null) {
                this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.export.fail.create.extendclass", "xeni.exportimport.storage"));
                int n = -2004;
                return n;
            }
            this.outputWriter.flush();
            if (extendClass instanceof XeniExcelDataStorageDef) {
                this.sendExportPartResponse(svltProvider, command);
            } else {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                inputStream = new FileInputStream(XeniUtils.getXeniFileHandler(this.absolutePath).toFile());
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                errorCode = extendClass.saveExportStream(this.context.getUserVariableList(), command, outputStream, this.absolutePath, this.downloadUrl, svltProvider.getHttpServletResponse());
            }
        }
        catch (FileNotFoundException e) {
            this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.export.no.such.file"));
            errorCode = -2020;
        }
        catch (Exception e) {
            this.setErrorMessage(e.getMessage());
            errorCode = -2001;
        }
        finally {
            try {
                if (this.outputWriter != null) {
                    this.outputWriter.close();
                }
            }
            catch (IOException e) {
                this.setErrorMessage(e.getMessage());
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
        return errorCode;
    }
}

