/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.export.impl;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.data.VariableList;
import com.nexacro.java.xapi.tx.HttpPlatformResponse;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xeni.data.GridExportFormatFactory;
import com.nexacro.java.xeni.data.exportformats.ExportFormat;
import com.nexacro.java.xeni.data.exportformats.FormatCell;
import com.nexacro.java.xeni.data.exportformats.FormatColumn;
import com.nexacro.java.xeni.data.exportformats.FormatRow;
import com.nexacro.java.xeni.export.GridExportBase;
import com.nexacro.java.xeni.export.GridExportContext;
import com.nexacro.java.xeni.export.impl.GridCellStyleInfo;
import com.nexacro.java.xeni.export.impl.GridCellStyleInfoExt;
import com.nexacro.java.xeni.extend.XeniDataValidationBase;
import com.nexacro.java.xeni.extend.XeniExcelDataStorageBase;
import com.nexacro.java.xeni.extend.XeniExcelDataStorageDef;
import com.nexacro.java.xeni.extend.XeniExtendLoader;
import com.nexacro.java.xeni.provider.ServletProvider;
import com.nexacro.java.xeni.util.CommUtil;
import com.nexacro.java.xeni.util.XeniErrorProperties;
import com.nexacro.java.xeni.util.XeniUtils;
import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.hssf.usermodel.HSSFPictureData;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.ImageUtils;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFPictureData;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class GridPartExportExcel
implements GridExportBase {
    private static final Log logger = LogFactory.getLog(GridPartExportExcel.class);
    private final float PX_MODIFIED = 36.56f;
    private final float PX_DEFAULT = 32.0f;
    private final int PX_POW = 15;
    private final int PX_PADDING = 2;
    private final int PIXEL_DPI = 96;
    private final int POINT_DPI = 72;
    private int nextExcelRow = 0;
    private long accessTime = 0L;
    private boolean isEof = false;
    private boolean isOdd = false;
    private String errorMessage = "";
    private String groupSeparator = String.valueOf('\u001d');
    private String absolutePath;
    private String downloadUrl;
    private Sheet sheet = null;
    private Workbook workBook = null;
    private ExportFormat gridFormat = null;
    private GridCellStyleInfo styleInfo = new GridCellStyleInfo();
    private GridExportContext context = null;
    private Drawing drawing = null;
    private HashMap<String, Integer> pictures = new HashMap();
    private XeniDataValidationBase validator;

    @Override
    public long getAccessTime() {
        return this.accessTime;
    }

    @Override
    public void setAccessTime(long accessTime) {
        this.accessTime = accessTime;
    }

    @Override
    public boolean isEof() {
        return this.isEof;
    }

    @Override
    public void setEof(boolean isEof) {
        this.isEof = isEof;
    }

    @Override
    public GridExportContext getExportContext() {
        return this.context;
    }

    @Override
    public int initialize(GridExportContext ctx, DataSet command) {
        this.validator = XeniExtendLoader.getDataValidationFactory().getDataValidator();
        this.context = ctx;
        this.setRangeInfo(command.getString(0, "range"));
        int code = this.getExportFilePath();
        if (code < 0) {
            return code;
        }
        if ("PlatformXml".equals(this.context.getRequestPlatformType()) || this.context.getCommandVersion() >= 2.0f && "PlatformJson".equals(this.context.getRequestPlatformType())) {
            this.groupSeparator = "_x001D_";
        }
        String exportFormat = command.getString(0, "format");
        if (this.context.getCommandVersion() == 2.0f) {
            exportFormat = new String(Base64.getDecoder().decode(exportFormat), StandardCharsets.UTF_8);
        } else if (this.context.getCommandVersion() == 3.0f) {
            exportFormat = new String(new Base32().decode(exportFormat), StandardCharsets.UTF_8);
        }
        this.gridFormat = new GridExportFormatFactory().readFormatString(exportFormat);
        if (this.gridFormat == null) {
            this.setErrorMessage("Fail to create grid format.");
            return -2012;
        }
        this.nextExcelRow = this.context.getStartRowIndex();
        this.workBook = this.createWorkBook();
        if (this.workBook == null) {
            this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.export.fail.create.workbook"));
            return -2012;
        }
        if (this.context.getAppendUrl() != null) {
            this.sheet = this.workBook.getSheet(this.context.getSheetName());
        }
        if (this.sheet == null) {
            this.sheet = this.workBook.createSheet(this.context.getSheetName());
        }
        if (this.sheet == null) {
            this.setErrorMessage("Fail to create sheet.");
            return -2012;
        }
        this.drawing = this.sheet.createDrawingPatriarch();
        if (this.context.isApplyWidth()) {
            this.setColumnLayout(this.context.getStartColIndex(), this.context.isOoxml());
        }
        return 0;
    }

    @Override
    public int startExport(ServletProvider svltProvider, DataSet command, DataSet style, DataSet data) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Start export : " + StringUtils.normalizeSpace((String)this.context.getFileName())));
        }
        int errorCode = 0;
        this.context.setSequence(command.getInt(0, "seq"));
        this.setEof(command.getBoolean(0, "eof"));
        if (style.getRowCount() > 0 && (errorCode = this.styleInfo.getStyleInfo(this.workBook, style, this.context.isOoxml(), this.context.isWrapText(), this.context.getAppendUrl() != null)) < 0) {
            this.setErrorMessage(this.styleInfo.getErrorMessage());
            return errorCode;
        }
        if (this.context.getSequence() == 1) {
            if (!this.context.isNoHead() && (errorCode = this.setHead()) < 0) {
                return errorCode;
            }
            if (!this.context.isNoSummary() && this.context.isTopSummary() && (errorCode = this.setSummary()) < 0) {
                return errorCode;
            }
        }
        if ((errorCode = this.setBody(data)) < 0) {
            return errorCode;
        }
        if (this.isEof()) {
            if (!this.context.isNoSummary() && !this.context.isTopSummary() && (errorCode = this.setSummary()) < 0) {
                return errorCode;
            }
            if (this.context.isRtl()) {
                this.sheet.setRightToLeft(true);
            }
            if (this.context.getRowHeights() != null) {
                this.setRowHeights(this.sheet, this.context.getRowHeights());
            }
            errorCode = this.saveExportFile(svltProvider, command);
        } else {
            errorCode = this.sendExportPartResponse(svltProvider, command);
        }
        return errorCode;
    }

    private void setRangeInfo(String value) {
        if (value == null || value.length() <= 0) {
            return;
        }
        String[] rangeInfo = value.split("\\!");
        if (rangeInfo.length == 1) {
            this.context.setSheetName(value);
        } else {
            int[] range = new int[]{0, 0};
            CommUtil.getRangeIndex(rangeInfo[1], range);
            this.context.setStartColIndex(range[0]);
            this.context.setStartRowIndex(range[1]);
            if (rangeInfo[0].length() > 0) {
                this.context.setSheetName(rangeInfo[0]);
            }
        }
    }

    @Override
    public void setErrorMessage(String message) {
        this.errorMessage = message;
        if (logger.isErrorEnabled()) {
            logger.error((Object)StringUtils.normalizeSpace((String)message));
        }
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    private int getExportFilePath() {
        if (this.context.getAppendUrl() == null) {
            String exportName = this.context.getFileName();
            String instanceId = this.context.getInstanceId();
            if (!(exportName != null && exportName.length() > 0 || (exportName = this.context.getItemName()) != null && exportName.length() > 0)) {
                exportName = "TEMP";
            }
            if (exportName.contains(".") || exportName.contains("/") || instanceId.contains(".") || instanceId.contains("/")) {
                this.setErrorMessage("Invalid file or path name.");
                return -3201;
            }
            String fileName = exportName;
            int fileType = this.context.getExportType();
            int extType = 0;
            if (fileType == 1024) {
                fileName = fileName + ".cell";
                extType = 2;
            } else if (fileType == 1040) {
                fileName = fileName + ".cell";
                extType = 3;
            } else {
                fileName = fileName + ".xls";
                if (this.context.isOoxml()) {
                    fileName = fileName + "x";
                    extType = 1;
                }
            }
            this.absolutePath = this.context.getAbsolutePath() + instanceId + "/" + fileName;
            if (this.context.isOutsidePath()) {
                try {
                    this.downloadUrl = this.context.getDownloadUrl() + "?command=export&key=" + instanceId + "&name=" + URLEncoder.encode(exportName, "UTF-8") + "&type=" + extType;
                }
                catch (UnsupportedEncodingException e) {
                    logger.info((Object)"getExportFilePath : UnsupportedEncodingException");
                }
            } else {
                this.downloadUrl = this.context.getDownloadUrl() + instanceId + "/" + fileName;
            }
        } else {
            String appendUrl = this.context.getAppendUrl();
            this.downloadUrl = appendUrl.replaceAll("&amp;", "&");
            if (this.context.isOutsidePath()) {
                int findIdx = appendUrl.indexOf("key=");
                String key = appendUrl.substring(findIdx + 4, appendUrl.indexOf(38, findIdx));
                if (key == null || key.contains(".") || key.contains("/")) {
                    this.setErrorMessage("Invalid key name.");
                    return -3201;
                }
                findIdx = appendUrl.indexOf("name=", findIdx);
                String fileName = appendUrl.substring(findIdx + 5, appendUrl.indexOf(38, findIdx));
                try {
                    fileName = URLDecoder.decode(fileName, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    logger.info((Object)"getExportFilePath : UnsupportedEncodingException");
                }
                findIdx = appendUrl.indexOf("type=", findIdx);
                int extType = Integer.parseInt(appendUrl.substring(findIdx + 5));
                String fileType = ".xls";
                if (extType == 1) {
                    fileType = fileType + "x";
                } else if (extType == 2 || extType == 3) {
                    fileType = ".cell";
                }
                this.absolutePath = this.context.getAbsolutePath() + key + "/" + fileName + fileType;
            } else {
                int findIdx = appendUrl.lastIndexOf("/");
                String path = appendUrl.substring(0, findIdx);
                String fileName = appendUrl.substring(findIdx);
                String name = fileName.substring(1, fileName.lastIndexOf(46));
                if (name == null || name.contains(".") || name.contains("/")) {
                    this.setErrorMessage("Invalid file name.");
                    return -3201;
                }
                this.absolutePath = this.context.getAbsolutePath() + path.substring(path.lastIndexOf("/") + 1) + fileName;
            }
        }
        return 0;
    }

    private void saveExportStream(InputStream in, String path) throws IOException {
        int read;
        if (in == null) {
            return;
        }
        int nIdx = path.lastIndexOf("/");
        File file = XeniUtils.getXeniFileHandler(path.substring(0, nIdx)).toFile();
        if (!file.exists()) {
            file.mkdirs();
        }
        file = XeniUtils.getXeniFileHandler(path).toFile();
        byte[] bytes = new byte[8192];
        FileOutputStream outStream = new FileOutputStream(file);
        while ((read = in.read(bytes)) != -1) {
            outStream.write(bytes, 0, read);
        }
        outStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Workbook createWorkBook() {
        Object workBook = null;
        if (this.context.getAppendUrl() == null) {
            workBook = this.context.isOoxml() ? new SXSSFWorkbook(this.context.getRowAccessSize()) : new HSSFWorkbook();
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Read file(workbook) : " + StringUtils.normalizeSpace((String)this.absolutePath)));
            }
            InputStream inputStream = null;
            try {
                String filePath = this.absolutePath;
                XeniExcelDataStorageBase extendClass = XeniExtendLoader.getExcelDataStorageFactory().getExtendClass("xeni.exportimport.storage");
                if (!(extendClass instanceof XeniExcelDataStorageDef)) {
                    inputStream = extendClass.loadTargetStream(filePath);
                    if (inputStream != null) {
                        filePath = filePath + ".xeni";
                        this.saveExportStream(inputStream, filePath);
                    }
                } else {
                    Files.move(Paths.get(filePath, new String[0]), Paths.get(filePath + ".xeni", new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    filePath = filePath + ".xeni";
                }
                File inFile = XeniUtils.getXeniFileHandler(filePath).toFile();
                if (this.context.isOoxml()) {
                    Workbook wbTemp = WorkbookFactory.create((File)inFile, (String)this.context.getPassword());
                    workBook = new SXSSFWorkbook((XSSFWorkbook)wbTemp, this.context.getRowAccessSize());
                } else {
                    workBook = WorkbookFactory.create((File)inFile, (String)this.context.getPassword());
                }
            }
            catch (Exception e) {
                this.setErrorMessage(e.getMessage());
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    this.setErrorMessage(e.getMessage());
                }
            }
        }
        return workBook;
    }

    private void setColumnLayout(int start, boolean ooxml) {
        int size = 0;
        int width = 0;
        for (int colIndex = 0; colIndex < this.gridFormat.getColumnCount(); ++colIndex) {
            FormatColumn formatColumn = this.gridFormat.getColumn(colIndex);
            if (formatColumn == null) continue;
            size = Integer.parseInt(formatColumn.getSize());
            if (size > 1500) {
                size = 1500;
            }
            width = ooxml ? size * 32 : size * 36;
            this.sheet.setColumnWidth(start + colIndex, width);
        }
    }

    private int createGridFormatBand(String band) {
        int formatColCnt = this.gridFormat.getColumnCount();
        int addedRowCnt = 0;
        int height = 0;
        for (int rowIdx = 0; rowIdx < this.gridFormat.getRowCount(); ++rowIdx) {
            FormatRow formatRow = this.gridFormat.getRow(rowIdx);
            if (!formatRow.getBand().equals(band)) continue;
            Row excelRow = this.sheet.createRow(this.nextExcelRow + addedRowCnt);
            if (this.context.isApplyHeight()) {
                height = Integer.parseInt(formatRow.getSize());
                excelRow.setHeight((short)(height * 15));
            }
            for (int colIdx = 0; colIdx < formatColCnt; ++colIdx) {
                excelRow.createCell(colIdx + this.context.getStartColIndex());
            }
            ++addedRowCnt;
        }
        return addedRowCnt;
    }

    private Cell getExcelCell(FormatCell formatcell) {
        int formatRowIdx = Integer.parseInt(formatcell.getRow());
        int formatColIdx = Integer.parseInt(formatcell.getCol());
        int excelRowIdx = formatRowIdx + this.nextExcelRow;
        int excelColIdx = formatColIdx + this.context.getStartColIndex();
        Row excelRow = this.sheet.getRow(excelRowIdx);
        Cell excelCell = excelRow.getCell(excelColIdx);
        if (excelCell == null) {
            this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.export.cell.null", Integer.toString(excelRowIdx), Integer.toString(excelColIdx)));
            return null;
        }
        return excelCell;
    }

    private int setCellValue(Cell exlcell, String value, GridCellStyleInfoExt extstyle, FormatCell formatcell, boolean applyspan) {
        if (value == null || value.length() <= 0) {
            return 0;
        }
        if (this.validator != null) {
            value = this.validator.checkData(value);
        }
        if (extstyle.isImageData()) {
            this.setCellImage(exlcell, value, applyspan, formatcell, extstyle.getImageStretch());
        } else {
            int nType = extstyle.getDataType();
            if (nType == 1) {
                value = value.replaceAll("\\,|\\%", "");
                try {
                    if (!"".equals(value)) {
                        double dbValue = Double.parseDouble(value);
                        if (value.matches("^[-+]?\\d+\\.\\d+") && extstyle.getDataFormat() == null) {
                            this.setStyleDoubleFormat(value, exlcell, extstyle);
                        }
                        if (extstyle.isbPercentage()) {
                            dbValue /= 100.0;
                        }
                        exlcell.setCellValue(dbValue);
                    }
                }
                catch (NumberFormatException e) {
                    this.setStyleNumberTextFormat(exlcell, extstyle);
                    exlcell.setCellValue(value);
                }
            } else if (nType == 2) {
                try {
                    DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern(extstyle.getDataFormat()).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter();
                    LocalDateTime date = LocalDateTime.parse(value, formatter);
                    exlcell.setCellValue(date);
                }
                catch (Exception e) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)e.getMessage());
                    }
                    exlcell.setCellValue(value);
                }
            } else if (nType == 0) {
                if (value.charAt(0) == '=') {
                    exlcell.setCellFormula(value.substring(1));
                } else {
                    exlcell.setCellValue(value);
                }
            } else {
                exlcell.setCellValue(value);
            }
        }
        return 0;
    }

    private void setMergeCell(FormatCell fomatcell, Cell excelcell, CellStyle cellstyle) {
        int rowSpan = Integer.parseInt(fomatcell.getRowspan());
        int colSpan = Integer.parseInt(fomatcell.getColspan());
        if (rowSpan > 1 || colSpan > 1) {
            int excelRowIdx = excelcell.getRowIndex();
            int excelColIdx = excelcell.getColumnIndex();
            this.sheet.addMergedRegionUnsafe(new CellRangeAddress(excelRowIdx, excelRowIdx + rowSpan - 1, excelColIdx, excelColIdx + colSpan - 1));
            if (cellstyle == null) {
                return;
            }
            Row row = null;
            Cell cell = null;
            for (int rowIdx = excelRowIdx; rowIdx < excelRowIdx + rowSpan; ++rowIdx) {
                row = this.sheet.getRow(rowIdx);
                if (row == null) continue;
                for (int colIdx = excelColIdx; colIdx < excelColIdx + colSpan; ++colIdx) {
                    if (rowIdx == excelRowIdx && colIdx == excelColIdx || (cell = row.getCell(colIdx)) == null) continue;
                    cell.setCellStyle(cellstyle);
                }
            }
        }
    }

    private void setSuppressCell(FormatCell formatcell, Cell excelcell, GridCellStyleInfoExt extstyle) {
        int rowSuppressCnt = extstyle.getiRowSuppressCount();
        int colSuppressCnt = extstyle.getiColSuppressCount();
        if (rowSuppressCnt > 1 || colSuppressCnt > 1) {
            int rowIdx = excelcell.getRowIndex();
            int colIdx = excelcell.getColumnIndex();
            int rowSpan = Integer.parseInt(formatcell.getRowspan()) - 1;
            int colSpan = Integer.parseInt(formatcell.getColspan()) - 1;
            int startRow = rowIdx;
            int startCol = colIdx;
            if (rowSuppressCnt > 1) {
                startRow = rowIdx - (rowSuppressCnt - rowSpan - 1);
            }
            if (colSuppressCnt > 1) {
                startCol = colIdx - (colSuppressCnt - colSpan - 1);
            }
            CellRangeAddress region = new CellRangeAddress(startRow, rowIdx + rowSpan, startCol, colIdx + colSpan);
            this.removeMergedRegion(region);
            this.setMergedCellStyle(excelcell.getCellStyle(), region);
            this.sheet.addMergedRegion(region);
        }
    }

    private void removeMergedRegion(CellRangeAddress region) {
        int firstRow = region.getFirstRow();
        int lastRow = region.getLastRow();
        int firstCol = region.getFirstColumn();
        int lastCol = region.getLastColumn();
        for (int i = this.sheet.getNumMergedRegions() - 1; i >= 0; --i) {
            CellRangeAddress mergedRegion = this.sheet.getMergedRegion(i);
            int mergedFstRow = mergedRegion.getFirstRow();
            int mergedLstRow = mergedRegion.getLastRow();
            int mergedFstCol = mergedRegion.getFirstColumn();
            int mergedLstCol = mergedRegion.getLastColumn();
            if ((firstRow > mergedFstRow || mergedFstRow > lastRow) && (firstRow > mergedLstRow || mergedLstRow > lastRow) || (firstCol > mergedFstCol || mergedFstCol > lastCol) && (firstCol > mergedLstCol || mergedLstCol > lastCol)) continue;
            this.sheet.removeMergedRegion(i);
        }
    }

    private void setMergedCellStyle(CellStyle style, CellRangeAddress region) {
        if (style == null) {
            return;
        }
        int firstRow = region.getFirstRow();
        int lastRow = region.getLastRow();
        int firstCol = region.getFirstColumn();
        int lastCol = region.getLastColumn();
        Row row = null;
        Cell cell = null;
        for (int rowIdx = firstRow; rowIdx <= lastRow; ++rowIdx) {
            row = this.sheet.getRow(rowIdx);
            if (row == null) continue;
            for (int colIdx = firstCol; colIdx <= lastCol; ++colIdx) {
                cell = row.getCell(colIdx);
                if (cell == null) continue;
                cell.setCellStyle(style);
            }
        }
    }

    private void setStyleDoubleFormat(String value, Cell cell, GridCellStyleInfoExt extstyle) {
        String format = "#,##0";
        String floating = value.substring(value.indexOf(46) + 1);
        for (int i = 0; i < floating.length(); ++i) {
            if (i == 0) {
                format = format + ".";
            }
            format = format + "0";
        }
        format = format + "_ ";
        short styleIndex = this.workBook.createDataFormat().getFormat(format);
        String sStyleName = extstyle.getStyleName() + "_dbl" + styleIndex;
        GridCellStyleInfoExt extStyleD = this.styleInfo.getCellStyle(sStyleName);
        CellStyle newStyle = null;
        if (extStyleD == null) {
            newStyle = this.workBook.createCellStyle();
            CellStyle style = this.workBook.getCellStyleAt((int)extstyle.getStyleIndex());
            newStyle.cloneStyleFrom(style);
            newStyle.setDataFormat(styleIndex);
            this.styleInfo.appendStyle(sStyleName, newStyle.getIndex(), extstyle.getDataType(), extstyle.getDataFormat(), extstyle.isImageData());
        } else {
            newStyle = this.workBook.getCellStyleAt((int)extStyleD.getStyleIndex());
        }
        cell.setCellStyle(newStyle);
    }

    private void setStyleNumberTextFormat(Cell cell, GridCellStyleInfoExt extstyle) {
        CellStyle newStyle = null;
        String styleName = extstyle.getStyleName();
        GridCellStyleInfoExt extStyleTxt = this.styleInfo.getCellStyle(styleName + "text");
        if (extStyleTxt == null) {
            newStyle = this.workBook.createCellStyle();
            CellStyle style = this.workBook.getCellStyleAt((int)extstyle.getStyleIndex());
            newStyle.cloneStyleFrom(style);
            newStyle.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"TEXT"));
            this.styleInfo.appendStyle(styleName + "text", newStyle.getIndex(), extstyle.getDataType(), extstyle.getDataFormat(), extstyle.isImageData());
        } else {
            newStyle = this.workBook.getCellStyleAt((int)extStyleTxt.getStyleIndex());
        }
        cell.setCellStyle(newStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setCellImage(Cell cell, String imagevalue, boolean cellspan, FormatCell formatcell, int stretch) {
        FilterInputStream inputStream = null;
        try {
            int pictureIdx = -1;
            String message = "";
            byte[] databytes = null;
            if (imagevalue.trim().startsWith("http")) {
                if (this.pictures.containsKey(imagevalue)) {
                    pictureIdx = this.pictures.get(imagevalue);
                } else {
                    URL url = new URL(this.getEncodedUrl(imagevalue));
                    URLConnection urlConnection = url.openConnection();
                    urlConnection.setConnectTimeout(5000);
                    urlConnection.connect();
                    inputStream = new DataInputStream(new BufferedInputStream(urlConnection.getInputStream()));
                    databytes = IOUtils.toByteArray((InputStream)inputStream);
                    String imageExt = imagevalue.substring(imagevalue.lastIndexOf(".") + 1);
                    pictureIdx = this.workBook.addPicture(databytes, this.getPictureType(imageExt));
                    this.pictures.put(imagevalue, pictureIdx);
                    message = imagevalue;
                }
            } else if (imagevalue.trim().startsWith("data:")) {
                String metaStr;
                String[] options;
                String[] types;
                int metaIndex = imagevalue.indexOf(44);
                if (metaIndex < 0) {
                    boolean urlConnection = false;
                    return urlConnection;
                }
                String imageType = "png";
                if (metaIndex > 5 && (types = (options = (metaStr = imagevalue.substring(5, metaIndex)).split(";"))[0].split("/")).length > 1) {
                    imageType = types[1];
                }
                if ((databytes = Base64.getDecoder().decode(imagevalue.substring(metaIndex + 1))) == null) {
                    boolean bl = false;
                    return bl;
                }
                pictureIdx = this.workBook.addPicture(databytes, this.getPictureType(imageType));
                message = imageType;
            } else {
                boolean bl = false;
                return bl;
            }
            if (pictureIdx >= 0) {
                this.setPicture(this.workBook.getCreationHelper(), cell, pictureIdx, message, cellspan, formatcell, stretch);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage());
                }
            }
        }
        return true;
    }

    String getEncodedUrl(String url) {
        int pos = url.indexOf(63);
        if (pos <= 0) {
            return url;
        }
        String base = url.substring(0, pos + 1);
        String query = url.substring(pos + 1);
        try {
            if (!query.equals(URLDecoder.decode(query, "UTF-8"))) {
                return url;
            }
            query = URLEncoder.encode(query, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
        return base + query;
    }

    private int getPictureType(String type) {
        if ((type = type.toUpperCase()).equals("JPEG") || type.equals("JPG")) {
            return 5;
        }
        if (type.equals("DIB")) {
            return 7;
        }
        if (type.equals("EMF")) {
            return 2;
        }
        if (type.equals("PICT")) {
            return 4;
        }
        if (type.equals("PNG")) {
            return 6;
        }
        if (type.equals("WMF")) {
            return 3;
        }
        return 6;
    }

    private void setPicture(CreationHelper helper, Cell cell, int index, String url, boolean cellspan, FormatCell formatcell, int stretch) {
        block11: {
            try {
                ClientAnchor anchor = helper.createClientAnchor();
                anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
                anchor.setCol1(cell.getColumnIndex());
                anchor.setRow1(cell.getRowIndex());
                int rowSpan = 1;
                int colSpan = 1;
                if (cellspan) {
                    rowSpan = Integer.parseInt(formatcell.getRowspan());
                    colSpan = Integer.parseInt(formatcell.getColspan());
                }
                if (stretch == 2) {
                    anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_DONT_RESIZE);
                    Picture picture = this.drawing.createPicture(anchor, index);
                    picture.resize();
                    return;
                }
                anchor.setCol2(cell.getColumnIndex() + colSpan);
                anchor.setRow2(cell.getRowIndex() + rowSpan);
                if (stretch == 0) {
                    this.drawing.createPicture(anchor, index);
                    return;
                }
                Picture oPict = this.drawing.createPicture(anchor, index);
                float px = 0.0f;
                float cellHeight = 0.0f;
                float cellWidth = 0.0f;
                int defWidth = this.sheet.getDefaultColumnWidth() * 256;
                if (this.context.isOoxml()) {
                    int i;
                    for (i = cell.getRowIndex(); i < cell.getRowIndex() + rowSpan; ++i) {
                        cellHeight += this.sheet.getRow(i).getHeightInPoints() * 96.0f / 72.0f;
                    }
                    for (i = cell.getColumnIndex(); i < cell.getColumnIndex() + colSpan; ++i) {
                        cellWidth += (float)this.sheet.getColumnWidth(i) / 32.0f;
                    }
                } else {
                    int i;
                    for (i = cell.getRowIndex(); i < cell.getRowIndex() + rowSpan; ++i) {
                        cellHeight += (float)(this.sheet.getRow(i).getHeight() / 15);
                    }
                    for (i = cell.getColumnIndex(); i < cell.getColumnIndex() + colSpan; ++i) {
                        cellWidth += (float)this.sheet.getColumnWidth(i);
                    }
                    px = cellWidth == (float)defWidth ? 32.0f : 36.56f;
                    cellWidth /= px;
                }
                this.resizePicture(oPict, anchor, cellWidth, cellHeight, stretch, cell.getCellStyle());
            }
            catch (Exception e) {
                if (!logger.isWarnEnabled()) break block11;
                logger.warn((Object)("Fail to draw image : " + StringUtils.normalizeSpace((String)url)));
            }
        }
    }

    private void resizePicture(Picture pic, ClientAnchor anchor, float width, float height, int stretch, CellStyle style) throws IOException {
        if (!this.context.isOoxml()) {
            anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_DONT_RESIZE);
        }
        Dimension dim = this.getImageDimension(pic.getPictureData());
        BigDecimal dimHeight = BigDecimal.valueOf(dim.getHeight());
        BigDecimal cellHeight = BigDecimal.valueOf(height - 2.0f);
        BigDecimal dimWidth = BigDecimal.valueOf(dim.getWidth());
        BigDecimal cellWidth = BigDecimal.valueOf(width - 2.0f);
        BigDecimal ratio = BigDecimal.ONE;
        BigDecimal vRatio = BigDecimal.ONE;
        BigDecimal hRatio = BigDecimal.ONE;
        if (dimHeight.compareTo(cellHeight) != 0) {
            vRatio = cellHeight.divide(dimHeight, 5, 1);
        }
        if (dimWidth.compareTo(cellWidth) != 0) {
            hRatio = cellWidth.divide(dimWidth, 5, 1);
        }
        if (vRatio.compareTo(BigDecimal.ONE) != 0 && hRatio.compareTo(BigDecimal.ONE) != 0) {
            if (vRatio.compareTo(BigDecimal.ONE) == 1 && hRatio.compareTo(BigDecimal.ONE) == 1) {
                ratio = vRatio.compareTo(hRatio) == 1 ? hRatio : vRatio;
            } else if (vRatio.compareTo(BigDecimal.ONE) == -1 && hRatio.compareTo(BigDecimal.ONE) == -1) {
                ratio = vRatio.compareTo(hRatio) == 1 ? hRatio : vRatio;
            } else if (hRatio.compareTo(BigDecimal.ONE) == -1) {
                ratio = hRatio;
            } else if (vRatio.compareTo(BigDecimal.ONE) == -1) {
                ratio = vRatio;
            }
        } else if (vRatio.compareTo(BigDecimal.ONE) == -1) {
            ratio = vRatio;
        } else if (hRatio.compareTo(BigDecimal.ONE) == -1) {
            ratio = hRatio;
        }
        this.getPreferredSize(pic, anchor, dimWidth.multiply(ratio).doubleValue(), dimHeight.multiply(ratio).doubleValue(), width, height, style);
    }

    private Dimension getImageDimension(PictureData data) throws IOException {
        if (!this.context.isOoxml()) {
            HSSFPictureData hssfData = (HSSFPictureData)data;
            return ImageUtils.getImageDimension((InputStream)new ByteArrayInputStream(hssfData.getData()), (int)hssfData.getFormat());
        }
        XSSFPictureData xssfData = (XSSFPictureData)data;
        return ImageUtils.getImageDimension((InputStream)xssfData.getPackagePart().getInputStream(), (int)xssfData.getPictureType());
    }

    private void getPreferredSize(Picture pic, ClientAnchor anchor, double picWidth, double picHeight, float cellWidth, float cellHeight, CellStyle style) throws IOException {
        HorizontalAlignment hAlign = HorizontalAlignment.LEFT;
        VerticalAlignment vAlign = VerticalAlignment.CENTER;
        if (style != null) {
            hAlign = style.getAlignment();
            vAlign = style.getVerticalAlignment();
        }
        this.setColumnAnchor(anchor, picWidth, cellWidth, hAlign);
        this.setRowAnchor(anchor, picHeight, cellHeight, vAlign);
    }

    private void setColumnAnchor(ClientAnchor anchor, double scaledWidth, float cellWidth, HorizontalAlignment align) {
        int col1;
        double w = 0.0;
        float curW = 0.0f;
        float px = 0.0f;
        int defWidth = this.sheet.getDefaultColumnWidth() * 256;
        int col2 = anchor.getCol2();
        int dx1 = anchor.getDx1();
        int dx2 = anchor.getDx2();
        int width = 0;
        int endCol = col2;
        double delta = (double)cellWidth - scaledWidth;
        double moveDelta = delta / 2.0;
        block0: for (col1 = anchor.getCol1(); col1 <= endCol; ++col1) {
            if (!this.context.isOoxml()) {
                width = this.sheet.getColumnWidth(col1);
                px = width == defWidth ? 32.0f : 36.56f;
                curW = (float)width / px;
            } else {
                curW = (float)this.sheet.getColumnWidth(col1) / 32.0f;
            }
            w += (double)curW;
            if (w < moveDelta) {
                continue;
            }
            dx1 = !this.context.isOoxml() ? (int)Math.round((moveDelta - (w - (double)curW)) / (double)curW * 1024.0) : (int)Math.round(9525.0 * (moveDelta - (w - (double)curW)));
            col2 = col1;
            moveDelta += scaledWidth;
            while (col2 <= endCol) {
                if (w >= moveDelta) {
                    if (!this.context.isOoxml()) {
                        dx2 = (int)Math.round(((double)curW - (w - moveDelta)) / (double)curW * 1024.0);
                        break block0;
                    }
                    dx2 = (int)Math.round(9525.0 * ((double)curW - (w - moveDelta)));
                    break block0;
                }
                ++col2;
                if (!this.context.isOoxml()) {
                    width = this.sheet.getColumnWidth(col2);
                    px = width == defWidth ? 32.0f : 36.56f;
                    curW = (float)width / px;
                } else {
                    curW = (float)this.sheet.getColumnWidth(col2) / 32.0f;
                }
                w += (double)curW;
            }
            break block0;
        }
        anchor.setCol1(col1);
        anchor.setCol2(col2);
        anchor.setDx1(dx1);
        anchor.setDx2(dx2);
    }

    private void setRowAnchor(ClientAnchor anchor, double scaledHeight, float cellHeight, VerticalAlignment align) {
        int row1;
        Row row = null;
        double h = 0.0;
        int row2 = anchor.getRow2();
        int dy1 = anchor.getDy1();
        int dy2 = anchor.getDy2();
        int endRow = row2;
        double delta = (double)cellHeight - scaledHeight;
        double moveDelta = delta / 2.0;
        block0: for (row1 = anchor.getRow1(); row1 <= endRow; ++row1) {
            float curH = 0.0f;
            row = this.sheet.getRow(row1);
            curH = !this.context.isOoxml() ? (row != null ? (float)(row.getHeight() / 15) : (float)(this.sheet.getDefaultRowHeight() / 15)) : (row != null ? row.getHeightInPoints() * 96.0f / 72.0f : this.sheet.getDefaultRowHeightInPoints() * 96.0f / 72.0f);
            h += (double)curH;
            if (h < moveDelta) {
                continue;
            }
            dy1 = !this.context.isOoxml() ? (int)Math.round((moveDelta - (h - (double)curH)) / (double)curH * 256.0) : (int)Math.round(9525.0 * (moveDelta - (h - (double)curH)));
            row2 = row1;
            moveDelta += scaledHeight;
            while (row2 <= endRow) {
                if (h >= moveDelta) {
                    if (!this.context.isOoxml()) {
                        dy2 = (int)Math.round(((double)curH - (h - moveDelta)) / (double)curH * 256.0);
                        break block0;
                    }
                    dy2 = (int)Math.round(9525.0 * ((double)curH - (h - moveDelta)));
                    break block0;
                }
                row = this.sheet.getRow(++row2);
                curH = !this.context.isOoxml() ? (row != null ? (float)(row.getHeight() / 15) : (float)(this.sheet.getDefaultRowHeight() / 15)) : (row != null ? row.getHeightInPoints() * 96.0f / 72.0f : this.sheet.getDefaultRowHeightInPoints() * 96.0f / 72.0f);
                h += (double)curH;
            }
            break block0;
        }
        anchor.setRow1(row1);
        anchor.setRow2(row2);
        anchor.setDy1(dy1);
        anchor.setDy2(dy2);
    }

    private GridCellStyleInfoExt getBodyCellStyle(Cell exlcell, FormatCell bodycell, String name) {
        GridCellStyleInfoExt extStyle = this.styleInfo.getCellStyle(name);
        if (extStyle == null) {
            String style2;
            String style = this.isOdd ? ((style2 = bodycell.getStyle2()) != null && style2.length() > 0 ? style2 : bodycell.getStyle1()) : bodycell.getStyle1();
            extStyle = this.styleInfo.getCellStyle(style);
        }
        return extStyle;
    }

    private int setHead() {
        int errorCode = 0;
        int addedRowCnt = this.createGridFormatBand("head");
        if (addedRowCnt > 0) {
            errorCode = this.setHeadData();
            this.nextExcelRow += addedRowCnt;
        }
        return errorCode;
    }

    private int setHeadData() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)StringUtils.normalizeSpace((String)("Export head( format count : " + this.gridFormat.getHeadCellCount() + " )")));
        }
        CellStyle cellStyle = null;
        FormatCell formatHeadCell = null;
        for (int cellIdx = 0; cellIdx < this.gridFormat.getHeadCellCount(); ++cellIdx) {
            formatHeadCell = this.gridFormat.getHeadCell(cellIdx);
            Cell excelCell = this.getExcelCell(formatHeadCell);
            if (excelCell == null) {
                this.setErrorMessage("Fail to get excel cell(set head).");
                return -2015;
            }
            GridCellStyleInfoExt styleExt = this.styleInfo.getCellStyle(formatHeadCell.getStyle1());
            if (styleExt != null && (cellStyle = this.workBook.getCellStyleAt((int)styleExt.getStyleIndex())) != null) {
                excelCell.setCellStyle(cellStyle);
            }
            this.setCellValue(excelCell, formatHeadCell.getText(), styleExt, formatHeadCell, true);
            this.setMergeCell(formatHeadCell, excelCell, cellStyle);
        }
        return 0;
    }

    private int setSummary() {
        int errorCode = 0;
        int addedRowCnt = this.createGridFormatBand("summ");
        if (addedRowCnt > 0) {
            errorCode = this.setSummaryData();
            this.nextExcelRow += addedRowCnt;
        }
        return errorCode;
    }

    private int setSummaryData() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)StringUtils.normalizeSpace((String)("Export summary( format count : " + this.gridFormat.getSummaryCellCount() + " )")));
        }
        CellStyle cellStyle = null;
        FormatCell formatSummCell = null;
        for (int nSmCellIdx = 0; nSmCellIdx < this.gridFormat.getSummaryCellCount(); ++nSmCellIdx) {
            formatSummCell = this.gridFormat.getSummary(nSmCellIdx);
            Cell excelCell = this.getExcelCell(formatSummCell);
            if (excelCell == null) {
                this.setErrorMessage("Fail to get excel cell(set summary).");
                return -2015;
            }
            GridCellStyleInfoExt styleExt = this.styleInfo.getCellStyle(formatSummCell.getStyle1());
            if (styleExt != null && (cellStyle = this.workBook.getCellStyleAt((int)styleExt.getStyleIndex())) != null) {
                excelCell.setCellStyle(cellStyle);
            }
            this.setCellValue(excelCell, formatSummCell.getText(), styleExt, formatSummCell, true);
            this.setMergeCell(formatSummCell, excelCell, cellStyle);
        }
        return 0;
    }

    private int setBody(DataSet data) {
        int errorCode = 0;
        int addedRowCnt = 0;
        int rowIndex = 0;
        data.stopStoreDataChanges();
        while (data.getRowCount() > 0) {
            addedRowCnt = this.createGridFormatBand("body");
            if (addedRowCnt > 0) {
                errorCode = this.setBodyData(data, rowIndex);
                if (errorCode < 0) {
                    return errorCode;
                }
                this.nextExcelRow += addedRowCnt;
            }
            this.isOdd = !this.isOdd;
            data.removeRow(rowIndex);
        }
        return errorCode;
    }

    private int setBodyData(DataSet data, int dsrow) {
        int formatCellCnt;
        int errorCode = 0;
        int dsColumnCnt = data.getColumnCount();
        if (dsColumnCnt != (formatCellCnt = this.gridFormat.getBodyCellCount())) {
            this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.export.fault.bodyformat", Integer.toString(dsColumnCnt), Integer.toString(formatCellCnt)));
            return -2014;
        }
        CellStyle cellStyle = null;
        FormatCell formatBodyCell = null;
        GridCellStyleInfoExt extStyle = null;
        for (int formatIdx = 0; formatIdx < formatCellCnt; ++formatIdx) {
            formatBodyCell = this.gridFormat.getBodyCell(formatIdx);
            Cell excelCell = this.getExcelCell(formatBodyCell);
            if (excelCell == null) {
                this.setErrorMessage("Fail to get excel cell(set body).");
                return -2015;
            }
            String value = "";
            String styleName = "";
            boolean applySpan = true;
            String valueText = data.getString(dsrow, formatIdx);
            if (valueText != null && valueText.length() > 0) {
                String[] values = valueText.split(this.groupSeparator);
                if (values.length > 0) {
                    value = values[0];
                }
                if (values.length > 1) {
                    styleName = values[1];
                }
                if (values.length > 2 && "true".equals(values[2])) {
                    applySpan = false;
                }
            }
            if ((extStyle = this.getBodyCellStyle(excelCell, formatBodyCell, styleName)) != null && (cellStyle = this.workBook.getCellStyleAt((int)extStyle.getStyleIndex())) != null) {
                excelCell.setCellStyle(cellStyle);
            }
            if (this.context.getCommandVersion() == 2.0f) {
                value = new String(Base64.getDecoder().decode(value), StandardCharsets.UTF_8);
            } else if (this.context.getCommandVersion() == 3.0f) {
                value = new String(new Base32().decode(value), StandardCharsets.UTF_8);
            }
            errorCode = this.setCellValue(excelCell, value, extStyle, formatBodyCell, applySpan);
            if (applySpan) {
                this.setMergeCell(formatBodyCell, excelCell, cellStyle);
            }
            this.setSuppressCell(formatBodyCell, excelCell, extStyle);
        }
        return errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int saveExportFile(ServletProvider svltProvider, DataSet command) {
        int errorCode = 0;
        try {
            XeniExcelDataStorageBase extendClass = XeniExtendLoader.getExcelDataStorageFactory().getExtendClass("xeni.exportimport.storage");
            if (extendClass == null) {
                this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.export.fail.create.extendclass", "xeni.exportimport.storage"));
                int n = -2004;
                return n;
            }
            if (extendClass instanceof XeniExcelDataStorageDef) {
                errorCode = this.saveExportStreamDefault(svltProvider, command);
            } else {
                ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
                this.workBook.write((OutputStream)outBytes);
                this.workBook.close();
                if (this.context.isOoxml()) {
                    ((SXSSFWorkbook)this.workBook).dispose();
                }
                errorCode = extendClass.saveExportStream(this.context.getUserVariableList(), command, outBytes, this.absolutePath, this.downloadUrl, svltProvider.getHttpServletResponse());
            }
        }
        catch (FileNotFoundException e) {
            this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.export.no.such.file"));
            errorCode = -2020;
        }
        catch (Exception e) {
            this.setErrorMessage(e.getMessage());
            errorCode = -2001;
        }
        finally {
            this.pictures.clear();
            this.styleInfo.clear();
        }
        return errorCode;
    }

    private int sendExportPartResponse(ServletProvider svltProvider, DataSet command) {
        PlatformData platformData = new PlatformData();
        VariableList varList = platformData.getVariableList();
        varList.add("ErrorCode", 0);
        varList.add("ErrorMsg", "SUCCESS");
        DataSet dsResponse = CommUtil.getDatasetExportResponse(command);
        if (this.isEof()) {
            dsResponse.set(0, "url", this.downloadUrl);
        }
        platformData.addDataSet(dsResponse);
        try {
            HttpPlatformResponse platformResponse = new HttpPlatformResponse(svltProvider.getHttpServletResponse(), this.context.getResponsePlatformType(), "UTF-8");
            platformResponse.setData(platformData);
            platformResponse.sendData();
        }
        catch (PlatformException e) {
            this.setErrorMessage(e.getMessage());
            return -2001;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int saveExportStreamDefault(ServletProvider svltProvider, DataSet command) {
        String filePath = this.absolutePath;
        File dirFile = null;
        try {
            dirFile = XeniUtils.getXeniFileHandler(filePath.substring(0, filePath.lastIndexOf("/"))).toFile();
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FileOutputStream fileOutput = null;
        try {
            fileOutput = new FileOutputStream(XeniUtils.getXeniFileHandler(filePath).toFile());
            String passWord = this.context.getPassword();
            if (passWord != null && passWord.length() > 0) {
                if (this.context.isOoxml()) {
                    this.workBook.write((OutputStream)fileOutput);
                    fileOutput.close();
                    POIFSFileSystem poiFileSystem = new POIFSFileSystem();
                    EncryptionInfo encryptionInfo = new EncryptionInfo(EncryptionMode.agile);
                    Encryptor encryptor = encryptionInfo.getEncryptor();
                    encryptor.confirmPassword(passWord);
                    OutputStream outputStream = encryptor.getDataStream(poiFileSystem);
                    OPCPackage opcPackage = OPCPackage.open((String)filePath);
                    opcPackage.save(outputStream);
                    opcPackage.close();
                    outputStream.close();
                    fileOutput = new FileOutputStream(XeniUtils.getXeniFileHandler(filePath).toFile());
                    poiFileSystem.writeFilesystem((OutputStream)fileOutput);
                } else {
                    Biff8EncryptionKey.setCurrentUserPassword((String)passWord);
                    this.workBook.write((OutputStream)fileOutput);
                }
            } else {
                this.workBook.write((OutputStream)fileOutput);
            }
            this.sendExportPartResponse(svltProvider, command);
        }
        catch (FileNotFoundException e) {
            this.setErrorMessage("File not found. (" + this.context.getFileName() + ")");
            int n = -2020;
            return n;
        }
        catch (Exception e) {
            this.setErrorMessage(e.getMessage());
            int n = -2001;
            return n;
        }
        finally {
            try {
                if (fileOutput != null) {
                    fileOutput.close();
                }
                this.workBook.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage());
            }
            if (this.context.isOoxml()) {
                ((SXSSFWorkbook)this.workBook).dispose();
            }
        }
        return 0;
    }

    private void setRowHeights(Sheet sheet, Map<Integer, Integer> heights) {
        Set<Integer> keys = heights.keySet();
        for (Integer key : keys) {
            Integer value;
            Row row = sheet.getRow(key.intValue());
            if (row == null || (value = heights.get(key)) == null) continue;
            row.setHeight((short)(value * 15));
        }
    }
}

