/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.extend;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class XeniBuiltinFormats {
    public static final int FIRST_USER_DEFINED_FORMAT_INDEX = 164;
    private static final String[] _formats;

    private static void putFormat(List<String> m, int index, String value) {
        if (m.size() != index) {
            throw new IllegalStateException("index " + index + " is wrong");
        }
        m.add(value);
    }

    public static Map<Integer, String> getBuiltinFormats() {
        LinkedHashMap<Integer, String> result = new LinkedHashMap<Integer, String>();
        for (int i = 0; i < _formats.length; ++i) {
            result.put(i, _formats[i]);
        }
        return result;
    }

    public static String[] getAll() {
        return (String[])_formats.clone();
    }

    public static String getBuiltinFormat(int index, String numberFmtLang) {
        if (index < 0 || index >= _formats.length) {
            return null;
        }
        if (index == 14) {
            return XeniBuiltinFormats.getNumberFmtDateString("ko");
        }
        return _formats[index];
    }

    public static int getBuiltinFormat(String pFmt) {
        String fmt = pFmt.equalsIgnoreCase("TEXT") ? "@" : pFmt;
        for (int i = 0; i < _formats.length; ++i) {
            if (!fmt.equals(_formats[i])) continue;
            return i;
        }
        return -1;
    }

    public static String getNumberFmtDateString(String lang) {
        String result = "";
        if (lang.equals("ko")) {
            result = "yyyy-mm-dd";
        }
        return result;
    }

    static {
        ArrayList<String> m = new ArrayList<String>();
        XeniBuiltinFormats.putFormat(m, 0, "General");
        XeniBuiltinFormats.putFormat(m, 1, "0");
        XeniBuiltinFormats.putFormat(m, 2, "0.00");
        XeniBuiltinFormats.putFormat(m, 3, "#,##0");
        XeniBuiltinFormats.putFormat(m, 4, "#,##0.00");
        XeniBuiltinFormats.putFormat(m, 5, "\"$\"#,##0_);(\"$\"#,##0)");
        XeniBuiltinFormats.putFormat(m, 6, "\"$\"#,##0_);[Red](\"$\"#,##0)");
        XeniBuiltinFormats.putFormat(m, 7, "\"$\"#,##0.00_);(\"$\"#,##0.00)");
        XeniBuiltinFormats.putFormat(m, 8, "\"$\"#,##0.00_);[Red](\"$\"#,##0.00)");
        XeniBuiltinFormats.putFormat(m, 9, "0%");
        XeniBuiltinFormats.putFormat(m, 10, "0.00%");
        XeniBuiltinFormats.putFormat(m, 11, "0.00E+00");
        XeniBuiltinFormats.putFormat(m, 12, "# ?/?");
        XeniBuiltinFormats.putFormat(m, 13, "# ??/??");
        XeniBuiltinFormats.putFormat(m, 14, "m-d-yy");
        XeniBuiltinFormats.putFormat(m, 15, "d-mmm-yy");
        XeniBuiltinFormats.putFormat(m, 16, "d-mmm");
        XeniBuiltinFormats.putFormat(m, 17, "mmm-yy");
        XeniBuiltinFormats.putFormat(m, 18, "h:mm AM/PM");
        XeniBuiltinFormats.putFormat(m, 19, "h:mm:ss AM/PM");
        XeniBuiltinFormats.putFormat(m, 20, "h:mm");
        XeniBuiltinFormats.putFormat(m, 21, "h:mm:ss");
        XeniBuiltinFormats.putFormat(m, 22, "m/d/yy h:mm");
        for (int i = 23; i <= 36; ++i) {
            XeniBuiltinFormats.putFormat(m, i, "reserved-0x" + Integer.toHexString(i));
        }
        XeniBuiltinFormats.putFormat(m, 37, "#,##0_);(#,##0)");
        XeniBuiltinFormats.putFormat(m, 38, "#,##0_);[Red](#,##0)");
        XeniBuiltinFormats.putFormat(m, 39, "#,##0.00_);(#,##0.00)");
        XeniBuiltinFormats.putFormat(m, 40, "#,##0.00_);[Red](#,##0.00)");
        XeniBuiltinFormats.putFormat(m, 41, "_(* #,##0_);_(* (#,##0);_(* \"-\"_);_(@_)");
        XeniBuiltinFormats.putFormat(m, 42, "_(\"$\"* #,##0_);_(\"$\"* (#,##0);_(\"$\"* \"-\"_);_(@_)");
        XeniBuiltinFormats.putFormat(m, 43, "_(* #,##0.00_);_(* (#,##0.00);_(* \"-\"??_);_(@_)");
        XeniBuiltinFormats.putFormat(m, 44, "_(\"$\"* #,##0.00_);_(\"$\"* (#,##0.00);_(\"$\"* \"-\"??_);_(@_)");
        XeniBuiltinFormats.putFormat(m, 45, "mm:ss");
        XeniBuiltinFormats.putFormat(m, 46, "[h]:mm:ss");
        XeniBuiltinFormats.putFormat(m, 47, "mm:ss.0");
        XeniBuiltinFormats.putFormat(m, 48, "##0.0E+0");
        XeniBuiltinFormats.putFormat(m, 49, "@");
        String[] ss = new String[m.size()];
        m.toArray(ss);
        _formats = ss;
    }
}

