/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.extend;

import com.nexacro.java.xeni.extend.XeniReadOnlySharedStringsTable;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XeniCustomSharedStringsTable
extends XeniReadOnlySharedStringsTable {
    private StringBuffer characters;
    private boolean tIsOpen;

    public XeniCustomSharedStringsTable(OPCPackage pkg) throws IOException, SAXException {
        super(pkg);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        int colonIndex = name.indexOf(":");
        if (colonIndex > -1) {
            name = name.substring(colonIndex + 1, name.length());
        }
        if ("sst".equals(name)) {
            String uniqueCount;
            String count = attributes.getValue("count");
            if (count != null) {
                this.setCount(Integer.parseInt(count));
            }
            if ((uniqueCount = attributes.getValue("uniqueCount")) != null) {
                this.setUniqueCount(Integer.parseInt(uniqueCount));
            }
            this.strings = new ArrayList(this.getUniqueCount());
            this.characters = new StringBuffer();
        } else if ("si".equals(name)) {
            this.characters.setLength(0);
        } else if ("t".equals(name)) {
            this.tIsOpen = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        int colonIndex = name.indexOf(":");
        if (colonIndex > -1) {
            name = name.substring(colonIndex + 1, name.length());
        }
        if ("si".equals(name)) {
            this.setStrings(this.characters.toString());
        } else if ("t".equals(name)) {
            this.tIsOpen = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.tIsOpen) {
            this.characters.append(ch, start, length);
        }
    }
}

