/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.extend;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.data.VariableList;
import com.nexacro.java.xapi.tx.HttpPlatformResponse;
import com.nexacro.java.xeni.extend.XeniExcelDataStorageBase;
import com.nexacro.java.xeni.util.CommUtil;
import com.nexacro.java.xeni.util.XeniProperties;
import com.nexacro.java.xeni.util.XeniUtils;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class XeniExcelDataStorageDef
implements XeniExcelDataStorageBase {
    @Override
    public InputStream loadTargetStream(String filepath) throws Exception {
        File file = XeniUtils.getXeniFileHandler(filepath).toFile();
        return new FileInputStream(file);
    }

    @Override
    public String saveImportStream(VariableList varlist, InputStream in, String filepath) throws Exception {
        int nIdx = filepath.lastIndexOf("/");
        String sPath = filepath.substring(0, nIdx);
        File file = XeniUtils.getXeniFileHandler(sPath).toFile();
        if (!file.exists()) {
            file.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(filepath);
        byte[] buf = new byte[1024];
        int length = 0;
        while ((length = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, length);
        }
        out.flush();
        ((OutputStream)out).close();
        return null;
    }

    @Override
    public int saveExportStream(VariableList varlist, DataSet dscmd, ByteArrayOutputStream out, String filepath, String fileurl, HttpServletResponse response) throws Exception {
        int nIdx = filepath.lastIndexOf("/");
        String sPath = filepath.substring(0, nIdx);
        File file = XeniUtils.getXeniFileHandler(sPath).toFile();
        if (!file.exists()) {
            file.mkdirs();
        }
        FileOutputStream fout = new FileOutputStream(XeniUtils.getXeniFileHandler(filepath).toFile());
        String pwd = dscmd.getString(0, "password");
        if (pwd != null && pwd.length() > 0) {
            int nExportType = dscmd.getInt(0, "type");
            if (nExportType == 288 || nExportType == 1040) {
                ByteArrayInputStream bais = new ByteArrayInputStream(out.toByteArray());
                OPCPackage opcpack = OPCPackage.open((InputStream)bais);
                POIFSFileSystem poiFs = new POIFSFileSystem();
                EncryptionInfo encInfo = new EncryptionInfo(EncryptionMode.agile);
                Encryptor enc = encInfo.getEncryptor();
                enc.confirmPassword(pwd);
                OutputStream encOut = enc.getDataStream(poiFs);
                opcpack.save(encOut);
                opcpack.close();
                encOut.close();
                poiFs.writeFilesystem((OutputStream)fout);
                fout.close();
            } else {
                fout.write(out.toByteArray());
            }
        } else {
            fout.write(out.toByteArray());
        }
        fout.close();
        out.close();
        DataSet dsRes = CommUtil.getDatasetExportResponse(dscmd);
        PlatformData resData = new PlatformData();
        VariableList varList = resData.getVariableList();
        varList.add("ErrorCode", 0);
        varList.add("ErrorMsg", "SUCCESS");
        dsRes.set(0, "url", fileurl);
        resData.addDataSet(dsRes);
        String commType = XeniProperties.getStringProperty("xeni.export.commdataformat", "ssv");
        String platformType = "PlatformSsv";
        if ("xml".equalsIgnoreCase(commType)) {
            platformType = "PlatformXml";
        } else if ("json".equalsIgnoreCase(commType)) {
            platformType = "PlatformJson";
        } else if ("binary".equalsIgnoreCase(commType)) {
            platformType = "PlatformBinary";
        }
        HttpPlatformResponse platformRes = new HttpPlatformResponse(response, platformType, "UTF-8");
        platformRes.setData(resData);
        platformRes.sendData();
        return 0;
    }

    @Override
    public DataSet saveExportStream(VariableList varlist, DataSet dscmd, ByteArrayOutputStream out, String filepath, String fileurl) throws Exception {
        int nIdx = filepath.lastIndexOf("/");
        String sPath = filepath.substring(0, nIdx);
        File file = new File(sPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        FileOutputStream fout = new FileOutputStream(filepath);
        fout.write(out.toByteArray());
        fout.close();
        out.close();
        DataSet dsRes = CommUtil.getDatasetExportResponse(dscmd);
        dsRes.set(0, "url", fileurl);
        return dsRes;
    }
}

