/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.extend;

import com.nexacro.java.xeni.extend.XeniDataValidationBase;
import com.nexacro.java.xeni.extend.XeniDataValidationFactory;
import com.nexacro.java.xeni.extend.XeniExcelDataStorageBase;
import com.nexacro.java.xeni.extend.XeniExcelDataStorageDef;
import com.nexacro.java.xeni.extend.XeniExcelDataStorageFactory;
import com.nexacro.java.xeni.extend.XeniMultipartProcBase;
import com.nexacro.java.xeni.extend.XeniMultipartProcDef;
import com.nexacro.java.xeni.extend.XeniMultipartProcFactory;
import java.util.Iterator;
import java.util.ServiceLoader;

public class XeniExtendLoader {
    static final XeniDataValidationFactory dataValidationFactory = XeniExtendLoader.loadDataValidationFactory();
    static final XeniExcelDataStorageFactory excelDataStorageFactory = XeniExtendLoader.loadExcelDataStorageFactory();
    static final XeniMultipartProcFactory multipartProcFactory = XeniExtendLoader.loadMultipartProcFactory();

    public static XeniDataValidationFactory getDataValidationFactory() {
        return dataValidationFactory;
    }

    public static XeniExcelDataStorageFactory getExcelDataStorageFactory() {
        return excelDataStorageFactory;
    }

    public static XeniMultipartProcFactory getMultipartProcFactory() {
        return multipartProcFactory;
    }

    protected static final XeniDataValidationFactory loadDataValidationFactory() {
        XeniDataValidationFactory extend = null;
        ServiceLoader<XeniDataValidationFactory> loader = ServiceLoader.load(XeniDataValidationFactory.class);
        Iterator<XeniDataValidationFactory> iterator = loader.iterator();
        if (iterator.hasNext()) {
            XeniDataValidationFactory factory;
            extend = factory = iterator.next();
        }
        if (extend == null) {
            extend = new DataValidationFactory();
        }
        return extend;
    }

    protected static final XeniExcelDataStorageFactory loadExcelDataStorageFactory() {
        XeniExcelDataStorageFactory extend = null;
        ServiceLoader<XeniExcelDataStorageFactory> loader = ServiceLoader.load(XeniExcelDataStorageFactory.class);
        Iterator<XeniExcelDataStorageFactory> iterator = loader.iterator();
        if (iterator.hasNext()) {
            XeniExcelDataStorageFactory factory;
            extend = factory = iterator.next();
        }
        if (extend == null) {
            extend = new ExcelDataStorageFactory();
        }
        return extend;
    }

    protected static final XeniMultipartProcFactory loadMultipartProcFactory() {
        XeniMultipartProcFactory extend = null;
        ServiceLoader<XeniMultipartProcFactory> loader = ServiceLoader.load(XeniMultipartProcFactory.class);
        Iterator<XeniMultipartProcFactory> iterator = loader.iterator();
        if (iterator.hasNext()) {
            XeniMultipartProcFactory factory;
            extend = factory = iterator.next();
        }
        if (extend == null) {
            extend = new MultipartProcFactory();
        }
        return extend;
    }

    private XeniExtendLoader() {
    }

    public static class MultipartProcFactory
    implements XeniMultipartProcFactory {
        @Override
        public XeniMultipartProcBase getMultipartProc(String type) {
            return new XeniMultipartProcDef();
        }
    }

    public static class ExcelDataStorageFactory
    implements XeniExcelDataStorageFactory {
        @Override
        public XeniExcelDataStorageBase getExtendClass(String type) {
            return new XeniExcelDataStorageDef();
        }
    }

    public static class DataValidationFactory
    implements XeniDataValidationFactory {
        @Override
        public XeniDataValidationBase getDataValidator() {
            return null;
        }
    }
}

