/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.extend;

import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.tx.PlatformRequest;
import com.nexacro.java.xeni.extend.XeniMultipartProcBase;
import com.nexacro.java.xeni.extend.XeniMultipartReqData;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.fileupload2.core.FileItemInput;
import org.apache.commons.fileupload2.core.FileItemInputIterator;
import org.apache.commons.fileupload2.jakarta.JakartaServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XeniMultipartProcDef
implements XeniMultipartProcBase {
    private static final Log logger = LogFactory.getLog(XeniMultipartProcDef.class);

    @Override
    public XeniMultipartReqData getImportData(HttpServletRequest req) throws Exception {
        JakartaServletFileUpload upload = new JakartaServletFileUpload();
        XeniMultipartReqData data = new XeniMultipartReqData();
        upload.setHeaderCharset(StandardCharsets.UTF_8);
        FileItemInputIterator fileIter = upload.getItemIterator(req);
        String sName = null;
        while (fileIter.hasNext()) {
            FileItemInput fileItem = fileIter.next();
            if (fileItem.isFormField()) {
                data.setPlatformData(this.getPlatformData(fileItem.getInputStream()));
            } else {
                sName = fileItem.getName();
                int nIdx = (sName = sName.replaceAll("\\\\", "/")).lastIndexOf(47);
                if (nIdx >= 0) {
                    sName = sName.substring(nIdx + 1);
                }
                data.setFileName(sName);
                InputStream in = fileItem.getInputStream();
                ByteArrayInputStream insFile = new ByteArrayInputStream(IOUtils.toByteArray((InputStream)in));
                data.setFileStream(insFile);
                in.close();
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("File field " + fileItem.getFieldName() + " with file name " + sName + " detected."));
        }
        return data;
    }

    private boolean IsValidName(String name) {
        boolean isValid = false;
        String sExt = "";
        int nIdx = name.lastIndexOf(46);
        if (nIdx > 0) {
            sExt = name.substring(nIdx + 1);
        }
        if (sExt.length() > 0 && ("xls".equalsIgnoreCase(sExt) || "xlsx".equalsIgnoreCase(sExt) || "cell".equalsIgnoreCase(sExt) || "csv".equalsIgnoreCase(sExt) || "xlsm".equalsIgnoreCase(sExt) || "pia".equalsIgnoreCase(sExt))) {
            isValid = true;
        }
        return isValid;
    }

    private PlatformData getPlatformData(InputStream in) throws PlatformException {
        PlatformRequest platformReq = new PlatformRequest(in);
        platformReq.receiveData();
        return platformReq.getData();
    }
}

