/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.extend;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XeniReadOnlySharedStringsTable
extends DefaultHandler {
    private int count;
    private int uniqueCount;
    public List<String> strings;
    private StringBuffer characters;
    private boolean tIsOpen;
    private boolean isPhonetic = false;

    public List<String> getStrings() {
        return this.strings;
    }

    public void setStrings(String strings) {
        this.strings.add(strings);
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setUniqueCount(int uniqueCount) {
        this.uniqueCount = uniqueCount;
    }

    public XeniReadOnlySharedStringsTable(OPCPackage pkg) throws IOException, SAXException {
        ArrayList parts = pkg.getPartsByContentType(XSSFRelation.SHARED_STRINGS.getContentType());
        if (parts.size() > 0) {
            PackagePart sstPart = (PackagePart)parts.get(0);
            this.readFrom(sstPart.getInputStream());
        }
    }

    public XeniReadOnlySharedStringsTable(PackagePart part, PackageRelationship rel_ignored) throws IOException, SAXException {
        this.readFrom(part.getInputStream());
    }

    public void readFrom(InputStream is) throws IOException, SAXException {
        InputSource sheetSource = new InputSource(is);
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = saxFactory.newSAXParser();
            XMLReader sheetParser = saxParser.getXMLReader();
            sheetParser.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            sheetParser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            sheetParser.setFeature("http://xml.org/sax/features/external-general-entities", false);
            sheetParser.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            sheetParser.setContentHandler(this);
            sheetParser.parse(sheetSource);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("SAX parser appears to be broken - " + e.getMessage());
        }
    }

    public int getCount() {
        return this.count;
    }

    public int getUniqueCount() {
        return this.uniqueCount;
    }

    public String getEntryAt(int idx) {
        return this.strings.get(idx);
    }

    public List<String> getItems() {
        return this.strings;
    }

    public StringBuffer getCharacters() {
        return this.characters;
    }

    public void setCharacters(StringBuffer characters) {
        this.characters = characters;
    }

    public boolean istIsOpen() {
        return this.tIsOpen;
    }

    public void settIsOpen(boolean tIsOpen) {
        this.tIsOpen = tIsOpen;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        int colonIndex = name.indexOf(":");
        if (colonIndex > -1) {
            name = name.substring(colonIndex + 1, name.length());
        }
        if ("sst".equals(name)) {
            String uniqueCount;
            String count = attributes.getValue("count");
            if (count != null) {
                this.count = Integer.parseInt(count);
            }
            if ((uniqueCount = attributes.getValue("uniqueCount")) != null) {
                this.uniqueCount = Integer.parseInt(uniqueCount);
            }
            this.strings = new ArrayList<String>(this.uniqueCount);
            this.characters = new StringBuffer();
        } else if ("si".equals(name)) {
            this.characters.setLength(0);
        } else if ("t".equals(name)) {
            this.tIsOpen = true;
        } else if ("rPh".equals(name)) {
            this.isPhonetic = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        int colonIndex = name.indexOf(":");
        if (colonIndex > -1) {
            name = name.substring(colonIndex + 1, name.length());
        }
        if ("si".equals(name)) {
            this.strings.add(this.characters.toString());
        } else if ("t".equals(name)) {
            this.tIsOpen = false;
        } else if ("rPh".equals(name)) {
            this.isPhonetic = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.tIsOpen && !this.isPhonetic) {
            this.characters.append(ch, start, length);
        }
    }
}

