/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.extend;

import com.nexacro.java.xeni.extend.XeniCTXf;
import com.nexacro.java.xeni.ximport.POIEventModelException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.xmlbeans.XmlException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XeniStylesTable
extends DefaultHandler {
    private boolean bHancell = false;
    private Boolean bIsCTXF = false;
    private final List<XeniCTXf> styleXfs = new ArrayList<XeniCTXf>();
    private final List<XeniCTXf> xfs = new ArrayList<XeniCTXf>();
    private XeniCTXf ctXf = null;
    private XeniCTXf styleCtXf = null;

    public XeniStylesTable() {
    }

    public XeniStylesTable(OPCPackage pkg) throws IOException, SAXException, XmlException {
        ArrayList parts = pkg.getPartsByContentType(XSSFRelation.STYLES.getContentType());
        if (parts.size() > 0) {
            this.bHancell = true;
            PackagePart sstPart = (PackagePart)parts.get(0);
            this.readFrom(sstPart.getInputStream());
        }
    }

    public void readFrom(OPCPackage pkg) throws IOException, SAXException {
        ArrayList parts = pkg.getPartsByContentType(XSSFRelation.STYLES.getContentType());
        if (parts.size() > 0) {
            this.bHancell = true;
            PackagePart sstPart = (PackagePart)parts.get(0);
            this.readFrom(sstPart.getInputStream());
        }
    }

    public void readFrom(InputStream is) throws IOException, SAXException {
        InputSource sheetSource = new InputSource(is);
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = saxFactory.newSAXParser();
            XMLReader sheetParser = saxParser.getXMLReader();
            sheetParser.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            sheetParser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            sheetParser.setFeature("http://xml.org/sax/features/external-general-entities", false);
            sheetParser.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            sheetParser.setContentHandler(this);
            sheetParser.parse(sheetSource);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("SAX parser appears to be broken - " + e.getMessage());
        }
    }

    public List<XeniCTXf> getArrCtxf() {
        return this.xfs;
    }

    public short getDataFormat(int index) {
        return this.xfs.get(index).getNumFmtId();
    }

    public String getDataFormatString(Short nFmtId) {
        String formatStr = null;
        List<XeniCTXf> li = this.styleXfs;
        for (XeniCTXf ct : li) {
            if (ct.getNumFmtId() != nFmtId.shortValue()) continue;
            formatStr = ct.getFormatCode();
            break;
        }
        return formatStr;
    }

    @Override
    public void startElement(String uri, String name, String localName, Attributes attributes) throws SAXException {
        if (localName.equals("x:numFmt") || localName.equals("numFmt")) {
            this.styleCtXf = new XeniCTXf();
            this.styleCtXf.setNumFmtId(Short.parseShort(attributes.getValue("numFmtId")));
            this.styleCtXf.setFormatCode(attributes.getValue("formatCode"));
        } else if (localName.equals("x:cellXfs") || localName.equals("cellXfs")) {
            this.bIsCTXF = true;
        } else if (localName.equals("mc:Choice") || localName.equals("Choice")) {
            this.bIsCTXF = false;
        } else if (localName.equals("mc:Fallback") || localName.equals("Fallback")) {
            this.bIsCTXF = true;
        } else if (this.bIsCTXF.booleanValue() && (localName.equals("x:xf") || localName.equals("xf"))) {
            this.ctXf = new XeniCTXf();
            this.ctXf.setNumFmtId(Short.parseShort(attributes.getValue("numFmtId")));
        } else if (localName.equals("styleSheet") && attributes.getIndex("xmlns:x") < 0) {
            this.bHancell = false;
            throw new SAXException(new POIEventModelException("Stop parsing the document."));
        }
    }

    @Override
    public void endElement(String uri, String name, String localName) throws SAXException {
        if (localName.equals("x:cellXfs") || localName.equals("cellXfs")) {
            this.bIsCTXF = false;
        } else if (localName.equals("x:numFmt") || localName.equals("numFmt")) {
            this.styleXfs.add(this.styleCtXf);
        } else if (this.bIsCTXF.booleanValue() && (localName.equals("x:xf") || localName.equals("xf"))) {
            this.xfs.add(this.ctXf);
        }
    }

    public boolean isHancellStyle() {
        return this.bHancell;
    }
}

