/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.extend;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.ooxml.POIXMLException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.model.ThemesTable;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.WorkbookDocument;

public class XeniXSSFReader
extends XSSFReader {
    private OPCPackage pkg;
    private PackagePart workbookPart;

    public XeniXSSFReader(OPCPackage pkg) throws IOException, OpenXML4JException {
        super(pkg);
        this.pkg = pkg;
        PackageRelationship coreDocRelationship = this.pkg.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument").getRelationship(0);
        this.workbookPart = this.pkg.getPart(coreDocRelationship);
    }

    public SharedStringsTable getSharedStringsTable() throws IOException, InvalidFormatException {
        ArrayList parts = this.pkg.getPartsByContentType(XSSFRelation.SHARED_STRINGS.getContentType());
        return parts.size() == 0 ? null : new SharedStringsTable((PackagePart)parts.get(0));
    }

    public StylesTable getStylesTable() throws IOException, InvalidFormatException {
        ArrayList parts = this.pkg.getPartsByContentType(XSSFRelation.STYLES.getContentType());
        if (parts.size() == 0) {
            return null;
        }
        StylesTable styles = new StylesTable((PackagePart)parts.get(0));
        parts = this.pkg.getPartsByContentType(XSSFRelation.THEME.getContentType());
        if (parts.size() != 0) {
            styles.setTheme(new ThemesTable((PackagePart)parts.get(0)));
        }
        return styles;
    }

    public InputStream getSharedStringsData() throws IOException, InvalidFormatException {
        return XSSFRelation.SHARED_STRINGS.getContents(this.workbookPart);
    }

    public InputStream getStylesData() throws IOException, InvalidFormatException {
        return XSSFRelation.STYLES.getContents(this.workbookPart);
    }

    public InputStream getThemesData() throws IOException, InvalidFormatException {
        return XSSFRelation.THEME.getContents(this.workbookPart);
    }

    public InputStream getWorkbookData() throws IOException, InvalidFormatException {
        return this.workbookPart.getInputStream();
    }

    public InputStream getSheet(String relId) throws IOException, InvalidFormatException {
        PackageRelationship rel = this.workbookPart.getRelationship(relId);
        if (rel == null) {
            throw new IllegalArgumentException("No Sheet found with r:id " + relId);
        }
        PackagePartName relName = PackagingURIHelper.createPartName((URI)rel.getTargetURI());
        PackagePart sheet = this.pkg.getPart(relName);
        if (sheet == null) {
            throw new IllegalArgumentException("No data found for Sheet with r:id " + relId);
        }
        return sheet.getInputStream();
    }

    public Iterator<InputStream> getSheetsData() throws IOException, InvalidFormatException {
        return new SheetIterator(this.workbookPart);
    }

    public static class SheetIterator
    implements Iterator<InputStream> {
        private Map<String, PackagePart> sheetMap;
        private CTSheet ctSheet;
        private Iterator<CTSheet> sheetIterator;

        private SheetIterator(PackagePart wb) throws IOException {
            try {
                this.sheetMap = new HashMap<String, PackagePart>();
                for (PackageRelationship rel : wb.getRelationships()) {
                    if (!rel.getRelationshipType().equals(XSSFRelation.WORKSHEET.getRelation()) && !rel.getRelationshipType().equals(XSSFRelation.CHARTSHEET.getRelation())) continue;
                    PackagePartName relName = PackagingURIHelper.createPartName((URI)rel.getTargetURI());
                    this.sheetMap.put(rel.getId(), wb.getPackage().getPart(relName));
                }
                CTWorkbook wbBean = ((WorkbookDocument)WorkbookDocument.Factory.parse(wb.getInputStream())).getWorkbook();
                this.sheetIterator = wbBean.getSheets().getSheetList().iterator();
            }
            catch (InvalidFormatException e) {
                throw new POIXMLException((Throwable)e);
            }
            catch (XmlException e) {
                throw new POIXMLException((Throwable)e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.sheetIterator.hasNext();
        }

        @Override
        public InputStream next() {
            this.ctSheet = this.sheetIterator.next();
            String sheetId = this.ctSheet.getId();
            try {
                PackagePart sheetPkg = this.sheetMap.get(sheetId);
                return sheetPkg.getInputStream();
            }
            catch (IOException e) {
                throw new POIXMLException((Throwable)e);
            }
        }

        public String getSheetName() {
            return this.ctSheet.getName();
        }

        public CommentsTable getSheetComments() {
            PackagePart sheetPkg = this.getSheetPart();
            try {
                PackageRelationshipCollection commentsList = sheetPkg.getRelationshipsByType(XSSFRelation.SHEET_COMMENTS.getRelation());
                if (commentsList.size() > 0) {
                    PackageRelationship comments = commentsList.getRelationship(0);
                    PackagePartName commentsName = PackagingURIHelper.createPartName((URI)comments.getTargetURI());
                    PackagePart commentsPart = sheetPkg.getPackage().getPart(commentsName);
                    return new CommentsTable(commentsPart);
                }
            }
            catch (InvalidFormatException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
            return null;
        }

        public PackagePart getSheetPart() {
            String sheetId = this.ctSheet.getId();
            return this.sheetMap.get(sheetId);
        }

        @Override
        public void remove() {
            throw new IllegalStateException("Not supported");
        }
    }
}

