/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.services;

import com.nexacro.java.xeni.data.GridExportDataFactory;
import com.nexacro.java.xeni.export.GridExportBase;
import com.nexacro.java.xeni.util.XeniUtils;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExportImportFileManager
extends TimerTask {
    private static final Log oLogger = LogFactory.getLog(ExportImportFileManager.class);
    private static ExportImportFileManager INSTANCE = null;
    private static Timer TIMER = null;
    private String sExportPath = null;
    private String sImportPath = null;
    private int m_iStorageTime = 0;
    SimpleDateFormat m_oSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private boolean bFileManage = true;

    public static synchronized ExportImportFileManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ExportImportFileManager();
        }
        return INSTANCE;
    }

    public synchronized Timer newTimerInstance() {
        if (TIMER == null) {
            TIMER = new Timer();
        }
        return TIMER;
    }

    public Timer getTimer() {
        return TIMER;
    }

    public void setServiceDir(String exportDir, String importDir, boolean bManage) {
        this.sExportPath = exportDir;
        this.sImportPath = importDir + '/';
        this.bFileManage = bManage;
    }

    public void setServiceDir(String exportDir, boolean bManage) {
        this.sExportPath = exportDir;
        this.bFileManage = bManage;
    }

    public void setStorageTime(int iStorageTime) {
        this.m_iStorageTime = iStorageTime;
    }

    @Override
    public void run() {
        if (oLogger.isInfoEnabled()) {
            oLogger.info((Object)("run file manager [ " + this.m_oSdf.format(System.currentTimeMillis()) + " ]"));
        }
        this.removeUncompletedChunkedData();
        if (this.bFileManage) {
            this.deleteExportFile();
            this.deleteImportFile();
        }
    }

    public void deleteExportFile() {
        if (oLogger.isDebugEnabled()) {
            oLogger.debug((Object)"Find file has been exported.");
        }
        File oExportDir = null;
        try {
            oExportDir = XeniUtils.getXeniFileHandler(this.sExportPath).toFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!oExportDir.exists()) {
            boolean bMkDir;
            if (oLogger.isInfoEnabled()) {
                oLogger.info((Object)StringUtils.normalizeSpace((String)("The directory does not exist [ " + this.sExportPath + " ]")));
            }
            if (bMkDir = oExportDir.mkdir()) {
                if (oLogger.isInfoEnabled()) {
                    oLogger.info((Object)"'Export' path has been created.");
                }
            } else {
                if (oLogger.isWarnEnabled()) {
                    oLogger.warn((Object)StringUtils.normalizeSpace((String)("Fail to creat directory [ " + this.sExportPath + " ]")));
                    oLogger.warn((Object)"File Monitor Thread Terminated.");
                }
                this.getTimer().cancel();
                return;
            }
        }
        this.deleteFile(oExportDir);
    }

    private void deleteFile(File folder) {
        boolean bDeleted = false;
        File[] oTargetDirs = folder.listFiles();
        if (oTargetDirs != null) {
            for (File file : oTargetDirs) {
                if (file.isDirectory()) {
                    this.deleteFile(file);
                    continue;
                }
                if (!bDeleted) {
                    Calendar oCalendar = Calendar.getInstance();
                    Date dtCurrTime = oCalendar.getTime();
                    oCalendar.setTimeInMillis(file.lastModified());
                    oCalendar.add(13, this.m_iStorageTime);
                    Date dtExportfileAddTime = oCalendar.getTime();
                    if (dtCurrTime.getTime() < dtExportfileAddTime.getTime()) continue;
                    if (file.delete()) {
                        bDeleted = true;
                        if (!oLogger.isInfoEnabled()) continue;
                        oLogger.info((Object)("Succeeded in deleting files [ " + file.getName() + " ]"));
                        continue;
                    }
                    if (!oLogger.isWarnEnabled()) continue;
                    oLogger.warn((Object)("Failed to delete the file is in using [ " + file.getName() + " ]"));
                    continue;
                }
                file.delete();
            }
        }
        if (bDeleted) {
            folder.delete();
        }
    }

    public void removeUncompletedChunkedData() {
        HashMap<String, GridExportBase> oHmDataFactory = GridExportDataFactory.getExportDataFactoryInstance().getExportDataFactory();
        if (oLogger.isDebugEnabled()) {
            oLogger.debug((Object)"Find chunk data uncompleted");
        }
        Set<String> oKeySet = oHmDataFactory.keySet();
        Iterator<String> oKeyIter = oKeySet.iterator();
        while (oKeyIter.hasNext()) {
            String sInstanceid = oKeyIter.next();
            GridExportBase oExportData = oHmDataFactory.get(sInstanceid);
            Calendar oCal = Calendar.getInstance();
            Date dtCurrentTime = oCal.getTime();
            long lnLastTime = oExportData.getAccessTime();
            oCal.setTimeInMillis(lnLastTime);
            Date dtLastAccTime = oCal.getTime();
            oCal.add(13, this.m_iStorageTime);
            Date dtLastAccAddTime = oCal.getTime();
            if (dtCurrentTime.getTime() < dtLastAccAddTime.getTime()) continue;
            oKeyIter.remove();
            if (!oLogger.isInfoEnabled()) continue;
            oLogger.info((Object)StringUtils.normalizeSpace((String)("Succeeded in deleting uncompleted chunk data [ " + sInstanceid + " ]")));
        }
    }

    public void deleteImportFile() {
        if (oLogger.isDebugEnabled()) {
            oLogger.debug((Object)"Find file has been imported.");
        }
        File oImportDir = null;
        try {
            oImportDir = XeniUtils.getXeniFileHandler(this.sImportPath).toFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!oImportDir.exists()) {
            boolean bMkDir;
            if (oLogger.isInfoEnabled()) {
                oLogger.info((Object)StringUtils.normalizeSpace((String)("The directory does not exist [ " + this.sImportPath + " ]")));
            }
            if (bMkDir = oImportDir.mkdir()) {
                if (oLogger.isInfoEnabled()) {
                    oLogger.info((Object)"'Import' path has been created.");
                }
            } else {
                if (oLogger.isWarnEnabled()) {
                    oLogger.warn((Object)StringUtils.normalizeSpace((String)("Fail to creat directory [ " + this.sImportPath + " ]")));
                    oLogger.warn((Object)"File Monitor Thread Terminated.");
                }
                this.getTimer().cancel();
                return;
            }
        }
        this.deleteFile(oImportDir);
    }
}

