/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.services;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.DataSetList;
import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.data.VariableList;
import com.nexacro.java.xapi.tx.DataSerializer;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xapi.tx.PlatformRequest;
import com.nexacro.java.xapi.tx.impl.PlatformJsonDataSerializer;
import com.nexacro.java.xapi.tx.impl.PlatformSsvDataSerializer;
import com.nexacro.java.xapi.tx.impl.PlatformXmlDataSerializer;
import com.nexacro.java.xeni.data.GridExportDataFactory;
import com.nexacro.java.xeni.data.GridImportFormatFactory;
import com.nexacro.java.xeni.export.GridExportBase;
import com.nexacro.java.xeni.export.GridExportContext;
import com.nexacro.java.xeni.export.GridExportTypeFactory;
import com.nexacro.java.xeni.extend.XeniExcelDataStorageBase;
import com.nexacro.java.xeni.extend.XeniExtendLoader;
import com.nexacro.java.xeni.extend.XeniMultipartProcBase;
import com.nexacro.java.xeni.extend.XeniMultipartReqData;
import com.nexacro.java.xeni.provider.ServletProvider;
import com.nexacro.java.xeni.services.ExportImportConfiguration;
import com.nexacro.java.xeni.util.CommUtil;
import com.nexacro.java.xeni.util.XeniErrorProperties;
import com.nexacro.java.xeni.util.XeniProperties;
import com.nexacro.java.xeni.util.XeniUtils;
import com.nexacro.java.xeni.ximport.GridImportBase;
import com.nexacro.java.xeni.ximport.GridImportContext;
import com.nexacro.java.xeni.ximport.GridImportTypeFactory;
import com.nexacro.java.xeni.ximport.PlatformCsvDataSerializer;
import com.nexacro.java.xeni.ximport.impl.GridImportExcelXSSFEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.openxml4j.util.ZipSecureFile;

public class GridExportImportAgent {
    private static final Log logger = LogFactory.getLog(GridExportImportAgent.class);
    private String errorMsg = "";
    private String securityPattern = XeniProperties.getStringProperty("xeni.security.pattern");
    private String securityPattern2;

    public GridExportImportAgent() {
        if (this.securityPattern == null || this.securityPattern.length() <= 0) {
            this.securityPattern = "'|\"|:|;|\\(|\\)|<|>|\\[|\\]|\\{|\\}|`|=|#|\\$|%|&|\\?|!|@|\\*|\t|\\||%27|%22|%3a|%3b|%28|%29|%3c|%3e|%5b|%5d|%7b|%7d|%60|%3d|%23|%24|%25|%26|%3f|%21|%40|%2a|%09|%7c|&#x|27;|&#x22;|&#x3a;|&#x3b;|&#x28;|&#x29;|&#x3c;|&#x3e;|&#x5b;|&#x5d;|&#x7b;|&#x7d;|&#x60;|&#x3d;|&#x23;|&#x24;|&#x25;|&#x26;|&#x3f;|&#x21;|&#x40;|&#x2a;|&#x09;|&#x7c;|script|javascript|vbscript|livescript|iframe|mocha|applet|img|embed|object|marquee|qss|body|input|form|div|style|table|isindex|meta|http-equiv|xss|href";
            this.securityPattern2 = "'|\"|:|;|<|>|`|=|#|\\$|%|&|\\?|!|@|\\*|\t|\\||%27|%22|%3a|%3b|%28|%29|%3c|%3e|%5b|%5d|%7b|%7d|%60|%3d|%23|%24|%25|%26|%3f|%21|%40|%2a|%09|%7c|&#x|27;|&#x22;|&#x3a;|&#x3b;|&#x28;|&#x29;|&#x3c;|&#x3e;|&#x5b;|&#x5d;|&#x7b;|&#x7d;|&#x60;|&#x3d;|&#x23;|&#x24;|&#x25;|&#x26;|&#x3f;|&#x21;|&#x40;|&#x2a;|&#x09;|&#x7c;|script|javascript|vbscript|livescript|iframe|mocha|applet|img|embed|object|marquee|qss|body|input|form|div|style|table|isindex|meta|http-equiv|xss|href";
        } else {
            this.securityPattern2 = this.securityPattern;
        }
        String maxEntryStr = XeniProperties.getStringProperty("xeni.guard.maxentry.size", null);
        String maxTextStr = XeniProperties.getStringProperty("xeni.guard.maxtext.size", null);
        String minRatioStr = XeniProperties.getStringProperty("xeni.guard.mininflate.ratio", null);
        if (maxEntryStr != null) {
            ZipSecureFile.setMaxEntrySize((long)Long.parseLong(maxEntryStr));
        }
        if (maxTextStr != null) {
            ZipSecureFile.setMaxTextSize((long)Long.parseLong(maxTextStr));
        }
        if (minRatioStr != null) {
            ZipSecureFile.setMinInflateRatio((double)Double.parseDouble(minRatioStr));
        }
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    public int gridExport(ServletProvider svltProvider, ExportImportConfiguration config) throws PlatformException, IOException {
        int errorCode = 0;
        PlatformRequest platformReq = new PlatformRequest((InputStream)svltProvider.getHttpServletRequest().getInputStream());
        platformReq.receiveData();
        PlatformData objReqData = platformReq.getData();
        if (objReqData == null) {
            this.errorMsg = XeniErrorProperties.getErrorProperty("err.agent.no.data");
            return -2006;
        }
        DataSetList dsList = objReqData.getDataSetList();
        VariableList varList = objReqData.getVariableList();
        DataSet dsCommand = dsList.get("COMMAND");
        if (dsCommand == null) {
            this.errorMsg = XeniErrorProperties.getErrorProperty("err.agent.no.data");
            return -2006;
        }
        String sCommand = dsCommand.getString(0, "command");
        if (!sCommand.equals("export")) {
            this.errorMsg = XeniErrorProperties.getErrorProperty("err.agent.not.exporttype", sCommand);
            return -2006;
        }
        String instanceId = dsCommand.getString(0, "instanceid");
        if (instanceId == null || instanceId.equals("")) {
            instanceId = this.createInstanceId(svltProvider);
        }
        if (logger.isInfoEnabled()) {
            String item = dsCommand.getString(0, "item");
            String seq = dsCommand.getString(0, "seq");
            String eof = dsCommand.getString(0, "eof");
            String url = dsCommand.getString(0, "url");
            String instid = dsCommand.getString(0, "instanceid");
            logger.info((Object)("Input export data : [ Item = " + StringUtils.normalizeSpace((String)item) + ", Seq. = " + StringUtils.normalizeSpace((String)seq) + ", EOF = " + StringUtils.normalizeSpace((String)eof) + ", Url = " + StringUtils.normalizeSpace((String)url) + ", Inst.Id = " + StringUtils.normalizeSpace((String)instid) + " ]"));
        }
        GridExportBase exporter = null;
        DataSet dsStyle = dsList.get("STYLE");
        DataSet dsCell = dsList.get("CELL");
        HashMap<String, GridExportBase> dataFactory = GridExportDataFactory.getExportDataFactoryInstance().getExportDataFactory();
        if (dataFactory.containsKey(instanceId)) {
            exporter = dataFactory.get(instanceId);
            GridExportContext context = exporter.getExportContext();
            context.setAbsolutePath(config.getExportPath());
            context.setDownloadUrl(config.getExportUrl());
            context.setUserVariableList(varList);
            errorCode = exporter.startExport(svltProvider, dsCommand, dsStyle, dsCell);
            if (!exporter.isEof() && errorCode == 0) {
                exporter.setAccessTime(System.currentTimeMillis());
            } else {
                dataFactory.remove(instanceId);
            }
        } else {
            int exportType = dsCommand.getInt(0, "type");
            exporter = GridExportTypeFactory.getGridExporter(exportType);
            if (exporter == null) {
                this.errorMsg = XeniErrorProperties.getErrorProperty("err.agent.fail.create.exporter", Integer.toHexString(exportType));
                if (logger.isErrorEnabled()) {
                    logger.error((Object)StringUtils.normalizeSpace((String)this.errorMsg));
                }
                return -2008;
            }
            dsCommand.set(0, "instanceid", instanceId);
            GridExportContext context = this.getExportContext(dsCommand, varList, platformReq.getContentType(), config);
            errorCode = exporter.initialize(context, dsCommand);
            if (errorCode >= 0) {
                errorCode = exporter.startExport(svltProvider, dsCommand, dsStyle, dsCell);
            }
            if (!exporter.isEof() && errorCode == 0) {
                exporter.setAccessTime(System.currentTimeMillis());
                dataFactory.put(instanceId, exporter);
            }
        }
        if (errorCode != 0) {
            this.errorMsg = exporter.getErrorMessage();
            if (dataFactory.containsKey(instanceId)) {
                dataFactory.remove(instanceId);
            }
        }
        return errorCode;
    }

    private GridExportContext getExportContext(DataSet command, VariableList varlist, String type, ExportImportConfiguration config) {
        GridExportContext context = new GridExportContext();
        context.setCsvQuote(config.isCsvQuote());
        context.setCsvBom(config.isCsvBom());
        context.setRequestPlatformType(type);
        context.setResponsePlatformType(XeniProperties.getStringProperty("xeni.export.commdataformat"));
        context.setAbsolutePath(config.getExportPath());
        context.setDownloadUrl(config.getExportUrl());
        context.setOutsidePath(config.isExportAbsPath());
        context.setUserVariableList(varlist);
        context.setAppendUrl(command.getString(0, "url"));
        context.setExportType(command.getInt(0, "type"));
        context.setItemName(command.getString(0, "item"));
        context.setFileName(command.getString(0, "exportfilename"));
        context.setInstanceId(command.getString(0, "instanceid"));
        String headSummary = command.getString(0, "exporthead");
        if (headSummary != null) {
            context.setNoHead(headSummary.contains("nohead"));
            context.setNoSummary(headSummary.contains("nosumm"));
        }
        context.setTopSummary("top".equals(command.getString(0, "summarytype")));
        if ("both".equals(command.getString(0, "exportsize"))) {
            context.setApplyHeight(true);
        } else if ("height".equals(command.getString(0, "exportsize"))) {
            context.setApplyWidth(false);
            context.setApplyHeight(true);
        }
        context.setWrapText(command.getBoolean(0, "wraptext"));
        context.setRtl(command.getBoolean(0, "righttoleft"));
        context.setPassword(command.getString(0, "password"));
        context.setCommandVersion(command.getFloat(0, "commandversion"));
        return context;
    }

    public int gridImport(ServletProvider svltProvider, ExportImportConfiguration config) throws IOException, PlatformException, Exception {
        int errorCode;
        XeniMultipartProcBase multiPartProc = XeniExtendLoader.getMultipartProcFactory().getMultipartProc("xeni.multipart.proc");
        if (multiPartProc == null) {
            this.errorMsg = "Could not create extend class : " + XeniProperties.getStringProperty("xeni.multipart.proc");
            return -3101;
        }
        XeniMultipartReqData reqData = multiPartProc.getImportData(svltProvider.getHttpServletRequest());
        if (reqData == null) {
            this.errorMsg = XeniErrorProperties.getErrorProperty("err.agent.request.data.null");
            return -3101;
        }
        PlatformData cmdData = reqData.getPlatformData();
        if (cmdData == null) {
            this.errorMsg = XeniErrorProperties.getErrorProperty("err.agent.command.data.null");
            return -3101;
        }
        VariableList varList = cmdData.getVariableList();
        DataSetList dsList = cmdData.getDataSetList();
        DataSet dsCmd = dsList.get("COMMAND");
        GridImportContext context = this.getImportContext(dsCmd, varList, config);
        if (logger.isInfoEnabled()) {
            String mode = dsCmd.getString(0, "filemode");
            String url = dsCmd.getString(0, "url");
            String html = dsCmd.getString(0, "usehtmltag");
            String rawnum = dsCmd.getString(0, "rawnumbervalue");
            logger.info((Object)("Input import data : [ Mode = " + StringUtils.normalizeSpace((String)mode) + ", Url = " + StringUtils.normalizeSpace((String)url) + ", Html tag = " + StringUtils.normalizeSpace((String)html) + ", Raw num = " + StringUtils.normalizeSpace((String)rawnum) + " ]"));
        }
        if (!"import".equals(dsCmd.getString(0, "command"))) {
            this.errorMsg = "Not import type. The type is " + dsCmd.getString(0, "command");
            return this.sendImportError(svltProvider, -2006, this.errorMsg, context);
        }
        if (!context.isServerMode() && (errorCode = this.saveImportStream(this.createInstanceId(svltProvider), varList, config.isTempName(), context, reqData)) < 0) {
            return this.sendImportError(svltProvider, errorCode, this.errorMsg, context);
        }
        GridImportBase gridImporter = null;
        try {
            gridImporter = this.getGridImporter(context);
        }
        catch (FileNotFoundException ex) {
            this.errorMsg = "File or directory not found. [" + context.getFileUrl() + "]";
            return this.sendImportError(svltProvider, -2003, this.errorMsg, context);
        }
        catch (Exception e) {
            if (context.isFileMonitor() && !context.isServerMode()) {
                CommUtil.deleteDir(context.getFilePath() + context.getFileUrl());
            }
            this.errorMsg = e.getMessage();
            return this.sendImportError(svltProvider, -2005, this.errorMsg, context);
        }
        if (!(gridImporter instanceof GridImportExcelXSSFEvent)) {
            context.setPartData(false);
        }
        if (context.isPartData()) {
            context.setServletProvider(svltProvider);
            context.initPartDataSerializer();
        }
        context.setPlatformData(new PlatformData());
        gridImporter.initialize(context);
        int errorCode2 = gridImporter.startImport();
        errorCode2 = this.sendImportResponse(svltProvider, context, errorCode2, gridImporter.getErrorMessage());
        if (config.isFileManage() && !context.isServerMode()) {
            CommUtil.deleteDir(context.getFilePath() + context.getFileUrl());
        }
        if (errorCode2 < 0) {
            errorCode2 = this.sendImportError(svltProvider, errorCode2, this.errorMsg, context);
        }
        return errorCode2;
    }

    private GridImportContext getImportContext(DataSet dscmd, VariableList varlist, ExportImportConfiguration config) throws UnsupportedEncodingException {
        GridImportContext context = new GridImportContext();
        context.setCsvQuote(config.isCsvQuote());
        context.setFilePath(config.getImportPath());
        context.setFileMonitor(config.isFileManage());
        context.setImportId(dscmd.getString(0, "importid"));
        context.setUserDomain(varlist.getString("domain"));
        context.setImportType(dscmd.getInt(0, "type"));
        context.setFilePassword(dscmd.getString(0, "password"));
        context.setResponseContentType(XeniProperties.getStringProperty("xeni.import.commdataformat", "ssv"));
        context.setCommandVersion(dscmd.getFloat(0, "commandversion"));
        context.setCompatibleMode(varlist.getInt("compatiblemode"));
        context.setSentData(false);
        String value = null;
        value = dscmd.getString(0, "filemode");
        if ("local".equals(value)) {
            context.setServerMode(false);
        } else {
            context.setServerMode(true);
            context.setFileUrl(URLDecoder.decode(dscmd.getString(0, "url"), "UTF-8"));
        }
        value = dscmd.getString(0, "responsetype");
        if (value != null) {
            context.setCorsResponseType(Integer.parseInt(value));
        }
        value = dscmd.getString(0, "format");
        if (context.getCommandVersion() == 2.0f) {
            value = new String(Base64.getDecoder().decode(value), StandardCharsets.UTF_8);
        } else if (context.getCommandVersion() == 3.0f) {
            value = new String(new Base32().decode(value), StandardCharsets.UTF_8);
        }
        context.setImportFormat(new GridImportFormatFactory().readFormatString(value));
        value = dscmd.getString(0, "rawdatevalue");
        if (value != null && "true".equals(value)) {
            context.setRawDateValue(true);
        }
        if ((value = dscmd.getString(0, "usehtmltag")) == null || "false".equals(value)) {
            context.setUseHtmlTag(false);
        }
        if ((value = dscmd.getString(0, "rawnumbervalue")) != null && "false".equals(value)) {
            context.setRawNumberValue(false);
        }
        context.setSeparator(dscmd.getString(0, "separator"));
        context.setQuoteChar(dscmd.getString(0, "quotechar"));
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int saveImportStream(String instanceId, VariableList varlist, boolean tempname, GridImportContext ctxt, XeniMultipartReqData data) {
        InputStream inputStream = data.getFileStream();
        if (inputStream == null) {
            this.errorMsg = "Upload file stream is null.";
            return -3101;
        }
        String fileName = data.getFileName();
        if (tempname) {
            String fileExt = "";
            int nIdx = fileName.lastIndexOf(46);
            if (nIdx > 0) {
                fileExt = fileName.substring(nIdx);
            }
            fileName = "import_temp" + fileExt;
        }
        if (!this.isValidFileName(fileName)) {
            return -3101;
        }
        XeniExcelDataStorageBase extend = XeniExtendLoader.getExcelDataStorageFactory().getExtendClass("xeni.exportimport.storage");
        if (extend == null) {
            this.errorMsg = "Could not create extend class : " + XeniProperties.getStringProperty("xeni.exportimport.storage");
            return -3101;
        }
        try {
            String fileUrl = "/" + instanceId + "/" + fileName;
            String dbKey = extend.saveImportStream(varlist, inputStream, ctxt.getFilePath() + fileUrl);
            if (dbKey != null) {
                fileUrl = dbKey;
            }
            ctxt.setFileUrl(fileUrl);
        }
        catch (Exception e) {
            this.errorMsg = e.getMessage();
            int n = -3101;
            return n;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                }
            }
        }
        return 0;
    }

    private GridImportBase getGridImporter(GridImportContext ctxt) throws Exception {
        GridImportBase importer = GridImportTypeFactory.getGridImporter(ctxt.getImportType(), ctxt.getFilePath(), ctxt.getFileUrl(), ctxt.getFilePassword());
        if (importer == null || importer.getErrorCode() < 0) {
            this.errorMsg = XeniErrorProperties.getErrorProperty("err.agent.fail.create.importer");
            this.errorMsg = importer != null ? this.errorMsg + " [" + importer.getErrorMessage() + "]" : this.errorMsg + " [" + XeniErrorProperties.getErrorProperty("err.agent.unsupported.format") + "]";
            if (logger.isErrorEnabled()) {
                logger.error((Object)StringUtils.normalizeSpace((String)this.errorMsg));
            }
            throw new Exception(this.errorMsg);
        }
        return importer;
    }

    private int sendImportResponse(ServletProvider svltProvider, GridImportContext ctxt, int error, String msg) {
        if (error == 0 && ctxt.isPartData()) {
            return 0;
        }
        try {
            VariableList varList = ctxt.getPlatformData().getVariableList();
            if (error == 0) {
                ctxt.getPlatformData().getDataSet("IMPORTFILES").set(0, "importid", ctxt.getImportId());
                varList.add("ErrorCode", 0);
                varList.add("ErrorMsg", "SUCCESS");
            } else {
                varList.add("ErrorCode", error);
                varList.add("ErrorMsg", msg);
                int index = ctxt.getPartIndex();
                if (ctxt.isPartData() && index >= 1) {
                    this.sendPartData(varList, ctxt, index);
                    return 0;
                }
            }
            String contentType = ctxt.getResponseContentType();
            if (ctxt.getCorsResponseType() == 1) {
                this.sendCorsReviseResponse(svltProvider, ctxt.getPlatformData(), contentType);
            } else {
                String domain = ctxt.getUserDomain();
                if (domain != null && domain.length() > 0) {
                    this.sendDomainResponse(svltProvider, ctxt.getPlatformData(), domain, contentType);
                } else {
                    this.sendCommonResponse(svltProvider, ctxt.getPlatformData(), contentType, ctxt.isUseHtmlTag());
                }
            }
        }
        catch (PlatformException e) {
            this.errorMsg = e.getMessage();
            return -3101;
        }
        catch (Exception e) {
            this.errorMsg = "" + e;
            return -2001;
        }
        return 0;
    }

    private String createInstanceId(ServletProvider svltProvider) {
        return UUID.randomUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendExportFileStream(ServletProvider svltProvider, String abspath) throws IOException {
        Map<String, String> params = this.getQueryParameters(svltProvider.getHttpServletRequest().getQueryString());
        if (params == null) {
            this.errorMsg = "Invalid export file parameter.";
            return -3201;
        }
        int nErrCode = 0;
        String sCmd = params.get("command");
        if (sCmd == null || !sCmd.equals("export")) {
            this.errorMsg = sCmd != null && this.isContainSecureCharacter(sCmd) ? XeniErrorProperties.getErrorProperty("err.agent.fail.excute.command", "") : XeniErrorProperties.getErrorProperty("err.agent.fail.excute.command", sCmd);
            return -3201;
        }
        String sKey = params.get("key");
        if (sKey == null || sKey.contains(".") || sKey.contains("/")) {
            this.errorMsg = this.isContainSecureCharacter(sKey) ? XeniErrorProperties.getErrorProperty("err.agent.invalid.export.key", "") : XeniErrorProperties.getErrorProperty("err.agent.invalid.export.key", sKey);
            return -3201;
        }
        String sPOrgName = params.get("name");
        String sPName = "";
        try {
            sPName = URLDecoder.decode(sPOrgName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.errorMsg = this.isContainSecureCharacter(sPName) ? XeniErrorProperties.getErrorProperty("err.agent.fail.decode.name", "") : XeniErrorProperties.getErrorProperty("err.agent.fail.decode.name", sPName);
            return -3201;
        }
        if (sPName == null || sPName.contains(".") || sPName.contains("/")) {
            this.errorMsg = this.isContainSecureCharacter(sPName) ? XeniErrorProperties.getErrorProperty("err.agent.invalid.filename", "") : XeniErrorProperties.getErrorProperty("err.agent.invalid.filename", sPName);
            return -3201;
        }
        String sType = params.get("type");
        if (sType == null) {
            this.errorMsg = XeniErrorProperties.getErrorProperty("err.agent.invalid.filetype", "");
            return -3201;
        }
        int nExtType = 1;
        try {
            nExtType = Integer.parseInt(sType);
        }
        catch (NumberFormatException e) {
            this.errorMsg = this.isContainSecureCharacter(sType) ? XeniErrorProperties.getErrorProperty("err.agent.invalid.filetype", "") : XeniErrorProperties.getErrorProperty("err.agent.invalid.filetype", sType);
            return -3201;
        }
        String sExtType = "";
        String contenttype = "";
        if (nExtType == 0) {
            sExtType = ".xls";
            contenttype = "application/vnd.ms-excel";
        } else if (nExtType == 1) {
            sExtType = ".xlsx";
            contenttype = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        } else if (nExtType == 2) {
            sExtType = ".cell";
            contenttype = "application/vnd.ms-excel";
        } else if (nExtType == 3) {
            sExtType = ".cell";
            contenttype = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        } else if (nExtType == 4) {
            sExtType = ".csv";
            svltProvider.getHttpServletResponse().setContentType("text/csv");
        } else if (nExtType == 5) {
            sExtType = ".txt";
            svltProvider.getHttpServletResponse().setContentType("text/csv");
        } else {
            this.errorMsg = XeniErrorProperties.getErrorProperty("err.agent.invalid.filetype", Integer.toString(nExtType));
            return -3201;
        }
        String sExportFilePath = abspath + sKey + "/" + sPName + sExtType;
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(XeniUtils.getXeniFileHandler(sExportFilePath).toFile());
            svltProvider.getHttpServletResponse().setContentType(StringUtils.normalizeSpace((String)contenttype));
            String fileName = "attachment; filename=" + URLEncoder.encode(sPName, "UTF-8").replaceAll("\\+", "%20") + sExtType;
            svltProvider.getHttpServletResponse().addHeader("Content-Disposition", StringUtils.normalizeSpace((String)fileName));
            svltProvider.writeOutputStream(fin);
        }
        catch (FileNotFoundException e) {
            this.errorMsg = this.isContainSecureCharacter(sKey) || this.isContainSecureCharacter(sPName) ? XeniErrorProperties.getErrorProperty("err.agent.file.notfound", "") : XeniErrorProperties.getErrorProperty("err.agent.file.notfound", sKey + "/" + sPName + sExtType);
            nErrCode = -2001;
        }
        catch (IOException e) {
            this.errorMsg = e.getMessage();
            nErrCode = -2003;
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
                svltProvider.closeOutputStream();
            }
            catch (IOException e) {
                this.errorMsg = e.getMessage();
                nErrCode = -2003;
            }
        }
        if (nErrCode == 0) {
            CommUtil.deleteDir(abspath + sKey);
        }
        return nErrCode;
    }

    private Map<String, String> getQueryParameters(String query) {
        if (query == null || query.length() <= 0) {
            return null;
        }
        String[] items = query.split("&");
        if (items != null && items.length > 0) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            for (String item : items) {
                String[] values = item.split("=");
                String key = values[0];
                String value = "";
                if (values.length > 1) {
                    value = values[1];
                }
                paramMap.put(key, value);
            }
            return paramMap;
        }
        return null;
    }

    private boolean isContainSecureCharacter(String src) {
        Pattern pattern = Pattern.compile("(?i)(" + this.securityPattern + "){1,}");
        Matcher matcher = pattern.matcher(src);
        return matcher.find();
    }

    private String containSecureCharacter2(String src) {
        Pattern pattern = Pattern.compile("(?i)(" + this.securityPattern2 + "){1,}");
        Matcher matcher = pattern.matcher(src);
        String matchStr = "";
        if (matcher.find()) {
            if (matchStr.length() > 0) {
                matchStr = matchStr + ", ";
            }
            matchStr = matchStr + matcher.group();
        }
        return matchStr;
    }

    private int sendImportError(ServletProvider svltProvider, int code, String msg, GridImportContext ctx) throws Exception {
        PlatformData resData = new PlatformData();
        VariableList varList = resData.getVariableList();
        varList.add("ErrorCode", code);
        varList.add("ErrorMsg", msg);
        String contentType = ctx.getResponseContentType();
        if (ctx.getCorsResponseType() == 1) {
            this.sendCorsReviseResponse(svltProvider, resData, contentType);
            return 0;
        }
        String domain = ctx.getUserDomain();
        if (domain != null && domain.length() > 0) {
            this.sendDomainResponse(svltProvider, resData, domain, contentType);
        } else {
            this.sendCommonResponse(svltProvider, resData, contentType, ctx.isUseHtmlTag());
        }
        return 0;
    }

    public void sendDomainResponse(ServletProvider svltProvider, PlatformData data, String domain, String type) throws Exception {
        svltProvider.getHttpServletResponse().setContentType("text/html; charset=UTF-8");
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)svltProvider.getHttpServletResponse().getOutputStream(), "UTF-8");
        DataSerializer serializer = this.getImportDataSerializer(type);
        XeniUtils.XeniEncoder encoder = XeniUtils.getXeniEncoder("js");
        encoder.encodeTo(writer, "<html><script>document.domain = \"" + domain + "\";</script>");
        serializer.writeData((Writer)writer, data, null, "UTF-8");
        encoder.encodeTo(writer, "</html>");
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    private void sendCommonResponse(ServletProvider svltProvider, PlatformData data, String type, boolean usetag) throws IOException, PlatformException {
        svltProvider.getHttpServletResponse().setContentType("text/html; charset=UTF-8");
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)svltProvider.getHttpServletResponse().getOutputStream(), "UTF-8");
        DataSerializer serializer = this.getImportDataSerializer(type);
        XeniUtils.XeniEncoder encoder = XeniUtils.getXeniEncoder("js");
        if (usetag) {
            encoder.encodeTo(writer, "<!--[if lt IE 9]><comment><![endif]--><noscript>");
        }
        serializer.writeData((Writer)writer, data, null, "UTF-8");
        if (usetag) {
            encoder.encodeTo(writer, "</noscript></comment>");
        }
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    private void sendCorsReviseResponse(ServletProvider svltProvider, PlatformData data, String type) throws Exception {
        DataSerializer serializer = this.getImportDataSerializer(type);
        svltProvider.getHttpServletResponse().setContentType("text/html; charset=UTF-8");
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)svltProvider.getHttpServletResponse().getOutputStream(), "UTF-8");
        XeniUtils.XeniEncoder encoder = XeniUtils.getXeniEncoder("js");
        encoder.encodeTo(writer, "<script type=\"text/javascript\">");
        encoder.encodeTo(writer, "var retValue = \"\";");
        encoder.encodeTo(writer, "window.onload = function() { ");
        encoder.encodeTo(writer, "if (window.addEventListener) { ");
        encoder.encodeTo(writer, "window.addEventListener (\"message\", OnMessage, false); }");
        encoder.encodeTo(writer, "else { ");
        encoder.encodeTo(writer, "if (window.attachEvent) { ");
        encoder.encodeTo(writer, "window.attachEvent(\"onmessage\", OnMessage); }");
        encoder.encodeTo(writer, " } }; ");
        encoder.encodeTo(writer, "function OnMessage (event) { ");
        encoder.encodeTo(writer, "message = `");
        StringWriter out = new StringWriter();
        serializer.writeData((Writer)out, data, null, "UTF-8");
        encoder.encodeTo(writer, out.toString().replace("`", "\\`").replace("${", "\\${"));
        encoder.encodeTo(writer, "`;");
        encoder.encodeTo(writer, "message = event.data + message;");
        encoder.encodeTo(writer, "event.source.postMessage (message, event.origin); }");
        encoder.encodeTo(writer, "</script>");
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    private boolean isValidFileName(String name) {
        String sExt = "";
        int nIdx = name.lastIndexOf(46);
        if (nIdx > 0) {
            sExt = name.substring(nIdx + 1);
        }
        if (!(sExt.length() > 0 && ("xls".equalsIgnoreCase(sExt) || "xlsx".equalsIgnoreCase(sExt) || "cell".equalsIgnoreCase(sExt) || "csv".equalsIgnoreCase(sExt) || "xlsm".equalsIgnoreCase(sExt) || "txt".equalsIgnoreCase(sExt)))) {
            this.errorMsg = XeniErrorProperties.getErrorProperty("err.agent.invalid.filename", name);
            return false;
        }
        String patternGrp = this.containSecureCharacter2(name);
        if (patternGrp.length() > 0) {
            this.errorMsg = XeniErrorProperties.getErrorProperty("err.agent.violate.security") + "[" + patternGrp + "]";
            return false;
        }
        return true;
    }

    private String getResponsePlatformType(String key) {
        String type = "PlatformSsv";
        String commType = XeniProperties.getStringProperty(key);
        if (commType != null) {
            if ("xml".equalsIgnoreCase(commType)) {
                type = "PlatformXml";
            } else if ("json".equalsIgnoreCase(commType)) {
                type = "PlatformJson";
            } else if ("binary".equalsIgnoreCase(commType)) {
                type = "PlatformBinary";
            }
        }
        return type;
    }

    private DataSerializer getImportDataSerializer(String type) {
        Object serializer = null;
        serializer = "csv".equalsIgnoreCase(type) ? new PlatformCsvDataSerializer() : ("xml".equalsIgnoreCase(type) ? new PlatformXmlDataSerializer() : ("json".equalsIgnoreCase(type) ? new PlatformJsonDataSerializer() : new PlatformSsvDataSerializer()));
        return serializer;
    }

    private String getHeaderContentType(String type) {
        String header = "text/html;charset=UTF-8";
        if ("ssv".equalsIgnoreCase(type)) {
            header = "text/plain;charset=UTF-8";
        } else if ("xml".equalsIgnoreCase(type)) {
            header = "text/xml;charset=UTF-8";
        } else if ("json".equalsIgnoreCase(type)) {
            header = "application/json;charset=UTF-8";
        }
        return header;
    }

    private void sendPartData(VariableList list, GridImportContext context, int index) throws IOException, PlatformException {
        XeniUtils.XeniEncoder encoder = XeniUtils.getXeniEncoder("js");
        if (index < 2) {
            StringWriter partWriter = new StringWriter();
            CommUtil.writePartDataHead(partWriter, context);
            encoder.encodeTo(context.getResponseWriter(), partWriter.toString());
        }
        StringWriter out = new StringWriter();
        CommUtil.writePartDataVariableList(out, context, list);
        if (context.getCorsResponseType() == 1) {
            encoder.encodeTo(context.getResponseWriter(), out.toString());
            encoder.encodeTo(context.getResponseWriter(), "`;");
            encoder.encodeTo(context.getResponseWriter(), "message = event.data + message;");
            encoder.encodeTo(context.getResponseWriter(), "event.source.postMessage (message, event.origin); }");
            encoder.encodeTo(context.getResponseWriter(), "</script>");
        } else {
            encoder.encodeTo(context.getResponseWriter(), out.toString());
            if (context.getUserDomain() != null) {
                encoder.encodeTo(context.getResponseWriter(), "</html>");
            } else if (context.isUseHtmlTag()) {
                encoder.encodeTo(context.getResponseWriter(), "</noscript></comment>");
            }
        }
        out.getBuffer().delete(0, out.getBuffer().length());
    }
}

