/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.services;

import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.data.VariableList;
import com.nexacro.java.xapi.tx.HttpPlatformResponse;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xeni.provider.ServletProvider;
import com.nexacro.java.xeni.services.ExportImportConfiguration;
import com.nexacro.java.xeni.services.ExportImportFileManager;
import com.nexacro.java.xeni.services.GridExportImportAgent;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.fileupload2.jakarta.JakartaServletFileUpload;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GridExportImportServlet
extends HttpServlet {
    private static final long serialVersionUID = -8877137699076711995L;
    private static final Log logger = LogFactory.getLog(GridExportImportServlet.class);
    private static final ExportImportConfiguration configuration = new ExportImportConfiguration();

    public void init() throws ServletException {
        super.init();
        this.setConfiguration();
    }

    public void destroy() {
        Timer timer;
        ExportImportFileManager objFileMonitor = ExportImportFileManager.getInstance();
        if (objFileMonitor != null && (timer = objFileMonitor.getTimer()) != null) {
            timer.cancel();
        }
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.setExportImportPath(request);
            GridExportImportAgent agent = new GridExportImportAgent();
            ServletProvider svltProvider = new ServletProvider(request, response);
            int nErrCode = agent.sendExportFileStream(svltProvider, configuration.getExportPath());
            if (nErrCode < 0) {
                this.sendErrorMessage(response, nErrCode, agent.getErrorMessage());
            }
        }
        catch (Exception e) {
            this.sendErrorMessage(response, -2001, e + "");
            System.out.println(e.getMessage());
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (PlatformException pe) {
            this.sendErrorMessage(response, -3101, "Platform Error ( " + pe.getMessage() + " )");
            System.out.println(pe.getMessage());
        }
        catch (IllegalArgumentException iae) {
            this.sendErrorMessage(response, -3201, "Illegal Argument ( " + iae.getMessage() + " )");
            System.out.println(iae.getMessage());
        }
        catch (IndexOutOfBoundsException iobe) {
            this.sendErrorMessage(response, -3301, "Index Out Of Bounds ( " + iobe.getMessage() + " )");
            System.out.println(iobe.getMessage());
        }
        catch (IllegalStateException ise) {
            this.sendErrorMessage(response, -3401, "Illegal State ( " + ise.getMessage() + " )");
            System.out.println(ise.getMessage());
        }
        catch (NullPointerException npe) {
            this.sendErrorMessage(response, -2004, npe + "");
            System.out.println(npe.getMessage());
        }
        catch (IOException ioe) {
            this.sendErrorMessage(response, -2003, ioe + "");
            System.out.println(ioe.getMessage());
        }
        catch (Exception e) {
            this.sendErrorMessage(response, -2001, e + "");
            System.out.println(e.getMessage());
        }
    }

    private void sendErrorMessage(HttpServletResponse response, int errCode, String errMsg) {
        block3: {
            PlatformData objResData = new PlatformData();
            VariableList varList = objResData.getVariableList();
            varList.add("ErrorCode", errCode);
            varList.add("ErrorMsg", errMsg);
            HttpPlatformResponse oPlatformRes = new HttpPlatformResponse(response, "PlatformSsv", "UTF-8");
            oPlatformRes.setData(objResData);
            if (logger.isInfoEnabled()) {
                logger.info((Object)StringUtils.normalizeSpace((String)errMsg));
            }
            try {
                oPlatformRes.sendData();
            }
            catch (PlatformException e1) {
                if (!logger.isInfoEnabled()) break block3;
                logger.info((Object)StringUtils.normalizeSpace((String)e1.getMessage()));
            }
        }
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        int nErrCode = 0;
        long lStartTime = System.currentTimeMillis();
        this.setExportImportPath(request);
        if (configuration.isFileManage()) {
            this.executeTimerSchedule(configuration);
        }
        String sCommand = null;
        GridExportImportAgent agent = new GridExportImportAgent();
        ServletProvider svltProvider = new ServletProvider(request, response);
        boolean isMultipart = JakartaServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (isMultipart) {
            sCommand = "import";
            nErrCode = agent.gridImport(svltProvider, configuration);
        } else {
            sCommand = "export";
            nErrCode = agent.gridExport(svltProvider, configuration);
        }
        if (nErrCode < 0) {
            this.sendErrorMessage(response, nErrCode, agent.getErrorMessage());
        }
        if (logger.isInfoEnabled()) {
            long lEndTime = System.currentTimeMillis();
            long lElapsedTime = lEndTime - lStartTime;
            logger.info((Object)StringUtils.normalizeSpace((String)(sCommand + " running time.......[ " + lElapsedTime + " ]")));
        }
    }

    private void setConfiguration() {
        String[] times;
        int chIdx;
        String paramValue = null;
        ServletContext context = this.getServletContext();
        paramValue = context.getInitParameter("export-path");
        if (paramValue == null || paramValue.equalsIgnoreCase("")) {
            paramValue = "export/";
        } else {
            if (paramValue.startsWith("file://")) {
                paramValue = paramValue.substring(7);
                configuration.setExportAbsPath(true);
            } else if (paramValue.startsWith("/")) {
                paramValue = paramValue.substring(1);
            }
            if (!paramValue.endsWith("/")) {
                paramValue = paramValue + "/";
            }
        }
        configuration.setExportParamPath(paramValue);
        paramValue = context.getInitParameter("import-path");
        if (paramValue == null || paramValue.equals("")) {
            paramValue = "import";
        } else if (paramValue.startsWith("file://")) {
            if (!(paramValue = paramValue.substring(7)).endsWith("/")) {
                paramValue = paramValue + "/";
            }
            configuration.setImportAbsPath(true);
        } else {
            if (paramValue.startsWith("/")) {
                paramValue = paramValue.substring(1);
            }
            if (paramValue.endsWith("/")) {
                paramValue = paramValue.substring(0, paramValue.lastIndexOf(47));
            }
        }
        configuration.setImportParamPath(paramValue);
        configuration.setExportParamUrl(context.getInitParameter("export-url"));
        paramValue = context.getInitParameter("monitor-enabled");
        if (paramValue != null && "false".equalsIgnoreCase(paramValue)) {
            configuration.setFileManage(false);
        }
        if ((paramValue = context.getInitParameter("monitor-cycle-time")) != null && paramValue.length() > 0) {
            chIdx = paramValue.indexOf(47);
            if (chIdx > 0) {
                times = paramValue.split("/");
                if (times.length > 1 && times[1].equalsIgnoreCase("sec")) {
                    configuration.setManagePeriodTime(Integer.parseInt(times[0]));
                } else {
                    configuration.setManagePeriodTime(Integer.parseInt(times[0]) * 60);
                }
            } else {
                configuration.setManagePeriodTime(Integer.parseInt(paramValue) * 60);
            }
        }
        if ((paramValue = context.getInitParameter("file-storage-time")) != null && paramValue.length() > 0) {
            chIdx = paramValue.indexOf(47);
            if (chIdx > 0) {
                times = paramValue.split("/");
                if (times.length > 1 && times[1].equalsIgnoreCase("sec")) {
                    configuration.setFileArchiveTime(Integer.parseInt(times[0]));
                } else {
                    configuration.setFileArchiveTime(Integer.parseInt(times[0]) * 60);
                }
            } else {
                configuration.setFileArchiveTime(Integer.parseInt(paramValue) * 60);
            }
        }
        if ((paramValue = context.getInitParameter("numFmt-lang")) != null && paramValue.length() > 0) {
            configuration.setFormatLanguage(paramValue);
        }
        if ((paramValue = context.getInitParameter("csv-quote")) != null && "false".equalsIgnoreCase(paramValue)) {
            configuration.setCsvQuote(false);
        }
        if ((paramValue = context.getInitParameter("csv-bom")) != null && "false".equalsIgnoreCase(paramValue)) {
            configuration.setCsvBom(false);
        }
        if ((paramValue = context.getInitParameter("import-temp-name")) != null && "true".equalsIgnoreCase(paramValue)) {
            configuration.setTempName(true);
        }
    }

    private void setExportImportPath(HttpServletRequest request) throws Exception {
        String contextPath = null;
        if (request.getSession() == null) {
            logger.info((Object)"Request session is null");
        } else if (request.getSession().getServletContext() == null) {
            logger.info((Object)"Servlet context is null");
        } else {
            contextPath = request.getSession().getServletContext().getRealPath("/");
        }
        if (contextPath == null) {
            if (!configuration.isExportAbsPath() || !configuration.isImportAbsPath()) {
                logger.error((Object)"Unable to get real path of the context. Set absolute paths for 'export-path' and 'import-path'");
                throw new Exception("Unable to get real path of the context. Set absolute paths for 'export-path' and 'import-path'");
            }
        } else if (!(contextPath = contextPath.replaceAll("\\\\", "/")).endsWith("/")) {
            contextPath = contextPath + "/";
        }
        if (configuration.isExportAbsPath()) {
            configuration.setExportPath(configuration.getExportParamPath());
        } else {
            configuration.setExportPath(contextPath + configuration.getExportParamPath());
        }
        if (configuration.isImportAbsPath()) {
            configuration.setImportPath(configuration.getImportParamPath());
        } else {
            configuration.setImportPath(contextPath + configuration.getImportParamPath());
        }
        String requestUrl = configuration.getExportParamUrl();
        if (requestUrl == null || "".equals(requestUrl)) {
            StringBuffer url = new StringBuffer();
            String scheme = request.getScheme();
            int port = request.getServerPort();
            if (port < 0) {
                port = 80;
            }
            url.append(scheme).append("://");
            url.append(request.getServerName());
            if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
                url.append(':');
                url.append(port);
            }
            if (configuration.isExportAbsPath()) {
                url.append(request.getRequestURI());
            } else {
                url.append(request.getContextPath()).append("/");
            }
            requestUrl = url.toString();
        }
        if (configuration.isExportAbsPath()) {
            configuration.setExportUrl(requestUrl);
        } else {
            String contextUrl = requestUrl.substring(0, requestUrl.lastIndexOf("/") + 1);
            configuration.setExportUrl(contextUrl + configuration.getExportParamPath());
        }
    }

    private ExportImportConfiguration getConfiguration(HttpServletRequest request) throws Exception {
        String[] times;
        ExportImportConfiguration config = new ExportImportConfiguration();
        ServletContext context = this.getServletContext();
        String paramExport = context.getInitParameter("export-path");
        if (paramExport == null || paramExport.equalsIgnoreCase("")) {
            paramExport = "export/";
        } else {
            if (paramExport.startsWith("file://")) {
                paramExport = paramExport.substring(7);
                config.setExportAbsPath(true);
            } else if (paramExport.startsWith("/")) {
                paramExport = paramExport.substring(1);
            }
            if (!paramExport.endsWith("/")) {
                paramExport = paramExport + "/";
            }
        }
        String paramImport = context.getInitParameter("import-path");
        if (paramImport == null || paramImport.equals("")) {
            paramImport = "import";
        } else if (paramImport.startsWith("file://")) {
            if (!(paramImport = paramImport.substring(7)).endsWith("/")) {
                paramImport = paramImport + "/";
            }
            config.setImportAbsPath(true);
        } else {
            if (paramImport.startsWith("/")) {
                paramImport = paramImport.substring(1);
            }
            if (paramImport.endsWith("/")) {
                paramImport = paramImport.substring(0, paramImport.lastIndexOf(47));
            }
        }
        String paramUrl = context.getInitParameter("export-url");
        String contextPath = null;
        if (request.getSession() == null) {
            logger.info((Object)"Request session is null");
        } else if (request.getSession().getServletContext() == null) {
            logger.info((Object)"Servlet context is null");
        } else {
            contextPath = request.getSession().getServletContext().getRealPath("/");
        }
        if (contextPath == null) {
            if (!config.isExportAbsPath() || !config.isImportAbsPath()) {
                logger.error((Object)"Unable to get real path of the context. Set absolute paths for 'export-path' and 'import-path'");
                throw new Exception("Unable to get real path of the context. Set absolute paths for 'export-path' and 'import-path'");
            }
        } else if (!(contextPath = contextPath.replaceAll("\\\\", "/")).endsWith("/")) {
            contextPath = contextPath + "/";
        }
        if (config.isExportAbsPath()) {
            config.setExportPath(paramExport);
        } else {
            config.setExportPath(contextPath + paramExport);
        }
        if (config.isImportAbsPath()) {
            config.setImportPath(paramImport);
        } else {
            config.setImportPath(contextPath + paramImport);
        }
        String requestUrl = null;
        requestUrl = paramUrl != null && !"".equals(paramUrl) ? paramUrl : request.getRequestURL().toString();
        if (config.isExportAbsPath()) {
            config.setExportUrl(requestUrl);
        } else {
            String contextUrl = requestUrl.substring(0, requestUrl.lastIndexOf("/") + 1);
            config.setExportUrl(contextUrl + paramExport);
        }
        String paramValue = context.getInitParameter("monitor-enabled");
        if (paramValue != null && "false".equalsIgnoreCase(paramValue)) {
            config.setFileManage(false);
        }
        if ((paramValue = context.getInitParameter("monitor-cycle-time")) != null && paramValue.length() > 0) {
            int chIdx = paramValue.indexOf(47);
            if (chIdx > 0) {
                times = paramValue.split("/");
                if (times.length > 1 && times[1].equalsIgnoreCase("sec")) {
                    config.setManagePeriodTime(Integer.parseInt(times[0]));
                } else {
                    config.setManagePeriodTime(Integer.parseInt(times[0]) * 60);
                }
            } else {
                config.setManagePeriodTime(Integer.parseInt(paramValue) * 60);
            }
        }
        if ((paramValue = context.getInitParameter("file-storage-time")) != null && paramValue.length() > 0) {
            int chIdx = paramValue.indexOf(47);
            if (chIdx > 0) {
                times = paramValue.split("/");
                if (times.length > 1 && times[1].equalsIgnoreCase("sec")) {
                    config.setFileArchiveTime(Integer.parseInt(times[0]));
                } else {
                    config.setFileArchiveTime(Integer.parseInt(times[0]) * 60);
                }
            } else {
                config.setFileArchiveTime(Integer.parseInt(paramValue) * 60);
            }
        }
        if ((paramValue = context.getInitParameter("numFmt-lang")) != null && paramValue.length() > 0) {
            config.setFormatLanguage(paramValue);
        }
        if ((paramValue = context.getInitParameter("csv-quote")) != null && "false".equalsIgnoreCase(paramValue)) {
            config.setCsvQuote(false);
        }
        if ((paramValue = context.getInitParameter("csv-bom")) != null && "false".equalsIgnoreCase(paramValue)) {
            config.setCsvBom(false);
        }
        if ((paramValue = context.getInitParameter("import-temp-name")) != null && "true".equalsIgnoreCase(paramValue)) {
            config.setTempName(true);
        }
        return config;
    }

    private void executeTimerSchedule(ExportImportConfiguration config) {
        ExportImportFileManager objFileMonitor = ExportImportFileManager.getInstance();
        Timer objTimer = objFileMonitor.getTimer();
        if (objTimer == null) {
            objTimer = objFileMonitor.newTimerInstance();
            objFileMonitor.setServiceDir(config.getExportPath(), config.getImportPath(), config.isFileManage());
            objFileMonitor.setStorageTime(config.getFileArchiveTime());
            objTimer.scheduleAtFixedRate((TimerTask)objFileMonitor, config.getManagePeriodTime() * 1000, (long)(config.getManagePeriodTime() * 1000));
        }
    }
}

