/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.util;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.VariableList;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xeni.util.XeniUtils;
import com.nexacro.java.xeni.ximport.GridImportContext;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CommUtil {
    public static String generateSerialNo() {
        SimpleDateFormat dayTime = new SimpleDateFormat("yyMMddHHmmssSSS");
        String strDT = dayTime.format(new Date(System.currentTimeMillis()));
        int id = new SecureRandom().nextInt();
        String serial = String.format("%s%02d", strDT, id);
        return serial;
    }

    public static boolean isNumber(String sValue) {
        if (sValue.length() < 1) {
            return false;
        }
        for (int nIdx = 0; nIdx < sValue.length(); ++nIdx) {
            if (Character.isDigit(sValue.charAt(nIdx))) continue;
            return false;
        }
        return true;
    }

    public static String getDataRange(String range, int[] start, int[] end) {
        if (range == null || "".equals(range)) {
            return null;
        }
        String[] sItems = range.split("\\!");
        String sheet = sItems[0];
        if (sItems.length > 1 && !"".equals(sItems[1])) {
            String[] sCells = sItems[1].split("\\:");
            CommUtil.getRangeIndex(sCells[0], start);
            if (sCells.length > 1) {
                CommUtil.getRangeIndex(sCells[1], end);
            }
        }
        return sheet;
    }

    public static void getRangeIndex(String range, int[] arr) {
        String sCol = "";
        String sRow = "";
        for (int nIdx = 0; nIdx < range.length(); ++nIdx) {
            char cChar = range.charAt(nIdx);
            if (Character.isDigit(cChar)) {
                sRow = range.substring(nIdx);
                break;
            }
            sCol = sCol + cChar;
        }
        if (!"".equals(sCol)) {
            arr[0] = CommUtil.getColumnIndexFormChars(sCol);
        }
        if (!"".equals(sRow)) {
            arr[1] = Integer.parseInt(sRow) - 1;
        }
    }

    public static int getColumnIndexFormChars(String chars) {
        int nIndex = 0;
        int nPow = 1;
        char[] cCols = chars.toUpperCase().toCharArray();
        for (int nIdx = cCols.length - 1; nIdx >= 0; --nIdx) {
            nIndex += (cCols[nIdx] - 65 + 1) * nPow;
            nPow *= 26;
        }
        return --nIndex;
    }

    public static DataSet getDatasetImportResponse() {
        DataSet ds = new DataSet("IMPORTFILES");
        ds.addColumn("filename", 2);
        ds.addColumn("filesize", 5);
        ds.addColumn("filetype", 2);
        ds.addColumn("filepath", 2);
        ds.addColumn("importid", 2);
        ds.newRow();
        return ds;
    }

    public static DataSet getDatasetExportResponse(DataSet dscmd) {
        DataSet ds = new DataSet("RESPONSE");
        ds.addColumn("command", 2, 32);
        ds.addColumn("type", 3);
        ds.addColumn("item", 2, 256);
        ds.addColumn("instanceid", 2, 256);
        ds.addColumn("lastseq", 3);
        ds.addColumn("eof", 4);
        ds.addColumn("url", 2, 1024);
        int nNewRow = ds.newRow();
        ds.set(nNewRow, "command", dscmd.getString(0, "command"));
        ds.set(nNewRow, "type", dscmd.getInt(0, "type"));
        ds.set(nNewRow, "item", dscmd.getString(0, "item"));
        ds.set(nNewRow, "instanceid", dscmd.getString(0, "instanceid"));
        ds.set(nNewRow, "lastseq", dscmd.getInt(0, "seq"));
        ds.set(nNewRow, "eof", dscmd.getBoolean(0, "eof"));
        ds.set(nNewRow, "url", "");
        return ds;
    }

    public static void deleteDir(String filepath) throws IOException {
        File delDir = null;
        File target = XeniUtils.getXeniFileHandler(filepath).toFile();
        delDir = target.isDirectory() ? target : target.getParentFile();
        if (delDir != null) {
            File[] arrFiles = delDir.listFiles();
            if (arrFiles != null) {
                for (File file : arrFiles) {
                    file.delete();
                }
            }
            delDir.delete();
        }
    }

    public static void writePartDataHead(StringWriter outwriter, GridImportContext context) throws PlatformException {
        if (context.getCorsResponseType() == 1) {
            outwriter.write("<script type=\"text/javascript\">");
            outwriter.write("var retValue = \"\";");
            outwriter.write("window.onload = function() { ");
            outwriter.write("if (window.addEventListener) { ");
            outwriter.write("window.addEventListener (\"message\", OnMessage, false); }");
            outwriter.write("else { ");
            outwriter.write("if (window.attachEvent) { ");
            outwriter.write("window.attachEvent(\"onmessage\", OnMessage); }");
            outwriter.write(" } }; ");
            outwriter.write("function OnMessage (event) { ");
            outwriter.write("message = `");
        } else if (context.getUserDomain() != null) {
            outwriter.write("<html><script>document.domain = \"" + context.getUserDomain() + "\";</script>");
        } else if (context.isUseHtmlTag()) {
            outwriter.write("<!--[if lt IE 9]><comment><![endif]--><noscript>");
        }
        context.getPartDataSerializer().setWriter((Writer)outwriter);
        context.getPartDataSerializer().writeHead();
    }

    public static void writePartDataTail(StringWriter outwriter, GridImportContext context) throws PlatformException {
        context.getPartDataSerializer().setWriter((Writer)outwriter);
        context.getPartDataSerializer().writeTail();
        if (context.getCorsResponseType() == 1) {
            outwriter.write("`;");
            outwriter.write("message = event.data + message;");
            outwriter.write("event.source.postMessage (message, event.origin); }");
            outwriter.write("</script>");
        } else if (context.getUserDomain() != null) {
            outwriter.write("</html>");
        } else if (context.isUseHtmlTag()) {
            outwriter.write("</noscript></comment>");
        }
    }

    public static void writePartDataVariableList(StringWriter outwriter, GridImportContext context, VariableList list) throws PlatformException {
        StringWriter writer = null;
        if (context.getCorsResponseType() == 1) {
            writer = new StringWriter();
            context.getPartDataSerializer().setWriter((Writer)writer);
        } else {
            context.getPartDataSerializer().setWriter((Writer)outwriter);
        }
        for (int i = 0; i < list.size(); ++i) {
            context.getPartDataSerializer().writeVariable(list.get(i));
        }
        if (context.getCorsResponseType() == 1) {
            outwriter.append(writer.toString().replace("`", "\\`").replace("${", "\\${"));
        }
    }

    public static void writePartDataDataset(StringWriter outwriter, GridImportContext context, DataSet ds) throws PlatformException {
        StringWriter writer = null;
        if (context.getCorsResponseType() == 1) {
            writer = new StringWriter();
            context.getPartDataSerializer().setWriter((Writer)writer);
        } else {
            context.getPartDataSerializer().setWriter((Writer)outwriter);
        }
        context.getPartDataSerializer().writeDataSet(ds);
        ds.clearData();
        if (context.getCorsResponseType() == 1) {
            outwriter.write(writer.toString().replace("`", "\\`").replace("${", "\\${"));
        }
    }
}

