/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.util;

import com.nexacro.java.xapi.util.JavaEnvUtils;
import com.nexacro.java.xeni.util.XeniProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XeniErrorProperties {
    private static final String DEFAULT_ERROR_PROPERTIES = "en";
    private static final String DEFAULT_VALUE_STRING = "";
    private static final String RESNAME_EN = "error_en.properties";
    private static final String RESNAME_KO = "error_ko.properties";
    private static final String RESNAME_ZH = "error_zh.properties";
    private static Map errorMap;

    private XeniErrorProperties() {
    }

    public static String getErrorProperty(String key) {
        return XeniErrorProperties.getStringProperty(key);
    }

    public static String getErrorProperty(String key, String param0) {
        String error = XeniErrorProperties.getStringProperty(key);
        return error.replace("{0}", param0 == null ? "{}" : param0);
    }

    public static String getErrorProperty(String key, String param0, String param1) {
        String error = XeniErrorProperties.getStringProperty(key);
        return error.replace("{0}", param0 == null ? "{}" : param0).replace("{1}", param1 == null ? "{}" : param1);
    }

    public static Object getProperty(String key) {
        return errorMap.get(key);
    }

    public static String getStringProperty(String key) {
        return XeniErrorProperties.getStringProperty(key, DEFAULT_VALUE_STRING);
    }

    public static String getStringProperty(String key, String defValue) {
        Object value = XeniErrorProperties.getProperty(key);
        return value == null ? defValue : value.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(URL resource) {
        if (resource == null) {
            return;
        }
        InputStream in = null;
        try {
            in = resource.openStream();
            Properties properties = new Properties();
            properties.load(in);
            errorMap.putAll(properties);
        }
        catch (IOException ex) {
            Log log = LogFactory.getLog(XeniErrorProperties.class);
            if (log.isTraceEnabled()) {
                log.trace((Object)"Could not load properties file", (Throwable)ex);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    System.out.println(ex.getMessage());
                }
            }
        }
    }

    private static URL getResource(String name) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = null;
        try {
            url = XeniErrorProperties.getJarLocationResource(name);
            if (url == null) {
                url = XeniErrorProperties.getClasspathResource(name);
            }
            if (url == null) {
                url = loader.getResource("com/nexacro/java/xeni/util/error_en.properties");
            }
            return url;
        }
        catch (Throwable th) {
            Log log = LogFactory.getLog(XeniErrorProperties.class);
            if (log.isTraceEnabled()) {
                log.trace((Object)"Could not find properties file", th);
            }
            return null;
        }
    }

    private static URL getJarLocationResource(String name) {
        block13: {
            int start;
            int index;
            String urlFile;
            String path = XeniErrorProperties.class.getName().replace('.', '/') + ".class";
            URL url = XeniErrorProperties.class.getClassLoader().getResource(path);
            Log log = LogFactory.getLog(XeniErrorProperties.class);
            if (log.isDebugEnabled()) {
                log.debug((Object)("getJarLocationResource(): path=" + path + ", url=" + url));
            }
            String protocol = url.getProtocol();
            String file = urlFile = url.getFile();
            if (JavaEnvUtils.isAtLeastJavaVersion((String)"1.4")) {
                try {
                    file = URLDecoder.decode(file, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Could not decode filename: urlFile=" + urlFile), (Throwable)ex);
                    }
                }
            } else {
                file = URLDecoder.decode(file);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("getJarLocationResource(): protocol=" + protocol + ", file=" + file + ", urlFile=" + urlFile));
            }
            if ((index = file.indexOf("!/", start = file.startsWith("file:") ? "file:".length() : 0)) > 0) {
                String jarPath = file.substring(start, index);
                File jarFile = new File(jarPath);
                File porpFile = new File(jarFile.getParent(), name);
                boolean propExists = porpFile.exists();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getJarLocationResource(): jarFile=" + jarFile + ", licenseFile=" + porpFile + ", licenseExists=" + propExists));
                }
                if (propExists) {
                    try {
                        URL porpUrl = porpFile.toURL();
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Loaded property file in JAR dir: path=" + porpFile.getAbsolutePath()));
                        }
                        return porpUrl;
                    }
                    catch (MalformedURLException ex) {
                        if (!log.isInfoEnabled()) break block13;
                        log.info((Object)("Could not find property file in JAR dir: " + ex.getMessage()));
                    }
                }
            }
        }
        return null;
    }

    private static URL getClasspathResource(String name) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Log log = LogFactory.getLog(XeniErrorProperties.class);
        try {
            URL url = loader.getResource(name);
            if (url != null && log.isInfoEnabled()) {
                log.info((Object)("Loaded property file in CLASSPATH: path=" + url));
            }
            return url;
        }
        catch (Throwable th) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Could not find property file in CLASSPATH: " + th.getMessage()));
            }
            return null;
        }
    }

    static {
        String propname;
        errorMap = new HashMap();
        switch (propname = XeniProperties.getStringProperty("xeni.error.language", DEFAULT_ERROR_PROPERTIES)) {
            case "ko": {
                XeniErrorProperties.load(XeniErrorProperties.getResource(RESNAME_KO));
                break;
            }
            case "zh": {
                XeniErrorProperties.load(XeniErrorProperties.getResource(RESNAME_ZH));
                break;
            }
            default: {
                XeniErrorProperties.load(XeniErrorProperties.getResource(RESNAME_EN));
            }
        }
    }
}

