/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.util;

import com.nexacro.java.xapi.util.JavaEnvUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XeniProperties {
    private static final String PROPERTIES_NAME = "xeni.properties";
    private static final String DEFAULT_VALUE_STRING = null;
    private static final char DEFAULT_VALUE_CHAR = ' ';
    private static final int DEFAULT_VALUE_INT = 0;
    private static final boolean DEFAULT_VALUE_BOOLEAN = false;
    private static Map propMap = new HashMap();

    private XeniProperties() {
    }

    public static Object getProperty(String key) {
        return propMap.get(key);
    }

    public static void setProperty(String key, Object value) {
        propMap.put(key, value);
    }

    public static void setProperty(String key, int value) {
        XeniProperties.setProperty(key, new Integer(value));
    }

    public static void setProperty(String key, boolean value) {
        XeniProperties.setProperty(key, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public static void removeProperty(String key) {
        propMap.remove(key);
    }

    public static String getStringProperty(String key) {
        return XeniProperties.getStringProperty(key, DEFAULT_VALUE_STRING);
    }

    public static String getStringProperty(String key, String defValue) {
        Object value = XeniProperties.getProperty(key);
        return value == null ? defValue : value.toString();
    }

    public static char getCharProperty(String key) {
        return XeniProperties.getCharProperty(key, ' ');
    }

    public static char getCharProperty(String key, char defValue) {
        Object value = XeniProperties.getProperty(key);
        if (value instanceof String) {
            String str = value.toString();
            if (str.length() > 1) {
                str = str.trim();
            }
            if (str.length() == 1) {
                return str.charAt(0);
            }
        } else if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        return defValue;
    }

    public static int getIntProperty(String key) {
        return XeniProperties.getIntProperty(key, 0);
    }

    public static int getIntProperty(String key, int defValue) {
        Object value = XeniProperties.getProperty(key);
        if (value instanceof String) {
            try {
                return Integer.parseInt(value.toString());
            }
            catch (NumberFormatException ex) {
                System.out.println(ex.getMessage());
            }
        } else if (value instanceof Integer) {
            return (Integer)value;
        }
        return defValue;
    }

    public static boolean getBooleanProperty(String key) {
        return XeniProperties.getBooleanProperty(key, false);
    }

    public static boolean getBooleanProperty(String key, boolean defValue) {
        Object value = XeniProperties.getProperty(key);
        if (value instanceof String) {
            String str = value.toString().toLowerCase();
            return "true".equals(str) || "on".equals(str) || "yes".equals(str);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return defValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(URL resource) {
        if (resource == null) {
            return;
        }
        InputStream in = null;
        try {
            in = resource.openStream();
            Properties properties = new Properties();
            properties.load(in);
            propMap.putAll(properties);
        }
        catch (IOException ex) {
            Log log = LogFactory.getLog(XeniProperties.class);
            if (log.isTraceEnabled()) {
                log.trace((Object)"Could not load properties file", (Throwable)ex);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    System.out.println(ex.getMessage());
                }
            }
        }
    }

    private static URL getResource(String name) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = null;
        try {
            url = XeniProperties.getJarLocationResource(name);
            if (url == null) {
                url = XeniProperties.getClasspathResource(name);
            }
            return url;
        }
        catch (Throwable th) {
            Log log = LogFactory.getLog(XeniProperties.class);
            if (log.isTraceEnabled()) {
                log.trace((Object)"Could not find properties file", th);
            }
            return null;
        }
    }

    private static URL getJarLocationResource(String name) {
        block13: {
            int start;
            int index;
            String urlFile;
            String path = XeniProperties.class.getName().replace('.', '/') + ".class";
            URL url = XeniProperties.class.getClassLoader().getResource(path);
            Log log = LogFactory.getLog(XeniProperties.class);
            if (log.isDebugEnabled()) {
                log.debug((Object)("getJarLocationResource(): path=" + StringUtils.normalizeSpace((String)(path + ", url=" + url))));
            }
            String protocol = url.getProtocol();
            String file = urlFile = url.getFile();
            if (JavaEnvUtils.isAtLeastJavaVersion((String)"1.4")) {
                try {
                    file = URLDecoder.decode(file, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Could not decode filename: urlFile=" + urlFile), (Throwable)ex);
                    }
                }
            } else {
                file = URLDecoder.decode(file);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("getJarLocationResource(): protocol=" + StringUtils.normalizeSpace((String)protocol) + ", file=" + StringUtils.normalizeSpace((String)file) + ", urlFile=" + StringUtils.normalizeSpace((String)urlFile)));
            }
            if ((index = file.indexOf("!/", start = file.startsWith("file:") ? "file:".length() : 0)) > 0) {
                String jarPath = file.substring(start, index);
                File jarFile = new File(jarPath);
                File porpFile = new File(jarFile.getParent(), name);
                boolean propExists = porpFile.exists();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getJarLocationResource(): jarFile=" + jarFile + ", licenseFile=" + porpFile + ", licenseExists=" + propExists));
                }
                if (propExists) {
                    try {
                        URL porpUrl = porpFile.toURL();
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Loaded property file in JAR dir: path=" + StringUtils.normalizeSpace((String)porpFile.getAbsolutePath())));
                        }
                        return porpUrl;
                    }
                    catch (MalformedURLException ex) {
                        if (!log.isInfoEnabled()) break block13;
                        log.info((Object)("Could not find property file in JAR dir: " + ex.getMessage()));
                    }
                }
            }
        }
        return null;
    }

    private static URL getClasspathResource(String name) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Log log = LogFactory.getLog(XeniProperties.class);
        try {
            URL url = loader.getResource(name);
            if (url != null && log.isInfoEnabled()) {
                log.info((Object)("Loaded property file in CLASSPATH: path=" + url));
            }
            return url;
        }
        catch (Throwable th) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Could not find property file in CLASSPATH: " + th.getMessage()));
            }
            return null;
        }
    }

    static {
        XeniProperties.load(XeniProperties.getResource(PROPERTIES_NAME));
    }
}

