/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.util;

import com.nexacro.java.xeni.util.PathSanitizer;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XeniUtils {
    private static XeniFileHandlerFactory fileHandlerFactory;
    private static XeniEncoder defaultStringEncoder;
    private static XeniEncoderFactory stringEncoderFactory;

    public static XeniFileHandler getXeniFileHandler(String file) {
        if (fileHandlerFactory == null) {
            return new DefaultXeniFileHandler(file);
        }
        return fileHandlerFactory.getXeniFileHandler(file);
    }

    public static XeniEncoder getXeniEncoder(String type) {
        if (stringEncoderFactory == null) {
            return defaultStringEncoder;
        }
        return stringEncoderFactory.getEncoder(type);
    }

    private XeniUtils() {
    }

    static {
        Object factory;
        fileHandlerFactory = null;
        ServiceLoader<Object> loader = ServiceLoader.load(XeniFileHandlerFactory.class);
        Iterator<Object> iterator = loader.iterator();
        if (iterator.hasNext()) {
            factory = iterator.next();
            fileHandlerFactory = factory;
        }
        defaultStringEncoder = null;
        stringEncoderFactory = null;
        loader = ServiceLoader.load(XeniEncoderFactory.class);
        iterator = loader.iterator();
        if (iterator.hasNext()) {
            stringEncoderFactory = factory = (XeniEncoderFactory)iterator.next();
        }
        defaultStringEncoder = new DefaultXeniEncoder();
    }

    public static class DefaultXeniEncoder
    implements XeniEncoder {
        @Override
        public void encodeTo(Writer out, String str) throws IOException {
            out.write(str);
        }
    }

    public static interface XeniEncoderFactory {
        public XeniEncoder getEncoder(String var1);
    }

    public static interface XeniEncoder {
        public void encodeTo(Writer var1, String var2) throws IOException;
    }

    public static class DefaultXeniFileHandler
    implements XeniFileHandler {
        private static final Log handlerLog = LogFactory.getLog(DefaultXeniFileHandler.class);
        private static final String[] allowedExtensions = new String[]{"txt", "csv", "xeni", "xls", "xlsx", "cell"};
        private File target;

        public DefaultXeniFileHandler(String file) {
            this.setTarget(file);
        }

        protected void setTarget(String file) {
            try {
                file = PathSanitizer.getSanitizerPath(file);
            }
            catch (IOException e) {
                handlerLog.error((Object)StringUtils.normalizeSpace((String)e.getMessage()));
                return;
            }
            String extension = FilenameUtils.getExtension((String)file);
            if (extension != null && extension.length() > 0) {
                boolean allowed = false;
                for (String allowedExtension : allowedExtensions) {
                    if (!extension.equalsIgnoreCase(allowedExtension)) continue;
                    allowed = true;
                    break;
                }
                if (!allowed) {
                    handlerLog.error((Object)StringUtils.normalizeSpace((String)("Invalid file name. (" + file + ")")));
                    return;
                }
            }
            this.target = new File(file);
        }

        @Override
        public File toFile() {
            return this.target;
        }

        @Override
        public Path toPath() throws IOException {
            return this.target.toPath();
        }
    }

    public static interface XeniFileHandlerFactory {
        public XeniFileHandler getXeniFileHandler(String var1);
    }

    public static interface XeniFileHandler {
        public File toFile() throws IOException;

        public Path toPath() throws IOException;
    }
}

