/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.ximport;

import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.tx.PartDataSerializer;
import com.nexacro.java.xapi.tx.impl.PlatformSsvPartDataSerializer;
import com.nexacro.java.xapi.tx.impl.PlatformXmlPartDataSerializer;
import com.nexacro.java.xeni.data.importformats.ImportFormat;
import com.nexacro.java.xeni.provider.ServletProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class GridImportContext {
    private PartDataSerializer serializer = null;
    private ServletProvider svltProvider = null;
    private Writer responseWriter;
    private PlatformData platformdata;
    private ImportFormat format;
    private String importId;
    private String userDomain;
    private String responseContentType;
    private String filePath;
    private String fileUrl;
    private String password;
    private String quoteChar;
    private char separator = (char)44;
    private int corsResponseType = 0;
    private int partSize = 100;
    private int partIndex = -1;
    private int importType;
    private int compatibleMode = 0;
    private float commandVersion = 1.0f;
    private boolean htmlTag = true;
    private boolean sentData;
    private boolean partData;
    private boolean serverMode;
    private boolean rawDate = false;
    private boolean rawNumber = true;
    private boolean monitor;
    private boolean csvQuote = true;

    public void setPartSize(int size) {
        this.partSize = size;
    }

    public int getPartSize() {
        return this.partSize;
    }

    public void setPartIndex(int index) {
        this.partIndex = index;
    }

    public int getPartIndex() {
        return this.partIndex;
    }

    public boolean isPartData() {
        return this.partData;
    }

    public void setPartData(boolean partData) {
        this.partData = partData;
    }

    public boolean isSentData() {
        return this.sentData;
    }

    public void setSentData(boolean sendData) {
        this.sentData = sendData;
    }

    public ServletProvider getServletProvider() {
        return this.svltProvider;
    }

    public void setServletProvider(ServletProvider provider) {
        this.svltProvider = provider;
    }

    public Writer getResponseWriter() throws IOException {
        if (this.responseWriter == null) {
            this.svltProvider.getHttpServletResponse().setContentType("text/html; charset=UTF-8");
            this.responseWriter = new OutputStreamWriter((OutputStream)this.svltProvider.getHttpServletResponse().getOutputStream(), "UTF-8");
        }
        return this.responseWriter;
    }

    public String getImportId() {
        return this.importId;
    }

    public void setImportId(String importId) {
        this.importId = importId;
    }

    public String getUserDomain() {
        return this.userDomain;
    }

    public void setUserDomain(String domain) {
        this.userDomain = domain;
    }

    public String getResponseContentType() {
        return this.responseContentType;
    }

    public void setResponseContentType(String respnseContentType) {
        this.responseContentType = respnseContentType;
        if ("ssv".equals(respnseContentType) || "xml".equals(respnseContentType)) {
            this.setPartData(true);
        }
    }

    public void initPartDataSerializer() {
        if ("ssv".equals(this.responseContentType)) {
            this.serializer = new PlatformSsvPartDataSerializer();
            this.serializer.setCharset("UTF-8");
        } else if ("xml".equals(this.responseContentType)) {
            this.serializer = new PlatformXmlPartDataSerializer();
            this.serializer.setCharset("UTF-8");
        }
    }

    public void setCsvQuote(boolean quote) {
        this.csvQuote = quote;
    }

    public boolean isCsvQuote() {
        return this.csvQuote;
    }

    public String getQuoteChar() {
        return this.quoteChar;
    }

    public void setQuoteChar(String charaters) {
        this.quoteChar = charaters == null || "default".equalsIgnoreCase(charaters) ? (this.isCsvQuote() ? "\"" : "") : ("none".equalsIgnoreCase(charaters) ? "" : "" + charaters.charAt(0));
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        if (this.getImportType() == 1296 && separator != null && separator.length() > 0) {
            this.separator = (char)Integer.parseInt(separator.substring(2), 16);
        }
    }

    public PartDataSerializer getPartDataSerializer() {
        return this.serializer;
    }

    public int getCorsResponseType() {
        return this.corsResponseType;
    }

    public void setCorsResponseType(int corsResponseType) {
        this.corsResponseType = corsResponseType;
    }

    public boolean isUseHtmlTag() {
        return this.htmlTag;
    }

    public void setUseHtmlTag(boolean useHtmlTag) {
        this.htmlTag = useHtmlTag;
    }

    public void setCompatibleMode(int mode) {
        this.compatibleMode = mode;
    }

    public int getCompatibleMode() {
        return this.compatibleMode;
    }

    public void setCommandVersion(float version) {
        this.commandVersion = version;
    }

    public float getCommandVersion() {
        return this.commandVersion;
    }

    public void setPlatformData(PlatformData data) {
        this.platformdata = data;
    }

    public PlatformData getPlatformData() {
        return this.platformdata;
    }

    public void setImportFormat(ImportFormat format) {
        this.format = format;
    }

    public ImportFormat getImportFormat() {
        return this.format;
    }

    public void setImportType(int type) {
        this.importType = type;
    }

    public int getImportType() {
        return this.importType;
    }

    public void setServerMode(boolean mode) {
        this.serverMode = mode;
    }

    public boolean isServerMode() {
        return this.serverMode;
    }

    public void setFilePath(String path) {
        this.filePath = path;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFileUrl(String url) {
        this.fileUrl = url;
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public void setFilePassword(String password) {
        this.password = password;
    }

    public String getFilePassword() {
        return this.password;
    }

    public void setRawDateValue(boolean rowdate) {
        this.rawDate = rowdate;
    }

    public boolean isRawDateValue() {
        return this.rawDate;
    }

    public void setRawNumberValue(boolean rownumber) {
        this.rawNumber = rownumber;
    }

    public boolean isRawNumberValue() {
        return this.rawNumber;
    }

    public void setFileMonitor(boolean monitor) {
        this.monitor = monitor;
    }

    public boolean isFileMonitor() {
        return this.monitor;
    }
}

