/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.ximport;

import com.nexacro.java.xeni.extend.XeniExcelDataStorageBase;
import com.nexacro.java.xeni.extend.XeniExcelDataStorageDef;
import com.nexacro.java.xeni.extend.XeniExtendLoader;
import com.nexacro.java.xeni.util.PathSanitizer;
import com.nexacro.java.xeni.util.XeniErrorProperties;
import com.nexacro.java.xeni.util.XeniUtils;
import com.nexacro.java.xeni.ximport.GridImportBase;
import com.nexacro.java.xeni.ximport.impl.GridImportCSV;
import com.nexacro.java.xeni.ximport.impl.GridImportExcelHSSFEvent;
import com.nexacro.java.xeni.ximport.impl.GridImportExcelXSSFEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.UUID;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class GridImportTypeFactory {
    private GridImportTypeFactory() {
    }

    public static GridImportBase getGridImporter(int type) {
        if (type == 256 || type == 272) {
            return new GridImportExcelHSSFEvent();
        }
        if (type == 288) {
            return new GridImportExcelXSSFEvent();
        }
        if (type == 1024 || type == 1040) {
            return new GridImportExcelXSSFEvent();
        }
        if (type == 1280) {
            return new GridImportCSV();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GridImportBase getGridImporter(int importtype, String svcpath, String svcurl, String password) throws Exception {
        InputStream inputStream = null;
        String targetPath = svcurl;
        if (svcurl.startsWith("http")) {
            int lastpos = svcurl.lastIndexOf(47);
            String ip = svcurl.substring(0, lastpos + 1);
            String file = svcurl.substring(lastpos + 1);
            URL url = new URL(ip + URLEncoder.encode(file, "UTF-8").replaceAll("\\+", "%20"));
            inputStream = new BufferedInputStream(url.openStream());
            targetPath = svcpath + "/" + UUID.randomUUID().toString() + "/" + URLEncoder.encode(file, "UTF-8").replaceAll("\\+", "%20");
        } else {
            XeniExcelDataStorageBase extend;
            if (svcurl.startsWith("/")) {
                targetPath = svcpath + svcurl;
            }
            if (!((extend = XeniExtendLoader.getExcelDataStorageFactory().getExtendClass("xeni.exportimport.storage")) instanceof XeniExcelDataStorageDef)) {
                targetPath = PathSanitizer.getSanitizerPath(targetPath);
                inputStream = extend.loadTargetStream(targetPath);
                File file = XeniUtils.getXeniFileHandler(targetPath).toFile();
                if (!file.exists() && inputStream != null) {
                    targetPath = svcpath + "/" + UUID.randomUUID().toString() + "/importfile";
                }
            }
        }
        if (inputStream != null) {
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream, 8);
            }
            targetPath = targetPath + ".xeni";
            GridImportTypeFactory.saveImportStreamExt(inputStream, targetPath);
            inputStream.close();
            inputStream = null;
        }
        GridImportBase importer = null;
        InputStream dataStream = null;
        try {
            File inFile = XeniUtils.getXeniFileHandler(targetPath).toFile();
            if (FileMagic.valueOf((File)inFile) == FileMagic.OLE2) {
                POIFSFileSystem fs = new POIFSFileSystem(inFile);
                if (fs.getRoot().hasEntry("EncryptionInfo")) {
                    importer = new GridImportExcelXSSFEvent();
                    if (password == null || password.length() == 0) {
                        importer.setErrorCode(-2021);
                        importer.setErrorMessage(XeniErrorProperties.getErrorProperty("err.import.require.password"));
                        fs.close();
                        GridImportBase gridImportBase = importer;
                        return gridImportBase;
                    }
                    EncryptionInfo info = new EncryptionInfo(fs);
                    Decryptor decrypt = Decryptor.getInstance((EncryptionInfo)info);
                    if (!decrypt.verifyPassword(password)) {
                        importer.setErrorCode(-2021);
                        importer.setErrorMessage(XeniErrorProperties.getErrorProperty("err.import.doc.encrypted"));
                        GridImportBase gridImportBase = importer;
                        return gridImportBase;
                    }
                    importer.setPOIFileSystem(fs);
                    dataStream = decrypt.getDataStream(fs);
                    importer.setInputStream(dataStream);
                    OPCPackage opcPkg = OPCPackage.open((InputStream)dataStream);
                    importer.setOPCPackage(opcPkg);
                } else {
                    importer = new GridImportExcelHSSFEvent();
                    if (password != null && password.length() > 0) {
                        Biff8EncryptionKey.setCurrentUserPassword((String)password);
                    }
                    importer.setPOIFileSystem(fs);
                }
            } else if (FileMagic.valueOf((File)inFile) == FileMagic.OOXML) {
                importer = new GridImportExcelXSSFEvent();
                OPCPackage opcPkg = OPCPackage.open((File)inFile);
                importer.setOPCPackage(opcPkg);
            } else if (importtype == 1280 || importtype == 1296) {
                importer = new GridImportCSV();
                importer.setInputStream(new FileInputStream(inFile));
            }
        }
        catch (GeneralSecurityException ex) {
            if (importer != null) {
                importer.setErrorCode(-2021);
                importer.setErrorMessage(XeniErrorProperties.getErrorProperty("err.import.doc.encrypted"));
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (dataStream != null) {
                    dataStream.close();
                }
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
        return importer;
    }

    private static void saveImportStreamExt(InputStream in, String path) throws IOException {
        int read;
        File file;
        if (in == null) {
            return;
        }
        int nIdx = path.lastIndexOf("/");
        if (nIdx < 0) {
            nIdx = path.lastIndexOf(File.separator);
        }
        if (!(file = XeniUtils.getXeniFileHandler(path.substring(0, nIdx)).toFile()).exists()) {
            file.mkdirs();
        }
        file = XeniUtils.getXeniFileHandler(path).toFile();
        byte[] bytes = new byte[8192];
        FileOutputStream outStream = new FileOutputStream(file);
        while ((read = in.read(bytes)) != -1) {
            outStream.write(bytes, 0, read);
        }
        outStream.close();
    }
}

