/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.ximport;

import com.nexacro.java.xapi.data.ColumnHeader;
import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.DataSetList;
import com.nexacro.java.xapi.data.DataTypes;
import com.nexacro.java.xapi.data.PlatformData;
import com.nexacro.java.xapi.data.Variable;
import com.nexacro.java.xapi.data.VariableList;
import com.nexacro.java.xapi.tx.DataSerializer;
import com.nexacro.java.xapi.tx.DataTypeChanger;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xeni.util.XeniUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformCsvDataSerializer
implements DataSerializer {
    private Log log = LogFactory.getLog(PlatformCsvDataSerializer.class);
    private char etx = (char)3;
    private String CR = "\r\n";
    private static final int BUFFER_SIZE = 4096;
    private byte[] buffer;

    public void setProperty(String key, Object value) {
    }

    public void writeData(OutputStream out, PlatformData data, DataTypeChanger dataTypeChanger, String charset) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)StringUtils.normalizeSpace((String)("Writing data: this=" + this + ", charset=" + charset)));
        }
        try {
            this.writeData(new OutputStreamWriter(out, charset), data, dataTypeChanger, charset);
        }
        catch (UnsupportedEncodingException ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)StringUtils.normalizeSpace((String)("Unsupported charset: " + charset)), (Throwable)ex);
            }
            throw new PlatformException("Unsupported charset: " + charset, (Throwable)ex);
        }
    }

    public void writeData(Writer out, PlatformData data, DataTypeChanger dataTypeChanger, String charset) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)StringUtils.normalizeSpace((String)("Writing data: this=" + this + ", charset=" + charset)));
        }
        try {
            this.write(out, data, dataTypeChanger, charset);
        }
        catch (IOException ex) {
            String contentType = "PlatformSsv";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)StringUtils.normalizeSpace((String)("Could not serialize: contentType=" + contentType)), (Throwable)ex);
            }
            throw new PlatformException(StringUtils.normalizeSpace((String)("Could not serialize: contentType=" + contentType)), (Throwable)ex);
        }
    }

    private void write(Writer out, PlatformData data, DataTypeChanger dataTypeChanger, String charset) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"write(Writer, PlatformData, DataTypeChanger, String): started");
        }
        this.writeHeader(out, data, charset);
        this.writeVariableList(out, data, dataTypeChanger);
        this.writeDataSetList(out, data, dataTypeChanger);
        out.flush();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"write(Writer, PlatformData, DataTypeChanger, String): finished");
        }
    }

    private void writeHeader(Writer out, PlatformData data, String charset) throws IOException {
        XeniUtils.XeniEncoder encoder = XeniUtils.getXeniEncoder("csv");
        if (charset == null) {
            out.write("CSV");
        } else {
            encoder.encodeTo(out, "CSV:" + charset);
        }
    }

    private void writeVariableList(Writer out, PlatformData data, DataTypeChanger dataTypeChanger) throws IOException {
        VariableList varList = data.getVariableList();
        int count = varList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)StringUtils.normalizeSpace((String)("Writing VariableList: count=" + count)));
        }
        if (count > 0) {
            out.write(this.CR);
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    out.write(44);
                }
                this.writeVariable(out, varList.get(i), dataTypeChanger);
            }
        }
    }

    private void writeVariable(Writer out, Variable var, DataTypeChanger dataTypeChanger) throws IOException {
        if (DataTypes.isBinary((int)var.getType())) {
            this.writeBinaryVariable(out, var);
        } else {
            this.writeStringVariable(out, var);
        }
    }

    private void writeStringVariable(Writer out, Variable var) throws IOException {
        XeniUtils.XeniEncoder encoder = XeniUtils.getXeniEncoder("csv");
        String name = var.getName();
        String type = this.getDataType(var.getType());
        String value = this.getStringValue(var);
        int length = value == null ? 0 : value.length();
        StringBuffer buffer = new StringBuffer(length + 32);
        if (value == null) {
            buffer.append(name).append('=');
        } else {
            buffer.append(name).append('=').append(value);
        }
        encoder.encodeTo(out, buffer.toString());
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)StringUtils.normalizeSpace((String)("writeString(Writer, Variable): name=" + name + ", type=" + type + ", value=" + value)));
        }
    }

    private void writeBinaryVariable(Writer out, Variable var) throws IOException {
        XeniUtils.XeniEncoder encoder = XeniUtils.getXeniEncoder("csv");
        String name = var.getName();
        String type = this.getDataType(var.getType());
        byte[] value = this.getBinaryValue(var);
        if (value == null) {
            StringBuffer buffer = new StringBuffer(32);
            buffer.append(name).append('=');
            encoder.encodeTo(out, buffer.toString());
        } else {
            String encoded = Base64.encodeBase64String((byte[])value);
            int length = encoded == null ? 0 : encoded.length();
            StringBuffer buffer = new StringBuffer(length + 32);
            buffer.append(name).append('=');
            if (encoded != null) {
                buffer.append(encoded);
            }
            encoder.encodeTo(out, buffer.toString());
        }
    }

    private String getStringValue(Variable var) {
        int dataType = var.getType();
        if (dataType == 4) {
            return var.getBoolean() ? "1" : "0";
        }
        String value = var.getString();
        return value;
    }

    private byte[] getBinaryValue(Variable var) {
        return var.getBlob();
    }

    private void writeDataSetList(Writer out, PlatformData data, DataTypeChanger dataTypeChanger) throws IOException {
        DataSetList dsList = data.getDataSetList();
        int count = dsList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)StringUtils.normalizeSpace((String)("Writing DataSetList: count=" + count)));
        }
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                out.write(this.CR);
            }
            this.writeDataSet(out, data, dsList.get(i), dataTypeChanger);
        }
    }

    private void writeDataSet(Writer out, PlatformData data, DataSet ds, DataTypeChanger dataTypeChanger) throws IOException {
        String name = ds.getName();
        String alias = ds.getAlias();
        XeniUtils.XeniEncoder encoder = XeniUtils.getXeniEncoder("csv");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)StringUtils.normalizeSpace((String)("Writing DataSet: name=" + name + ", alias=" + alias + ", columnCount=" + ds.getColumnCount() + ", rowCount=" + ds.getRowCount() + ", removedRowCount=" + ds.getRemovedRowCount())));
        }
        out.write(this.CR);
        encoder.encodeTo(out, "Dataset:" + alias);
        int[] dataTypes = this.getTargetDataTypes(ds, dataTypeChanger);
        this.writeColumns(out, ds, dataTypes);
        this.writeRows(out, data, ds, dataTypes);
    }

    private void writeColumns(Writer out, DataSet ds, int[] dataTypes) throws IOException {
        int count = ds.getColumnCount();
        XeniUtils.XeniEncoder encoder = XeniUtils.getXeniEncoder("csv");
        StringBuffer defaultBuffer = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            ColumnHeader header = ds.getColumn(i);
            int dataType = dataTypes[i];
            if (i > 0) {
                defaultBuffer.append(',');
            }
            if (header.getType() == 0) {
                this.writeDefaultColumnHeader(defaultBuffer, header, dataType);
                continue;
            }
            if (header.getType() == 1) continue;
            throw new IOException("Invalid column type: " + header.getType());
        }
        if (defaultBuffer.length() > 0) {
            out.write(this.CR);
            encoder.encodeTo(out, defaultBuffer.toString());
        }
    }

    private void writeDefaultColumnHeader(StringBuffer buffer, ColumnHeader header, int dataType) throws IOException {
        String name = header.getName();
        String dataTypeStr = this.getDataType(dataType);
        int dataSize = header.getDataSize();
        buffer.append(name);
        buffer.append(':');
        buffer.append(dataTypeStr);
        buffer.append('(');
        buffer.append(dataSize);
        buffer.append(')');
    }

    private void writeRows(Writer out, PlatformData data, DataSet ds, int[] dataTypes) throws IOException {
        boolean isCheckingGetterDataIndex;
        int saveType = ds.getSaveType();
        if (saveType == 0) {
            saveType = data.getSaveType();
        }
        if (saveType == 0) {
            saveType = 2;
        }
        int count = ds.getRowCount();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)StringUtils.normalizeSpace((String)("Writing rows: count=" + count)));
        }
        if (isCheckingGetterDataIndex = ds.isCheckingGetterDataIndex()) {
            ds.setCheckingGetterDataIndex(false);
        }
        for (int i = 0; i < count; ++i) {
            this.writeRow(out, ds, dataTypes, i, saveType);
        }
        if (isCheckingGetterDataIndex) {
            ds.setCheckingGetterDataIndex(true);
        }
    }

    private void writeRow(Writer out, DataSet ds, int[] dataTypes, int row, int saveType) throws IOException {
        int rowType = ds.getRowType(row);
        XeniUtils.XeniEncoder encoder = XeniUtils.getXeniEncoder("csv");
        if ((row % 10 == 0 || row == ds.getRowCount() - 1) && this.log.isTraceEnabled()) {
            this.log.trace((Object)StringUtils.normalizeSpace((String)("writeRow(Writer, DataSet, int[], int, int): row=" + row + ", saveType=" + saveType + ", rowType=" + rowType)));
        }
        if (saveType != 1 && (saveType == 2 ? rowType == 3 : (saveType == 3 ? rowType == 0 || rowType == 3 : (saveType == 4 ? rowType == 0 || rowType == 1 || rowType == 2 : saveType == 5 && rowType == 0)))) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        int count = ds.getColumnCount();
        for (int i = 0; i < count; ++i) {
            Object value;
            ColumnHeader header = ds.getColumn(i);
            if (header.isConstant()) continue;
            if (i > 0) {
                buffer.append(',');
            }
            int sourceDataType = header.getDataType();
            int dataType = dataTypes[i];
            if (dataType == 13 || DataTypes.isBinary((int)dataType)) {
                byte[] byArray = value = sourceDataType == 13 ? this.getBinaryValueFromFile(ds, row, i, dataType) : this.getBinaryValue(ds, row, i);
                if (value == null) continue;
                String encoded = Base64.encodeBase64String((byte[])value);
                buffer.append(encoded);
                continue;
            }
            value = sourceDataType == 13 ? this.getStringValueFromFile(ds, row, i, dataType) : this.getStringValue(ds, row, i);
            if (value == null) continue;
            buffer.append((String)value);
        }
        out.write(this.CR);
        encoder.encodeTo(out, buffer.toString());
    }

    private byte[] getBinaryValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 12 || dataType == 13) {
            String filename = ds.getString(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)StringUtils.normalizeSpace((String)("Loading data from file: filename=" + filename + ", content=" + content)));
            }
            return content;
        }
        return null;
    }

    private String getStringValueFromFile(DataSet ds, int row, int column, int dataType) throws IOException {
        if (dataType == 2) {
            String filename = ds.getString(row, column);
            byte[] content = this.loadFile(filename);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)StringUtils.normalizeSpace((String)("Loading data from file: filename=" + filename + ", content=" + content)));
            }
            return content == null ? null : new String(content);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadFile(String filename) throws IOException {
        if (filename == null) {
            return null;
        }
        File file = XeniUtils.getXeniFileHandler(filename).toFile();
        if (file.canRead()) {
            FileInputStream in = new FileInputStream(file);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = this.getBuffer();
            try {
                int n;
                while ((n = in.read(buffer)) != -1) {
                    out.write(buffer, 0, n);
                }
                out.close();
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            finally {
                in.close();
            }
        }
        return null;
    }

    private byte[] getBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[4096];
        }
        return this.buffer;
    }

    private byte[] getBinaryValue(DataSet ds, int row, int column) {
        return ds.getBlob(row, column);
    }

    private String getStringValue(DataSet ds, int row, int column) {
        int dataType = ds.getColumn(column).getDataType();
        if (dataType == 4) {
            return ds.getBoolean(row, column) ? "1" : "0";
        }
        String value = ds.getString(row, column);
        return value;
    }

    private int[] getTargetDataTypes(DataSet ds, DataTypeChanger dataTypeChanger) {
        int count = ds.getColumnCount();
        int[] dataTypes = new int[count];
        for (int i = 0; i < count; ++i) {
            ColumnHeader header = ds.getColumn(i);
            if (dataTypeChanger == null) {
                dataTypes[i] = header.getDataType();
                continue;
            }
            String dsName = ds.getAlias();
            String columnName = header.getName();
            int dataType = header.getDataType();
            dataTypes[i] = dataTypeChanger.getDataType(dsName, columnName, dataType);
        }
        return dataTypes;
    }

    private String getDataType(int dataType) {
        if (dataType == 4) {
            return DataTypes.toStringType((int)3);
        }
        if (dataType == 5) {
            return DataTypes.toStringType((int)8);
        }
        if (dataType == 7) {
            return DataTypes.toStringType((int)6);
        }
        if (dataType == 13) {
            return DataTypes.toStringType((int)12);
        }
        return DataTypes.toStringType((int)dataType);
    }
}

