/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.ximport.impl;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xeni.data.importformats.ImportSheet;
import com.nexacro.java.xeni.util.CommUtil;
import com.nexacro.java.xeni.util.XeniErrorProperties;
import com.nexacro.java.xeni.ximport.GridImportBase;
import com.nexacro.java.xeni.ximport.GridImportContext;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class GridImportCSV
implements GridImportBase {
    private static final Log objLogger = LogFactory.getLog(GridImportCSV.class);
    private int errorCode = 0;
    private String errorMsg = "";
    private InputStream inputStream = null;
    private GridImportContext importContext = null;

    @Override
    public void setInputStream(InputStream ins) {
        this.inputStream = ins;
    }

    @Override
    public void setPartIndex(int index) {
    }

    @Override
    public int getPartIndex() {
        return 0;
    }

    @Override
    public void setOPCPackage(OPCPackage opcPkg) {
    }

    @Override
    public void setPOIFileSystem(POIFSFileSystem poifs) {
    }

    @Override
    public String getErrorMessage() {
        return this.errorMsg;
    }

    @Override
    public void setErrorMessage(String message) {
        this.errorMsg = message;
        if (objLogger.isInfoEnabled()) {
            objLogger.info((Object)StringUtils.normalizeSpace((String)message));
        }
    }

    @Override
    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public void setErrorCode(int code) {
        this.errorCode = code;
    }

    @Override
    public void initialize(GridImportContext context) {
        this.importContext = context;
    }

    @Override
    public int startImport() {
        if (objLogger.isDebugEnabled()) {
            objLogger.debug((Object)"Exceute import : CSV");
        }
        if (this.importContext.getFileUrl() == null || "".equals(this.importContext.getFileUrl())) {
            try {
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.import.path.empty"));
            return -2001;
        }
        this.errorCode = 0;
        DataSet dsInfo = CommUtil.getDatasetImportResponse();
        dsInfo.set(0, "filepath", this.importContext.getFileUrl());
        this.importContext.getPlatformData().getDataSetList().add(dsInfo);
        for (int nIdx = 0; nIdx < this.importContext.getImportFormat().getSheetCount(); ++nIdx) {
            DataSet dsData;
            ImportSheet fmtSheet = this.importContext.getImportFormat().getSheet(nIdx);
            if (fmtSheet == null || "getsheetlist".equals(fmtSheet.getCommand()) || (dsData = this.getCsvData(fmtSheet)) == null) continue;
            this.importContext.getPlatformData().getDataSetList().add(dsData);
        }
        return this.errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet getCsvData(ImportSheet sheet) {
        DataSet dsResult;
        block48: {
            int rowIndex = 0;
            String dsName = sheet.getOutput();
            if (dsName == null || "".equals(dsName)) {
                dsName = "CSVDATA";
            }
            dsResult = new DataSet(dsName);
            BufferedReader bufReader = null;
            InputStream inStream = null;
            CSVReader csvReader = null;
            try {
                int nBdStartRow;
                String[] values;
                inStream = this.inputStream;
                bufReader = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
                csvReader = new CSVReader(bufReader, this.importContext);
                int[] nHdStart = new int[]{-1, -1};
                int[] nHdEnd = new int[]{-1, -1};
                int[] nBdStart = new int[]{-1, -1};
                int[] nBdEnd = new int[]{-1, -1};
                boolean isUserRange = this.getUserRange(sheet, nHdStart, nHdEnd, nBdStart, nBdEnd);
                dsResult.setChangeStructureWithData(true);
                if (objLogger.isDebugEnabled()) {
                    objLogger.debug((Object)StringUtils.normalizeSpace((String)("head start column : " + nHdStart[0] + "\nhead start row : " + nHdStart[1] + "\nhead end column : " + nHdEnd[0] + "\nhead end row : " + nHdEnd[1] + "\nbody start column : " + nBdStart[0] + "\nbody start row : " + nBdStart[1] + "\nbody end column : " + nBdEnd[0] + "\nbody end row : " + nBdEnd[1])));
                }
                if (isUserRange) {
                    while ((values = csvReader.readNext(rowIndex)) != null) {
                        int nIdx;
                        if (rowIndex == 0) {
                            for (int nIdx2 = 0; nIdx2 < values.length; ++nIdx2) {
                                dsResult.addColumn("Column" + nIdx2, 2, 256);
                            }
                        } else {
                            int colCnt = dsResult.getColumnCount();
                            if (values.length > colCnt) {
                                for (nIdx = colCnt; nIdx < values.length; ++nIdx) {
                                    dsResult.addColumn("Column" + nIdx, 2, 256);
                                }
                            }
                        }
                        int nAddRow = dsResult.newRow();
                        for (nIdx = 0; nIdx < values.length; ++nIdx) {
                            dsResult.set(nAddRow, nIdx, values[nIdx]);
                        }
                        ++rowIndex;
                    }
                    break block48;
                }
                boolean bAddedCol = false;
                int nHdStartCol = nHdStart[0] < 0 ? 0 : nHdStart[0];
                int nHdStartRow = nHdStart[1] < 0 ? 0 : nHdStart[1];
                int nBdStartCol = nBdStart[0] < 0 ? 0 : nBdStart[0];
                int n = nBdStartRow = nBdStart[1] < 0 ? 0 : nBdStart[1];
                while ((values = csvReader.readNext(rowIndex)) != null) {
                    if (rowIndex == 0 && nHdStart[0] < 0 && nHdStart[1] < 0 && nHdEnd[0] < 0 && nHdEnd[1] < 0) {
                        for (int nIdx = 0; nIdx < values.length; ++nIdx) {
                            dsResult.addColumn("Column" + nIdx, 2, 256);
                        }
                        bAddedCol = true;
                    } else if (!bAddedCol) {
                        int nHdEndCol;
                        int n2 = nHdEndCol = nHdEnd[0] < 0 ? values.length - 1 : nHdEnd[0];
                        if (nHdStartRow <= rowIndex) {
                            for (int nIdx = nHdStartCol; nIdx <= nHdEndCol; ++nIdx) {
                                dsResult.addColumn(values[nIdx], 2, 256);
                            }
                            bAddedCol = true;
                        }
                    }
                    if (bAddedCol) {
                        int nBdEndRow;
                        int nBdEndCol = nBdEnd[0] < 0 ? values.length - 1 : nBdEnd[0];
                        int n3 = nBdEndRow = nBdEnd[1] < 0 ? rowIndex : nBdEnd[1];
                        if (nBdStartRow <= rowIndex && rowIndex <= nBdEndRow) {
                            int nAddRow = dsResult.newRow();
                            for (int nIdx = nBdStartCol; nIdx <= nBdEndCol; ++nIdx) {
                                dsResult.set(nAddRow, nIdx - nBdStartCol, values[nIdx]);
                            }
                        } else if (rowIndex > nBdEndRow) {
                            break;
                        }
                    }
                    ++rowIndex;
                }
            }
            catch (MalformedURLException e) {
                this.errorCode = -2018;
                this.setErrorMessage(e.getMessage());
            }
            catch (FileNotFoundException fnfe) {
                this.errorCode = -2020;
                this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.import.no.such.file"));
            }
            catch (IOException ioe) {
                this.errorCode = -2003;
                this.setErrorMessage(ioe.getMessage());
            }
            catch (Exception e) {
                this.errorCode = -2001;
                this.setErrorMessage(e + "");
            }
            finally {
                try {
                    if (csvReader != null) {
                        csvReader.release();
                    }
                    if (bufReader != null) {
                        bufReader.close();
                    }
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (IOException e) {
                    this.errorCode = -2003;
                    this.setErrorMessage(e.getMessage());
                }
            }
        }
        return dsResult;
    }

    private boolean getUserRange(ImportSheet sheet, int[] hdstart, int[] hdend, int[] bdstart, int[] bdend) {
        this.getDataRange(sheet.getHead(), hdstart, hdend);
        this.getDataRange(sheet.getBody(), bdstart, bdend);
        return hdstart[0] < 0 && hdstart[1] < 0 && hdend[0] < 0 && hdend[1] < 0 && bdstart[0] < 0 && bdstart[1] < 0 && bdend[0] < 0 && bdend[1] < 0;
    }

    public void getDataRange(String range, int[] start, int[] end) {
        if (objLogger.isDebugEnabled()) {
            objLogger.debug((Object)("Import range : " + StringUtils.normalizeSpace((String)range)));
        }
        if (range == null || "".equals(range)) {
            return;
        }
        try {
            String[] sCells = range.split("\\:");
            String[] sStart = sCells[0].split("\\,");
            if (sStart[0] != null && !"".equals(sStart[0])) {
                start[0] = Integer.parseInt(sStart[0]);
            }
            if (sStart.length > 1 && sStart[1] != null && !"".equals(sStart[1])) {
                start[1] = Integer.parseInt(sStart[1]);
            }
            if (sCells.length > 1) {
                String[] sEnd = sCells[1].split("\\,");
                if (sEnd[0] != null && !"".equals(sEnd[0])) {
                    end[0] = Integer.parseInt(sEnd[0]);
                }
                if (sEnd.length > 1 && sEnd[1] != null && !"".equals(sEnd[1])) {
                    end[1] = Integer.parseInt(sEnd[1]);
                }
            }
        }
        catch (NumberFormatException e) {
            System.out.println(e.getMessage());
        }
    }

    private class CSVReader {
        private BufferedReader bufreader;
        private boolean hasnextline = true;
        private char separator;
        private String quoteChars;

        public CSVReader(Reader reader, GridImportContext ctxt) {
            this.bufreader = new BufferedReader(reader);
            this.separator = ctxt.getSeparator();
            this.quoteChars = ctxt.getQuoteChar();
        }

        public void release() throws IOException {
            if (this.bufreader != null) {
                this.bufreader.close();
            }
        }

        public String[] readNext(int rowidx) throws IOException {
            String nextline = this.getNextLine();
            if (nextline == null) {
                return null;
            }
            if (rowidx == 0 && nextline.startsWith("\ufeff")) {
                nextline = nextline.substring(1);
            }
            return this.hasnextline ? this.parseLine(nextline) : null;
        }

        private String getNextLine() throws IOException {
            String nextLine = this.bufreader.readLine();
            if (nextLine == null) {
                this.hasnextline = false;
            }
            return this.hasnextline ? nextLine : null;
        }

        private String[] parseLine(String nextLine) throws IOException {
            boolean isinquote = false;
            StringBuilder strbuilder = new StringBuilder();
            ArrayList<String> tokens = new ArrayList<String>();
            do {
                if (isinquote) {
                    strbuilder.append("\n");
                    nextLine = this.getNextLine();
                    if (nextLine == null) break;
                }
                for (int idx = 0; idx < nextLine.length(); ++idx) {
                    char c = nextLine.charAt(idx);
                    if (c == '\\') {
                        if (this.isEscapable(nextLine, isinquote, idx)) {
                            strbuilder.append(nextLine.charAt(idx + 1));
                            ++idx;
                            continue;
                        }
                        strbuilder.append(c);
                        continue;
                    }
                    if (this.quoteChars.length() > 0 && c == this.quoteChars.charAt(0)) {
                        if (this.isEscapedQuote(nextLine, isinquote, idx)) {
                            strbuilder.append(nextLine.charAt(idx + 1));
                            ++idx;
                            continue;
                        }
                        boolean bl = isinquote = !isinquote;
                        if (idx <= 2 || nextLine.charAt(idx - 1) == this.separator || nextLine.length() <= idx + 1 || nextLine.charAt(idx + 1) == this.separator) continue;
                        strbuilder.append(c);
                        continue;
                    }
                    if (c == this.separator && !isinquote) {
                        tokens.add(strbuilder.toString());
                        strbuilder = new StringBuilder();
                        continue;
                    }
                    strbuilder.append(c);
                }
            } while (isinquote);
            tokens.add(strbuilder.toString());
            return tokens.toArray(new String[0]);
        }

        private boolean isEscapedQuote(String nextLine, boolean isquote, int index) {
            return isquote && nextLine.length() > index + 1 && this.quoteChars.length() > 0 && nextLine.charAt(index + 1) == this.quoteChars.charAt(0);
        }

        private boolean isEscapable(String nextline, boolean inquote, int index) {
            return inquote && nextline.length() > index + 1 && (this.quoteChars.length() > 0 && nextline.charAt(index + 1) == this.quoteChars.charAt(0) || nextline.charAt(index + 1) == '\\');
        }
    }
}

