/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.ximport.impl;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xeni.data.importformats.ImportSheet;
import com.nexacro.java.xeni.util.CommUtil;
import com.nexacro.java.xeni.util.XeniErrorProperties;
import com.nexacro.java.xeni.ximport.ExcelDimensionInfo;
import com.nexacro.java.xeni.ximport.GridImportBase;
import com.nexacro.java.xeni.ximport.GridImportContext;
import com.nexacro.java.xeni.ximport.impl.HSSFEventModelHandlerBody;
import com.nexacro.java.xeni.ximport.impl.HSSFEventModelHandlerHead;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class GridImportExcelHSSFEvent
implements GridImportBase {
    private static final Log logger = LogFactory.getLog(GridImportExcelHSSFEvent.class);
    private int errorCode = 0;
    private String errorMsg = "SUCCESS";
    private POIFSFileSystem poiFs = null;
    private GridImportContext importContext = null;

    @Override
    public void setOPCPackage(OPCPackage opcPkg) {
    }

    @Override
    public void setPOIFileSystem(POIFSFileSystem poifs) {
        this.poiFs = poifs;
    }

    @Override
    public void setInputStream(InputStream ins) {
    }

    @Override
    public void setPartIndex(int index) {
    }

    @Override
    public int getPartIndex() {
        return 0;
    }

    @Override
    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public void setErrorCode(int code) {
        this.errorCode = code;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMsg;
    }

    @Override
    public void setErrorMessage(String message) {
        this.errorMsg = message;
        if (logger.isInfoEnabled()) {
            logger.info((Object)StringUtils.normalizeSpace((String)message));
        }
    }

    @Override
    public void initialize(GridImportContext context) {
        this.importContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startImport() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Excute import : HSSF");
        }
        if (this.importContext.getFileUrl() == null || "".equals(this.importContext.getFileUrl())) {
            this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.import.path.empty"));
            return -2001;
        }
        this.errorCode = 0;
        DataSet ds = CommUtil.getDatasetImportResponse();
        ds.set(0, "filepath", this.importContext.getFileUrl());
        this.importContext.getPlatformData().getDataSetList().add(ds);
        POIFSFileSystem poiFs = null;
        try {
            poiFs = this.poiFs;
            for (int nFmtIdx = 0; nFmtIdx < this.importContext.getImportFormat().getSheetCount(); ++nFmtIdx) {
                ImportSheet sheetFormat = this.importContext.getImportFormat().getSheet(nFmtIdx);
                if (sheetFormat == null) continue;
                DataSet dsResult = null;
                dsResult = "getsheetlist".equals(sheetFormat.getCommand()) ? this.getSheetList(sheetFormat, poiFs) : this.getSheetData(sheetFormat, poiFs);
                if (dsResult == null) continue;
                this.importContext.getPlatformData().getDataSetList().add(dsResult);
            }
        }
        catch (InvalidFormatException e) {
            this.errorCode = -2019;
            this.setErrorMessage(e.getMessage());
        }
        catch (MalformedURLException e) {
            this.errorCode = -2018;
            this.setErrorMessage(e.getMessage());
        }
        catch (PlatformException e) {
            this.errorCode = -3101;
            this.setErrorMessage(e.getMessage());
        }
        catch (IOException e) {
            this.errorCode = -2003;
            this.setErrorMessage(e.getMessage());
        }
        catch (Exception e) {
            this.errorCode = -2001;
            this.setErrorMessage(e.getMessage());
        }
        finally {
            if (poiFs != null) {
                try {
                    poiFs.close();
                }
                catch (IOException e) {
                    this.errorCode = -2003;
                    this.setErrorMessage(e.getMessage());
                }
            }
            Biff8EncryptionKey.setCurrentUserPassword(null);
        }
        return this.errorCode;
    }

    private DataSet getSheetList(ImportSheet sheetformat, POIFSFileSystem poifs) throws Exception {
        String dsName;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Get sheet list.");
        }
        if ((dsName = sheetformat.getOutput()) == null || "".equals(dsName)) {
            dsName = "SHEETS";
        }
        DataSet dsResult = new DataSet(dsName);
        dsResult.addColumn("number", 3);
        dsResult.addColumn("sheetname", 2);
        HSSFRequest hssfReq = new HSSFRequest();
        hssfReq.addListenerForAllRecords((HSSFListener)new HSSFEventModelHandlerHead(dsResult, "", HSSFEventModelHandlerHead.commandType.SHEETLIST, new ExcelDimensionInfo(), this.importContext));
        HSSFEventFactory factory = new HSSFEventFactory();
        DocumentInputStream in = poifs.createDocumentInputStream("Workbook");
        factory.processEvents(hssfReq, (InputStream)in);
        if (in != null) {
            in.close();
        }
        return dsResult;
    }

    private DataSet getSheetData(ImportSheet sheetformat, POIFSFileSystem poifs) throws Exception {
        String sDsName;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Get sheet data.");
        }
        if ((sDsName = sheetformat.getOutput()) == null || "".equals(sDsName)) {
            sDsName = "SHEETDATA";
        }
        DataSet dsResult = new DataSet(sDsName);
        int[] nHdStart = new int[]{-1, -1};
        int[] nHdEnd = new int[]{-1, -1};
        String sSheetName = null;
        String sRange = sheetformat.getHead();
        if (sRange != null && sRange.length() > 0) {
            sSheetName = CommUtil.getDataRange(sRange, nHdStart, nHdEnd);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Import head range : " + StringUtils.normalizeSpace((String)sRange)));
        }
        ExcelDimensionInfo dimension = new ExcelDimensionInfo();
        dimension.setUserStartColumn(nHdStart[0]);
        dimension.setUserStartRow(nHdStart[1]);
        dimension.setUserEndColumn(nHdEnd[0]);
        dimension.setUserEndRow(nHdEnd[1]);
        HSSFEventModelHandlerHead hdHandler = new HSSFEventModelHandlerHead(dsResult, sSheetName, HSSFEventModelHandlerHead.commandType.HEAD, dimension, this.importContext);
        hdHandler.excute(poifs);
        if (!hdHandler.isFoundSheet()) {
            this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.import.sheet.notfound", sSheetName));
            throw new IOException(this.errorMsg);
        }
        int[] nBdStart = new int[]{-1, -1};
        int[] nBdEnd = new int[]{-1, -1};
        sRange = sheetformat.getBody();
        if (sRange != null && sRange.length() > 0) {
            sSheetName = CommUtil.getDataRange(sRange, nBdStart, nBdEnd);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Import body range : " + StringUtils.normalizeSpace((String)sRange)));
        }
        dimension.setUserStartColumn(nBdStart[0]);
        dimension.setUserStartRow(nBdStart[1]);
        dimension.setUserEndColumn(nBdEnd[0]);
        dimension.setUserEndRow(nBdEnd[1]);
        HSSFEventModelHandlerBody bdHandler = new HSSFEventModelHandlerBody(dsResult, sSheetName, dimension, this.importContext);
        bdHandler.excute(poifs);
        if (!bdHandler.isFoundSheet()) {
            this.setErrorMessage("Unable to process: Not found '" + sSheetName + "' sheet.");
            throw new IOException(this.errorMsg);
        }
        return dsResult;
    }
}

