/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.ximport.impl;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.VariableList;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xeni.data.importformats.ImportSheet;
import com.nexacro.java.xeni.extend.XeniReadOnlySharedStringsTable;
import com.nexacro.java.xeni.extend.XeniStylesTable;
import com.nexacro.java.xeni.util.CommUtil;
import com.nexacro.java.xeni.util.XeniErrorProperties;
import com.nexacro.java.xeni.util.XeniUtils;
import com.nexacro.java.xeni.ximport.ExcelDimensionInfo;
import com.nexacro.java.xeni.ximport.GridImportBase;
import com.nexacro.java.xeni.ximport.GridImportContext;
import com.nexacro.java.xeni.ximport.POIEventModelException;
import com.nexacro.java.xeni.ximport.impl.XSSFEventModelHandlerBody;
import com.nexacro.java.xeni.ximport.impl.XSSFEventModelHandlerHead;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.security.GeneralSecurityException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.StylesTable;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class GridImportExcelXSSFEvent
implements GridImportBase {
    private static final Log logger = LogFactory.getLog(GridImportExcelXSSFEvent.class);
    private int errorCode = 0;
    private int partIndex;
    private String errorMsg = "SUCCESS";
    private boolean bHancell = false;
    private OPCPackage opcPackage = null;
    private GridImportContext importContext = null;

    @Override
    public void setOPCPackage(OPCPackage opcpackage) {
        this.opcPackage = opcpackage;
    }

    @Override
    public void setPOIFileSystem(POIFSFileSystem poifs) {
    }

    @Override
    public void setInputStream(InputStream ins) {
    }

    @Override
    public void setPartIndex(int index) {
        this.partIndex = index;
    }

    @Override
    public int getPartIndex() {
        return this.partIndex;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMsg;
    }

    @Override
    public void setErrorMessage(String message) {
        this.errorMsg = message;
        logger.error((Object)StringUtils.normalizeSpace((String)message));
    }

    @Override
    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public void setErrorCode(int code) {
        this.errorCode = code;
    }

    @Override
    public void initialize(GridImportContext context) {
        this.importContext = context;
        if (context.getImportType() == 1040 || context.getImportType() == 1056) {
            this.bHancell = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startImport() {
        if (this.importContext.getFileUrl() == null || "".equals(this.importContext.getFileUrl())) {
            this.setErrorMessage("Import file path is empty...");
            return -2001;
        }
        this.errorCode = 0;
        DataSet dsInfo = CommUtil.getDatasetImportResponse();
        dsInfo.set(0, "filepath", this.importContext.getFileUrl());
        this.importContext.getPlatformData().getDataSetList().add(dsInfo);
        try {
            if (this.importContext.isPartData() && (this.errorCode = this.sendDataHead()) < 0) {
                int n = this.errorCode;
                return n;
            }
            XSSFReader xssfReader = new XSSFReader(this.opcPackage);
            for (int nFmtIdx = 0; nFmtIdx < this.importContext.getImportFormat().getSheetCount(); ++nFmtIdx) {
                ImportSheet sheetFormat = this.importContext.getImportFormat().getSheet(nFmtIdx);
                if (sheetFormat == null) continue;
                DataSet dsResult = null;
                if ("getsheetlist".equals(sheetFormat.getCommand())) {
                    dsResult = this.getSheetList(xssfReader, sheetFormat);
                    if (this.importContext.isPartData()) {
                        this.sendDataFirst(dsInfo);
                        this.writePartDataset(dsResult);
                    }
                } else {
                    dsResult = this.getSheetData(xssfReader, sheetFormat, this.opcPackage, dsInfo);
                }
                if (dsResult == null || this.importContext.isPartData()) continue;
                this.importContext.getPlatformData().getDataSetList().add(dsResult);
            }
            if (this.importContext.isPartData()) {
                this.sendDataTail();
            }
        }
        catch (InvalidFormatException e) {
            this.errorCode = -2019;
            this.setErrorMessage(e.getMessage());
        }
        catch (OpenXML4JException e) {
            this.errorCode = -2001;
            this.setErrorMessage(e.getMessage());
        }
        catch (SAXException e) {
            this.errorCode = -2001;
            this.setErrorMessage(e.getMessage());
        }
        catch (MalformedURLException e) {
            this.errorCode = -2018;
            this.setErrorMessage(e.getMessage());
        }
        catch (PlatformException e) {
            this.errorCode = -3101;
            this.setErrorMessage(e.getMessage());
        }
        catch (IOException e) {
            this.errorCode = -2003;
            this.setErrorMessage(e.getMessage());
        }
        catch (GeneralSecurityException e) {
            this.errorCode = -2021;
            this.setErrorMessage(e.getMessage());
        }
        catch (Exception e) {
            this.errorCode = -2001;
            this.setErrorMessage(e.getMessage());
        }
        finally {
            try {
                if (this.opcPackage != null) {
                    this.opcPackage.close();
                }
            }
            catch (IOException e) {
                this.errorCode = -2003;
                this.setErrorMessage(e.getMessage());
            }
        }
        return this.errorCode;
    }

    private DataSet getSheetList(XSSFReader xssfreader, ImportSheet sheetformat) throws Exception {
        String dsName;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Get sheet list.");
        }
        if ((dsName = sheetformat.getOutput()) == null || "".equals(dsName)) {
            dsName = "SHEETS";
        }
        DataSet ds = new DataSet(dsName);
        ds.addColumn("number", 3);
        ds.addColumn("sheetname", 2);
        XSSFReader.SheetIterator sheets = (XSSFReader.SheetIterator)xssfreader.getSheetsData();
        while (sheets.hasNext()) {
            InputStream sheet = sheets.next();
            int nNewRow = ds.newRow();
            ds.set(nNewRow, "number", nNewRow + 1);
            ds.set(nNewRow, "sheetname", sheets.getSheetName());
            sheet.close();
        }
        return ds;
    }

    private DataSet getSheetData(XSSFReader xssfreader, ImportSheet sheetformat, OPCPackage opcpackage, DataSet dsinfo) throws OpenXML4JException, SAXException, Exception {
        DataSet dsResult;
        block12: {
            ExcelDimensionInfo dim;
            InputSource inSource;
            XeniReadOnlySharedStringsTable stringsTable;
            XMLReader xmlReader;
            DefaultHandler xmlHandler;
            StylesTable xlsStyleTable;
            XeniStylesTable xeniStylesTable;
            block11: {
                block10: {
                    String sDsName;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Get sheet data.");
                    }
                    if ((sDsName = sheetformat.getOutput()) == null || "".equals(sDsName)) {
                        sDsName = "SHEETDATA";
                    }
                    dsResult = new DataSet(sDsName);
                    xeniStylesTable = new XeniStylesTable();
                    try {
                        xeniStylesTable.readFrom(opcpackage);
                    }
                    catch (SAXException e) {
                        if (e.getException() instanceof POIEventModelException) break block10;
                        throw e;
                    }
                }
                this.bHancell = xeniStylesTable.isHancellStyle();
                xlsStyleTable = null;
                if (!this.bHancell) {
                    xlsStyleTable = xssfreader.getStylesTable();
                }
                xmlHandler = null;
                xmlReader = this.createXMLReader();
                stringsTable = new XeniReadOnlySharedStringsTable(this.opcPackage);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Import head range : " + StringUtils.normalizeSpace((String)sheetformat.getHead())));
                    logger.debug((Object)("Import body range : " + StringUtils.normalizeSpace((String)sheetformat.getBody())));
                }
                int[] nHdStart = new int[]{-1, -1};
                int[] nHdEnd = new int[]{-1, -1};
                inSource = this.getSheetSource(xssfreader, sheetformat.getHead(), nHdStart, nHdEnd);
                dim = new ExcelDimensionInfo();
                dim.setUserStartColumn(nHdStart[0]);
                dim.setUserStartRow(nHdStart[1]);
                dim.setUserEndColumn(nHdEnd[0]);
                dim.setUserEndRow(nHdEnd[1]);
                xmlHandler = new XSSFEventModelHandlerHead(dsResult, dim, xlsStyleTable, xeniStylesTable, stringsTable, false, this.bHancell, this.importContext);
                try {
                    xmlReader.setContentHandler(xmlHandler);
                    xmlReader.parse(inSource);
                }
                catch (SAXException e) {
                    if (e.getException() instanceof POIEventModelException) break block11;
                    throw e;
                }
            }
            int[] nBdStart = new int[]{-1, -1};
            int[] nBdEnd = new int[]{-1, -1};
            inSource = this.getSheetSource(xssfreader, sheetformat.getBody(), nBdStart, nBdEnd);
            dim.setUserStartColumn(nBdStart[0]);
            dim.setUserStartRow(nBdStart[1]);
            dim.setUserEndColumn(nBdEnd[0]);
            dim.setUserEndRow(nBdEnd[1]);
            xmlHandler = new XSSFEventModelHandlerBody(dsResult, dim, xlsStyleTable, xeniStylesTable, stringsTable, false, this.bHancell, this.importContext, dsinfo);
            try {
                xmlReader.setContentHandler(xmlHandler);
                xmlReader.parse(inSource);
            }
            catch (SAXException e) {
                if (e.getException() instanceof POIEventModelException) break block12;
                throw e;
            }
        }
        return dsResult;
    }

    public InputSource getSheetSource(XSSFReader reader, String range, int[] start, int[] end) throws OpenXML4JException, SAXException, InvalidFormatException, IOException {
        InputStream inStream = null;
        if (range != null && range.length() > 0) {
            String sSheetName = CommUtil.getDataRange(range, start, end);
            if (sSheetName == null || "".equals(sSheetName)) {
                inStream = this.getSheetStream(reader, null);
            } else {
                inStream = this.getSheetStream(reader, sSheetName);
                if (inStream == null) {
                    this.setErrorMessage(XeniErrorProperties.getErrorProperty("err.import.sheet.notfound", sSheetName));
                    throw new IOException(this.errorMsg);
                }
            }
        } else {
            inStream = this.getSheetStream(reader, null);
        }
        return new InputSource(inStream);
    }

    private InputStream getSheetStream(XSSFReader reader, String name) throws InvalidFormatException, IOException {
        InputStream in = null;
        XSSFReader.SheetIterator sheets = (XSSFReader.SheetIterator)reader.getSheetsData();
        while (sheets.hasNext()) {
            if (name == null) {
                in = sheets.next();
                break;
            }
            in = sheets.next();
            if (name.equalsIgnoreCase(sheets.getSheetName())) break;
            in.close();
            in = null;
        }
        return in;
    }

    private XMLReader createXMLReader() throws SAXException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        return reader;
    }

    private int sendDataHead() throws PlatformException, IOException {
        XeniUtils.XeniEncoder encoder = XeniUtils.getXeniEncoder("");
        if (this.importContext.getServletProvider().getHttpServletResponse() == null) {
            this.setErrorMessage("Response is null.");
            return -2001;
        }
        this.importContext.setPartIndex(0);
        this.importContext.setPartIndex(1);
        StringWriter partHead = new StringWriter();
        CommUtil.writePartDataHead(partHead, this.importContext);
        encoder.encodeTo(this.importContext.getResponseWriter(), partHead.toString());
        this.importContext.setPartIndex(2);
        return 0;
    }

    private int sendDataFirst(DataSet ds) throws PlatformException, IOException {
        XeniUtils.XeniEncoder encoder = XeniUtils.getXeniEncoder("");
        if (this.importContext.isPartData()) {
            if (this.importContext.getServletProvider().getHttpServletResponse() == null) {
                this.setErrorMessage("Response is null.");
                return -2001;
            }
            VariableList varList = new VariableList();
            varList.add("ErrorCode", 0);
            varList.add("ErrorMsg", "SUCCESS");
            StringWriter partVarialbe = new StringWriter();
            CommUtil.writePartDataVariableList(partVarialbe, this.importContext, varList);
            encoder.encodeTo(this.importContext.getResponseWriter(), partVarialbe.toString());
            partVarialbe.getBuffer().delete(0, partVarialbe.getBuffer().length());
            this.importContext.setPartIndex(3);
            ds.set(0, "importid", this.importContext.getImportId());
            this.writePartDataset(ds);
            this.importContext.setPartIndex(4);
        }
        return 0;
    }

    private void sendDataTail() throws IOException, PlatformException {
        XeniUtils.XeniEncoder encoder = XeniUtils.getXeniEncoder("");
        StringWriter partWriter = new StringWriter();
        CommUtil.writePartDataTail(partWriter, this.importContext);
        encoder.encodeTo(this.importContext.getResponseWriter(), partWriter.toString());
        this.importContext.getResponseWriter().flush();
        partWriter.getBuffer().delete(0, partWriter.getBuffer().length());
        this.importContext.setPartIndex(6);
    }

    private void writePartDataset(DataSet ds) throws IOException, PlatformException {
        XeniUtils.XeniEncoder encoder = XeniUtils.getXeniEncoder("");
        StringWriter partWriter = new StringWriter();
        CommUtil.writePartDataDataset(partWriter, this.importContext, ds);
        encoder.encodeTo(this.importContext.getResponseWriter(), partWriter.toString());
        this.importContext.getResponseWriter().flush();
        partWriter.getBuffer().delete(0, partWriter.getBuffer().length());
    }
}

