/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.ximport.impl;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xeni.extend.XeniBuiltinFormats;
import com.nexacro.java.xeni.extend.XeniDataFormatter;
import com.nexacro.java.xeni.util.XeniProperties;
import com.nexacro.java.xeni.ximport.ExcelDimensionInfo;
import com.nexacro.java.xeni.ximport.GridImportContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.eventusermodel.AbortableHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.HSSFUserException;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.DimensionsRecord;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FormatRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.formula.ptg.Ptg;

public class HSSFEventModelHandlerBody
extends AbortableHSSFListener {
    private static final Log logger = LogFactory.getLog(HSSFEventModelHandlerBody.class);
    private int nextRow;
    private int nextColumn;
    private boolean outputNextStringRecord;
    private boolean outputFormulaValues = true;
    private SSTRecord sstRecord;
    private XeniDataFormatter formatter;
    private String sSheetName;
    private DataSet dsResult;
    private int nSheetIdx = 0;
    private int nCurrExlRow = -1;
    private boolean bFoundSheet = false;
    private List<BoundSheetRecord> boundSheetRecords = new ArrayList<BoundSheetRecord>();
    private final Map<Integer, FormatRecord> customFormatRecords = new Hashtable<Integer, FormatRecord>();
    private final List<ExtendedFormatRecord> extFormatRecords = new ArrayList<ExtendedFormatRecord>();
    private GridImportContext importContext;
    private ExcelDimensionInfo dimInfo;

    public HSSFEventModelHandlerBody(DataSet ds, String name, ExcelDimensionInfo dim, GridImportContext context) {
        this.dsResult = ds;
        this.sSheetName = name;
        this.dimInfo = dim;
        this.formatter = new XeniDataFormatter();
        this.importContext = context;
        if (this.dimInfo.getUserStartColumn() >= 0) {
            this.dimInfo.setStartColumn(this.dimInfo.getUserStartColumn());
        }
        if (this.dimInfo.getUserEndColumn() >= 0) {
            this.dimInfo.setEndColumn(this.dimInfo.getUserEndColumn());
        }
        if (this.dimInfo.getUserStartRow() >= 0) {
            this.dimInfo.setStartRow(this.dimInfo.getUserStartRow());
        }
        if (this.dimInfo.getUserEndRow() >= 0) {
            this.dimInfo.setEndRow(this.dimInfo.getUserEndRow());
        }
    }

    public void excute(POIFSFileSystem fs) throws IOException {
        HSSFEventFactory factory = new HSSFEventFactory();
        HSSFRequest request = new HSSFRequest();
        request.addListenerForAllRecords((HSSFListener)this);
        factory.processWorkbookEvents(request, fs.getRoot());
    }

    public short abortableProcessRecord(Record record) throws HSSFUserException {
        short curSID = record.getSid();
        if (!this.bFoundSheet && curSID != 1054 && curSID != 224 && curSID != 133 && curSID != 2057 && curSID != 10 && curSID != 252) {
            return 0;
        }
        short res = 0;
        int thisRow = -1;
        int thisColumn = -1;
        String thisStr = null;
        switch (curSID) {
            case 1054: {
                FormatRecord fmtRec = (FormatRecord)record;
                this.customFormatRecords.put(fmtRec.getIndexCode(), fmtRec);
                break;
            }
            case 224: {
                ExtendedFormatRecord extFmtRec = (ExtendedFormatRecord)record;
                this.extFormatRecords.add(extFmtRec);
                break;
            }
            case 133: {
                this.boundSheetRecords.add((BoundSheetRecord)record);
                break;
            }
            case 2057: {
                BOFRecord bofRec = (BOFRecord)record;
                if (bofRec.getType() != 16) break;
                this.findSheet();
                break;
            }
            case 512: {
                DimensionsRecord dimRec = (DimensionsRecord)record;
                res = this.setDimension(dimRec);
                break;
            }
            case 252: {
                this.sstRecord = (SSTRecord)record;
                break;
            }
            case 10: {
                if (!this.bFoundSheet) break;
                res = -1;
                break;
            }
            case 513: {
                BlankRecord blnkRec = (BlankRecord)record;
                thisRow = blnkRec.getRow();
                thisColumn = blnkRec.getColumn();
                thisStr = "";
                break;
            }
            case 6: {
                FormulaRecord formulaRec = (FormulaRecord)record;
                thisRow = formulaRec.getRow();
                thisColumn = formulaRec.getColumn();
                thisStr = this.getFormulaValue(formulaRec);
                break;
            }
            case 519: {
                if (!this.outputNextStringRecord) break;
                StringRecord strRec = (StringRecord)record;
                thisStr = strRec.getString();
                thisRow = this.nextRow;
                thisColumn = this.nextColumn;
                this.outputNextStringRecord = false;
                break;
            }
            case 516: {
                LabelRecord labelRec = (LabelRecord)record;
                thisRow = labelRec.getRow();
                thisColumn = labelRec.getColumn();
                thisStr = labelRec.getValue();
                break;
            }
            case 253: {
                LabelSSTRecord labelSstRec = (LabelSSTRecord)record;
                thisRow = labelSstRec.getRow();
                thisColumn = labelSstRec.getColumn();
                if (this.sstRecord == null) {
                    thisStr = "";
                    break;
                }
                thisStr = this.sstRecord.getString(labelSstRec.getSSTIndex()).toString();
                break;
            }
            case 515: {
                NumberRecord numRec = (NumberRecord)record;
                thisRow = numRec.getRow();
                thisColumn = numRec.getColumn();
                thisStr = this.formatNumberDateCell((CellValueRecordInterface)numRec, numRec.getValue());
                break;
            }
            case 517: {
                BoolErrRecord berrRec = (BoolErrRecord)record;
                thisRow = berrRec.getRow();
                thisColumn = berrRec.getColumn();
                byte errVal = berrRec.getErrorValue();
                thisStr = errVal == 0 ? "FALSE" : "TRUE";
                break;
            }
            case 520: {
                break;
            }
        }
        if (res > -1 && thisRow >= 0 && thisColumn >= 0) {
            res = this.setCellValue(thisRow, thisColumn, thisStr);
        }
        return res;
    }

    private void findSheet() {
        if (this.sSheetName == null || "".equals(this.sSheetName)) {
            this.bFoundSheet = true;
        } else {
            String sName = this.boundSheetRecords.get(this.nSheetIdx).getSheetname();
            if (sName.equalsIgnoreCase(this.sSheetName)) {
                this.bFoundSheet = true;
            }
        }
        ++this.nSheetIdx;
    }

    private short setDimension(DimensionsRecord dimRec) throws HSSFUserException {
        long cellCount;
        long maxCellCount = Long.parseLong(XeniProperties.getStringProperty("xeni.import.cell.max", "-1"));
        if (maxCellCount > 0L && (cellCount = (long)(this.dimInfo.getEndColumn() - this.dimInfo.getStartColumn() + 1) * (long)(this.dimInfo.getEndRow() - this.dimInfo.getStartRow() + 1)) > maxCellCount) {
            throw new HSSFUserException("Maximum number of cells exceeded. (" + cellCount + ":" + maxCellCount + ")");
        }
        return 0;
    }

    public boolean isFoundSheet() {
        return this.bFoundSheet;
    }

    private String getFormulaValue(FormulaRecord formulaRec) {
        String value = "";
        if (this.outputFormulaValues) {
            int resType = formulaRec.getCachedResultType();
            if (resType == 1) {
                this.outputNextStringRecord = true;
                this.nextRow = formulaRec.getRow();
                this.nextColumn = formulaRec.getColumn();
            } else {
                value = resType == 4 ? (formulaRec.getCachedBooleanValue() ? "TRUE" : "FALSE") : (resType == 5 ? "ERROR:" + formulaRec.getCachedErrorValue() : this.formatNumberDateCell((CellValueRecordInterface)formulaRec, formulaRec.getValue()));
            }
        } else {
            value = HSSFFormulaParser.toFormulaString(null, (Ptg[])formulaRec.getParsedExpression());
        }
        return value;
    }

    private String formatNumberDateCell(CellValueRecordInterface cell, double value) {
        int formatIndex = this.getFormatIndex(cell);
        String formatString = this.getFormatString(formatIndex);
        String thisStr = "";
        thisStr = this.formatter.formatRawCellContents(value, formatIndex, formatString, false, this.importContext.isRawDateValue(), this.importContext.isRawNumberValue(), this.importContext.getCompatibleMode());
        thisStr = thisStr.replaceAll("[\"*? ]", "");
        return thisStr;
    }

    private int getFormatIndex(CellValueRecordInterface cell) {
        ExtendedFormatRecord extFmtRec = this.extFormatRecords.get(cell.getXFIndex());
        if (extFmtRec == null) {
            return -1;
        }
        return extFmtRec.getFormatIndex();
    }

    private String getFormatString(int index) {
        if (index == -1) {
            return null;
        }
        String sFormat = null;
        if (index == 14) {
            sFormat = XeniBuiltinFormats.getBuiltinFormat(index, null);
        } else if (index >= HSSFDataFormat.getNumberOfBuiltinBuiltinFormats()) {
            FormatRecord fmtRec = this.customFormatRecords.get(index);
            if (fmtRec != null) {
                sFormat = fmtRec.getFormatString();
            }
        } else {
            sFormat = XeniBuiltinFormats.getBuiltinFormat(index, null);
        }
        if (sFormat == null) {
            sFormat = XeniBuiltinFormats.getBuiltinFormat(index, null);
        }
        return sFormat;
    }

    private boolean isValidDimension(int rowindex, int colindex) {
        return rowindex >= this.dimInfo.getStartRow() && colindex >= this.dimInfo.getStartColumn() && colindex <= this.dimInfo.getEndColumn();
    }

    private void setRowRecordIndex(int newrow) {
        if (this.nCurrExlRow == newrow) {
            return;
        }
        if (this.nCurrExlRow >= 0 && newrow - this.nCurrExlRow > 1) {
            for (int i = this.nCurrExlRow + 1; i < newrow && newrow <= this.dimInfo.getEndRow(); ++i) {
                this.dsResult.newRow();
            }
        }
        if (newrow >= this.dimInfo.getStartRow() && newrow <= this.dimInfo.getEndRow()) {
            this.dsResult.newRow();
        }
        this.nCurrExlRow = newrow;
    }

    private short setCellValue(int row, int col, String value) {
        if (row > this.dimInfo.getEndRow()) {
            return -1;
        }
        if (!this.isValidDimension(row, col)) {
            return 0;
        }
        this.setRowRecordIndex(row);
        if (this.importContext.getCorsResponseType() == 1 && value != null) {
            value = value.replaceAll("\n", "\\\\n");
            value = value.replaceAll("\"", "\\\\\"");
            value = value.replaceAll("\\\\", "\\\\\\\\");
        }
        if (value != null) {
            this.dsResult.set(row - this.dimInfo.getStartRow(), col - this.dimInfo.getStartColumn(), value);
        }
        return 0;
    }
}

