/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.ximport.impl;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xeni.extend.XeniBuiltinFormats;
import com.nexacro.java.xeni.extend.XeniDataFormatter;
import com.nexacro.java.xeni.ximport.ExcelDimensionInfo;
import com.nexacro.java.xeni.ximport.GridImportContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.eventusermodel.AbortableHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.HSSFUserException;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.DimensionsRecord;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FormatRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.formula.ptg.Ptg;

public class HSSFEventModelHandlerHead
extends AbortableHSSFListener {
    private static final Log logger = LogFactory.getLog(HSSFEventModelHandlerHead.class);
    private int nextRow;
    private int nextColumn;
    private boolean outputNextStringRecord;
    private boolean outputFormulaValues = true;
    private SSTRecord sstRecord;
    private XeniDataFormatter formatter;
    private commandType cmdType;
    private String sSheetName = null;
    private int nCurrDsCol = 0;
    private int nPreColIndex = 0;
    private DataSet dsResult = null;
    private int nSheetIdx = 0;
    private boolean bFoundSheet = false;
    private boolean bUserDimensin = false;
    private List<BoundSheetRecord> boundSheetRecords = new ArrayList<BoundSheetRecord>();
    private final Map<Integer, FormatRecord> customFormatRecords = new Hashtable<Integer, FormatRecord>();
    private final List<ExtendedFormatRecord> extFormatRecords = new ArrayList<ExtendedFormatRecord>();
    private GridImportContext importContext;
    private ExcelDimensionInfo dimInfo;

    public HSSFEventModelHandlerHead(DataSet ds, String name, commandType type, ExcelDimensionInfo dim, GridImportContext context) {
        this.dsResult = ds;
        this.sSheetName = name;
        this.importContext = context;
        this.cmdType = type;
        this.dimInfo = dim;
        this.formatter = new XeniDataFormatter();
        this.bUserDimensin = dim.isUserDimension();
    }

    public void excute(POIFSFileSystem fs) throws IOException {
        HSSFEventFactory factory = new HSSFEventFactory();
        HSSFRequest request = new HSSFRequest();
        request.addListenerForAllRecords((HSSFListener)this);
        factory.processWorkbookEvents(request, fs.getRoot());
    }

    public short abortableProcessRecord(Record record) throws HSSFUserException {
        short curSID = record.getSid();
        if (!this.bFoundSheet && curSID != 1054 && curSID != 224 && curSID != 133 && curSID != 2057 && curSID != 10 && curSID != 252) {
            return 0;
        }
        int res = 0;
        int thisRow = -1;
        int thisColumn = -1;
        String thisStr = null;
        switch (curSID) {
            case 1054: {
                FormatRecord fmtRec = (FormatRecord)record;
                this.customFormatRecords.put(fmtRec.getIndexCode(), fmtRec);
                break;
            }
            case 224: {
                ExtendedFormatRecord extFmtRec = (ExtendedFormatRecord)record;
                this.extFormatRecords.add(extFmtRec);
                break;
            }
            case 133: {
                this.boundSheetRecords.add((BoundSheetRecord)record);
                break;
            }
            case 2057: {
                BOFRecord bofRec = (BOFRecord)record;
                if (bofRec.getType() != 16) break;
                this.findSheet();
                break;
            }
            case 512: {
                DimensionsRecord dimRec = (DimensionsRecord)record;
                break;
            }
            case 252: {
                this.sstRecord = (SSTRecord)record;
                break;
            }
            case 10: {
                if (this.cmdType == commandType.SHEETLIST) {
                    res = this.getSheetList();
                    break;
                }
                if (!this.bFoundSheet) break;
                this.addDefaultColumn();
                res = -1;
                break;
            }
            case 513: {
                BlankRecord blnkRec = (BlankRecord)record;
                thisRow = blnkRec.getRow();
                thisColumn = blnkRec.getColumn();
                thisStr = "";
                break;
            }
            case 6: {
                FormulaRecord formulaRec = (FormulaRecord)record;
                thisRow = formulaRec.getRow();
                thisColumn = formulaRec.getColumn();
                thisStr = this.getFormulaValue(formulaRec);
                break;
            }
            case 519: {
                if (!this.outputNextStringRecord) break;
                StringRecord strRec = (StringRecord)record;
                thisStr = strRec.getString();
                thisRow = this.nextRow;
                thisColumn = this.nextColumn;
                this.outputNextStringRecord = false;
                break;
            }
            case 516: {
                LabelRecord labelRec = (LabelRecord)record;
                thisRow = labelRec.getRow();
                thisColumn = labelRec.getColumn();
                thisStr = labelRec.getValue();
                break;
            }
            case 253: {
                LabelSSTRecord labelSstRec = (LabelSSTRecord)record;
                thisRow = labelSstRec.getRow();
                thisColumn = labelSstRec.getColumn();
                if (this.sstRecord == null) {
                    thisStr = "";
                    break;
                }
                thisStr = this.sstRecord.getString(labelSstRec.getSSTIndex()).toString();
                break;
            }
            case 515: {
                NumberRecord numRec = (NumberRecord)record;
                thisRow = numRec.getRow();
                thisColumn = numRec.getColumn();
                thisStr = this.formatNumberDateCell((CellValueRecordInterface)numRec, numRec.getValue());
                break;
            }
            case 517: {
                BoolErrRecord berrRec = (BoolErrRecord)record;
                thisRow = berrRec.getRow();
                thisColumn = berrRec.getColumn();
                byte errVal = berrRec.getErrorValue();
                thisStr = errVal == 0 ? "FALSE" : "TRUE";
                break;
            }
            case 520: {
                break;
            }
        }
        if (res > -1 && thisRow >= 0 && thisColumn >= 0) {
            res = this.setCellValue(thisRow, thisColumn, thisStr);
        }
        return (short)res;
    }

    private void addDefaultColumn() {
        if (!this.bUserDimensin) {
            for (int i = 0; i <= this.dimInfo.getEndColumn() - this.dimInfo.getStartColumn(); ++i) {
                this.dsResult.addColumn("Column" + i, 2, 256);
            }
        }
    }

    private String getFormulaValue(FormulaRecord formulaRec) {
        String value = "";
        if (this.outputFormulaValues) {
            int resType = formulaRec.getCachedResultType();
            if (resType == 1) {
                this.outputNextStringRecord = true;
                this.nextRow = formulaRec.getRow();
                this.nextColumn = formulaRec.getColumn();
            } else {
                value = resType == 4 ? (formulaRec.getCachedBooleanValue() ? "TRUE" : "FALSE") : (resType == 5 ? "ERROR:" + formulaRec.getCachedErrorValue() : this.formatNumberDateCell((CellValueRecordInterface)formulaRec, formulaRec.getValue()));
            }
        } else {
            value = HSSFFormulaParser.toFormulaString(null, (Ptg[])formulaRec.getParsedExpression());
        }
        return value;
    }

    private void findSheet() {
        if (this.sSheetName == null || "".equals(this.sSheetName)) {
            this.bFoundSheet = true;
        } else {
            String sName = this.boundSheetRecords.get(this.nSheetIdx).getSheetname();
            if (sName.equalsIgnoreCase(this.sSheetName)) {
                this.bFoundSheet = true;
            }
        }
        ++this.nSheetIdx;
    }

    public boolean isFoundSheet() {
        return this.bFoundSheet;
    }

    private String formatNumberDateCell(CellValueRecordInterface cell, double value) {
        int formatIndex = this.getFormatIndex(cell);
        String formatString = this.getFormatString(formatIndex);
        String thisStr = "";
        thisStr = this.formatter.formatRawCellContents(value, formatIndex, formatString, false, this.importContext.isRawDateValue(), this.importContext.isRawNumberValue(), this.importContext.getCompatibleMode());
        thisStr = thisStr.replaceAll("[\"*? ]", "");
        return thisStr;
    }

    private int getFormatIndex(CellValueRecordInterface cell) {
        ExtendedFormatRecord extFmtRec = this.extFormatRecords.get(cell.getXFIndex());
        if (extFmtRec == null) {
            return -1;
        }
        return extFmtRec.getFormatIndex();
    }

    private String getFormatString(int index) {
        if (index == -1) {
            return null;
        }
        String sFormat = null;
        if (index == 14) {
            sFormat = XeniBuiltinFormats.getBuiltinFormat(index, null);
        } else if (index >= HSSFDataFormat.getNumberOfBuiltinBuiltinFormats()) {
            FormatRecord fmtRec = this.customFormatRecords.get(index);
            if (fmtRec != null) {
                sFormat = fmtRec.getFormatString();
            }
        } else {
            sFormat = XeniBuiltinFormats.getBuiltinFormat(index, null);
        }
        if (sFormat == null) {
            sFormat = XeniBuiltinFormats.getBuiltinFormat(index, null);
        }
        return sFormat;
    }

    private short getSheetList() {
        for (int nIdx = 0; nIdx < this.boundSheetRecords.size(); ++nIdx) {
            int nRowIdx = this.dsResult.newRow();
            BoundSheetRecord rec = this.boundSheetRecords.get(nIdx);
            this.dsResult.set(nRowIdx, "number", nIdx + 1);
            this.dsResult.set(nRowIdx, "sheetname", rec == null ? "" : rec.getSheetname());
        }
        return -1;
    }

    private void setDimension(int rowindex, int colindex) {
        if (this.dimInfo.getStartRow() < 0) {
            this.dimInfo.setStartRow(rowindex);
        }
        this.dimInfo.setEndRow(rowindex);
        if (this.dimInfo.getStartColumn() < 0) {
            this.dimInfo.setStartColumn(colindex);
        } else if (this.dimInfo.getStartColumn() > colindex) {
            this.dimInfo.setStartColumn(colindex);
        }
        if (this.dimInfo.getEndColumn() < 0) {
            this.dimInfo.setEndColumn(colindex);
        } else if (this.dimInfo.getEndColumn() < colindex) {
            this.dimInfo.setEndColumn(colindex);
        }
    }

    private boolean isValidDimension(int rowindex, int colindex) {
        if (rowindex < 0 || this.dimInfo.getUserStartRow() >= 0 && this.dimInfo.getUserStartRow() > rowindex) {
            return false;
        }
        if (this.dimInfo.getUserEndRow() >= 0 && this.dimInfo.getUserEndRow() < rowindex) {
            return false;
        }
        if (this.dimInfo.getUserStartColumn() >= 0 && this.dimInfo.getUserStartColumn() > colindex) {
            return false;
        }
        return this.dimInfo.getUserEndColumn() < 0 || this.dimInfo.getUserEndColumn() >= colindex;
    }

    private short setCellValue(int row, int col, String value) {
        this.setDimension(row, col);
        if (!this.bUserDimensin || !this.isValidDimension(row, col)) {
            return 0;
        }
        if (this.importContext.getCorsResponseType() == 1 && value != null) {
            value = value.replaceAll("\n", "\\\\n");
            value = value.replaceAll("\"", "\\\\\"");
            value = value.replaceAll("\\\\", "\\\\\\\\");
        }
        int nCols = col - this.nPreColIndex;
        this.nPreColIndex = col;
        if (this.nCurrDsCol != 0 && nCols > 1) {
            for (int nIdx = 1; nIdx < nCols; ++nIdx) {
                this.dsResult.addColumn("Column" + this.nCurrDsCol, 2, 256);
                ++this.nCurrDsCol;
            }
        }
        if (value == null || "".equals(value)) {
            this.dsResult.addColumn("Column" + this.nCurrDsCol, 2, 256);
        } else {
            this.dsResult.addColumn(value, 2, 256);
        }
        ++this.nCurrDsCol;
        return 0;
    }

    static enum commandType {
        SHEETLIST,
        HEAD,
        BODY;

    }
}

