/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.ximport.impl;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xapi.data.VariableList;
import com.nexacro.java.xapi.tx.PlatformException;
import com.nexacro.java.xeni.extend.XeniBuiltinFormats;
import com.nexacro.java.xeni.extend.XeniDataFormatter;
import com.nexacro.java.xeni.extend.XeniReadOnlySharedStringsTable;
import com.nexacro.java.xeni.extend.XeniStylesTable;
import com.nexacro.java.xeni.util.CommUtil;
import com.nexacro.java.xeni.util.XeniProperties;
import com.nexacro.java.xeni.util.XeniUtils;
import com.nexacro.java.xeni.ximport.ExcelDimensionInfo;
import com.nexacro.java.xeni.ximport.GridImportContext;
import com.nexacro.java.xeni.ximport.POIEventModelException;
import java.io.IOException;
import java.io.StringWriter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XSSFEventModelHandlerBody
extends DefaultHandler {
    private static final Log logger = LogFactory.getLog(XSSFEventModelHandlerBody.class);
    private StylesTable stylesTable;
    private XeniStylesTable xeniStylesTable;
    private XeniReadOnlySharedStringsTable sharedStringsTable;
    private boolean vIsOpen;
    private boolean fIsOpen;
    private boolean isIsOpen;
    private boolean hfIsOpen;
    private xssfDataType nextDataType;
    private short formatIndex;
    private String formatString;
    private final XeniDataFormatter formatter;
    private boolean formulasNotResults;
    private int nCurrExlRow = -1;
    private int nCurrDsRow = -1;
    private int[] currCellRef = new int[]{-1, -1};
    private StringBuffer value = new StringBuffer();
    private StringBuffer formula = new StringBuffer();
    private StringBuffer headerFooter = new StringBuffer();
    private DataSet dsResult = null;
    private DataSet dsInfo = null;
    private boolean isHancell = false;
    private GridImportContext importContext;
    private ExcelDimensionInfo dimInfo;

    public XSSFEventModelHandlerBody(DataSet ds, ExcelDimensionInfo dim, StylesTable styles, XeniStylesTable xeniStyles, XeniReadOnlySharedStringsTable strings, boolean formulasnotresults, boolean hancell, GridImportContext context, DataSet dsinfo) {
        this.dsResult = ds;
        this.dimInfo = dim;
        this.stylesTable = styles;
        this.xeniStylesTable = xeniStyles;
        this.sharedStringsTable = strings;
        this.formulasNotResults = formulasnotresults;
        this.formatter = new XeniDataFormatter();
        this.nextDataType = xssfDataType.NUMBER;
        this.isHancell = hancell;
        this.importContext = context;
        if (this.dimInfo.getUserStartColumn() >= 0) {
            this.dimInfo.setStartColumn(this.dimInfo.getUserStartColumn());
        }
        if (this.dimInfo.getUserEndColumn() >= 0) {
            this.dimInfo.setEndColumn(this.dimInfo.getUserEndColumn());
        }
        if (this.dimInfo.getUserStartRow() >= 0) {
            this.dimInfo.setStartRow(this.dimInfo.getUserStartRow());
        }
        if (this.dimInfo.getUserEndRow() >= 0) {
            this.dimInfo.setEndRow(this.dimInfo.getUserEndRow());
        }
        this.dsInfo = dsinfo;
    }

    private boolean isTextTag(String name) {
        if ("v".equals(name)) {
            return true;
        }
        if ("inlineStr".equals(name)) {
            return true;
        }
        return "t".equals(name) && this.isIsOpen;
    }

    @Override
    public void startElement(String uri, String name, String localName, Attributes attributes) throws SAXException {
        if ("dimension".equals(name)) {
            String dim = attributes.getValue("ref");
            this.setDimension(dim);
        } else if (this.isTextTag(name)) {
            this.vIsOpen = true;
            this.value.setLength(0);
        } else if ("is".equals(name)) {
            this.isIsOpen = true;
        } else if ("f".equals(name)) {
            this.setStartFormula(attributes);
        } else if ("oddHeader".equals(name) || "evenHeader".equals(name) || "firstHeader".equals(name) || "firstFooter".equals(name) || "oddFooter".equals(name) || "evenFooter".equals(name)) {
            this.hfIsOpen = true;
            this.headerFooter.setLength(0);
        } else if ("row".equals(name)) {
            int rowNum = Integer.parseInt(attributes.getValue("r")) - 1;
            if (rowNum > this.dimInfo.getEndRow()) {
                if (this.importContext.isPartData()) {
                    this.writePartDataset(this.dsResult);
                }
                throw new SAXException(new POIEventModelException("Stop parsing the document."));
            }
            this.setStartRowIndex(rowNum);
        } else if ("c".equals(name)) {
            this.setStartCellValue(attributes);
        }
    }

    @Override
    public void endElement(String uri, String name, String localName) throws SAXException {
        Object thisStr = null;
        if (this.isTextTag(name)) {
            this.vIsOpen = false;
            if (this.isValidDimension()) {
                this.setCellValue(this.getCellValue());
            }
        } else if ("f".equals(name)) {
            this.fIsOpen = false;
        } else if ("is".equals(name)) {
            this.isIsOpen = false;
        } else if ("row".equals(name)) {
            this.setEndRow();
        } else if ("oddHeader".equals(name) || "evenHeader".equals(name) || "firstHeader".equals(name)) {
            this.hfIsOpen = false;
            this.setHeaderFooter(this.headerFooter.toString(), true, name);
        } else if ("oddFooter".equals(name) || "evenFooter".equals(name) || "firstFooter".equals(name)) {
            this.hfIsOpen = false;
            this.setHeaderFooter(this.headerFooter.toString(), false, name);
        } else if ("c".equals(name)) {
            this.value.setLength(0);
        } else if ("sheetData".equals(name)) {
            if (this.importContext.isPartData()) {
                this.writePartDataset(this.dsResult);
            }
            throw new SAXException(new POIEventModelException("Stop parsing the document."));
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.vIsOpen) {
            this.value.append(ch, start, length);
        }
        if (this.fIsOpen) {
            this.formula.append(ch, start, length);
        }
        if (this.hfIsOpen) {
            this.headerFooter.append(ch, start, length);
        }
    }

    private void setDimension(String dim) throws SAXException {
        long cellCount;
        long maxCellCount = Long.parseLong(XeniProperties.getStringProperty("xeni.import.cell.max", "-1"));
        if (maxCellCount > 0L && (cellCount = (long)(this.dimInfo.getEndColumn() - this.dimInfo.getStartColumn() + 1) * (long)(this.dimInfo.getEndRow() - this.dimInfo.getStartRow() + 1)) > maxCellCount) {
            throw new SAXException("Maximum number of cells exceeded. (" + cellCount + ":" + maxCellCount + ")");
        }
    }

    private void setStartRowIndex(int newrow) {
        this.sendPartDataset();
        if (this.nCurrExlRow >= 0 && newrow - this.nCurrExlRow > 1) {
            for (int i = this.nCurrExlRow + 1; i < newrow; ++i) {
                if (this.dimInfo.getStartRow() > i) continue;
                this.dsResult.newRow();
            }
        }
        if (this.dimInfo.getStartRow() <= newrow) {
            this.nCurrDsRow = this.dsResult.newRow();
        }
        this.nCurrExlRow = newrow;
    }

    private void setEndRow() {
        this.nCurrDsRow = -1;
    }

    private void setCellValue(String value) throws SAXException {
        if (value != null) {
            if (this.importContext.getCorsResponseType() == 1) {
                value = value.replaceAll("\n", "\\\\n");
                value = value.replaceAll("\"", "\\\\\"");
                value = value.replaceAll("\\\\", "\\\\\\\\");
            }
            this.dsResult.set(this.nCurrDsRow, this.currCellRef[0] - this.dimInfo.getStartColumn(), value);
        }
    }

    private void setHeaderFooter(String text, boolean isheader, String tagname) {
    }

    private void setStartCellValue(Attributes attributes) {
        CommUtil.getRangeIndex(attributes.getValue("r"), this.currCellRef);
        this.nextDataType = xssfDataType.NUMBER;
        this.formatIndex = (short)-1;
        this.formatString = null;
        String type = attributes.getValue("t");
        String style = attributes.getValue("s");
        if ("b".equals(type)) {
            this.nextDataType = xssfDataType.BOOLEAN;
        } else if ("e".equals(type)) {
            this.nextDataType = xssfDataType.ERROR;
        } else if ("inlineStr".equals(type)) {
            this.nextDataType = xssfDataType.INLINE_STRING;
        } else if ("s".equals(type)) {
            this.nextDataType = xssfDataType.SST_STRING;
        } else if ("str".equals(type)) {
            this.nextDataType = xssfDataType.FORMULA;
        } else if (style != null) {
            int styleIdx = Integer.parseInt(style);
            if (!this.isHancell) {
                XSSFCellStyle cellStyle = this.stylesTable.getStyleAt(styleIdx);
                if (cellStyle != null) {
                    this.formatIndex = cellStyle.getDataFormat();
                    this.formatString = this.formatIndex == 14 ? XeniBuiltinFormats.getBuiltinFormat(this.formatIndex, null) : cellStyle.getDataFormatString();
                }
            } else {
                this.formatIndex = this.xeniStylesTable.getDataFormat(styleIdx);
                this.formatString = this.formatIndex == 14 ? XeniBuiltinFormats.getBuiltinFormat(this.formatIndex, null) : this.xeniStylesTable.getDataFormatString(this.formatIndex);
            }
            if (this.formatString == null) {
                this.formatString = XeniBuiltinFormats.getBuiltinFormat(this.formatIndex, null);
            }
        }
    }

    private String getCellValue() {
        String thisStr = null;
        switch (this.nextDataType) {
            case BOOLEAN: {
                char first = this.value.charAt(0);
                thisStr = first == '0' ? "FALSE" : "TRUE";
                break;
            }
            case ERROR: {
                thisStr = "ERROR:" + this.value.toString();
            }
            case FORMULA: {
                if (this.formulasNotResults) {
                    thisStr = this.formula.toString();
                    break;
                }
                thisStr = this.value.toString();
                if (this.importContext.isRawNumberValue() && this.importContext.getCompatibleMode() <= 0) break;
                try {
                    double dValue = Double.parseDouble(thisStr);
                    thisStr = this.formatter.formatRawCellContents(dValue, this.formatIndex, this.formatString, false, this.importContext.isRawDateValue(), this.importContext.isRawNumberValue(), this.importContext.getCompatibleMode());
                    thisStr = thisStr.replaceAll("[\"*? ]", "");
                }
                catch (NumberFormatException e) {
                    System.out.println(e.getMessage());
                }
                break;
            }
            case INLINE_STRING: {
                if (!this.isHancell) {
                    XSSFRichTextString richInline = new XSSFRichTextString(this.value.toString());
                    thisStr = richInline.toString();
                    break;
                }
                thisStr = this.value.toString();
                break;
            }
            case SST_STRING: {
                String sstIndex = this.value.toString();
                try {
                    int idx = Integer.parseInt(sstIndex);
                    if (!this.isHancell) {
                        XSSFRichTextString richSST = new XSSFRichTextString(this.sharedStringsTable.getEntryAt(idx));
                        thisStr = richSST.toString();
                        break;
                    }
                    thisStr = this.sharedStringsTable.getEntryAt(idx);
                }
                catch (NumberFormatException e) {
                    if (!logger.isErrorEnabled()) break;
                    logger.error((Object)("Failed to parse SST index '" + StringUtils.normalizeSpace((String)sstIndex) + "': " + StringUtils.normalizeSpace((String)e.toString())));
                }
                break;
            }
            case NUMBER: {
                double dValue = Double.parseDouble(this.value.toString());
                thisStr = this.formatter.formatRawCellContents(dValue, this.formatIndex, this.formatString, false, this.importContext.isRawDateValue(), this.importContext.isRawNumberValue(), this.importContext.getCompatibleMode());
                thisStr = thisStr.replaceAll("[\"*? ]", "");
                break;
            }
            default: {
                thisStr = "(Unexpected type: " + (Object)((Object)this.nextDataType) + ")";
            }
        }
        return thisStr;
    }

    private void setStartFormula(Attributes attributes) {
        String type;
        this.formula.setLength(0);
        if (this.nextDataType == xssfDataType.NUMBER) {
            this.nextDataType = xssfDataType.FORMULA;
        }
        if ((type = attributes.getValue("t")) != null && "shared".equals(type)) {
            String ref = attributes.getValue("ref");
            String si = attributes.getValue("si");
            if (ref != null) {
                this.fIsOpen = true;
            } else if (this.formulasNotResults && logger.isErrorEnabled()) {
                logger.error((Object)"Warning - shared formulas not yet supported!");
            }
        } else {
            this.fIsOpen = true;
        }
    }

    private boolean isValidDimension() {
        if (this.nCurrExlRow < this.dimInfo.getStartRow()) {
            return false;
        }
        return this.currCellRef[0] >= this.dimInfo.getStartColumn() && this.currCellRef[0] <= this.dimInfo.getEndColumn();
    }

    private void writePartDataset(DataSet ds) {
        try {
            XeniUtils.XeniEncoder encoder = XeniUtils.getXeniEncoder("");
            if (this.importContext.getPartIndex() <= 2) {
                VariableList varList = new VariableList();
                varList.add("ErrorCode", 0);
                varList.add("ErrorMsg", "SUCCESS");
                StringWriter partVarialbe = new StringWriter();
                CommUtil.writePartDataVariableList(partVarialbe, this.importContext, varList);
                this.importContext.getResponseWriter().write(partVarialbe.toString());
                partVarialbe.getBuffer().delete(0, partVarialbe.getBuffer().length());
                this.importContext.setPartIndex(3);
                if (this.dsInfo != null) {
                    this.dsInfo.set(0, "importid", this.importContext.getImportId());
                    this.writePartDataset(this.dsInfo);
                    this.importContext.setPartIndex(4);
                }
            }
            StringWriter partWriter = new StringWriter();
            CommUtil.writePartDataDataset(partWriter, this.importContext, ds);
            encoder.encodeTo(this.importContext.getResponseWriter(), partWriter.toString());
            this.importContext.getResponseWriter().flush();
            this.importContext.setPartIndex(4);
            partWriter.getBuffer().delete(0, partWriter.getBuffer().length());
        }
        catch (PlatformException | IOException e) {
            logger.error((Object)StringUtils.normalizeSpace((String)e.getMessage()));
        }
    }

    private void sendPartDataset() {
        if (this.importContext.isPartData() && this.dsResult.getRowCount() >= this.importContext.getPartSize()) {
            this.writePartDataset(this.dsResult);
        }
    }

    static enum xssfDataType {
        BOOLEAN,
        ERROR,
        FORMULA,
        INLINE_STRING,
        SST_STRING,
        NUMBER;

    }
}

