/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.ximport.impl;

import com.nexacro.java.xapi.data.DataSet;
import com.nexacro.java.xeni.extend.XeniBuiltinFormats;
import com.nexacro.java.xeni.extend.XeniDataFormatter;
import com.nexacro.java.xeni.extend.XeniReadOnlySharedStringsTable;
import com.nexacro.java.xeni.extend.XeniStylesTable;
import com.nexacro.java.xeni.util.CommUtil;
import com.nexacro.java.xeni.ximport.ExcelDimensionInfo;
import com.nexacro.java.xeni.ximport.GridImportContext;
import com.nexacro.java.xeni.ximport.POIEventModelException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XSSFEventModelHandlerHead
extends DefaultHandler {
    private static final Log logger = LogFactory.getLog(XSSFEventModelHandlerHead.class);
    private StylesTable stylesTable;
    private XeniStylesTable xeniStylesTable;
    private XeniReadOnlySharedStringsTable sharedStringsTable;
    private boolean vIsOpen;
    private boolean fIsOpen;
    private boolean isIsOpen;
    private boolean hfIsOpen;
    private xssfDataType nextDataType;
    private short formatIndex;
    private String formatString;
    private final XeniDataFormatter formatter;
    private boolean formulasNotResults;
    private int[] currCellRef = new int[]{-1, -1};
    private StringBuffer value = new StringBuffer();
    private StringBuffer formula = new StringBuffer();
    private StringBuffer headerFooter = new StringBuffer();
    private ExcelDimensionInfo dimInfo;
    private int nCurrDsCol = 0;
    private int nPreColIndex = 0;
    private int nLastColIndex = 0;
    private boolean isHancell = false;
    private boolean isUserDimension = false;
    private DataSet dsResult = null;
    private GridImportContext importContext;

    public XSSFEventModelHandlerHead(DataSet ds, ExcelDimensionInfo dim, StylesTable styles, XeniStylesTable xeniStyles, XeniReadOnlySharedStringsTable strings, boolean formulasnotresults, boolean hancell, GridImportContext context) {
        this.dsResult = ds;
        this.dimInfo = dim;
        this.stylesTable = styles;
        this.xeniStylesTable = xeniStyles;
        this.sharedStringsTable = strings;
        this.formulasNotResults = formulasnotresults;
        this.formatter = new XeniDataFormatter();
        this.nextDataType = xssfDataType.NUMBER;
        this.isHancell = hancell;
        this.importContext = context;
        this.isUserDimension = dim.isUserDimension();
    }

    private boolean isTextTag(String name) {
        if ("v".equals(name)) {
            return true;
        }
        if ("inlineStr".equals(name)) {
            return true;
        }
        return "t".equals(name) && this.isIsOpen;
    }

    @Override
    public void startElement(String uri, String name, String localName, Attributes attributes) throws SAXException {
        if (!"dimension".equals(name)) {
            if (this.isTextTag(name)) {
                this.vIsOpen = true;
                this.value.setLength(0);
            } else if ("is".equals(name)) {
                this.isIsOpen = true;
            } else if ("f".equals(name)) {
                this.formula.setLength(0);
                this.setStartFormula(attributes);
            } else if ("oddHeader".equals(name) || "evenHeader".equals(name) || "firstHeader".equals(name) || "firstFooter".equals(name) || "oddFooter".equals(name) || "evenFooter".equals(name)) {
                this.hfIsOpen = true;
                this.headerFooter.setLength(0);
            } else if ("row".equals(name)) {
                int rowNum = Integer.parseInt(attributes.getValue("r")) - 1;
                this.setStartRowIndex(rowNum);
            } else if ("c".equals(name)) {
                this.setStartCellValue(attributes);
            }
        }
    }

    @Override
    public void endElement(String uri, String name, String localName) throws SAXException {
        Object thisStr = null;
        if (this.isTextTag(name)) {
            this.vIsOpen = false;
            if (this.isUserDimension && this.isValidDimension()) {
                this.setCellValue(this.getCellValue());
            }
        } else if ("f".equals(name)) {
            this.fIsOpen = false;
        } else if ("is".equals(name)) {
            this.isIsOpen = false;
        } else if ("row".equals(name)) {
            this.setEndRow();
        } else if ("oddHeader".equals(name) || "evenHeader".equals(name) || "firstHeader".equals(name)) {
            this.hfIsOpen = false;
            this.setHeaderFooter(this.headerFooter.toString(), true, name);
        } else if ("oddFooter".equals(name) || "evenFooter".equals(name) || "firstFooter".equals(name)) {
            this.hfIsOpen = false;
            this.setHeaderFooter(this.headerFooter.toString(), false, name);
        } else if ("c".equals(name)) {
            this.value.setLength(0);
        } else if ("sheetData".equals(name)) {
            if (!this.isUserDimension) {
                this.addColumn();
            } else {
                this.addEmptyColumn();
            }
            throw new SAXException(new POIEventModelException("Stop parsing the document."));
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.vIsOpen) {
            this.value.append(ch, start, length);
        }
        if (this.fIsOpen) {
            this.formula.append(ch, start, length);
        }
        if (this.hfIsOpen) {
            this.headerFooter.append(ch, start, length);
        }
    }

    private void setDimension(String dim) {
    }

    private void setStartFormula(Attributes attributes) {
        String type;
        if (this.nextDataType == xssfDataType.NUMBER) {
            this.nextDataType = xssfDataType.FORMULA;
        }
        if ((type = attributes.getValue("t")) != null && "shared".equals(type)) {
            String ref = attributes.getValue("ref");
            String si = attributes.getValue("si");
            if (ref != null) {
                this.fIsOpen = true;
            } else if (this.formulasNotResults && logger.isErrorEnabled()) {
                logger.error((Object)"Warning - shared formulas not yet supported!");
            }
        } else {
            this.fIsOpen = true;
        }
    }

    private void setStartRowIndex(int newrow) {
        this.nPreColIndex = 0;
        if (this.dimInfo.getStartRow() < 0) {
            this.dimInfo.setStartRow(newrow);
        }
        this.dimInfo.setEndRow(newrow);
    }

    private void setEndRow() {
    }

    private void setStartCellValue(Attributes attributes) {
        CommUtil.getRangeIndex(attributes.getValue("r"), this.currCellRef);
        if (this.dimInfo.getStartColumn() < 0) {
            this.dimInfo.setStartColumn(this.currCellRef[0]);
        } else if (this.dimInfo.getStartColumn() > this.currCellRef[0]) {
            this.dimInfo.setStartColumn(this.currCellRef[0]);
        }
        if (this.dimInfo.getEndColumn() < 0) {
            this.dimInfo.setEndColumn(this.currCellRef[0]);
        } else if (this.dimInfo.getEndColumn() < this.currCellRef[0]) {
            this.dimInfo.setEndColumn(this.currCellRef[0]);
        }
        this.nextDataType = xssfDataType.NUMBER;
        this.formatIndex = (short)-1;
        this.formatString = null;
        String type = attributes.getValue("t");
        String style = attributes.getValue("s");
        if ("b".equals(type)) {
            this.nextDataType = xssfDataType.BOOLEAN;
        } else if ("e".equals(type)) {
            this.nextDataType = xssfDataType.ERROR;
        } else if ("inlineStr".equals(type)) {
            this.nextDataType = xssfDataType.INLINE_STRING;
        } else if ("s".equals(type)) {
            this.nextDataType = xssfDataType.SST_STRING;
        } else if ("str".equals(type)) {
            this.nextDataType = xssfDataType.FORMULA;
        } else if (style != null) {
            int styleIdx = Integer.parseInt(style);
            if (!this.isHancell) {
                XSSFCellStyle cellStyle = this.stylesTable.getStyleAt(styleIdx);
                if (cellStyle != null) {
                    this.formatIndex = cellStyle.getDataFormat();
                    this.formatString = this.formatIndex == 14 ? XeniBuiltinFormats.getBuiltinFormat(this.formatIndex, null) : cellStyle.getDataFormatString();
                }
            } else {
                this.formatIndex = this.xeniStylesTable.getDataFormat(styleIdx);
                this.formatString = this.formatIndex == 14 ? XeniBuiltinFormats.getBuiltinFormat(this.formatIndex, null) : this.xeniStylesTable.getDataFormatString(this.formatIndex);
            }
            if (this.formatString == null) {
                this.formatString = XeniBuiltinFormats.getBuiltinFormat(this.formatIndex, null);
            }
        }
    }

    private String getCellValue() {
        String thisStr = null;
        switch (this.nextDataType) {
            case BOOLEAN: {
                char first = this.value.charAt(0);
                thisStr = first == '0' ? "FALSE" : "TRUE";
                break;
            }
            case ERROR: {
                thisStr = "ERROR:" + this.value.toString();
            }
            case FORMULA: {
                if (this.formulasNotResults) {
                    thisStr = this.formula.toString();
                    break;
                }
                thisStr = this.value.toString();
                if (this.importContext.isRawNumberValue() && this.importContext.getCompatibleMode() <= 0) break;
                try {
                    double dValue = Double.parseDouble(thisStr);
                    thisStr = this.formatter.formatRawCellContents(dValue, this.formatIndex, this.formatString, false, this.importContext.isRawDateValue(), this.importContext.isRawNumberValue(), this.importContext.getCompatibleMode());
                    thisStr = thisStr.replaceAll("[\"*? ]", "");
                }
                catch (NumberFormatException e) {
                    System.out.println(e.getMessage());
                }
                break;
            }
            case INLINE_STRING: {
                if (!this.isHancell) {
                    XSSFRichTextString richInline = new XSSFRichTextString(this.value.toString());
                    thisStr = richInline.toString();
                    break;
                }
                thisStr = this.value.toString();
                break;
            }
            case SST_STRING: {
                String sstIndex = this.value.toString();
                try {
                    int idx = Integer.parseInt(sstIndex);
                    if (!this.isHancell) {
                        XSSFRichTextString richSST = new XSSFRichTextString(this.sharedStringsTable.getEntryAt(idx));
                        thisStr = richSST.toString();
                        break;
                    }
                    thisStr = this.sharedStringsTable.getEntryAt(idx);
                }
                catch (NumberFormatException e) {
                    if (!logger.isErrorEnabled()) break;
                    logger.error((Object)("Failed to parse SST index '" + StringUtils.normalizeSpace((String)sstIndex) + "': " + StringUtils.normalizeSpace((String)e.toString())));
                }
                break;
            }
            case NUMBER: {
                double dValue = Double.parseDouble(this.value.toString());
                thisStr = this.formatter.formatRawCellContents(dValue, this.formatIndex, this.formatString, false, this.importContext.isRawDateValue(), this.importContext.isRawNumberValue(), this.importContext.getCompatibleMode());
                thisStr = thisStr.replaceAll("[\"*? ]", "");
                break;
            }
            default: {
                thisStr = "(Unexpected type: " + (Object)((Object)this.nextDataType) + ")";
            }
        }
        return thisStr;
    }

    private void setCellValue(String value) throws SAXException {
        if (value != null && this.importContext.getCorsResponseType() == 1) {
            value = value.replaceAll("\n", "\\\\n");
            value = value.replaceAll("\"", "\\\\\"");
            value = value.replaceAll("\\\\", "\\\\\\\\");
        }
        int nCols = this.currCellRef[0] - this.nPreColIndex;
        if (this.nCurrDsCol == 0 && nCols > 0) {
            int startCol = this.dimInfo.getUserStartColumn() >= 0 ? this.dimInfo.getUserStartColumn() : this.dimInfo.getStartColumn();
            int endCol = this.currCellRef[0];
            for (int nIdx = this.nPreColIndex; nIdx < this.currCellRef[0]; ++nIdx) {
                if (nIdx < startCol || nIdx > endCol) continue;
                this.dsResult.addColumn("Column" + this.nCurrDsCol, 2, 256);
                ++this.nCurrDsCol;
            }
        } else if (this.nCurrDsCol != 0 && nCols > 1) {
            for (int nIdx = 1; nIdx < nCols; ++nIdx) {
                this.dsResult.addColumn("Column" + this.nCurrDsCol, 2, 256);
                ++this.nCurrDsCol;
            }
        }
        this.nLastColIndex = this.nPreColIndex = this.currCellRef[0];
        if (value == null || "".equals(value)) {
            this.dsResult.addColumn("Column" + this.nCurrDsCol, 2, 256);
        } else {
            this.dsResult.addColumn(value, 2, 256);
        }
        ++this.nCurrDsCol;
    }

    private boolean isValidDimension() {
        if (this.dimInfo.getEndRow() < 0 || this.dimInfo.getUserStartRow() >= 0 && this.dimInfo.getUserStartRow() > this.dimInfo.getEndRow()) {
            return false;
        }
        if (this.dimInfo.getUserEndRow() >= 0 && this.dimInfo.getUserEndRow() < this.dimInfo.getEndRow()) {
            return false;
        }
        if (this.dimInfo.getUserStartColumn() >= 0 && this.dimInfo.getUserStartColumn() > this.currCellRef[0]) {
            return false;
        }
        return this.dimInfo.getUserEndColumn() < 0 || this.dimInfo.getUserEndColumn() >= this.currCellRef[0];
    }

    private void setHeaderFooter(String text, boolean isheader, String tagname) {
    }

    private void addColumn() {
        for (int i = 0; i <= this.dimInfo.getEndColumn() - this.dimInfo.getStartColumn(); ++i) {
            this.dsResult.addColumn("Column" + i, 2, 256);
        }
    }

    private void addEmptyColumn() {
        int cols = this.currCellRef[0] - this.nLastColIndex;
        if (this.nCurrDsCol != 0 && cols > 0) {
            int startCol = this.dimInfo.getUserStartColumn() >= 0 ? this.dimInfo.getUserStartColumn() : this.dimInfo.getStartColumn();
            int endCol = this.dimInfo.getUserEndColumn() >= 0 ? this.dimInfo.getUserEndColumn() : this.dimInfo.getEndColumn();
            for (int nIdx = this.nLastColIndex + 1; nIdx <= this.nLastColIndex + cols; ++nIdx) {
                if (startCol > nIdx || nIdx > endCol) continue;
                this.dsResult.addColumn("Column" + this.nCurrDsCol, 2, 256);
                ++this.nCurrDsCol;
            }
        }
    }

    static enum xssfDataType {
        BOOLEAN,
        ERROR,
        FORMULA,
        INLINE_STRING,
        SST_STRING,
        NUMBER;

    }
}

