/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.java.xeni.data;

import com.nexacro.java.xeni.data.exportformats.ExportFormat;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class GridExportFormatFactory
extends DefaultHandler {
    private static final Log oLogger = LogFactory.getLog(GridExportFormatFactory.class);
    private ExportFormat format;
    private int currIndex;
    protected static final int INDEX_UNDEFINED = 0;
    protected static final int INDEX_COLUMNS = 1;
    protected static final int INDEX_ROWS = 2;
    protected static final int INDEX_DATA_HEAD = 3;
    protected static final int INDEX_DATA_BODY = 4;
    protected static final int INDEX_DATA_SUMMARY = 5;

    public ExportFormat readFormatString(String string) {
        InputSource inputSource = new InputSource(new StringReader(string));
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            sAXParserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            sAXParserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            sAXParserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputSource, (DefaultHandler)this);
        }
        catch (Exception exception) {
            oLogger.error((Object)("Fail to create grid format : " + StringUtils.normalizeSpace((String)exception.getMessage())));
            return null;
        }
        return this.format;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if ("Cell".equals(string3)) {
            this.startCell(attributes);
        } else if ("Summary".equals(string3)) {
            this.setCurrentIndex(5);
        } else if ("Body".equals(string3)) {
            this.setCurrentIndex(4);
        } else if ("Head".equals(string3)) {
            this.setCurrentIndex(3);
        } else if ("Row".equals(string3)) {
            this.startRow(attributes);
        } else if ("Column".equals(string3)) {
            this.startColumn(attributes);
        } else if ("Format".equals(string3)) {
            this.startFormat(attributes);
        } else if ("Formats".equals(string3)) {
            this.startData();
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if (!"Cell".equals(string3)) {
            if ("Summary".equals(string3)) {
                this.setCurrentIndex(0);
            } else if ("Body".equals(string3)) {
                this.setCurrentIndex(0);
            } else if ("Head".equals(string3)) {
                this.setCurrentIndex(0);
            } else if ("Formats".equals(string3)) {
                this.endData();
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
    }

    protected void startData() {
        this.setData(new ExportFormat());
    }

    protected void endData() {
        this.setCurrentIndex(0);
    }

    protected void setData(ExportFormat exportFormat) {
        this.format = exportFormat;
    }

    protected ExportFormat getData() {
        return this.format;
    }

    protected void setCurrentIndex(int n) {
        this.currIndex = n;
    }

    protected int getCurrentIndex() {
        return this.currIndex;
    }

    protected void startFormat(Attributes attributes) {
        String string = attributes.getValue("id");
        this.getData().setId(string);
    }

    protected void startColumn(Attributes attributes) {
        String string = attributes.getValue("size");
        this.getData().addColumn(string);
    }

    protected void startRow(Attributes attributes) {
        String string = attributes.getValue("size");
        String string2 = attributes.getValue("band");
        this.getData().addRow(string, string2);
    }

    protected void startCell(Attributes attributes) {
        int n = this.getCurrentIndex();
        if (n != 3 && n != 4 && n != 5) {
            return;
        }
        this.getData().addCell(n, attributes.getValue("row"), attributes.getValue("col"), attributes.getValue("rowspan"), attributes.getValue("colspan"), attributes.getValue("style"), attributes.getValue("style1"), attributes.getValue("style2"), attributes.getValue("text"), attributes.getValue("displaytype"), attributes.getValue("edittype"), attributes.getValue("combodisplay"), attributes.getValue("type"));
    }
}

